/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.feature.Word2VecBase;
import org.apache.spark.ml.feature.Word2VecBase$class;
import org.apache.spark.ml.feature.Word2VecModel$;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasInputCol$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasOutputCol$class;
import org.apache.spark.ml.param.shared.HasSeed$class;
import org.apache.spark.ml.param.shared.HasStepSize$class;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SQLContext$;
import org.apache.spark.sql.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001B\u0001\u0003\u00015\u0011QbV8sIJ2VmY'pI\u0016d'BA\u0002\u0005\u0003\u001d1W-\u0019;ve\u0016T!!\u0002\u0004\u0002\u00055d'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0007=\u0001\"#D\u0001\u0005\u0013\t\tBAA\u0003N_\u0012,G\u000e\u0005\u0002\u0014\u00015\t!\u0001\u0005\u0002\u0014+%\u0011aC\u0001\u0002\r/>\u0014HM\r,fG\n\u000b7/\u001a\u0005\t1\u0001\u0011)\u0019!C!3\u0005\u0019Q/\u001b3\u0016\u0003i\u0001\"aG\u0011\u000f\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0002\rA\u0013X\rZ3g\u0013\t\u00113E\u0001\u0004TiJLgn\u001a\u0006\u0003AuA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0005k&$\u0007\u0005\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003)\u0003-9xN\u001d3WK\u000e$xN]:\u0011\u0005%jS\"\u0001\u0016\u000b\u0005\rY#B\u0001\u0017\u0007\u0003\u0015iG\u000e\\5c\u0013\t\t!\u0006\u0003\u00040\u0001\u0011\u0005A\u0001M\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007I\t$\u0007C\u0003\u0019]\u0001\u0007!\u0004C\u0003(]\u0001\u0007\u0001\u0006\u0003\u00055\u0001!\u0015\r\u0011\"\u00016\u0003)9W\r\u001e,fGR|'o]\u000b\u0002mA\u0011qGO\u0007\u0002q)\u0011\u0011HB\u0001\u0004gFd\u0017BA\u001e9\u0005%!\u0015\r^1Ge\u0006lW\r\u0003\u0005>\u0001!\u0005\t\u0015)\u00037\u0003-9W\r\u001e,fGR|'o\u001d\u0011)\u0005qz\u0004C\u0001\u000fA\u0013\t\tUDA\u0005ue\u0006t7/[3oi\")1\t\u0001C\u0001\t\u0006aa-\u001b8e'ftwN\\=ngR\u0019a'R$\t\u000b\u0019\u0013\u0005\u0019\u0001\u000e\u0002\t]|'\u000f\u001a\u0005\u0006\u0011\n\u0003\r!S\u0001\u0004]Vl\u0007C\u0001\u000fK\u0013\tYUDA\u0002J]RDQa\u0011\u0001\u0005\u00025#2A\u000e(V\u0011\u00151E\n1\u0001P!\t\u00016+D\u0001R\u0015\t\u00116&\u0001\u0004mS:\fGnZ\u0005\u0003)F\u0013aAV3di>\u0014\b\"\u0002%M\u0001\u0004I\u0005\"B,\u0001\t\u0003A\u0016aC:fi&s\u0007/\u001e;D_2$\"!\u0017.\u000e\u0003\u0001AQa\u0017,A\u0002i\tQA^1mk\u0016DQ!\u0018\u0001\u0005\u0002y\u000bAb]3u\u001fV$\b/\u001e;D_2$\"!W0\t\u000bmc\u0006\u0019\u0001\u000e\t\u000b\u0005\u0004A\u0011\t2\u0002\u0013Q\u0014\u0018M\\:g_JlGC\u0001\u001cd\u0011\u0015!\u0007\r1\u00017\u0003\u001d!\u0017\r^1tKRDQA\u001a\u0001\u0005B\u001d\fq\u0002\u001e:b]N4wN]7TG\",W.\u0019\u000b\u0003Q:\u0004\"!\u001b7\u000e\u0003)T!a\u001b\u001d\u0002\u000bQL\b/Z:\n\u00055T'AC*ueV\u001cG\u000fV=qK\")q.\u001aa\u0001Q\u000611o\u00195f[\u0006DQ!\u001d\u0001\u0005BI\fAaY8qsR\u0011!c\u001d\u0005\u0006iB\u0004\r!^\u0001\u0006Kb$(/\u0019\t\u0003mfl\u0011a\u001e\u0006\u0003q\u0012\tQ\u0001]1sC6L!A_<\u0003\u0011A\u000b'/Y7NCBD#\u0001\u0001?\u0011\u0007u\f\t!D\u0001\u007f\u0015\tyh!\u0001\u0006b]:|G/\u0019;j_:L1!a\u0001\u007f\u00051)\u0005\u0010]3sS6,g\u000e^1m\u0001")
public class Word2VecModel
extends Model<Word2VecModel>
implements Word2VecBase {
    private final String uid;
    private final org.apache.spark.mllib.feature.Word2VecModel wordVectors;
    private transient DataFrame getVectors;
    private final IntParam vectorSize;
    private final IntParam numPartitions;
    private final IntParam minCount;
    private final LongParam seed;
    private final DoubleParam stepSize;
    private final IntParam maxIter;
    private final Param<String> outputCol;
    private final Param<String> inputCol;
    private volatile transient boolean bitmap$trans$0;

    private DataFrame getVectors$lzycompute() {
        Word2VecModel word2VecModel = this;
        synchronized (word2VecModel) {
            if (!this.bitmap$trans$0) {
                SparkContext sc = SparkContext$.MODULE$.getOrCreate();
                SQLContext sqlContext = SQLContext$.MODULE$.getOrCreate(sc);
                Map wordVec = this.wordVectors.getVectors().mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(float[] vec) {
                        return Vectors$.MODULE$.dense((double[])Predef$.MODULE$.floatArrayOps(vec).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply(float x$2) {
                                return this.apply$mcDF$sp(x$2);
                            }

                            public double apply$mcDF$sp(float x$2) {
                                return x$2;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
                    }
                });
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
                public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator2$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $m.staticClass("org.apache.spark.mllib.linalg.Vector").asType().toTypeConstructor()})));
                    }

                    public Org_apache_spark_ml_feature_Word2VecModel$$typecreator2$1(Word2VecModel $outer) {
                    }
                }
                this.getVectors = sqlContext.implicits().rddToDataFrameHolder(sc.parallelize(wordVec.toSeq(), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator2$1(this))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"word", "vector"}));
                this.bitmap$trans$0 = true;
            }
            return this.getVectors;
        }
    }

    @Override
    public final IntParam vectorSize() {
        return this.vectorSize;
    }

    @Override
    public final IntParam numPartitions() {
        return this.numPartitions;
    }

    @Override
    public final IntParam minCount() {
        return this.minCount;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$vectorSize_$eq(IntParam x$1) {
        this.vectorSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$numPartitions_$eq(IntParam x$1) {
        this.numPartitions = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$minCount_$eq(IntParam x$1) {
        this.minCount = x$1;
    }

    @Override
    public int getVectorSize() {
        return Word2VecBase$class.getVectorSize(this);
    }

    @Override
    public int getNumPartitions() {
        return Word2VecBase$class.getNumPartitions(this);
    }

    @Override
    public int getMinCount() {
        return Word2VecBase$class.getMinCount(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return Word2VecBase$class.validateAndTransformSchema(this, schema);
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final long getSeed() {
        return HasSeed$class.getSeed(this);
    }

    @Override
    public final DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final double getStepSize() {
        return HasStepSize$class.getStepSize(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final Param<String> outputCol() {
        return this.outputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param x$1) {
        this.outputCol = x$1;
    }

    @Override
    public final String getOutputCol() {
        return HasOutputCol$class.getOutputCol(this);
    }

    @Override
    public final Param<String> inputCol() {
        return this.inputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param x$1) {
        this.inputCol = x$1;
    }

    @Override
    public final String getInputCol() {
        return HasInputCol$class.getInputCol(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public DataFrame getVectors() {
        return this.bitmap$trans$0 ? this.getVectors : this.getVectors$lzycompute();
    }

    public DataFrame findSynonyms(String word, int num) {
        return this.findSynonyms(this.wordVectors.transform(word), num);
    }

    public DataFrame findSynonyms(Vector word, int num) {
        SparkContext sc = SparkContext$.MODULE$.getOrCreate();
        SQLContext sqlContext = SQLContext$.MODULE$.getOrCreate(sc);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
        public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $m.staticClass("scala.Double").asType().toTypeConstructor()})));
            }

            public Org_apache_spark_ml_feature_Word2VecModel$$typecreator4$1(Word2VecModel $outer) {
            }
        }
        return sqlContext.implicits().rddToDataFrameHolder(sc.parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.wordVectors.findSynonyms(word, num)), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator4$1(this))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"word", "similarity"}));
    }

    public Word2VecModel setInputCol(String value) {
        return (Word2VecModel)this.set(this.inputCol(), value);
    }

    public Word2VecModel setOutputCol(String value) {
        return (Word2VecModel)this.set(this.outputCol(), value);
    }

    @Override
    public DataFrame transform(DataFrame dataset) {
        this.transformSchema(dataset.schema(), true);
        Broadcast bWordVectors = dataset.sqlContext().sparkContext().broadcast((Object)this.wordVectors, ClassTag$.MODULE$.apply(org.apache.spark.mllib.feature.Word2VecModel.class));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
        public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.mllib.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_feature_Word2VecModel$$typecreator5$1(Word2VecModel $outer) {
            }
        }
        public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator6$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$)})));
            }

            public Org_apache_spark_ml_feature_Word2VecModel$$typecreator6$1(Word2VecModel $outer) {
            }
        }
        UserDefinedFunction word2Vec = functions$.MODULE$.udf((Function1)new Serializable(this, bWordVectors){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Word2VecModel $outer;
            public final Broadcast bWordVectors$1;

            /*
             * WARNING - void declaration
             */
            public final Vector apply(Seq<String> sentence) {
                Vector vector;
                if (sentence.size() == 0) {
                    vector = Vectors$.MODULE$.sparse(BoxesRunTime.unboxToInt((Object)this.$outer.$(this.$outer.vectorSize())), (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
                } else {
                    void var2_2;
                    Vector cum = Vectors$.MODULE$.zeros(BoxesRunTime.unboxToInt((Object)this.$outer.$(this.$outer.vectorSize())));
                    Map<String, float[]> model = ((org.apache.spark.mllib.feature.Word2VecModel)this.bWordVectors$1.value()).getVectors();
                    sentence.foreach((Function1)new Serializable(this, cum, model){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$3 $outer;
                        private final Vector cum$1;
                        private final Map model$1;

                        public final void apply(String word) {
                            if (this.model$1.contains((Object)word)) {
                                BLAS$.MODULE$.axpy(1.0, ((org.apache.spark.mllib.feature.Word2VecModel)this.$outer.bWordVectors$1.value()).transform(word), this.cum$1);
                            }
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.cum$1 = cum$1;
                            this.model$1 = model$1;
                        }
                    });
                    BLAS$.MODULE$.scal(1.0 / (double)sentence.size(), cum);
                    vector = var2_2;
                }
                return vector;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bWordVectors$1 = bWordVectors$1;
            }
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator5$1(this)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator6$1(this)));
        return dataset.withColumn(this.$(this.outputCol()), word2Vec.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.inputCol()))})));
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    @Override
    public Word2VecModel copy(ParamMap extra) {
        Word2VecModel copied = new Word2VecModel(this.uid(), this.wordVectors);
        return (Word2VecModel)((Model)this.copyValues(copied, extra)).setParent(this.parent());
    }

    public Word2VecModel(String uid, org.apache.spark.mllib.feature.Word2VecModel wordVectors) {
        this.uid = uid;
        this.wordVectors = wordVectors;
        HasInputCol$class.$init$(this);
        HasOutputCol$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasStepSize$class.$init$(this);
        HasSeed$class.$init$(this);
        Word2VecBase$class.$init$(this);
    }
}

