/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.recommendation;

import com.github.fommil.netlib.BLAS;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Logging;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.recommendation.ALS;
import org.apache.spark.ml.recommendation.ALS$;
import org.apache.spark.ml.recommendation.ALS$$anonfun$18$;
import org.apache.spark.ml.recommendation.ALS$$anonfun$initialize$1$;
import org.apache.spark.ml.recommendation.ALS$$anonfun$partitionRatings$1$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.collection.OpenHashMap;
import org.apache.spark.util.collection.OpenHashSet;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqView;
import scala.collection.TraversableViewLike;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.IndexedSeqView$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Sorting$;

@DeveloperApi
public final class ALS$
implements Logging,
Serializable {
    public static final ALS$ MODULE$;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new ALS$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    @DeveloperApi
    public <ID> Tuple2<RDD<Tuple2<ID, float[]>>, RDD<Tuple2<ID, float[]>>> train(RDD<ALS.Rating<ID>> ratings, int rank, int numUserBlocks, int numItemBlocks, int maxIter, double regParam, boolean implicitPrefs, double alpha, boolean nonnegative, StorageLevel intermediateRDDStorageLevel, StorageLevel finalRDDStorageLevel, int checkpointInterval, long seed, ClassTag<ID> evidence$1, Ordering<ID> ord) {
        StorageLevel storageLevel = intermediateRDDStorageLevel;
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        Predef$.MODULE$.require(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "ALS is not designed to run without persisting intermediate RDDs.";
            }
        });
        SparkContext sc = ratings.sparkContext();
        HashPartitioner userPart = new HashPartitioner(numUserBlocks);
        HashPartitioner itemPart = new HashPartitioner(numItemBlocks);
        ALS.LocalIndexEncoder userLocalIndexEncoder = new ALS.LocalIndexEncoder(userPart.numPartitions());
        ALS.LocalIndexEncoder itemLocalIndexEncoder = new ALS.LocalIndexEncoder(itemPart.numPartitions());
        ALS.LeastSquaresNESolver solver = nonnegative ? new ALS.NNLSSolver() : new ALS.CholeskySolver();
        RDD blockRatings = this.partitionRatings(ratings, (Partitioner)userPart, (Partitioner)itemPart, evidence$1).persist(intermediateRDDStorageLevel);
        Tuple2<RDD<Tuple2<Object, ALS.InBlock<ID>>>, RDD<Tuple2<Object, int[][]>>> tuple2 = this.makeBlocks("user", blockRatings, (Partitioner)userPart, (Partitioner)itemPart, intermediateRDDStorageLevel, evidence$1, ord);
        if (tuple2 != null) {
            Tuple2 tuple22;
            RDD userInBlocks = (RDD)tuple2._1();
            RDD userOutBlocks = (RDD)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)userInBlocks, (Object)userOutBlocks);
            RDD userInBlocks2 = (RDD)tuple23._1();
            RDD userOutBlocks2 = (RDD)tuple23._2();
            userOutBlocks2.count();
            RDD swappedBlockRatings = blockRatings.map((Function1)new Serializable(evidence$1){
                public static final long serialVersionUID = 0L;
                private final ClassTag evidence$1$1;

                public final Tuple2<Tuple2<Object, Object>, ALS.RatingBlock<ID>> apply(Tuple2<Tuple2<Object, Object>, ALS.RatingBlock<ID>> x0$1) {
                    Tuple2<Tuple2<Object, Object>, ALS.RatingBlock<ID>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        Tuple2 tuple22 = (Tuple2)tuple2._1();
                        ALS.RatingBlock ratingBlock = (ALS.RatingBlock)tuple2._2();
                        if (tuple22 != null) {
                            int userBlockId = tuple22._1$mcI$sp();
                            int itemBlockId = tuple22._2$mcI$sp();
                            if (ratingBlock != null) {
                                Object userIds = ratingBlock.srcIds();
                                Object itemIds = ratingBlock.dstIds();
                                float[] localRatings = ratingBlock.ratings();
                                Tuple2 tuple23 = new Tuple2((Object)new Tuple2.mcII.sp(itemBlockId, userBlockId), new ALS.RatingBlock<ID>(itemIds, userIds, localRatings, this.evidence$1$1));
                                return tuple23;
                            }
                        }
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.evidence$1$1 = evidence$1$1;
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            Tuple2<RDD<Tuple2<Object, ALS.InBlock<ID>>>, RDD<Tuple2<Object, int[][]>>> tuple24 = this.makeBlocks("item", swappedBlockRatings, (Partitioner)itemPart, (Partitioner)userPart, intermediateRDDStorageLevel, evidence$1, ord);
            if (tuple24 != null) {
                BoxedUnit boxedUnit;
                Tuple2 tuple25;
                RDD itemInBlocks = (RDD)tuple24._1();
                RDD itemOutBlocks = (RDD)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)itemInBlocks, (Object)itemOutBlocks);
                RDD itemInBlocks2 = (RDD)tuple26._1();
                RDD itemOutBlocks2 = (RDD)tuple26._2();
                itemOutBlocks2.count();
                XORShiftRandom seedGen = new XORShiftRandom(seed);
                ObjectRef userFactors = ObjectRef.create(this.initialize(userInBlocks2, rank, seedGen.nextLong()));
                ObjectRef itemFactors = ObjectRef.create(this.initialize(itemInBlocks2, rank, seedGen.nextLong()));
                ObjectRef previousCheckpointFile = ObjectRef.create((Object)None$.MODULE$);
                Serializable shouldCheckpoint = new Serializable(checkpointInterval, sc){
                    public static final long serialVersionUID = 0L;
                    private final int checkpointInterval$1;
                    private final SparkContext sc$1;

                    public final boolean apply(int iter) {
                        return this.apply$mcZI$sp(iter);
                    }

                    public boolean apply$mcZI$sp(int iter) {
                        return this.sc$1.checkpointDir().isDefined() && iter % this.checkpointInterval$1 == 0;
                    }
                    {
                        this.checkpointInterval$1 = checkpointInterval$1;
                        this.sc$1 = sc$1;
                    }
                };
                Serializable deletePreviousCheckpointFile = new Serializable(sc, previousCheckpointFile){
                    public static final long serialVersionUID = 0L;
                    public final SparkContext sc$1;
                    private final ObjectRef previousCheckpointFile$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        ((Option)this.previousCheckpointFile$1.elem).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.2 $outer;

                            public final Object apply(String file) {
                                Object object;
                                try {
                                    object = BoxesRunTime.boxToBoolean((boolean)FileSystem.get((Configuration)this.$outer.sc$1.hadoopConfiguration()).delete(new Path(file), true));
                                }
                                catch (IOException iOException) {
                                    ALS$.MODULE$.logWarning((Function0<String>)new Serializable(this, file){
                                        public static final long serialVersionUID = 0L;
                                        private final String file$1;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot delete checkpoint file ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1}));
                                        }
                                        {
                                            this.file$1 = file$1;
                                        }
                                    }, iOException);
                                    object = BoxedUnit.UNIT;
                                }
                                return object;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        this.sc$1 = sc$1;
                        this.previousCheckpointFile$1 = previousCheckpointFile$1;
                    }
                };
                if (implicitPrefs) {
                    RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), maxIter).foreach((Function1)new Serializable(rank, regParam, implicitPrefs, alpha, intermediateRDDStorageLevel, userLocalIndexEncoder, itemLocalIndexEncoder, solver, userInBlocks2, userOutBlocks2, itemInBlocks2, itemOutBlocks2, userFactors, itemFactors, previousCheckpointFile, (Function1)shouldCheckpoint, (Function0)deletePreviousCheckpointFile){
                        public static final long serialVersionUID = 0L;
                        private final int rank$1;
                        private final double regParam$1;
                        private final boolean implicitPrefs$1;
                        private final double alpha$1;
                        private final StorageLevel intermediateRDDStorageLevel$1;
                        private final ALS.LocalIndexEncoder userLocalIndexEncoder$1;
                        private final ALS.LocalIndexEncoder itemLocalIndexEncoder$1;
                        private final ALS.LeastSquaresNESolver solver$1;
                        private final RDD userInBlocks$1;
                        private final RDD userOutBlocks$1;
                        private final RDD itemInBlocks$1;
                        private final RDD itemOutBlocks$1;
                        private final ObjectRef userFactors$1;
                        private final ObjectRef itemFactors$1;
                        private final ObjectRef previousCheckpointFile$1;
                        private final Function1 shouldCheckpoint$1;
                        private final Function0 deletePreviousCheckpointFile$1;

                        public final RDD<Tuple2<Object, float[][]>> apply(int iter) {
                            ((RDD)this.userFactors$1.elem).setName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"userFactors-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)iter)}))).persist(this.intermediateRDDStorageLevel$1);
                            RDD previousItemFactors = (RDD)this.itemFactors$1.elem;
                            this.itemFactors$1.elem = ALS$.MODULE$.org$apache$spark$ml$recommendation$ALS$$computeFactors((RDD<Tuple2<Object, float[][]>>)((RDD)this.userFactors$1.elem), (RDD<Tuple2<Object, int[][]>>)this.userOutBlocks$1, this.itemInBlocks$1, this.rank$1, this.regParam$1, this.userLocalIndexEncoder$1, this.implicitPrefs$1, this.alpha$1, this.solver$1);
                            previousItemFactors.unpersist(previousItemFactors.unpersist$default$1());
                            ((RDD)this.itemFactors$1.elem).setName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"itemFactors-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)iter)}))).persist(this.intermediateRDDStorageLevel$1);
                            if (this.shouldCheckpoint$1.apply$mcZI$sp(iter)) {
                                ((RDD)this.itemFactors$1.elem).checkpoint();
                            }
                            RDD previousUserFactors = (RDD)this.userFactors$1.elem;
                            this.userFactors$1.elem = ALS$.MODULE$.org$apache$spark$ml$recommendation$ALS$$computeFactors((RDD<Tuple2<Object, float[][]>>)((RDD)this.itemFactors$1.elem), (RDD<Tuple2<Object, int[][]>>)this.itemOutBlocks$1, this.userInBlocks$1, this.rank$1, this.regParam$1, this.itemLocalIndexEncoder$1, this.implicitPrefs$1, this.alpha$1, this.solver$1);
                            if (this.shouldCheckpoint$1.apply$mcZI$sp(iter)) {
                                this.deletePreviousCheckpointFile$1.apply$mcV$sp();
                                this.previousCheckpointFile$1.elem = ((RDD)this.itemFactors$1.elem).getCheckpointFile();
                            }
                            return previousUserFactors.unpersist(previousUserFactors.unpersist$default$1());
                        }
                        {
                            this.rank$1 = rank$1;
                            this.regParam$1 = regParam$1;
                            this.implicitPrefs$1 = implicitPrefs$1;
                            this.alpha$1 = alpha$1;
                            this.intermediateRDDStorageLevel$1 = intermediateRDDStorageLevel$1;
                            this.userLocalIndexEncoder$1 = userLocalIndexEncoder$1;
                            this.itemLocalIndexEncoder$1 = itemLocalIndexEncoder$1;
                            this.solver$1 = solver$1;
                            this.userInBlocks$1 = userInBlocks$1;
                            this.userOutBlocks$1 = userOutBlocks$1;
                            this.itemInBlocks$1 = itemInBlocks$1;
                            this.itemOutBlocks$1 = itemOutBlocks$1;
                            this.userFactors$1 = userFactors$1;
                            this.itemFactors$1 = itemFactors$1;
                            this.previousCheckpointFile$1 = previousCheckpointFile$1;
                            this.shouldCheckpoint$1 = shouldCheckpoint$1;
                            this.deletePreviousCheckpointFile$1 = deletePreviousCheckpointFile$1;
                        }
                    });
                } else {
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), maxIter).foreach$mVc$sp((Function1)new Serializable(rank, regParam, userLocalIndexEncoder, itemLocalIndexEncoder, solver, userInBlocks2, userOutBlocks2, itemInBlocks2, itemOutBlocks2, userFactors, itemFactors, previousCheckpointFile, (Function1)shouldCheckpoint, (Function0)deletePreviousCheckpointFile){
                        public static final long serialVersionUID = 0L;
                        private final int rank$1;
                        private final double regParam$1;
                        private final ALS.LocalIndexEncoder userLocalIndexEncoder$1;
                        private final ALS.LocalIndexEncoder itemLocalIndexEncoder$1;
                        private final ALS.LeastSquaresNESolver solver$1;
                        private final RDD userInBlocks$1;
                        private final RDD userOutBlocks$1;
                        private final RDD itemInBlocks$1;
                        private final RDD itemOutBlocks$1;
                        private final ObjectRef userFactors$1;
                        private final ObjectRef itemFactors$1;
                        private final ObjectRef previousCheckpointFile$1;
                        private final Function1 shouldCheckpoint$1;
                        private final Function0 deletePreviousCheckpointFile$1;

                        public final void apply(int iter) {
                            this.apply$mcVI$sp(iter);
                        }

                        public void apply$mcVI$sp(int iter) {
                            RDD x$21 = (RDD)this.userFactors$1.elem;
                            RDD x$22 = this.userOutBlocks$1;
                            RDD x$23 = this.itemInBlocks$1;
                            int x$24 = this.rank$1;
                            double x$25 = this.regParam$1;
                            ALS.LocalIndexEncoder x$26 = this.userLocalIndexEncoder$1;
                            ALS.LeastSquaresNESolver x$27 = this.solver$1;
                            boolean x$28 = ALS$.MODULE$.org$apache$spark$ml$recommendation$ALS$$computeFactors$default$7();
                            double x$29 = ALS$.MODULE$.org$apache$spark$ml$recommendation$ALS$$computeFactors$default$8();
                            this.itemFactors$1.elem = ALS$.MODULE$.org$apache$spark$ml$recommendation$ALS$$computeFactors((RDD<Tuple2<Object, float[][]>>)x$21, (RDD<Tuple2<Object, int[][]>>)x$22, x$23, x$24, x$25, x$26, x$28, x$29, x$27);
                            if (this.shouldCheckpoint$1.apply$mcZI$sp(iter)) {
                                ((RDD)this.itemFactors$1.elem).checkpoint();
                                ((RDD)this.itemFactors$1.elem).count();
                                this.deletePreviousCheckpointFile$1.apply$mcV$sp();
                                this.previousCheckpointFile$1.elem = ((RDD)this.itemFactors$1.elem).getCheckpointFile();
                            }
                            RDD x$30 = (RDD)this.itemFactors$1.elem;
                            RDD x$31 = this.itemOutBlocks$1;
                            RDD x$32 = this.userInBlocks$1;
                            int x$33 = this.rank$1;
                            double x$34 = this.regParam$1;
                            ALS.LocalIndexEncoder x$35 = this.itemLocalIndexEncoder$1;
                            ALS.LeastSquaresNESolver x$36 = this.solver$1;
                            boolean x$37 = ALS$.MODULE$.org$apache$spark$ml$recommendation$ALS$$computeFactors$default$7();
                            double x$38 = ALS$.MODULE$.org$apache$spark$ml$recommendation$ALS$$computeFactors$default$8();
                            this.userFactors$1.elem = ALS$.MODULE$.org$apache$spark$ml$recommendation$ALS$$computeFactors((RDD<Tuple2<Object, float[][]>>)x$30, (RDD<Tuple2<Object, int[][]>>)x$31, x$32, x$33, x$34, x$35, x$37, x$38, x$36);
                        }
                        {
                            this.rank$1 = rank$1;
                            this.regParam$1 = regParam$1;
                            this.userLocalIndexEncoder$1 = userLocalIndexEncoder$1;
                            this.itemLocalIndexEncoder$1 = itemLocalIndexEncoder$1;
                            this.solver$1 = solver$1;
                            this.userInBlocks$1 = userInBlocks$1;
                            this.userOutBlocks$1 = userOutBlocks$1;
                            this.itemInBlocks$1 = itemInBlocks$1;
                            this.itemOutBlocks$1 = itemOutBlocks$1;
                            this.userFactors$1 = userFactors$1;
                            this.itemFactors$1 = itemFactors$1;
                            this.previousCheckpointFile$1 = previousCheckpointFile$1;
                            this.shouldCheckpoint$1 = shouldCheckpoint$1;
                            this.deletePreviousCheckpointFile$1 = deletePreviousCheckpointFile$1;
                        }
                    });
                }
                RDD userIdAndFactors = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(userInBlocks2, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ALS.InBlock.class), (Ordering)Ordering.Int$.MODULE$).mapValues((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(ALS.InBlock<ID> x$4) {
                        return x$4.srcIds();
                    }
                }), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(evidence$1.runtimeClass())), (Ordering)Ordering.Int$.MODULE$).join((RDD)userFactors.elem).mapPartitions((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Iterator<Tuple2<ID, float[]>> apply(Iterator<Tuple2<Object, Tuple2<Object, float[][]>>> items) {
                        return items.flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final SeqView<Tuple2<ID, float[]>, Tuple2<ID, float[]>[]> apply(Tuple2<Object, Tuple2<Object, float[][]>> x0$2) {
                                Tuple2 tuple2;
                                Tuple2<Object, Tuple2<Object, float[][]>> tuple22 = x0$2;
                                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                                    Object ids = tuple2._1();
                                    float[][] factors = (float[][])tuple2._2();
                                    SeqView seqView = (SeqView)Predef$.MODULE$.genericArrayOps(ids).view().zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])factors), IndexedSeqView$.MODULE$.arrCanBuildFrom());
                                    return seqView;
                                }
                                throw new MatchError(tuple22);
                            }
                        });
                    }
                }, true, ClassTag$.MODULE$.apply(Tuple2.class)).setName("userFactors").persist(finalRDDStorageLevel);
                RDD itemIdAndFactors = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(itemInBlocks2, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ALS.InBlock.class), (Ordering)Ordering.Int$.MODULE$).mapValues((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(ALS.InBlock<ID> x$5) {
                        return x$5.srcIds();
                    }
                }), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(evidence$1.runtimeClass())), (Ordering)Ordering.Int$.MODULE$).join((RDD)itemFactors.elem).mapPartitions((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Iterator<Tuple2<ID, float[]>> apply(Iterator<Tuple2<Object, Tuple2<Object, float[][]>>> items) {
                        return items.flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final SeqView<Tuple2<ID, float[]>, Tuple2<ID, float[]>[]> apply(Tuple2<Object, Tuple2<Object, float[][]>> x0$3) {
                                Tuple2 tuple2;
                                Tuple2<Object, Tuple2<Object, float[][]>> tuple22 = x0$3;
                                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                                    Object ids = tuple2._1();
                                    float[][] factors = (float[][])tuple2._2();
                                    SeqView seqView = (SeqView)Predef$.MODULE$.genericArrayOps(ids).view().zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])factors), IndexedSeqView$.MODULE$.arrCanBuildFrom());
                                    return seqView;
                                }
                                throw new MatchError(tuple22);
                            }
                        });
                    }
                }, true, ClassTag$.MODULE$.apply(Tuple2.class)).setName("itemFactors").persist(finalRDDStorageLevel);
                StorageLevel storageLevel3 = finalRDDStorageLevel;
                StorageLevel storageLevel4 = StorageLevel$.MODULE$.NONE();
                if (!(storageLevel3 != null ? !storageLevel3.equals(storageLevel4) : storageLevel4 != null)) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    userIdAndFactors.count();
                    RDD qual$1 = (RDD)itemFactors.elem;
                    boolean x$39 = qual$1.unpersist$default$1();
                    qual$1.unpersist(x$39);
                    itemIdAndFactors.count();
                    userInBlocks2.unpersist(userInBlocks2.unpersist$default$1());
                    userOutBlocks2.unpersist(userOutBlocks2.unpersist$default$1());
                    itemInBlocks2.unpersist(itemInBlocks2.unpersist$default$1());
                    itemOutBlocks2.unpersist(itemOutBlocks2.unpersist$default$1());
                    boxedUnit = blockRatings.unpersist(blockRatings.unpersist$default$1());
                }
                return new Tuple2((Object)userIdAndFactors, (Object)itemIdAndFactors);
            }
            throw new MatchError(tuple24);
        }
        throw new MatchError(tuple2);
    }

    public <ID> int train$default$2() {
        return 10;
    }

    public <ID> int train$default$3() {
        return 10;
    }

    public <ID> int train$default$4() {
        return 10;
    }

    public <ID> int train$default$5() {
        return 10;
    }

    public <ID> double train$default$6() {
        return 1.0;
    }

    public <ID> boolean train$default$7() {
        return false;
    }

    public <ID> double train$default$8() {
        return 1.0;
    }

    public <ID> boolean train$default$9() {
        return false;
    }

    public <ID> StorageLevel train$default$10() {
        return StorageLevel$.MODULE$.MEMORY_AND_DISK();
    }

    public <ID> StorageLevel train$default$11() {
        return StorageLevel$.MODULE$.MEMORY_AND_DISK();
    }

    public <ID> int train$default$12() {
        return 10;
    }

    public <ID> long train$default$13() {
        return 0L;
    }

    private <ID> RDD<Tuple2<Object, float[][]>> initialize(RDD<Tuple2<Object, ALS.InBlock<ID>>> inBlocks, int rank, long seed) {
        return inBlocks.map((Function1)new Serializable(rank, seed){
            public static final long serialVersionUID = 0L;
            public final int rank$2;
            private final long seed$1;

            public final Tuple2<Object, float[][]> apply(Tuple2<Object, ALS.InBlock<ID>> x0$4) {
                Tuple2<Object, ALS.InBlock<ID>> tuple2 = x0$4;
                if (tuple2 != null) {
                    int srcBlockId = tuple2._1$mcI$sp();
                    ALS.InBlock inBlock = (ALS.InBlock)tuple2._2();
                    XORShiftRandom random = new XORShiftRandom(scala.util.hashing.package$.MODULE$.byteswap64(this.seed$1 ^ (long)srcBlockId));
                    float[][] factors = (float[][])Array$.MODULE$.fill(ScalaRunTime$.MODULE$.array_length(inBlock.srcIds()), (Function0)new Serializable(this, random){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.initialize.1 $outer;
                        public final XORShiftRandom random$1;

                        /*
                         * WARNING - void declaration
                         */
                        public final float[] apply() {
                            void var1_1;
                            float[] factor = (float[])Array$.MODULE$.fill(this.$outer.rank$2, (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$initialize$1$$anonfun$11 $outer;

                                public final float apply() {
                                    return this.apply$mcF$sp();
                                }

                                public float apply$mcF$sp() {
                                    return (float)this.$outer.random$1.nextGaussian();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, ClassTag$.MODULE$.Float());
                            float nrm = BLAS.getInstance().snrm2(this.$outer.rank$2, factor, 1);
                            BLAS.getInstance().sscal(this.$outer.rank$2, 1.0f / nrm, factor, 1);
                            return var1_1;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.random$1 = random$1;
                        }
                    }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)));
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)srcBlockId), (Object)factors);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.rank$2 = rank$2;
                this.seed$1 = seed$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private <ID> RDD<Tuple2<Tuple2<Object, Object>, ALS.RatingBlock<ID>>> partitionRatings(RDD<ALS.Rating<ID>> ratings, Partitioner srcPart, Partitioner dstPart, ClassTag<ID> evidence$5) {
        int numPartitions = srcPart.numPartitions() * dstPart.numPartitions();
        return RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(ratings.mapPartitions((Function1)new Serializable(srcPart, dstPart, evidence$5, numPartitions){
            public static final long serialVersionUID = 0L;
            public final Partitioner srcPart$1;
            public final Partitioner dstPart$1;
            public final ClassTag evidence$5$1;
            private final int numPartitions$1;

            public final Iterator<Tuple2<Tuple2<Object, Object>, ALS.RatingBlock<ID>>> apply(Iterator<ALS.Rating<ID>> iter) {
                ALS.RatingBlockBuilder[] builders = (ALS.RatingBlockBuilder[])Array$.MODULE$.fill(this.numPartitions$1, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.partitionRatings.1 $outer;

                    public final ALS.RatingBlockBuilder<ID> apply() {
                        return new ALS.RatingBlockBuilder<ID>(this.$outer.evidence$5$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.apply(ALS.RatingBlockBuilder.class));
                return iter.flatMap((Function1)new Serializable(this, builders){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.partitionRatings.1 $outer;
                    private final ALS.RatingBlockBuilder[] builders$1;

                    public final Iterator<Tuple2<Tuple2<Object, Object>, ALS.RatingBlock<ID>>> apply(ALS.Rating<ID> r) {
                        Iterator iterator;
                        int srcBlockId = this.$outer.srcPart$1.getPartition(r.user());
                        int dstBlockId = this.$outer.dstPart$1.getPartition(r.item());
                        int idx = srcBlockId + this.$outer.srcPart$1.numPartitions() * dstBlockId;
                        ALS.RatingBlockBuilder builder = this.builders$1[idx];
                        builder.add(r);
                        if (builder.size() >= 2048) {
                            this.builders$1[idx] = new ALS.RatingBlockBuilder<ID>(this.$outer.evidence$5$1);
                            iterator = package$.MODULE$.Iterator().single((Object)new Tuple2((Object)new Tuple2.mcII.sp(srcBlockId, dstBlockId), builder.build()));
                        } else {
                            iterator = package$.MODULE$.Iterator().empty();
                        }
                        return iterator;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.builders$1 = builders$1;
                    }
                }).$plus$plus((Function0)new Serializable(this, builders){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.partitionRatings.1 $outer;
                    private final ALS.RatingBlockBuilder[] builders$1;

                    public final Seq<Tuple2<Tuple2<Object, Object>, ALS.RatingBlock<ID>>> apply() {
                        return (Seq)((TraversableViewLike)Predef$.MODULE$.refArrayOps((Object[])this.builders$1).view().zipWithIndex(IndexedSeqView$.MODULE$.arrCanBuildFrom())).filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Tuple2<ALS.RatingBlockBuilder<ID>, Object> x$6) {
                                return ((ALS.RatingBlockBuilder)x$6._1()).size() > 0;
                            }
                        }).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$partitionRatings$1$$anonfun$apply$5 $outer;

                            public final Tuple2<Tuple2<Object, Object>, ALS.RatingBlock<ID>> apply(Tuple2<ALS.RatingBlockBuilder<ID>, Object> x0$5) {
                                Tuple2<ALS.RatingBlockBuilder<ID>, Object> tuple2 = x0$5;
                                if (tuple2 != null) {
                                    ALS.RatingBlockBuilder block = (ALS.RatingBlockBuilder)tuple2._1();
                                    int idx = tuple2._2$mcI$sp();
                                    int srcBlockId = idx % this.$outer.org$apache$spark$ml$recommendation$ALS$$anonfun$$anonfun$$$outer().srcPart$1.numPartitions();
                                    int dstBlockId = idx / this.$outer.org$apache$spark$ml$recommendation$ALS$$anonfun$$anonfun$$$outer().srcPart$1.numPartitions();
                                    Tuple2 tuple22 = new Tuple2((Object)new Tuple2.mcII.sp(srcBlockId, dstBlockId), block.build());
                                    return tuple22;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                    }

                    public /* synthetic */ anonfun.partitionRatings.1 org$apache$spark$ml$recommendation$ALS$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.builders$1 = builders$1;
                    }
                });
            }
            {
                this.srcPart$1 = srcPart$1;
                this.dstPart$1 = dstPart$1;
                this.evidence$5$1 = evidence$5$1;
                this.numPartitions$1 = numPartitions$1;
            }
        }, ratings.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(ALS.RatingBlock.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).groupByKey(), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Iterable.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).mapValues((Function1)new Serializable(evidence$5){
            public static final long serialVersionUID = 0L;
            private final ClassTag evidence$5$1;

            public final ALS.RatingBlock<ID> apply(Iterable<ALS.RatingBlock<ID>> blocks) {
                ALS.RatingBlockBuilder<ID> builder = new ALS.RatingBlockBuilder<ID>(this.evidence$5$1);
                blocks.foreach((Function1)new Serializable(this, builder){
                    public static final long serialVersionUID = 0L;
                    private final ALS.RatingBlockBuilder builder$1;

                    public final ALS.RatingBlockBuilder<ID> apply(ALS.RatingBlock<ID> other) {
                        return this.builder$1.merge(other);
                    }
                    {
                        this.builder$1 = builder$1;
                    }
                });
                return builder.build();
            }
            {
                this.evidence$5$1 = evidence$5$1;
            }
        }).setName("ratingBlocks");
    }

    private <ID> Tuple2<RDD<Tuple2<Object, ALS.InBlock<ID>>>, RDD<Tuple2<Object, int[][]>>> makeBlocks(String prefix, RDD<Tuple2<Tuple2<Object, Object>, ALS.RatingBlock<ID>>> ratingBlocks, Partitioner srcPart, Partitioner dstPart, StorageLevel storageLevel, ClassTag<ID> evidence$10, Ordering<ID> srcOrd) {
        RDD inBlocks = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(ratingBlocks.map((Function1)new Serializable(evidence$10, srcOrd){
            public static final long serialVersionUID = 0L;
            private final ClassTag evidence$10$1;
            private final Ordering srcOrd$1;

            public final Tuple2<Object, Tuple4<Object, Object, int[], float[]>> apply(Tuple2<Tuple2<Object, Object>, ALS.RatingBlock<ID>> x0$6) {
                Tuple2<Tuple2<Object, Object>, ALS.RatingBlock<ID>> tuple2 = x0$6;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    ALS.RatingBlock ratingBlock = (ALS.RatingBlock)tuple2._2();
                    if (tuple22 != null) {
                        int srcBlockId = tuple22._1$mcI$sp();
                        int dstBlockId = tuple22._2$mcI$sp();
                        if (ratingBlock != null) {
                            Object srcIds = ratingBlock.srcIds();
                            Object dstIds = ratingBlock.dstIds();
                            float[] ratings = ratingBlock.ratings();
                            long start2 = System.nanoTime();
                            OpenHashSet dstIdSet = new OpenHashSet(0x100000, this.evidence$10$1);
                            Predef$.MODULE$.genericArrayOps(dstIds).foreach((Function1)new Serializable(this, dstIdSet){
                                public static final long serialVersionUID = 0L;
                                private final OpenHashSet dstIdSet$1;

                                public final void apply(ID k) {
                                    this.dstIdSet$1.add(k);
                                }
                                {
                                    this.dstIdSet$1 = dstIdSet$1;
                                }
                            });
                            Object sortedDstIds = this.evidence$10$1.newArray(dstIdSet.size());
                            int i = 0;
                            int pos = dstIdSet.nextPos(0);
                            while (pos != -1) {
                                ScalaRunTime$.MODULE$.array_update(sortedDstIds, i, dstIdSet.getValue(pos));
                                pos = dstIdSet.nextPos(pos + 1);
                                ++i;
                            }
                            Predef$.MODULE$.assert(i == dstIdSet.size());
                            Sorting$.MODULE$.quickSort(sortedDstIds, this.srcOrd$1);
                            OpenHashMap.mcI.sp dstIdToLocalIndex = new OpenHashMap.mcI.sp(ScalaRunTime$.MODULE$.array_length(sortedDstIds), this.evidence$10$1, ClassTag$.MODULE$.Int());
                            for (i = 0; i < ScalaRunTime$.MODULE$.array_length(sortedDstIds); ++i) {
                                dstIdToLocalIndex.update$mcI$sp(ScalaRunTime$.MODULE$.array_apply(sortedDstIds, i), i);
                            }
                            ALS$.MODULE$.logDebug((Function0<String>)new Serializable(this, start2){
                                public static final long serialVersionUID = 0L;
                                private final long start$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Converting to local indices took ").append((Object)BoxesRunTime.boxToDouble((double)((double)(System.nanoTime() - this.start$1) / 1.0E9))).append((Object)" seconds.").toString();
                                }
                                {
                                    this.start$1 = start$1;
                                }
                            });
                            int[] dstLocalIndices = (int[])Predef$.MODULE$.genericArrayOps(dstIds).map((Function1)new Serializable(this, (OpenHashMap)dstIdToLocalIndex){
                                public static final long serialVersionUID = 0L;
                                private final OpenHashMap dstIdToLocalIndex$1;

                                public final int apply(ID k) {
                                    return this.dstIdToLocalIndex$1.apply$mcI$sp(k);
                                }
                                {
                                    this.dstIdToLocalIndex$1 = dstIdToLocalIndex$1;
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                            Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)srcBlockId), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)dstBlockId), srcIds, (Object)dstLocalIndices, (Object)ratings));
                            return tuple23;
                        }
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                this.evidence$10$1 = evidence$10$1;
                this.srcOrd$1 = srcOrd$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple4.class), (Ordering)Ordering.Int$.MODULE$).groupByKey((Partitioner)new HashPartitioner(srcPart.numPartitions())), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Iterable.class), (Ordering)Ordering.Int$.MODULE$).mapValues((Function1)new Serializable(dstPart, evidence$10, srcOrd){
            public static final long serialVersionUID = 0L;
            private final Partitioner dstPart$2;
            private final ClassTag evidence$10$1;
            private final Ordering srcOrd$1;

            public final ALS.InBlock<ID> apply(Iterable<Tuple4<Object, Object, int[], float[]>> iter) {
                ALS.UncompressedInBlockBuilder<ID> builder = new ALS.UncompressedInBlockBuilder<ID>(new ALS.LocalIndexEncoder(this.dstPart$2.numPartitions()), this.evidence$10$1, this.srcOrd$1);
                iter.foreach((Function1)new Serializable(this, builder){
                    public static final long serialVersionUID = 0L;
                    private final ALS.UncompressedInBlockBuilder builder$2;

                    public final ALS.UncompressedInBlockBuilder<ID> apply(Tuple4<Object, Object, int[], float[]> x0$7) {
                        Tuple4<Object, Object, int[], float[]> tuple4 = x0$7;
                        if (tuple4 != null) {
                            int dstBlockId = BoxesRunTime.unboxToInt((Object)tuple4._1());
                            Object srcIds = tuple4._2();
                            int[] dstLocalIndices = (int[])tuple4._3();
                            float[] ratings = (float[])tuple4._4();
                            ALS.UncompressedInBlockBuilder<ID> uncompressedInBlockBuilder = this.builder$2.add(dstBlockId, srcIds, dstLocalIndices, ratings);
                            return uncompressedInBlockBuilder;
                        }
                        throw new MatchError(tuple4);
                    }
                    {
                        this.builder$2 = builder$2;
                    }
                });
                return builder.build().compress();
            }
            {
                this.dstPart$2 = dstPart$2;
                this.evidence$10$1 = evidence$10$1;
                this.srcOrd$1 = srcOrd$1;
            }
        }).setName(new StringBuilder().append((Object)prefix).append((Object)"InBlocks").toString()).persist(storageLevel);
        RDD outBlocks = RDD$.MODULE$.rddToPairRDDFunctions(inBlocks, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ALS.InBlock.class), (Ordering)Ordering.Int$.MODULE$).mapValues((Function1)new Serializable(dstPart){
            public static final long serialVersionUID = 0L;
            private final Partitioner dstPart$2;

            public final int[][] apply(ALS.InBlock<ID> x0$8) {
                ALS.InBlock<ID> inBlock = x0$8;
                if (inBlock != null) {
                    Object srcIds = inBlock.srcIds();
                    int[] dstPtrs = inBlock.dstPtrs();
                    int[] dstEncodedIndices = inBlock.dstEncodedIndices();
                    ALS.LocalIndexEncoder encoder = new ALS.LocalIndexEncoder(this.dstPart$2.numPartitions());
                    ArrayBuilder[] activeIds = (ArrayBuilder[])Array$.MODULE$.fill(this.dstPart$2.numPartitions(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ArrayBuilder<Object> apply() {
                            return ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Int());
                        }
                    }, ClassTag$.MODULE$.apply(ArrayBuilder.class));
                    boolean[] seen = new boolean[this.dstPart$2.numPartitions()];
                    for (int i = 0; i < ScalaRunTime$.MODULE$.array_length(srcIds); ++i) {
                        Arrays.fill(seen, false);
                        for (int j = dstPtrs[i]; j < dstPtrs[i + 1]; ++j) {
                            int dstBlockId = encoder.blockId(dstEncodedIndices[j]);
                            if (seen[dstBlockId]) continue;
                            activeIds[dstBlockId].$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                            seen[dstBlockId] = true;
                        }
                    }
                    int[][] nArray = (int[][])Predef$.MODULE$.refArrayOps((Object[])activeIds).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int[] apply(ArrayBuilder<Object> x) {
                            return (int[])x.result();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
                    return nArray;
                }
                throw new MatchError(inBlock);
            }
            {
                this.dstPart$2 = dstPart$2;
            }
        }).setName(new StringBuilder().append((Object)prefix).append((Object)"OutBlocks").toString()).persist(storageLevel);
        return new Tuple2((Object)inBlocks, (Object)outBlocks);
    }

    public <ID> RDD<Tuple2<Object, float[][]>> org$apache$spark$ml$recommendation$ALS$$computeFactors(RDD<Tuple2<Object, float[][]>> srcFactorBlocks, RDD<Tuple2<Object, int[][]>> srcOutBlocks, RDD<Tuple2<Object, ALS.InBlock<ID>>> dstInBlocks, int rank, double regParam, ALS.LocalIndexEncoder srcEncoder, boolean implicitPrefs, double alpha, ALS.LeastSquaresNESolver solver) {
        int numSrcBlocks = srcFactorBlocks.partitions().length;
        None$ YtY = implicitPrefs ? new Some((Object)this.computeYtY(srcFactorBlocks, rank)) : None$.MODULE$;
        RDD srcOut = RDD$.MODULE$.rddToPairRDDFunctions(srcOutBlocks, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))), (Ordering)Ordering.Int$.MODULE$).join(srcFactorBlocks).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Tuple2<Object, Tuple2<Object, float[][]>>> apply(Tuple2<Object, Tuple2<int[][], float[][]>> x0$9) {
                Tuple2<Object, Tuple2<int[][], float[][]>> tuple2 = x0$9;
                if (tuple2 != null) {
                    int srcBlockId = tuple2._1$mcI$sp();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        int[][] srcOutBlock = (int[][])tuple22._1();
                        float[][] srcFactors = (float[][])tuple22._2();
                        Seq seq = (Seq)((TraversableViewLike)Predef$.MODULE$.refArrayOps((Object[])srcOutBlock).view().zipWithIndex(IndexedSeqView$.MODULE$.arrCanBuildFrom())).map((Function1)new Serializable(this, srcBlockId, srcFactors){
                            public static final long serialVersionUID = 0L;
                            private final int srcBlockId$1;
                            public final float[][] srcFactors$1;

                            public final Tuple2<Object, Tuple2<Object, float[][]>> apply(Tuple2<int[], Object> x0$10) {
                                Tuple2<int[], Object> tuple2 = x0$10;
                                if (tuple2 != null) {
                                    int[] activeIndices = (int[])tuple2._1();
                                    int dstBlockId = tuple2._2$mcI$sp();
                                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)dstBlockId), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.srcBlockId$1), Predef$.MODULE$.intArrayOps(activeIndices).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ anonfun$18$$anonfun$apply$13 $outer;

                                        public final float[] apply(int idx) {
                                            return this.$outer.srcFactors$1[idx];
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE))))));
                                    return tuple22;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.srcBlockId$1 = srcBlockId$1;
                                this.srcFactors$1 = srcFactors$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        return seq;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD merged = RDD$.MODULE$.rddToPairRDDFunctions(srcOut, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).groupByKey((Partitioner)new HashPartitioner(dstInBlocks.partitions().length));
        return RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(dstInBlocks, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ALS.InBlock.class), (Ordering)Ordering.Int$.MODULE$).join(merged), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).mapValues((Function1)new Serializable(rank, regParam, srcEncoder, implicitPrefs, alpha, solver, numSrcBlocks, (Option)YtY){
            public static final long serialVersionUID = 0L;
            private final int rank$3;
            private final double regParam$2;
            private final ALS.LocalIndexEncoder srcEncoder$1;
            private final boolean implicitPrefs$2;
            private final double alpha$2;
            private final ALS.LeastSquaresNESolver solver$2;
            private final int numSrcBlocks$1;
            private final Option YtY$1;

            public final float[][] apply(Tuple2<ALS.InBlock<ID>, Iterable<Tuple2<Object, float[][]>>> x0$11) {
                Tuple2<ALS.InBlock<ID>, Iterable<Tuple2<Object, float[][]>>> tuple2 = x0$11;
                if (tuple2 != null) {
                    ALS.InBlock inBlock = (ALS.InBlock)tuple2._1();
                    Iterable srcFactors = (Iterable)tuple2._2();
                    if (inBlock != null) {
                        Object dstIds = inBlock.srcIds();
                        int[] srcPtrs = inBlock.dstPtrs();
                        int[] srcEncodedIndices = inBlock.dstEncodedIndices();
                        float[] ratings = inBlock.ratings();
                        float[][][] sortedSrcFactors = new float[this.numSrcBlocks$1][][];
                        srcFactors.foreach((Function1)new Serializable(this, sortedSrcFactors){
                            public static final long serialVersionUID = 0L;
                            private final float[][][] sortedSrcFactors$1;

                            public final void apply(Tuple2<Object, float[][]> x0$12) {
                                Tuple2<Object, float[][]> tuple2 = x0$12;
                                if (tuple2 != null) {
                                    int srcBlockId = tuple2._1$mcI$sp();
                                    float[][] factors = (float[][])tuple2._2();
                                    this.sortedSrcFactors$1[srcBlockId] = factors;
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.sortedSrcFactors$1 = sortedSrcFactors$1;
                            }
                        });
                        float[][] dstFactors = new float[ScalaRunTime$.MODULE$.array_length(dstIds)][];
                        ALS.NormalEquation ls = new ALS.NormalEquation(this.rank$3);
                        for (int j = 0; j < ScalaRunTime$.MODULE$.array_length(dstIds); ++j) {
                            ls.reset();
                            Object object = this.implicitPrefs$2 ? ls.merge((ALS.NormalEquation)this.YtY$1.get()) : BoxedUnit.UNIT;
                            int numExplicits = 0;
                            for (int i = srcPtrs[j]; i < srcPtrs[j + 1]; ++i) {
                                Object object2;
                                int encoded = srcEncodedIndices[i];
                                int blockId = this.srcEncoder$1.blockId(encoded);
                                int localIndex = this.srcEncoder$1.localIndex(encoded);
                                float[] srcFactor = sortedSrcFactors[blockId][localIndex];
                                float rating = ratings[i];
                                if (this.implicitPrefs$2) {
                                    double c1 = this.alpha$2 * (double)scala.math.package$.MODULE$.abs(rating);
                                    if (rating > 0.0f) {
                                        ++numExplicits;
                                        object2 = ls.add(srcFactor, (c1 + 1.0) / c1, c1);
                                        continue;
                                    }
                                    object2 = BoxedUnit.UNIT;
                                    continue;
                                }
                                ls.add(srcFactor, rating, ls.add$default$3());
                                ++numExplicits;
                                object2 = BoxedUnit.UNIT;
                            }
                            dstFactors[j] = this.solver$2.solve(ls, (double)numExplicits * this.regParam$2);
                        }
                        float[][] fArrayArray = dstFactors;
                        return fArrayArray;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                this.rank$3 = rank$3;
                this.regParam$2 = regParam$2;
                this.srcEncoder$1 = srcEncoder$1;
                this.implicitPrefs$2 = implicitPrefs$2;
                this.alpha$2 = alpha$2;
                this.solver$2 = solver$2;
                this.numSrcBlocks$1 = numSrcBlocks$1;
                this.YtY$1 = YtY$1;
            }
        });
    }

    public <ID> boolean org$apache$spark$ml$recommendation$ALS$$computeFactors$default$7() {
        return false;
    }

    public <ID> double org$apache$spark$ml$recommendation$ALS$$computeFactors$default$8() {
        return 1.0;
    }

    private ALS.NormalEquation computeYtY(RDD<Tuple2<Object, float[][]>> factorBlocks, int rank) {
        return (ALS.NormalEquation)RDD$.MODULE$.rddToPairRDDFunctions(factorBlocks, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE))), (Ordering)Ordering.Int$.MODULE$).values().aggregate((Object)new ALS.NormalEquation(rank), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ALS.NormalEquation apply(ALS.NormalEquation ne, float[][] factors) {
                Predef$.MODULE$.refArrayOps((Object[])factors).foreach((Function1)new Serializable(this, ne){
                    public static final long serialVersionUID = 0L;
                    private final ALS.NormalEquation ne$1;

                    public final ALS.NormalEquation apply(float[] x$7) {
                        return this.ne$1.add(x$7, 0.0, this.ne$1.add$default$3());
                    }
                    {
                        this.ne$1 = ne$1;
                    }
                });
                return ne;
            }
        }, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ALS.NormalEquation apply(ALS.NormalEquation ne1, ALS.NormalEquation ne2) {
                return ne1.merge(ne2);
            }
        }, ClassTag$.MODULE$.apply(ALS.NormalEquation.class));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ALS$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

