/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import org.apache.spark.SparkException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasElasticNetParam$class;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasRegParam$class;
import org.apache.spark.ml.param.shared.HasStandardization$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.regression.LinearRegressionModel$;
import org.apache.spark.ml.regression.LinearRegressionParams;
import org.apache.spark.ml.regression.LinearRegressionSummary;
import org.apache.spark.ml.regression.LinearRegressionTrainingSummary;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001B\u0001\u0003\u00015\u0011Q\u0003T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8N_\u0012,GN\u0003\u0002\u0004\t\u0005Q!/Z4sKN\u001c\u0018n\u001c8\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019Y\u0002\u0003B\b\u0011%ii\u0011AA\u0005\u0003#\t\u0011qBU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\t\u0003'ai\u0011\u0001\u0006\u0006\u0003+Y\ta\u0001\\5oC2<'BA\f\u0007\u0003\u0015iG\u000e\\5c\u0013\tIBC\u0001\u0004WK\u000e$xN\u001d\t\u0003\u001f\u0001\u0001\"a\u0004\u000f\n\u0005u\u0011!A\u0006'j]\u0016\f'OU3he\u0016\u001c8/[8o!\u0006\u0014\u0018-\\:\t\u0011}\u0001!Q1A\u0005B\u0001\n1!^5e+\u0005\t\u0003C\u0001\u0012)\u001d\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011F\u000b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u001d\"\u0003\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0011\u0002\tULG\r\t\u0005\t]\u0001\u0011)\u0019!C\u0001_\u00059q/Z5hQR\u001cX#\u0001\n\t\u0011E\u0002!\u0011!Q\u0001\nI\t\u0001b^3jO\"$8\u000f\t\u0005\tg\u0001\u0011)\u0019!C\u0001i\u0005I\u0011N\u001c;fe\u000e,\u0007\u000f^\u000b\u0002kA\u00111EN\u0005\u0003o\u0011\u0012a\u0001R8vE2,\u0007\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u001b\u0002\u0015%tG/\u001a:dKB$\b\u0005\u0003\u0004<\u0001\u0011\u0005A\u0001P\u0001\u0007y%t\u0017\u000e\u001e \u0015\tiidh\u0010\u0005\u0006?i\u0002\r!\t\u0005\u0006]i\u0002\rA\u0005\u0005\u0006gi\u0002\r!\u000e\u0005\b\u0003\u0002\u0001\r\u0011\"\u0003C\u0003=!(/Y5oS:<7+^7nCJLX#A\"\u0011\u0007\r\"e)\u0003\u0002FI\t1q\n\u001d;j_:\u0004\"aD$\n\u0005!\u0013!a\b'j]\u0016\f'OU3he\u0016\u001c8/[8o)J\f\u0017N\\5oON+X.\\1ss\"9!\n\u0001a\u0001\n\u0013Y\u0015a\u0005;sC&t\u0017N\\4Tk6l\u0017M]=`I\u0015\fHC\u0001'P!\t\u0019S*\u0003\u0002OI\t!QK\\5u\u0011\u001d\u0001\u0016*!AA\u0002\r\u000b1\u0001\u001f\u00132\u0011\u0019\u0011\u0006\u0001)Q\u0005\u0007\u0006\u0001BO]1j]&twmU;n[\u0006\u0014\u0018\u0010\t\u0005\u0006)\u0002!\t!V\u0001\bgVlW.\u0019:z+\u00051\u0005BB,\u0001\t\u0003\u0011\u0001,\u0001\u0006tKR\u001cV/\\7bef$\"!\u0017.\u000e\u0003\u0001AQ\u0001\u0016,A\u0002\u0019CQ\u0001\u0018\u0001\u0005\u0002u\u000b!\u0002[1t'VlW.\u0019:z+\u0005q\u0006CA\u0012`\u0013\t\u0001GEA\u0004C_>dW-\u00198\t\r\t\u0004A\u0011\u0001\u0002d\u0003!)g/\u00197vCR,GC\u00013h!\tyQ-\u0003\u0002g\u0005\t9B*\u001b8fCJ\u0014Vm\u001a:fgNLwN\\*v[6\f'/\u001f\u0005\u0006Q\u0006\u0004\r![\u0001\bI\u0006$\u0018m]3u!\tQW.D\u0001l\u0015\tag!A\u0002tc2L!A\\6\u0003\u0013\u0011\u000bG/\u0019$sC6,\u0007\"\u00029\u0001\t#\n\u0018a\u00029sK\u0012L7\r\u001e\u000b\u0003kIDQa]8A\u0002I\t\u0001BZ3biV\u0014Xm\u001d\u0005\u0006k\u0002!\tE^\u0001\u0005G>\u0004\u0018\u0010\u0006\u0002\u001bo\")\u0001\u0010\u001ea\u0001s\u0006)Q\r\u001f;sCB\u0011!0`\u0007\u0002w*\u0011A\u0010B\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0003}n\u0014\u0001\u0002U1sC6l\u0015\r\u001d\u0015\u0004\u0001\u0005\u0005\u0001\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001da!\u0001\u0006b]:|G/\u0019;j_:LA!a\u0003\u0002\u0006\taQ\t\u001f9fe&lWM\u001c;bY\u0002")
public class LinearRegressionModel
extends RegressionModel<Vector, LinearRegressionModel>
implements LinearRegressionParams {
    private final String uid;
    private final Vector weights;
    private final double intercept;
    private Option<LinearRegressionTrainingSummary> trainingSummary;
    private final BooleanParam standardization;
    private final BooleanParam fitIntercept;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization$class.getStandardization(this);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam$class.getElasticNetParam(this);
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector weights() {
        return this.weights;
    }

    public double intercept() {
        return this.intercept;
    }

    private Option<LinearRegressionTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    private void trainingSummary_$eq(Option<LinearRegressionTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    public LinearRegressionTrainingSummary summary() {
        Option<LinearRegressionTrainingSummary> option = this.trainingSummary();
        if (option instanceof Some) {
            LinearRegressionTrainingSummary summ;
            Some some = (Some)option;
            LinearRegressionTrainingSummary linearRegressionTrainingSummary = summ = (LinearRegressionTrainingSummary)some.x();
            return linearRegressionTrainingSummary;
        }
        if (None$.MODULE$.equals(option)) {
            throw new SparkException("No training summary available for this LinearRegressionModel", (Throwable)new NullPointerException());
        }
        throw new MatchError(option);
    }

    public LinearRegressionModel setSummary(LinearRegressionTrainingSummary summary) {
        this.trainingSummary_$eq((Option<LinearRegressionTrainingSummary>)new Some((Object)summary));
        return this;
    }

    public boolean hasSummary() {
        return this.trainingSummary().isDefined();
    }

    public LinearRegressionSummary evaluate(DataFrame dataset) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LinearRegressionModel.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_LinearRegressionModel$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.mllib.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_LinearRegressionModel$$typecreator1$1(LinearRegressionModel $outer) {
            }
        }
        UserDefinedFunction t = functions$.MODULE$.udf((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionModel $outer;

            public final double apply(Vector features) {
                return this.$outer.predict(features);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_LinearRegressionModel$$typecreator1$1(this)));
        DataFrame predictionAndObservations = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.labelCol())), t.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).as(this.$(this.predictionCol()))}));
        return new LinearRegressionSummary(predictionAndObservations, this.$(this.predictionCol()), this.$(this.labelCol()));
    }

    @Override
    public double predict(Vector features) {
        return BLAS$.MODULE$.dot(features, this.weights()) + this.intercept();
    }

    @Override
    public LinearRegressionModel copy(ParamMap extra) {
        LinearRegressionModel newModel = this.copyValues(new LinearRegressionModel(this.uid(), this.weights(), this.intercept()), this.copyValues$default$2());
        Object object = this.trainingSummary().isDefined() ? newModel.setSummary((LinearRegressionTrainingSummary)this.trainingSummary().get()) : BoxedUnit.UNIT;
        return (LinearRegressionModel)newModel.setParent(this.parent());
    }

    public LinearRegressionModel(String uid, Vector weights2, double intercept2) {
        this.uid = uid;
        this.weights = weights2;
        this.intercept = intercept2;
        HasRegParam$class.$init$(this);
        HasElasticNetParam$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasTol$class.$init$(this);
        HasFitIntercept$class.$init$(this);
        HasStandardization$class.$init$(this);
        this.trainingSummary = None$.MODULE$;
    }
}

