/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.generic.UFunc;
import breeze.linalg.$times$;
import breeze.linalg.BitVector;
import breeze.linalg.BroadcastedColumns$;
import breeze.linalg.Broadcaster$;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Matrix;
import breeze.linalg.Matrix$;
import breeze.linalg.NumericOps;
import breeze.linalg.all$;
import breeze.linalg.package;
import breeze.linalg.sum$;
import breeze.linalg.support.CanTraverseValues;
import breeze.math.Ring$;
import breeze.math.Semiring;
import breeze.math.Semiring$;
import breeze.numerics.package;
import breeze.stats.distributions.Gamma;
import breeze.stats.distributions.RandBasis;
import breeze.storage.Zero;
import java.util.Random;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.clustering.LDA;
import org.apache.spark.mllib.clustering.LDAModel;
import org.apache.spark.mllib.clustering.LDAOptimizer;
import org.apache.spark.mllib.clustering.LDAUtils$;
import org.apache.spark.mllib.clustering.LocalLDAModel;
import org.apache.spark.mllib.clustering.OnlineLDAOptimizer$;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\t5f\u0001B\u0001\u0003\u00055\u0011!c\u00148mS:,G\nR!PaRLW.\u001b>fe*\u00111\u0001B\u0001\u000bG2,8\u000f^3sS:<'BA\u0003\u0007\u0003\u0015iG\u000e\\5c\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0016-5\t!!\u0003\u0002\u0018\u0005\taA\nR!PaRLW.\u001b>fe\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u0003+\u0001Aq!\b\u0001A\u0002\u0013%a$A\u0001l+\u0005y\u0002CA\b!\u0013\t\t\u0003CA\u0002J]RDqa\t\u0001A\u0002\u0013%A%A\u0003l?\u0012*\u0017\u000f\u0006\u0002&QA\u0011qBJ\u0005\u0003OA\u0011A!\u00168ji\"9\u0011FIA\u0001\u0002\u0004y\u0012a\u0001=%c!11\u0006\u0001Q!\n}\t!a\u001b\u0011\t\u000f5\u0002\u0001\u0019!C\u0005]\u0005Q1m\u001c:qkN\u001c\u0016N_3\u0016\u0003=\u0002\"a\u0004\u0019\n\u0005E\u0002\"\u0001\u0002'p]\u001eDqa\r\u0001A\u0002\u0013%A'\u0001\bd_J\u0004Xo]*ju\u0016|F%Z9\u0015\u0005\u0015*\u0004bB\u00153\u0003\u0003\u0005\ra\f\u0005\u0007o\u0001\u0001\u000b\u0015B\u0018\u0002\u0017\r|'\u000f];t'&TX\r\t\u0005\bs\u0001\u0001\r\u0011\"\u0003\u001f\u0003%1xnY1c'&TX\rC\u0004<\u0001\u0001\u0007I\u0011\u0002\u001f\u0002\u001bY|7-\u00192TSj,w\fJ3r)\t)S\bC\u0004*u\u0005\u0005\t\u0019A\u0010\t\r}\u0002\u0001\u0015)\u0003 \u0003)1xnY1c'&TX\r\t\u0005\b\u0003\u0002\u0001\r\u0011\"\u0003C\u0003\u0015\tG\u000e\u001d5b+\u0005\u0019\u0005C\u0001#H\u001b\u0005)%B\u0001$\u0005\u0003\u0019a\u0017N\\1mO&\u0011\u0001*\u0012\u0002\u0007-\u0016\u001cGo\u001c:\t\u000f)\u0003\u0001\u0019!C\u0005\u0017\u0006I\u0011\r\u001c9iC~#S-\u001d\u000b\u0003K1Cq!K%\u0002\u0002\u0003\u00071\t\u0003\u0004O\u0001\u0001\u0006KaQ\u0001\u0007C2\u0004\b.\u0019\u0011\t\rA\u0003A\u0011\u0001\u0002C\u0003!9W\r^!ma\"\f\u0007b\u0002*\u0001\u0001\u0004%IaU\u0001\u0004KR\fW#\u0001+\u0011\u0005=)\u0016B\u0001,\u0011\u0005\u0019!u.\u001e2mK\"9\u0001\f\u0001a\u0001\n\u0013I\u0016aB3uC~#S-\u001d\u000b\u0003KiCq!K,\u0002\u0002\u0003\u0007A\u000b\u0003\u0004]\u0001\u0001\u0006K\u0001V\u0001\u0005KR\f\u0007\u0005\u0003\u0004_\u0001\u0011\u0005!aU\u0001\u0007O\u0016$X\t^1\t\u000f\u0001\u0004\u0001\u0019!C\u0005C\u0006y!/\u00198e_6<UM\\3sCR|'/F\u0001c!\t\u0019\u0007.D\u0001e\u0015\t)g-\u0001\u0003vi&d'\"A4\u0002\t)\fg/Y\u0005\u0003S\u0012\u0014aAU1oI>l\u0007bB6\u0001\u0001\u0004%I\u0001\\\u0001\u0014e\u0006tGm\\7HK:,'/\u0019;pe~#S-\u001d\u000b\u0003K5Dq!\u000b6\u0002\u0002\u0003\u0007!\r\u0003\u0004p\u0001\u0001\u0006KAY\u0001\u0011e\u0006tGm\\7HK:,'/\u0019;pe\u0002Bq!\u001d\u0001A\u0002\u0013%!/A\u000btC6\u0004H.Z,ji\"\u0014V\r\u001d7bG\u0016lWM\u001c;\u0016\u0003M\u0004\"a\u0004;\n\u0005U\u0004\"a\u0002\"p_2,\u0017M\u001c\u0005\bo\u0002\u0001\r\u0011\"\u0003y\u0003e\u0019\u0018-\u001c9mK^KG\u000f\u001b*fa2\f7-Z7f]R|F%Z9\u0015\u0005\u0015J\bbB\u0015w\u0003\u0003\u0005\ra\u001d\u0005\u0007w\u0002\u0001\u000b\u0015B:\u0002-M\fW\u000e\u001d7f/&$\bNU3qY\u0006\u001cW-\\3oi\u0002Bq! \u0001A\u0002\u0013%1+\u0001\u0003uCV\u0004\u0004\u0002C@\u0001\u0001\u0004%I!!\u0001\u0002\u0011Q\fW\u000fM0%KF$2!JA\u0002\u0011\u001dIc0!AA\u0002QCq!a\u0002\u0001A\u0003&A+A\u0003uCV\u0004\u0004\u0005\u0003\u0005\u0002\f\u0001\u0001\r\u0011\"\u0003T\u0003\u0015Y\u0017\r\u001d9b\u0011%\ty\u0001\u0001a\u0001\n\u0013\t\t\"A\u0005lCB\u0004\u0018m\u0018\u0013fcR\u0019Q%a\u0005\t\u0011%\ni!!AA\u0002QCq!a\u0006\u0001A\u0003&A+\u0001\u0004lCB\u0004\u0018\r\t\u0005\t\u00037\u0001\u0001\u0019!C\u0005'\u0006\tR.\u001b8j\u0005\u0006$8\r\u001b$sC\u000e$\u0018n\u001c8\t\u0013\u0005}\u0001\u00011A\u0005\n\u0005\u0005\u0012!F7j]&\u0014\u0015\r^2i\rJ\f7\r^5p]~#S-\u001d\u000b\u0004K\u0005\r\u0002\u0002C\u0015\u0002\u001e\u0005\u0005\t\u0019\u0001+\t\u000f\u0005\u001d\u0002\u0001)Q\u0005)\u0006\u0011R.\u001b8j\u0005\u0006$8\r\u001b$sC\u000e$\u0018n\u001c8!\u0011!\tY\u0003\u0001a\u0001\n\u0013\u0011\u0018\u0001G8qi&l\u0017N_3E_\u000e\u001cuN\\2f]R\u0014\u0018\r^5p]\"I\u0011q\u0006\u0001A\u0002\u0013%\u0011\u0011G\u0001\u001d_B$\u0018.\\5{K\u0012{7mQ8oG\u0016tGO]1uS>tw\fJ3r)\r)\u00131\u0007\u0005\tS\u00055\u0012\u0011!a\u0001g\"9\u0011q\u0007\u0001!B\u0013\u0019\u0018!G8qi&l\u0017N_3E_\u000e\u001cuN\\2f]R\u0014\u0018\r^5p]\u0002B\u0011\"a\u000f\u0001\u0001\u0004%I!!\u0010\u0002\t\u0011|7m]\u000b\u0003\u0003\u007f\u0001b!!\u0011\u0002H\u0005-SBAA\"\u0015\r\t)EB\u0001\u0004e\u0012$\u0017\u0002BA%\u0003\u0007\u00121A\u0015#E!\u0015y\u0011QJ\u0018D\u0013\r\ty\u0005\u0005\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\u0005M\u0003\u00011A\u0005\n\u0005U\u0013\u0001\u00033pGN|F%Z9\u0015\u0007\u0015\n9\u0006C\u0005*\u0003#\n\t\u00111\u0001\u0002@!A\u00111\f\u0001!B\u0013\ty$A\u0003e_\u000e\u001c\b\u0005C\u0005\u0002`\u0001\u0001\r\u0011\"\u0003\u0002b\u00051A.Y7cI\u0006,\"!a\u0019\u0011\u000b\u0005\u0015\u0014Q\u000e+\u000e\u0005\u0005\u001d$b\u0001$\u0002j)\u0011\u00111N\u0001\u0007EJ,WM_3\n\t\u0005=\u0014q\r\u0002\f\t\u0016t7/Z'biJL\u0007\u0010C\u0005\u0002t\u0001\u0001\r\u0011\"\u0003\u0002v\u0005QA.Y7cI\u0006|F%Z9\u0015\u0007\u0015\n9\bC\u0005*\u0003c\n\t\u00111\u0001\u0002d!A\u00111\u0010\u0001!B\u0013\t\u0019'A\u0004mC6\u0014G-\u0019\u0011\t\u0011\u0005}\u0004\u0001\"\u0001\u0003\u0003C\n\u0011bZ3u\u0019\u0006l'\rZ1\t\u0011\u0005\r\u0005\u00011A\u0005\ny\t\u0011\"\u001b;fe\u0006$\u0018n\u001c8\t\u0013\u0005\u001d\u0005\u00011A\u0005\n\u0005%\u0015!D5uKJ\fG/[8o?\u0012*\u0017\u000fF\u0002&\u0003\u0017C\u0001\"KAC\u0003\u0003\u0005\ra\b\u0005\b\u0003\u001f\u0003\u0001\u0015)\u0003 \u0003)IG/\u001a:bi&|g\u000e\t\u0005\t\u0003'\u0003\u0001\u0019!C\u0005'\u0006Qq-Y7nCNC\u0017\r]3\t\u0013\u0005]\u0005\u00011A\u0005\n\u0005e\u0015AD4b[6\f7\u000b[1qK~#S-\u001d\u000b\u0004K\u0005m\u0005\u0002C\u0015\u0002\u0016\u0006\u0005\t\u0019\u0001+\t\u000f\u0005}\u0005\u0001)Q\u0005)\u0006Yq-Y7nCNC\u0017\r]3!\u0011\u0019\t\u0019\u000b\u0001C\u0001'\u00069q-\u001a;UCV\u0004\u0004FBAQ\u0003O\u000b\u0019\f\u0005\u0003\u0002*\u0006=VBAAV\u0015\r\tiKB\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAY\u0003W\u0013QaU5oG\u0016\f#!!.\u0002\u000bErCG\f\u0019\t\u000f\u0005e\u0006\u0001\"\u0001\u0002<\u000691/\u001a;UCV\u0004D\u0003BA_\u0003\u007fk\u0011\u0001\u0001\u0005\u0007{\u0006]\u0006\u0019\u0001+)\r\u0005]\u0016qUAZ\u0011\u0019\t)\r\u0001C\u0001'\u0006Aq-\u001a;LCB\u0004\u0018\r\u000b\u0004\u0002D\u0006\u001d\u00161\u0017\u0005\b\u0003\u0017\u0004A\u0011AAg\u0003!\u0019X\r^&baB\fG\u0003BA_\u0003\u001fDq!a\u0003\u0002J\u0002\u0007A\u000b\u000b\u0004\u0002J\u0006\u001d\u00161\u0017\u0005\u0007\u0003+\u0004A\u0011A*\u0002)\u001d,G/T5oS\n\u000bGo\u00195Ge\u0006\u001cG/[8oQ\u0019\t\u0019.a*\u00024\"9\u00111\u001c\u0001\u0005\u0002\u0005u\u0017\u0001F:fi6Kg.\u001b\"bi\u000eDgI]1di&|g\u000e\u0006\u0003\u0002>\u0006}\u0007bBA\u000e\u00033\u0004\r\u0001\u0016\u0015\u0007\u00033\f9+a-\t\r\u0005\u0015\b\u0001\"\u0001s\u0003m9W\r^(qi&l\u0017N_3E_\u000e\u001cuN\\2f]R\u0014\u0018\r^5p]\"2\u00111]AT\u0003S\f#!a;\u0002\u000bErSG\f\u0019\t\u000f\u0005=\b\u0001\"\u0001\u0002r\u0006Y2/\u001a;PaRLW.\u001b>f\t>\u001c7i\u001c8dK:$(/\u0019;j_:$B!!0\u0002t\"9\u00111FAw\u0001\u0004\u0019\bFBAw\u0003O\u000bI\u000f\u0003\u0005\u0002z\u0002!\tAAA~\u0003%\u0019X\r\u001e'b[\n$\u0017\r\u0006\u0003\u0002>\u0006u\b\u0002CA0\u0003o\u0004\r!a\u0019\t\u0011\t\u0005\u0001\u0001\"\u0001\u0003\u0005\u0007\tQb]3u\u000f\u0006lW.Y*iCB,G\u0003BA_\u0005\u000bAqAa\u0002\u0002\u0000\u0002\u0007A+A\u0003tQ\u0006\u0004X\r\u0003\u0005\u0003\f\u0001!\tA\u0001B\u0007\u0003a\u0019X\r^*b[BdWmV5uQJ+\u0007\u000f\\1dK6,g\u000e\u001e\u000b\u0005\u0003{\u0013y\u0001C\u0004\u0003\u0012\t%\u0001\u0019A:\u0002\u000fI,\u0007\u000f\\1dK\"A!Q\u0003\u0001\u0005B\t\u00119\"\u0001\u0006j]&$\u0018.\u00197ju\u0016$Ra\u0007B\r\u00057A\u0001\"a\u000f\u0003\u0014\u0001\u0007\u0011q\b\u0005\t\u0005;\u0011\u0019\u00021\u0001\u0003 \u0005\u0019A\u000eZ1\u0011\u0007U\u0011\t#C\u0002\u0003$\t\u00111\u0001\u0014#B\u0011\u001d\u00119\u0003\u0001C!\u0005i\tAA\\3yi\"A!1\u0006\u0001\u0005\u0002\t\u0011i#A\btk\nl\u0017\u000e^'j]&\u0014\u0015\r^2i)\rY\"q\u0006\u0005\t\u0005c\u0011I\u00031\u0001\u0002@\u0005)!-\u0019;dQ\"9!Q\u0007\u0001\u0005\n\t]\u0012\u0001D;qI\u0006$X\rT1nE\u0012\fG#B\u0013\u0003:\tu\u0002\u0002\u0003B\u001e\u0005g\u0001\r!a\u0019\u0002\tM$\u0018\r\u001e\u0005\b\u0005\u007f\u0011\u0019\u00041\u0001 \u0003%\u0011\u0017\r^2i'&TX\rC\u0004\u0003D\u0001!IA!\u0012\u0002\u0017U\u0004H-\u0019;f\u00032\u0004\b.\u0019\u000b\u0004K\t\u001d\u0003\u0002\u0003B%\u0005\u0003\u0002\r!a\u0019\u0002\r\u001d\fW.\\1u\u0011\u001d\u0011i\u0005\u0001C\u0005\u0005\u001f\n1A\u001d5p)\u0005!\u0006b\u0002B*\u0001\u0011%!QK\u0001\u000fO\u0016$x)Y7nC6\u000bGO]5y)\u0019\t\u0019Ga\u0016\u0003\\!9!\u0011\fB)\u0001\u0004y\u0012a\u0001:po\"9!Q\fB)\u0001\u0004y\u0012aA2pY\"A!\u0011\r\u0001\u0005B\t\u0011\u0019'A\u0006hKRdE)Q'pI\u0016dG\u0003\u0002B3\u0005W\u00022!\u0006B4\u0013\r\u0011IG\u0001\u0002\t\u0019\u0012\u000bUj\u001c3fY\"A!Q\u000eB0\u0001\u0004\u0011y'\u0001\bji\u0016\u0014\u0018\r^5p]RKW.Z:\u0011\t=\u0011\t\bV\u0005\u0004\u0005g\u0002\"!B!se\u0006L\bf\u0001\u0001\u0003xA!\u0011\u0011\u0016B=\u0013\u0011\u0011Y(a+\u0003\u0019\u0011+g/\u001a7pa\u0016\u0014\u0018\t]5)\u000b\u0001\t9+a-\b\u0011\t\u0005%\u0001#\u0001\u0003\u0005\u0007\u000b!c\u00148mS:,G\nR!PaRLW.\u001b>feB\u0019QC!\"\u0007\u000f\u0005\u0011\u0001\u0012\u0001\u0002\u0003\bN\u0019!Q\u0011\b\t\u000fe\u0011)\t\"\u0001\u0003\fR\u0011!1\u0011\u0005\n\u0005\u001f\u0013)\t\"\u0001\u0003\u0005#\u000b\u0011D^1sS\u0006$\u0018n\u001c8bYR{\u0007/[2J]\u001a,'/\u001a8dKRa!1\u0013BN\u0005?\u0013\u0019K!+\u0003,B9q\"!\u0014\u0003\u0016\u0006\r\u0004#BA3\u0005/#\u0016\u0002\u0002BM\u0003O\u00121\u0002R3og\u00164Vm\u0019;pe\"9!Q\u0014BG\u0001\u0004\u0019\u0015A\u0003;fe6\u001cu.\u001e8ug\"A!\u0011\u0015BG\u0001\u0004\t\u0019'A\u0006fqB,En\\4cKR\f\u0007bB!\u0003\u000e\u0002\u0007!Q\u0015\t\u0006\u0003K\u00129\u000bV\u0005\u0004\u0011\u0006\u001d\u0004bBAJ\u0005\u001b\u0003\r\u0001\u0016\u0005\u0007;\t5\u0005\u0019A\u0010")
public final class OnlineLDAOptimizer
implements LDAOptimizer {
    private int org$apache$spark$mllib$clustering$OnlineLDAOptimizer$$k = 0;
    private long corpusSize = 0L;
    private int vocabSize = 0;
    private Vector org$apache$spark$mllib$clustering$OnlineLDAOptimizer$$alpha = Vectors$.MODULE$.dense(0.0, (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[0]));
    private double eta = 0.0;
    private Random randomGenerator = null;
    private boolean sampleWithReplacement = true;
    private double tau0 = 1024.0;
    private double kappa = 0.51;
    private double miniBatchFraction = 0.05;
    private boolean optimizeDocConcentration = false;
    private RDD<Tuple2<Object, Vector>> docs = null;
    private DenseMatrix<Object> lambda = null;
    private int iteration = 0;
    private double gammaShape = 100.0;

    public int org$apache$spark$mllib$clustering$OnlineLDAOptimizer$$k() {
        return this.org$apache$spark$mllib$clustering$OnlineLDAOptimizer$$k;
    }

    private void org$apache$spark$mllib$clustering$OnlineLDAOptimizer$$k_$eq(int x$1) {
        this.org$apache$spark$mllib$clustering$OnlineLDAOptimizer$$k = x$1;
    }

    private long corpusSize() {
        return this.corpusSize;
    }

    private void corpusSize_$eq(long x$1) {
        this.corpusSize = x$1;
    }

    private int vocabSize() {
        return this.vocabSize;
    }

    private void vocabSize_$eq(int x$1) {
        this.vocabSize = x$1;
    }

    public Vector org$apache$spark$mllib$clustering$OnlineLDAOptimizer$$alpha() {
        return this.org$apache$spark$mllib$clustering$OnlineLDAOptimizer$$alpha;
    }

    private void org$apache$spark$mllib$clustering$OnlineLDAOptimizer$$alpha_$eq(Vector x$1) {
        this.org$apache$spark$mllib$clustering$OnlineLDAOptimizer$$alpha = x$1;
    }

    public Vector getAlpha() {
        return this.org$apache$spark$mllib$clustering$OnlineLDAOptimizer$$alpha();
    }

    private double eta() {
        return this.eta;
    }

    private void eta_$eq(double x$1) {
        this.eta = x$1;
    }

    public double getEta() {
        return this.eta();
    }

    private Random randomGenerator() {
        return this.randomGenerator;
    }

    private void randomGenerator_$eq(Random x$1) {
        this.randomGenerator = x$1;
    }

    private boolean sampleWithReplacement() {
        return this.sampleWithReplacement;
    }

    private void sampleWithReplacement_$eq(boolean x$1) {
        this.sampleWithReplacement = x$1;
    }

    private double tau0() {
        return this.tau0;
    }

    private void tau0_$eq(double x$1) {
        this.tau0 = x$1;
    }

    private double kappa() {
        return this.kappa;
    }

    private void kappa_$eq(double x$1) {
        this.kappa = x$1;
    }

    private double miniBatchFraction() {
        return this.miniBatchFraction;
    }

    private void miniBatchFraction_$eq(double x$1) {
        this.miniBatchFraction = x$1;
    }

    private boolean optimizeDocConcentration() {
        return this.optimizeDocConcentration;
    }

    private void optimizeDocConcentration_$eq(boolean x$1) {
        this.optimizeDocConcentration = x$1;
    }

    private RDD<Tuple2<Object, Vector>> docs() {
        return this.docs;
    }

    private void docs_$eq(RDD<Tuple2<Object, Vector>> x$1) {
        this.docs = x$1;
    }

    private DenseMatrix<Object> lambda() {
        return this.lambda;
    }

    private void lambda_$eq(DenseMatrix<Object> x$1) {
        this.lambda = x$1;
    }

    public DenseMatrix<Object> getLambda() {
        return this.lambda();
    }

    private int iteration() {
        return this.iteration;
    }

    private void iteration_$eq(int x$1) {
        this.iteration = x$1;
    }

    private double gammaShape() {
        return this.gammaShape;
    }

    private void gammaShape_$eq(double x$1) {
        this.gammaShape = x$1;
    }

    public double getTau0() {
        return this.tau0();
    }

    public OnlineLDAOptimizer setTau0(double tau0) {
        Predef$.MODULE$.require(tau0 > 0.0, (Function0)new Serializable(this, tau0){
            public static final long serialVersionUID = 0L;
            private final double tau0$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LDA tau0 must be positive, but was set to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.tau0$1)}));
            }
            {
                this.tau0$1 = tau0$1;
            }
        });
        this.tau0_$eq(tau0);
        return this;
    }

    public double getKappa() {
        return this.kappa();
    }

    public OnlineLDAOptimizer setKappa(double kappa) {
        Predef$.MODULE$.require(kappa >= 0.0, (Function0)new Serializable(this, kappa){
            public static final long serialVersionUID = 0L;
            private final double kappa$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Online LDA kappa must be nonnegative, but was set to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.kappa$1)}));
            }
            {
                this.kappa$1 = kappa$1;
            }
        });
        this.kappa_$eq(kappa);
        return this;
    }

    public double getMiniBatchFraction() {
        return this.miniBatchFraction();
    }

    public OnlineLDAOptimizer setMiniBatchFraction(double miniBatchFraction) {
        Predef$.MODULE$.require(miniBatchFraction > 0.0 && miniBatchFraction <= 1.0, (Function0)new Serializable(this, miniBatchFraction){
            public static final long serialVersionUID = 0L;
            private final double miniBatchFraction$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Online LDA miniBatchFraction must be in range (0,1], but was set to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.miniBatchFraction$1)}));
            }
            {
                this.miniBatchFraction$1 = miniBatchFraction$1;
            }
        });
        this.miniBatchFraction_$eq(miniBatchFraction);
        return this;
    }

    public boolean getOptimizeDocConcentration() {
        return this.optimizeDocConcentration();
    }

    public OnlineLDAOptimizer setOptimizeDocConcentration(boolean optimizeDocConcentration) {
        this.optimizeDocConcentration_$eq(optimizeDocConcentration);
        return this;
    }

    public OnlineLDAOptimizer setLambda(DenseMatrix<Object> lambda) {
        this.lambda_$eq(lambda);
        return this;
    }

    public OnlineLDAOptimizer setGammaShape(double shape) {
        this.gammaShape_$eq(shape);
        return this;
    }

    public OnlineLDAOptimizer setSampleWithReplacement(boolean replace) {
        this.sampleWithReplacement_$eq(replace);
        return this;
    }

    @Override
    public OnlineLDAOptimizer initialize(RDD<Tuple2<Object, Vector>> docs, LDA lda) {
        Vector vector;
        this.org$apache$spark$mllib$clustering$OnlineLDAOptimizer$$k_$eq(lda.getK());
        this.corpusSize_$eq(docs.count());
        this.vocabSize_$eq(((Vector)((Tuple2)docs.first())._2()).size());
        if (lda.getAsymmetricDocConcentration().size() == 1) {
            if (lda.getAsymmetricDocConcentration().apply(0) == (double)-1) {
                vector = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(this.org$apache$spark$mllib$clustering$OnlineLDAOptimizer$$k(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ OnlineLDAOptimizer $outer;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return 1.0 / (double)this.$outer.org$apache$spark$mllib$clustering$OnlineLDAOptimizer$$k();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.Double()));
            } else {
                Predef$.MODULE$.require(lda.getAsymmetricDocConcentration().apply(0) >= 0.0, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ OnlineLDAOptimizer $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"all entries in alpha must be >=0, got: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$mllib$clustering$OnlineLDAOptimizer$$alpha()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                vector = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(this.org$apache$spark$mllib$clustering$OnlineLDAOptimizer$$k(), (Function0)new Serializable(this, lda){
                    public static final long serialVersionUID = 0L;
                    private final LDA lda$1;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return this.lda$1.getAsymmetricDocConcentration().apply(0);
                    }
                    {
                        this.lda$1 = lda$1;
                    }
                }, ClassTag$.MODULE$.Double()));
            }
        } else {
            Predef$.MODULE$.require(lda.getAsymmetricDocConcentration().size() == this.org$apache$spark$mllib$clustering$OnlineLDAOptimizer$$k(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ OnlineLDAOptimizer $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha must have length k, got: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$mllib$clustering$OnlineLDAOptimizer$$alpha()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            lda.getAsymmetricDocConcentration().foreachActive((Function2<Object, Object, BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ OnlineLDAOptimizer $outer;

                public final void apply(int x0$4, double x1$2) {
                    this.apply$mcVID$sp(x0$4, x1$2);
                }

                public void apply$mcVID$sp(int x0$4, double x1$2) {
                    Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(x0$4, x1$2);
                    if (sp2 != null) {
                        double x = sp2._2$mcD$sp();
                        Predef$.MODULE$.require(x >= 0.0, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$initialize$3 $outer;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"all entries in alpha must be >= 0, got: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$mllib$clustering$OnlineLDAOptimizer$$anonfun$$$outer().org$apache$spark$mllib$clustering$OnlineLDAOptimizer$$alpha()}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError((Object)sp2);
                }

                public /* synthetic */ OnlineLDAOptimizer org$apache$spark$mllib$clustering$OnlineLDAOptimizer$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            vector = lda.getAsymmetricDocConcentration();
        }
        this.org$apache$spark$mllib$clustering$OnlineLDAOptimizer$$alpha_$eq(vector);
        this.eta_$eq(lda.getTopicConcentration() == (double)-1 ? 1.0 / (double)this.org$apache$spark$mllib$clustering$OnlineLDAOptimizer$$k() : lda.getTopicConcentration());
        this.randomGenerator_$eq(new Random(lda.getSeed()));
        this.docs_$eq(docs);
        this.lambda_$eq(this.getGammaMatrix(this.org$apache$spark$mllib$clustering$OnlineLDAOptimizer$$k(), this.vocabSize()));
        this.iteration_$eq(0);
        return this;
    }

    @Override
    public OnlineLDAOptimizer next() {
        RDD batch = this.docs().sample(this.sampleWithReplacement(), this.miniBatchFraction(), this.randomGenerator().nextLong());
        if (batch.isEmpty()) {
            return this;
        }
        return this.submitMiniBatch((RDD<Tuple2<Object, Vector>>)batch);
    }

    public OnlineLDAOptimizer submitMiniBatch(RDD<Tuple2<Object, Vector>> batch) {
        this.iteration_$eq(this.iteration() + 1);
        int k = this.org$apache$spark$mllib$clustering$OnlineLDAOptimizer$$k();
        int vocabSize = this.vocabSize();
        DenseMatrix expElogbeta = (DenseMatrix)((ImmutableNumericOps)package.exp$.MODULE$.apply(LDAUtils$.MODULE$.dirichletExpectation(this.lambda()), package.exp$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.handholdCMV(), (UFunc.UImpl)package.exp$.expDoubleImpl$.MODULE$, DenseMatrix$.MODULE$.canMapValues(ClassTag$.MODULE$.Double())))).t(DenseMatrix$.MODULE$.canTranspose());
        Broadcast expElogbetaBc = batch.sparkContext().broadcast((Object)expElogbeta, ClassTag$.MODULE$.apply(DenseMatrix.class));
        breeze.linalg.Vector<Object> alpha = this.org$apache$spark$mllib$clustering$OnlineLDAOptimizer$$alpha().toBreeze();
        double gammaShape = this.gammaShape();
        RDD stats = batch.mapPartitions((Function1)new Serializable(this, k, vocabSize, expElogbetaBc, alpha, gammaShape){
            public static final long serialVersionUID = 0L;
            public final int k$2;
            private final int vocabSize$1;
            public final Broadcast expElogbetaBc$1;
            public final breeze.linalg.Vector alpha$2;
            public final double gammaShape$1;

            public final Iterator<Tuple2<DenseMatrix<Object>, List<breeze.linalg.DenseVector<Object>>>> apply(Iterator<Tuple2<Object, Vector>> docs) {
                Iterator nonEmptyDocs = docs.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Object, Vector> x$7) {
                        return ((Vector)x$7._2()).numNonzeros() > 0;
                    }
                });
                DenseMatrix stat = DenseMatrix$.MODULE$.zeros$mDc$sp(this.k$2, this.vocabSize$1, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                ObjectRef gammaPart = ObjectRef.create((Object)Nil$.MODULE$);
                nonEmptyDocs.zipWithIndex().foreach((Function1)new Serializable(this, stat, gammaPart){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;
                    private final DenseMatrix stat$1;
                    private final ObjectRef gammaPart$1;

                    public final void apply(Tuple2<Tuple2<Object, Vector>, Object> x0$5) {
                        Tuple2<Tuple2<Object, Vector>, Object> tuple2;
                        block4: {
                            Vector vector;
                            block7: {
                                List list;
                                Vector vector2;
                                block6: {
                                    block5: {
                                        Vector termCounts;
                                        Tuple2 tuple22;
                                        tuple2 = x0$5;
                                        if (tuple2 == null || (tuple22 = (Tuple2)tuple2._1()) == null || (termCounts = (Vector)tuple22._2()) == null) break block4;
                                        vector2 = termCounts;
                                        vector = vector2;
                                        if (!(vector instanceof DenseVector)) break block5;
                                        DenseVector denseVector = (DenseVector)vector;
                                        list = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), denseVector.size()).toList();
                                        break block6;
                                    }
                                    if (!(vector instanceof SparseVector)) break block7;
                                    SparseVector sparseVector = (SparseVector)vector;
                                    list = Predef$.MODULE$.intArrayOps(sparseVector.indices()).toList();
                                }
                                List ids = list;
                                Tuple2<breeze.linalg.DenseVector<Object>, DenseMatrix<Object>> tuple23 = OnlineLDAOptimizer$.MODULE$.variationalTopicInference(vector2, (DenseMatrix<Object>)((DenseMatrix)this.$outer.expElogbetaBc$1.value()), (breeze.linalg.Vector<Object>)this.$outer.alpha$2, this.$outer.gammaShape$1, this.$outer.k$2);
                                if (tuple23 != null) {
                                    Tuple2 tuple24;
                                    breeze.linalg.DenseVector gammad = (breeze.linalg.DenseVector)tuple23._1();
                                    DenseMatrix sstats = (DenseMatrix)tuple23._2();
                                    Tuple2 tuple25 = tuple24 = new Tuple2((Object)gammad, (Object)sstats);
                                    breeze.linalg.DenseVector gammad2 = (breeze.linalg.DenseVector)tuple25._1();
                                    DenseMatrix sstats2 = (DenseMatrix)tuple25._2();
                                    ((NumericOps)this.stat$1.apply((Object)package$.MODULE$.$colon$colon(), (Object)ids, DenseMatrix$.MODULE$.canSliceWeirdCols(Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.Double()))).$colon$eq(((Matrix)this.stat$1.apply((Object)package$.MODULE$.$colon$colon(), (Object)ids, DenseMatrix$.MODULE$.canSliceWeirdCols(Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.Double()))).toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$).$plus((Object)sstats2, DenseMatrix$.MODULE$.op_DM_DM_Double_OpAdd()), (UFunc.InPlaceImpl2)Matrix$.MODULE$.setDMDV(Predef$.MODULE$.$conforms()));
                                    breeze.linalg.DenseVector denseVector = gammad2;
                                    this.gammaPart$1.elem = ((List)this.gammaPart$1.elem).$colon$colon((Object)denseVector);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple23);
                            }
                            throw new MatchError((Object)vector);
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.stat$1 = stat$1;
                        this.gammaPart$1 = gammaPart$1;
                    }
                });
                return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)stat, (Object)((List)gammaPart.elem))}));
            }
            {
                this.k$2 = k$2;
                this.vocabSize$1 = vocabSize$1;
                this.expElogbetaBc$1 = expElogbetaBc$1;
                this.alpha$2 = alpha$2;
                this.gammaShape$1 = gammaShape$1;
            }
        }, batch.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
        DenseMatrix statsSum = (DenseMatrix)stats.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DenseMatrix<Object> apply(Tuple2<DenseMatrix<Object>, List<breeze.linalg.DenseVector<Object>>> x$10) {
                return (DenseMatrix)x$10._1();
            }
        }, ClassTag$.MODULE$.apply(DenseMatrix.class)).reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DenseMatrix<Object> apply(DenseMatrix<Object> x$11, DenseMatrix<Object> x$12) {
                return (DenseMatrix)x$11.$plus$eq(x$12, DenseMatrix$.MODULE$.dm_dm_UpdateOp_Double_OpAdd());
            }
        });
        expElogbetaBc.unpersist();
        DenseMatrix gammat = DenseMatrix$.MODULE$.vertcat((Seq)((List)stats.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final List<breeze.linalg.DenseVector<Object>> apply(Tuple2<DenseMatrix<Object>, List<breeze.linalg.DenseVector<Object>>> x$13) {
                return (List)x$13._2();
            }
        }, ClassTag$.MODULE$.apply(List.class)).reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final List<breeze.linalg.DenseVector<Object>> apply(List<breeze.linalg.DenseVector<Object>> x$14, List<breeze.linalg.DenseVector<Object>> x$15) {
                return (List)x$14.$plus$plus(x$15, List$.MODULE$.canBuildFrom());
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DenseMatrix<Object> apply(breeze.linalg.DenseVector<Object> x$16) {
                return x$16.toDenseMatrix$mcD$sp();
            }
        }, List$.MODULE$.canBuildFrom()), DenseMatrix$.MODULE$.dm_dm_UpdateOp_Double_OpSet(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        DenseMatrix batchResult = (DenseMatrix)statsSum.$colon$times(expElogbeta.t(DenseMatrix$.MODULE$.canTranspose()), DenseMatrix$.MODULE$.op_DM_DM_Double_OpMulScalar());
        this.updateLambda((DenseMatrix<Object>)batchResult, (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(this.miniBatchFraction() * (double)this.corpusSize())));
        if (this.optimizeDocConcentration()) {
            this.updateAlpha((DenseMatrix<Object>)gammat);
        }
        return this;
    }

    private void updateLambda(DenseMatrix<Object> stat, int batchSize) {
        double weight = this.rho();
        this.lambda().$colon$eq(((NumericOps)new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)(1.0 - weight)))).$times(this.lambda(), DenseMatrix$.MODULE$.s_dm_op_Double_OpMulMatrix())).$plus(new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)weight))).$times(((NumericOps)stat.$times((Object)BoxesRunTime.boxToDouble((double)((double)this.corpusSize() / (double)batchSize)), DenseMatrix$.MODULE$.op_DM_S_Double_OpMulMatrix())).$plus((Object)BoxesRunTime.boxToDouble((double)this.eta()), DenseMatrix$.MODULE$.op_DM_S_Double_OpAdd()), DenseMatrix$.MODULE$.s_dm_op_Double_OpMulMatrix()), DenseMatrix$.MODULE$.op_DM_DM_Double_OpAdd()), DenseMatrix$.MODULE$.dm_dm_UpdateOp_Double_OpSet());
    }

    private void updateAlpha(DenseMatrix<Object> gammat) {
        double weight = this.rho();
        double N = gammat.rows();
        breeze.linalg.DenseVector alpha = this.org$apache$spark$mllib$clustering$OnlineLDAOptimizer$$alpha().toBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double());
        DenseMatrix logphat = (DenseMatrix)((ImmutableNumericOps)sum$.MODULE$.apply(LDAUtils$.MODULE$.dirichletExpectation(gammat).apply((Object)package$.MODULE$.$colon$colon(), (Object)$times$.MODULE$, Broadcaster$.MODULE$.canBroadcastColumns(DenseMatrix$.MODULE$.handholdCanMapRows())), BroadcastedColumns$.MODULE$.broadcastOp(DenseMatrix$.MODULE$.handholdCanMapRows(), sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()), DenseMatrix$.MODULE$.canCollapseRows(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$)))).$div((Object)BoxesRunTime.boxToDouble((double)N), DenseMatrix$.MODULE$.op_DM_S_Double_OpDiv());
        breeze.linalg.DenseVector gradf = (breeze.linalg.DenseVector)new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)N))).$times(((NumericOps)LDAUtils$.MODULE$.dirichletExpectation((breeze.linalg.DenseVector<Object>)alpha).unary_$minus(DenseVector$.MODULE$.negFromScale(DenseVector$.MODULE$.canScaleD(), Ring$.MODULE$.ringD()))).$plus((Object)logphat.toDenseVector$mcD$sp(), DenseVector$.MODULE$.canAddD()), DenseVector$.MODULE$.s_dv_Op_Double_OpMulMatrix());
        double c = N * package.trigamma$.MODULE$.apply$mDDc$sp(BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply((Object)alpha, sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))), (UFunc.UImpl)package.trigamma$.trigammaImplDouble$.MODULE$);
        breeze.linalg.DenseVector q = (breeze.linalg.DenseVector)new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)(-N)))).$times(package.trigamma$.MODULE$.apply((Object)alpha, package.trigamma$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.handholdCMV(), (UFunc.UImpl)package.trigamma$.trigammaImplDouble$.MODULE$, DenseVector$.MODULE$.canMapValues(ClassTag$.MODULE$.Double()))), DenseVector$.MODULE$.s_dv_Op_Double_OpMulMatrix());
        double b = BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(gradf.$div((Object)q, DenseVector$.MODULE$.dv_dv_Op_Double_OpDiv()), sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))) / (1.0 / c + BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)1.0))).$div((Object)q, DenseVector$.MODULE$.s_dv_Op_Double_OpDiv()), sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))));
        breeze.linalg.DenseVector dalpha = (breeze.linalg.DenseVector)((ImmutableNumericOps)((ImmutableNumericOps)gradf.$minus((Object)BoxesRunTime.boxToDouble((double)b), DenseVector$.MODULE$.dv_s_Op_Double_OpSub())).unary_$minus(DenseVector$.MODULE$.negFromScale(DenseVector$.MODULE$.canScaleD(), Ring$.MODULE$.ringD()))).$div((Object)q, DenseVector$.MODULE$.dv_dv_Op_Double_OpDiv());
        if (BoxesRunTime.unboxToBoolean((Object)all$.MODULE$.apply(((NumericOps)((NumericOps)new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)weight))).$times((Object)dalpha, DenseVector$.MODULE$.s_dv_Op_Double_OpMulMatrix())).$plus((Object)alpha, DenseVector$.MODULE$.canAddD())).$colon$greater((Object)BoxesRunTime.boxToDouble((double)0.0), DenseVector$.MODULE$.dv_s_CompOp_Double_OpGT()), all$.MODULE$.reduceSemiring((CanTraverseValues)BitVector.traverseBitVector$.MODULE$, (Semiring)Semiring.fieldB$.MODULE$)))) {
            alpha.$colon$plus$eq(new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)weight))).$times((Object)dalpha, DenseVector$.MODULE$.s_dv_Op_Double_OpMulMatrix()), DenseVector$.MODULE$.canAddIntoD());
            this.org$apache$spark$mllib$clustering$OnlineLDAOptimizer$$alpha_$eq(Vectors$.MODULE$.dense(alpha.toArray$mcD$sp(ClassTag$.MODULE$.Double())));
        }
    }

    private double rho() {
        return scala.math.package$.MODULE$.pow(this.getTau0() + (double)this.iteration(), -this.getKappa());
    }

    private DenseMatrix<Object> getGammaMatrix(int row, int col) {
        RandBasis randBasis = new RandBasis((RandomGenerator)new MersenneTwister(this.randomGenerator().nextLong()));
        Gamma gammaRandomGenerator = new Gamma(this.gammaShape(), 1.0 / this.gammaShape(), randBasis);
        double[] temp = (double[])gammaRandomGenerator.sample(row * col).toArray(ClassTag$.MODULE$.Double());
        return (DenseMatrix)new DenseMatrix.mcD.sp(col, row, temp).t(DenseMatrix$.MODULE$.canTranspose());
    }

    @Override
    public LDAModel getLDAModel(double[] iterationTimes) {
        return new LocalLDAModel(Matrices$.MODULE$.fromBreeze((Matrix<Object>)this.lambda()).transpose(), this.org$apache$spark$mllib$clustering$OnlineLDAOptimizer$$alpha(), this.eta(), this.gammaShape());
    }
}

