/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.Logging;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqView;
import scala.collection.TraversableOnce;
import scala.collection.mutable.IndexedSeqView$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001\u001b\t!2\u000b\u001e:fC6LgnZ&NK\u0006t7/T8eK2T!a\u0001\u0003\u0002\u0015\rdWo\u001d;fe&twM\u0003\u0002\u0006\r\u0005)Q\u000e\u001c7jE*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001q!\u0003\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\tY1*T3b]Nlu\u000eZ3m!\t\u0019B#D\u0001\u0007\u0013\t)bAA\u0004M_\u001e<\u0017N\\4\t\u0011]\u0001!Q1A\u0005Ba\tab\u00197vgR,'oQ3oi\u0016\u00148/F\u0001\u001a!\rQRdH\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t)\u0011I\u001d:bsB\u0011\u0001eI\u0007\u0002C)\u0011!\u0005B\u0001\u0007Y&t\u0017\r\\4\n\u0005\u0011\n#A\u0002,fGR|'\u000fK\u0002\u0017M1\u0002\"a\n\u0016\u000e\u0003!R!!\u000b\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002,Q\t)1+\u001b8dK\u0006\nQ&A\u00032]Ir\u0003\u0007C\u00050\u0001\t\u0005\t\u0015!\u0003\u001aa\u0005y1\r\\;ti\u0016\u00148)\u001a8uKJ\u001c\b%\u0003\u0002\u0018!!\u001aaF\n\u0017\t\u0011M\u0002!Q1A\u0005\u0002Q\nab\u00197vgR,'oV3jO\"$8/F\u00016!\rQRD\u000e\t\u00035]J!\u0001O\u000e\u0003\r\u0011{WO\u00197fQ\r\u0011d\u0005\f\u0005\tw\u0001\u0011\t\u0011)A\u0005k\u0005y1\r\\;ti\u0016\u0014x+Z5hQR\u001c\b\u0005K\u0002;M1BQA\u0010\u0001\u0005\u0002}\na\u0001P5oSRtDc\u0001!B\u0007B\u0011q\u0002\u0001\u0005\u0006/u\u0002\r!\u0007\u0015\u0004\u0003\u001ab\u0003\"B\u001a>\u0001\u0004)\u0004fA\"'Y!\u001aQH\n\u0017\t\u000b\u001d\u0003A\u0011\u0001%\u0002\rU\u0004H-\u0019;f)\u0011\u0001\u0015*U*\t\u000b)3\u0005\u0019A&\u0002\t\u0011\fG/\u0019\t\u0004\u0019>{R\"A'\u000b\u000593\u0011a\u0001:eI&\u0011\u0001+\u0014\u0002\u0004%\u0012#\u0005\"\u0002*G\u0001\u00041\u0014a\u00033fG\u0006Lh)Y2u_JDQ\u0001\u0016$A\u0002U\u000b\u0001\u0002^5nKVs\u0017\u000e\u001e\t\u0003-fs!AG,\n\u0005a[\u0012A\u0002)sK\u0012,g-\u0003\u0002[7\n11\u000b\u001e:j]\u001eT!\u0001W\u000e)\u0007\u00193C\u0006\u000b\u0002\u0001=B\u0011qeX\u0005\u0003A\"\u0012A\"\u0012=qKJLW.\u001a8uC2D3\u0001\u0001\u0014-\u0001")
public class StreamingKMeansModel
extends KMeansModel
implements Logging {
    private final double[] clusterWeights;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    @Override
    public Vector[] clusterCenters() {
        return super.clusterCenters();
    }

    public double[] clusterWeights() {
        return this.clusterWeights;
    }

    public StreamingKMeansModel update(RDD<Vector> data, double decayFactor, String timeUnit) {
        String string;
        block9: {
            double d;
            Tuple2[] pointStats;
            int dim;
            block8: {
                block7: {
                    RDD closest = data.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ StreamingKMeansModel $outer;

                        public final Tuple2<Object, Tuple2<Vector, Object>> apply(Vector point) {
                            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.$outer.predict(point)), (Object)new Tuple2((Object)point, (Object)BoxesRunTime.boxToLong((long)1L)));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, ClassTag$.MODULE$.apply(Tuple2.class));
                    Serializable mergeContribs = new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Vector, Object> apply(Tuple2<Vector, Object> p1, Tuple2<Vector, Object> p2) {
                            BLAS$.MODULE$.axpy(1.0, (Vector)p2._1(), (Vector)p1._1());
                            return new Tuple2(p1._1(), (Object)BoxesRunTime.boxToLong((long)(p1._2$mcJ$sp() + p2._2$mcJ$sp())));
                        }
                    };
                    dim = this.clusterCenters()[0].size();
                    pointStats = (Tuple2[])RDD$.MODULE$.rddToPairRDDFunctions(closest, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).aggregateByKey((Object)new Tuple2((Object)Vectors$.MODULE$.zeros(dim), (Object)BoxesRunTime.boxToLong((long)0L)), (Function2)mergeContribs, (Function2)mergeContribs, ClassTag$.MODULE$.apply(Tuple2.class)).collect();
                    string = timeUnit;
                    if (!"batches".equals(string)) break block7;
                    d = decayFactor;
                    break block8;
                }
                if (!"points".equals(string)) break block9;
                long numNewPoints = BoxesRunTime.unboxToLong((Object)((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])pointStats).view().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(Tuple2<Object, Tuple2<Vector, Object>> x0$1) {
                        Tuple2 tuple2;
                        Tuple2<Object, Tuple2<Vector, Object>> tuple22 = x0$1;
                        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                            long n;
                            long l = n = tuple2._2$mcJ$sp();
                            return l;
                        }
                        throw new MatchError(tuple22);
                    }
                }, IndexedSeqView$.MODULE$.arrCanBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                d = package$.MODULE$.pow(decayFactor, (double)numNewPoints);
            }
            double discount = d;
            BLAS$.MODULE$.scal(discount, Vectors$.MODULE$.dense(this.clusterWeights()));
            Predef$.MODULE$.refArrayOps((Object[])pointStats).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ StreamingKMeansModel $outer;

                public final void apply(Tuple2<Object, Tuple2<Vector, Object>> x0$2) {
                    Tuple2<Object, Tuple2<Vector, Object>> tuple2 = x0$2;
                    if (tuple2 != null) {
                        int label = tuple2._1$mcI$sp();
                        Tuple2 tuple22 = (Tuple2)tuple2._2();
                        if (tuple22 != null) {
                            Vector sum = (Vector)tuple22._1();
                            long count = tuple22._2$mcJ$sp();
                            Vector centroid = this.$outer.clusterCenters()[label];
                            double updatedWeight = this.$outer.clusterWeights()[label] + (double)count;
                            double lambda = (double)count / package$.MODULE$.max(updatedWeight, 1.0E-16);
                            this.$outer.clusterWeights()[label] = updatedWeight;
                            BLAS$.MODULE$.scal(1.0 - lambda, centroid);
                            BLAS$.MODULE$.axpy(lambda / (double)count, sum, centroid);
                            int n = this.$outer.clusterCenters()[label].size();
                            switch (n) {
                                default: 
                            }
                            String display = n > 100 ? Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(centroid.toArray()).take(100)).mkString("[", ",", "...") : Predef$.MODULE$.doubleArrayOps(centroid.toArray()).mkString("[", ",", "]");
                            this.$outer.logInfo((Function0<String>)new Serializable(this, label, updatedWeight, display){
                                public static final long serialVersionUID = 0L;
                                private final int label$1;
                                private final double updatedWeight$1;
                                private final String display$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cluster ", " updated with weight ", " and centroid: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.label$1), BoxesRunTime.boxToDouble((double)this.updatedWeight$1), this.display$1}));
                                }
                                {
                                    this.label$1 = label$1;
                                    this.updatedWeight$1 = updatedWeight$1;
                                    this.display$1 = display$1;
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            SeqView weightsWithIndex = (SeqView)Predef$.MODULE$.doubleArrayOps(this.clusterWeights()).view().zipWithIndex(IndexedSeqView$.MODULE$.arrCanBuildFrom());
            Tuple2 tuple2 = (Tuple2)weightsWithIndex.maxBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(Tuple2<Object, Object> x$1) {
                    return x$1._1$mcD$sp();
                }
            }, (Ordering)Ordering.Double$.MODULE$);
            if (tuple2 != null) {
                Tuple2.mcDI.sp sp2;
                double maxWeight = tuple2._1$mcD$sp();
                int largest = tuple2._2$mcI$sp();
                Tuple2.mcDI.sp sp3 = sp2 = new Tuple2.mcDI.sp(maxWeight, largest);
                double maxWeight2 = sp3._1$mcD$sp();
                int largest2 = sp3._2$mcI$sp();
                Tuple2 tuple22 = (Tuple2)weightsWithIndex.minBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Tuple2<Object, Object> x$3) {
                        return x$3._1$mcD$sp();
                    }
                }, (Ordering)Ordering.Double$.MODULE$);
                if (tuple22 != null) {
                    Tuple2.mcDI.sp sp4;
                    double minWeight = tuple22._1$mcD$sp();
                    int smallest = tuple22._2$mcI$sp();
                    Tuple2.mcDI.sp sp5 = sp4 = new Tuple2.mcDI.sp(minWeight, smallest);
                    double minWeight2 = sp5._1$mcD$sp();
                    int smallest2 = sp5._2$mcI$sp();
                    if (minWeight2 < 1.0E-8 * maxWeight2) {
                        double weight;
                        this.logInfo((Function0<String>)new Serializable(this, largest2, smallest2){
                            public static final long serialVersionUID = 0L;
                            private final int largest$1;
                            private final int smallest$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cluster ", " is dying. Split the largest cluster ", " into two."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.smallest$1), BoxesRunTime.boxToInteger((int)this.largest$1)}));
                            }
                            {
                                this.largest$1 = largest$1;
                                this.smallest$1 = smallest$1;
                            }
                        });
                        this.clusterWeights()[largest2] = weight = (maxWeight2 + minWeight2) / 2.0;
                        this.clusterWeights()[smallest2] = weight;
                        Vector largestClusterCenter = this.clusterCenters()[largest2];
                        Vector smallestClusterCenter = this.clusterCenters()[smallest2];
                        for (int j = 0; j < dim; ++j) {
                            double x = largestClusterCenter.apply(j);
                            double p = 1.0E-14 * package$.MODULE$.max(package$.MODULE$.abs(x), 1.0);
                            largestClusterCenter.toBreeze().update$mcID$sp(j, x + p);
                            smallestClusterCenter.toBreeze().update$mcID$sp(j, x - p);
                        }
                    }
                    return this;
                }
                throw new MatchError((Object)tuple22);
            }
            throw new MatchError((Object)tuple2);
        }
        throw new MatchError((Object)string);
    }

    public StreamingKMeansModel(Vector[] clusterCenters, double[] clusterWeights) {
        this.clusterWeights = clusterWeights;
        super(clusterCenters);
        Logging.class.$init$((Logging)this);
    }
}

