/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg.distributed;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.Matrix$;
import org.apache.spark.Logging;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SparseMatrix;
import org.apache.spark.mllib.linalg.distributed.BlockMatrix$;
import org.apache.spark.mllib.linalg.distributed.CoordinateMatrix;
import org.apache.spark.mllib.linalg.distributed.DistributedMatrix;
import org.apache.spark.mllib.linalg.distributed.GridPartitioner;
import org.apache.spark.mllib.linalg.distributed.GridPartitioner$;
import org.apache.spark.mllib.linalg.distributed.IndexedRowMatrix;
import org.apache.spark.mllib.linalg.distributed.MatrixEntry;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u0001\u0003\u0001=\u00111B\u00117pG.l\u0015\r\u001e:jq*\u00111\u0001B\u0001\fI&\u001cHO]5ckR,GM\u0003\u0002\u0006\r\u00051A.\u001b8bY\u001eT!a\u0002\u0005\u0002\u000b5dG.\u001b2\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001!YQ\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\r\u0005\u0002\u001815\t!!\u0003\u0002\u001a\u0005\t\tB)[:ue&\u0014W\u000f^3e\u001b\u0006$(/\u001b=\u0011\u0005maR\"\u0001\u0005\n\u0005uA!a\u0002'pO\u001eLgn\u001a\u0005\t?\u0001\u0011)\u0019!C\u0001A\u00051!\r\\8dWN,\u0012!\t\t\u0004E\u0015:S\"A\u0012\u000b\u0005\u0011B\u0011a\u0001:eI&\u0011ae\t\u0002\u0004%\u0012#\u0005\u0003B\t)U9J!!\u000b\n\u0003\rQ+\b\u000f\\33!\u0011\t\u0002fK\u0016\u0011\u0005Ea\u0013BA\u0017\u0013\u0005\rIe\u000e\u001e\t\u0003_Aj\u0011\u0001B\u0005\u0003c\u0011\u0011a!T1ue&D\bf\u0001\u00104sA\u0011AgN\u0007\u0002k)\u0011a\u0007C\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001\u001d6\u0005\u0015\u0019\u0016N\\2fC\u0005Q\u0014!B\u0019/g9\u0002\u0004\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\u0011\u0002\u000f\tdwnY6tA!\u001a1hM\u001d\t\u0011}\u0002!Q1A\u0005\u0002\u0001\u000bAB]8xgB+'O\u00117pG.,\u0012a\u000b\u0015\u0004}MJ\u0004\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002\u001bI|wo\u001d)fe\ncwnY6!Q\r\u00115'\u000f\u0005\t\r\u0002\u0011)\u0019!C\u0001\u0001\u0006a1m\u001c7t!\u0016\u0014(\t\\8dW\"\u001aQiM\u001d\t\u0011%\u0003!\u0011!Q\u0001\n-\nQbY8mgB+'O\u00117pG.\u0004\u0003f\u0001%4s!AA\n\u0001BA\u0002\u0013%Q*A\u0003o%><8/F\u0001O!\t\tr*\u0003\u0002Q%\t!Aj\u001c8h\u0011!\u0011\u0006A!a\u0001\n\u0013\u0019\u0016!\u00038S_^\u001cx\fJ3r)\t!v\u000b\u0005\u0002\u0012+&\u0011aK\u0005\u0002\u0005+:LG\u000fC\u0004Y#\u0006\u0005\t\u0019\u0001(\u0002\u0007a$\u0013\u0007\u0003\u0005[\u0001\t\u0005\t\u0015)\u0003O\u0003\u0019q'k\\<tA!AA\f\u0001BA\u0002\u0013%Q*A\u0003o\u0007>d7\u000f\u0003\u0005_\u0001\t\u0005\r\u0011\"\u0003`\u0003%q7i\u001c7t?\u0012*\u0017\u000f\u0006\u0002UA\"9\u0001,XA\u0001\u0002\u0004q\u0005\u0002\u00032\u0001\u0005\u0003\u0005\u000b\u0015\u0002(\u0002\r9\u001cu\u000e\\:!\u0011\u0015!\u0007\u0001\"\u0001f\u0003\u0019a\u0014N\\5u}Q1amZ5l[:\u0004\"a\u0006\u0001\t\u000b}\u0019\u0007\u0019A\u0011)\u0007\u001d\u001c\u0014\bC\u0003@G\u0002\u00071\u0006K\u0002jgeBQAR2A\u0002-B3a[\u001a:\u0011\u0015a5\r1\u0001O\u0011\u0015a6\r1\u0001OQ\r\u00197'O\u0003\u0005c\u0002!qEA\u0006NCR\u0014\u0018\u000e\u001f\"m_\u000e\\\u0007\"\u00023\u0001\t\u0003\u0019H\u0003\u00024ukZDQa\b:A\u0002\u0005BQa\u0010:A\u0002-BQA\u0012:A\u0002-B3A]\u001a:\u0011\u0015I\b\u0001\"\u0011{\u0003\u001dqW/\u001c*poN$\u0012A\u0014\u0015\u0004qNJ\u0004\"B?\u0001\t\u0003R\u0018a\u00028v[\u000e{Gn\u001d\u0015\u0004yNJ\u0004\u0002CA\u0001\u0001\t\u0007I\u0011\u0001!\u0002\u00199,XNU8x\u00052|7m[:)\u0007}\u001c\u0014\bC\u0004\u0002\b\u0001\u0001\u000b\u0011B\u0016\u0002\u001b9,XNU8x\u00052|7m[:!Q\u0011\t)aM\u001d\t\u0011\u00055\u0001A1A\u0005\u0002\u0001\u000bAB\\;n\u0007>d'\t\\8dWNDC!a\u00034s!9\u00111\u0003\u0001!\u0002\u0013Y\u0013!\u00048v[\u000e{GN\u00117pG.\u001c\b\u0005\u000b\u0003\u0002\u0012MJ\u0004\u0002CA\r\u0001\u0011\u0005a!a\u0007\u0002#\r\u0014X-\u0019;f!\u0006\u0014H/\u001b;j_:,'\u000f\u0006\u0002\u0002\u001eA\u0019q#a\b\n\u0007\u0005\u0005\"AA\bHe&$\u0007+\u0019:uSRLwN\\3s\u0011)\t)\u0003\u0001EC\u0002\u0013%\u0011qE\u0001\nE2|7m[%oM>,\"!!\u000b\u0011\t\t*\u00131\u0006\t\u0005#!R#\u0006\u0003\u0006\u00020\u0001A\t\u0011)Q\u0005\u0003S\t!B\u00197pG.LeNZ8!\u0011\u001d\t\u0019\u0004\u0001C\u0005\u0003k\t1\"Z:uS6\fG/\u001a#j[R\tA\u000bC\u0004\u0002:\u0001!\t!!\u000e\u0002\u0011Y\fG.\u001b3bi\u0016DC!a\u000e4s!9\u0011q\b\u0001\u0005\u0002\u0005\u0005\u0013!B2bG\",GCAA\"\u001b\u0005\u0001\u0001\u0006BA\u001fgeBq!!\u0013\u0001\t\u0003\tY%A\u0004qKJ\u001c\u0018n\u001d;\u0015\t\u0005\r\u0013Q\n\u0005\t\u0003\u001f\n9\u00051\u0001\u0002R\u0005a1\u000f^8sC\u001e,G*\u001a<fYB!\u00111KA-\u001b\t\t)FC\u0002\u0002X!\tqa\u001d;pe\u0006<W-\u0003\u0003\u0002\\\u0005U#\u0001D*u_J\fw-\u001a'fm\u0016d\u0007\u0006BA$geBq!!\u0019\u0001\t\u0003\t\u0019'\u0001\nu_\u000e{wN\u001d3j]\u0006$X-T1ue&DHCAA3!\r9\u0012qM\u0005\u0004\u0003S\u0012!\u0001E\"p_J$\u0017N\\1uK6\u000bGO]5yQ\u0011\tyfM\u001d\t\u000f\u0005=\u0004\u0001\"\u0001\u0002r\u0005\u0011Bo\\%oI\u0016DX\r\u001a*po6\u000bGO]5y)\t\t\u0019\bE\u0002\u0018\u0003kJ1!a\u001e\u0003\u0005AIe\u000eZ3yK\u0012\u0014vn^'biJL\u0007\u0010\u000b\u0003\u0002nMJ\u0004bBA?\u0001\u0011\u0005\u0011qP\u0001\u000ei>dunY1m\u001b\u0006$(/\u001b=\u0015\u00039BC!a\u001f4s!9\u0011Q\u0011\u0001\u0005\u0002\u0005\u001d\u0015!\u0003;sC:\u001c\bo\\:f+\u00051\u0007\u0006BABgeB\u0001\"!$\u0001\t\u00031\u0011qR\u0001\ti>\u0014%/Z3{KR\u0011\u0011\u0011\u0013\t\u0007\u0003'\u000bY*a(\u000e\u0005\u0005U%bA\u0003\u0002\u0018*\u0011\u0011\u0011T\u0001\u0007EJ,WM_3\n\t\u0005u\u0015Q\u0013\u0002\f\t\u0016t7/Z'biJL\u0007\u0010E\u0002\u0012\u0003CK1!a)\u0013\u0005\u0019!u.\u001e2mK\"9\u0011q\u0015\u0001\u0005\u0002\u0005%\u0016aA1eIR\u0019a-a+\t\u000f\u00055\u0016Q\u0015a\u0001M\u0006)q\u000e\u001e5fe\"\"\u0011QU\u001a:\u0011\u001d\t\u0019\f\u0001C\u0001\u0003k\u000b\u0001\"\\;mi&\u0004H.\u001f\u000b\u0004M\u0006]\u0006bBAW\u0003c\u0003\rA\u001a\u0015\u0005\u0003c\u001b\u0014\bK\u0002\u0001\u0003{\u00032\u0001NA`\u0013\r\t\t-\u000e\u0002\r\u000bb\u0004XM]5nK:$\u0018\r\u001c\u0015\u0004\u0001MJ\u0004")
public class BlockMatrix
implements DistributedMatrix,
Logging {
    private final RDD<Tuple2<Tuple2<Object, Object>, Matrix>> blocks;
    private final int rowsPerBlock;
    private final int colsPerBlock;
    private long org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nRows;
    private long org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nCols;
    private final int numRowBlocks;
    private final int numColBlocks;
    private RDD<Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>>> blockInfo;
    private transient Logger org$apache$spark$Logging$$log_;
    private volatile boolean bitmap$0;

    private RDD blockInfo$lzycompute() {
        BlockMatrix blockMatrix = this;
        synchronized (blockMatrix) {
            if (!this.bitmap$0) {
                this.blockInfo = RDD$.MODULE$.rddToPairRDDFunctions(this.blocks(), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Matrix.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(Matrix block) {
                        return new Tuple2.mcII.sp(block.numRows(), block.numCols());
                    }
                }).cache();
                this.bitmap$0 = true;
            }
            return this.blockInfo;
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public RDD<Tuple2<Tuple2<Object, Object>, Matrix>> blocks() {
        return this.blocks;
    }

    public int rowsPerBlock() {
        return this.rowsPerBlock;
    }

    public int colsPerBlock() {
        return this.colsPerBlock;
    }

    public long org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nRows() {
        return this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nRows;
    }

    private void org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nRows_$eq(long x$1) {
        this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nRows = x$1;
    }

    public long org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nCols() {
        return this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nCols;
    }

    private void org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nCols_$eq(long x$1) {
        this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nCols = x$1;
    }

    @Override
    public long numRows() {
        if (this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nRows() <= 0L) {
            this.estimateDim();
        }
        return this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nRows();
    }

    @Override
    public long numCols() {
        if (this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nCols() <= 0L) {
            this.estimateDim();
        }
        return this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nCols();
    }

    public int numRowBlocks() {
        return this.numRowBlocks;
    }

    public int numColBlocks() {
        return this.numColBlocks;
    }

    public GridPartitioner createPartitioner() {
        return GridPartitioner$.MODULE$.apply(this.numRowBlocks(), this.numColBlocks(), Predef$.MODULE$.refArrayOps((Object[])this.blocks().partitions()).size());
    }

    private RDD<Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>>> blockInfo() {
        return this.bitmap$0 ? this.blockInfo : this.blockInfo$lzycompute();
    }

    private void estimateDim() {
        Tuple2 tuple2 = (Tuple2)this.blockInfo().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrix $outer;

            public final Tuple2<Object, Object> apply(Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>> x0$1) {
                Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        int blockRowIndex = tuple22._1$mcI$sp();
                        int blockColIndex = tuple22._2$mcI$sp();
                        if (tuple23 != null) {
                            int m = tuple23._1$mcI$sp();
                            int n = tuple23._2$mcI$sp();
                            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp((long)blockRowIndex * (long)this.$outer.rowsPerBlock() + (long)m, (long)blockColIndex * (long)this.$outer.colsPerBlock() + (long)n);
                            return sp2;
                        }
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0, Tuple2<Object, Object> x1) {
                return new Tuple2.mcJJ.sp(scala.math.package$.MODULE$.max(x0._1$mcJ$sp(), x1._1$mcJ$sp()), scala.math.package$.MODULE$.max(x0._2$mcJ$sp(), x1._2$mcJ$sp()));
            }
        });
        if (tuple2 != null) {
            Tuple2.mcJJ.sp sp2;
            long rows = tuple2._1$mcJ$sp();
            long cols = tuple2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp3 = sp2 = new Tuple2.mcJJ.sp(rows, cols);
            long rows2 = sp3._1$mcJ$sp();
            long cols2 = sp3._2$mcJ$sp();
            if (this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nRows() <= 0L) {
                this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nRows_$eq(rows2);
            }
            Predef$.MODULE$.assert(rows2 <= this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nRows(), (Function0)new Serializable(this, rows2){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BlockMatrix $outer;
                private final long rows$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The number of rows ", " is more than claimed ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.rows$1), BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nRows())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.rows$1 = rows$1;
                }
            });
            if (this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nCols() <= 0L) {
                this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nCols_$eq(cols2);
            }
            Predef$.MODULE$.assert(cols2 <= this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nCols(), (Function0)new Serializable(this, cols2){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BlockMatrix $outer;
                private final long cols$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The number of columns ", " is more than claimed ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.cols$1), BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nCols())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.cols$1 = cols$1;
                }
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public void validate() {
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Validating BlockMatrix...";
            }
        });
        this.estimateDim();
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "BlockMatrix dimensions are okay...";
            }
        });
        RDD$.MODULE$.rddToPairRDDFunctions(this.blockInfo(), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Tuple2.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).countByKey().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<Tuple2<Object, Object>, Object> x0$2) {
                Tuple2<Tuple2<Object, Object>, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    Tuple2 key = (Tuple2)tuple2._1();
                    long cnt = tuple2._2$mcJ$sp();
                    if (cnt > 1L) {
                        throw new SparkException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found multiple MatrixBlocks with the indices ", ". Please "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key}))).append((Object)"remove blocks with duplicate indices.").toString());
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "MatrixBlock indices are okay...";
            }
        });
        String dimensionMsg = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dimensions different than rowsPerBlock: ", ", and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.rowsPerBlock())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"colsPerBlock: ", ". Blocks on the right and bottom edges can have smaller "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.colsPerBlock())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dimensions. You may use the repartition method to fix this issue."})).s((Seq)Nil$.MODULE$)).toString();
        this.blockInfo().foreach((Function1)new Serializable(this, dimensionMsg){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrix $outer;
            private final String dimensionMsg$1;

            public final void apply(Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>> x0$3) {
                Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>> tuple2 = x0$3;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        int blockRowIndex = tuple22._1$mcI$sp();
                        int blockColIndex = tuple22._2$mcI$sp();
                        if (tuple23 != null) {
                            int m = tuple23._1$mcI$sp();
                            int n = tuple23._2$mcI$sp();
                            if (blockRowIndex < this.$outer.numRowBlocks() - 1 && m != this.$outer.rowsPerBlock() || blockRowIndex == this.$outer.numRowBlocks() - 1 && (m <= 0 || m > this.$outer.rowsPerBlock())) {
                                throw new SparkException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The MatrixBlock at (", ", ", ") has "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)blockRowIndex), BoxesRunTime.boxToInteger((int)blockColIndex)}))).append((Object)this.dimensionMsg$1).toString());
                            }
                            if (blockColIndex < this.$outer.numColBlocks() - 1 && n != this.$outer.colsPerBlock() || blockColIndex == this.$outer.numColBlocks() - 1 && (n <= 0 || n > this.$outer.colsPerBlock())) {
                                throw new SparkException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The MatrixBlock at (", ", ", ") has "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)blockRowIndex), BoxesRunTime.boxToInteger((int)blockColIndex)}))).append((Object)this.dimensionMsg$1).toString());
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dimensionMsg$1 = dimensionMsg$1;
            }
        });
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "MatrixBlock dimensions are okay...";
            }
        });
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "BlockMatrix is valid!";
            }
        });
    }

    public BlockMatrix cache() {
        this.blocks().cache();
        return this;
    }

    public BlockMatrix persist(StorageLevel storageLevel) {
        this.blocks().persist(storageLevel);
        return this;
    }

    public CoordinateMatrix toCoordinateMatrix() {
        RDD entryRDD = this.blocks().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrix $outer;

            public final ArrayBuffer<MatrixEntry> apply(Tuple2<Tuple2<Object, Object>, Matrix> x0$4) {
                Tuple2<Tuple2<Object, Object>, Matrix> tuple2 = x0$4;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Matrix mat = (Matrix)tuple2._2();
                    if (tuple22 != null) {
                        int blockRowIndex = tuple22._1$mcI$sp();
                        int blockColIndex = tuple22._2$mcI$sp();
                        long rowStart = (long)blockRowIndex * (long)this.$outer.rowsPerBlock();
                        long colStart = (long)blockColIndex * (long)this.$outer.colsPerBlock();
                        ArrayBuffer entryValues = new ArrayBuffer();
                        mat.foreachActive((Function3<Object, Object, Object, BoxedUnit>)new Serializable(this, rowStart, colStart, entryValues){
                            public static final long serialVersionUID = 0L;
                            private final long rowStart$1;
                            private final long colStart$1;
                            private final ArrayBuffer entryValues$1;

                            public final void apply(int i, int j, double v) {
                                if (v != 0.0) {
                                    this.entryValues$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MatrixEntry[]{new MatrixEntry(this.rowStart$1 + (long)i, this.colStart$1 + (long)j, v)}));
                                }
                            }
                            {
                                this.rowStart$1 = rowStart$1;
                                this.colStart$1 = colStart$1;
                                this.entryValues$1 = entryValues$1;
                            }
                        });
                        ArrayBuffer arrayBuffer = entryValues;
                        return arrayBuffer;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(MatrixEntry.class));
        return new CoordinateMatrix((RDD<MatrixEntry>)entryRDD, this.numRows(), this.numCols());
    }

    public IndexedRowMatrix toIndexedRowMatrix() {
        Predef$.MODULE$.require(this.numCols() < Integer.MAX_VALUE, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrix $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"The number of columns must be within the integer range. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numCols: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.numCols())}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return this.toCoordinateMatrix().toIndexedRowMatrix();
    }

    public Matrix toLocalMatrix() {
        Predef$.MODULE$.require(this.numRows() < Integer.MAX_VALUE, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrix $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"The number of rows of this matrix should be less than ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Int.MaxValue. Currently numRows: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.numRows())}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(this.numCols() < Integer.MAX_VALUE, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrix $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"The number of columns of this matrix should be less than ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Int.MaxValue. Currently numCols: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.numCols())}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(this.numRows() * this.numCols() < Integer.MAX_VALUE, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrix $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"The length of the values array must be ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"less than Int.MaxValue. Currently numRows * numCols: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(this.$outer.numRows() * this.$outer.numCols()))}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        int m = (int)this.numRows();
        int n = (int)this.numCols();
        int mem = m * n / 125000;
        if (mem > 500) {
            this.logWarning((Function0<String>)new Serializable(this, mem){
                public static final long serialVersionUID = 0L;
                private final int mem$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Storing this matrix will require ", " MB of memory!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.mem$1)}));
                }
                {
                    this.mem$1 = mem$1;
                }
            });
        }
        Tuple2[] localBlocks = (Tuple2[])this.blocks().collect();
        double[] values = new double[m * n];
        Predef$.MODULE$.refArrayOps((Object[])localBlocks).foreach((Function1)new Serializable(this, m, values){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrix $outer;
            public final int m$1;
            public final double[] values$1;

            public final void apply(Tuple2<Tuple2<Object, Object>, Matrix> x0$5) {
                Tuple2<Tuple2<Object, Object>, Matrix> tuple2 = x0$5;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Matrix submat = (Matrix)tuple2._2();
                    if (tuple22 != null) {
                        int blockRowIndex = tuple22._1$mcI$sp();
                        int blockColIndex = tuple22._2$mcI$sp();
                        int rowOffset = blockRowIndex * this.$outer.rowsPerBlock();
                        int colOffset = blockColIndex * this.$outer.colsPerBlock();
                        submat.foreachActive((Function3<Object, Object, Object, BoxedUnit>)new Serializable(this, rowOffset, colOffset){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$toLocalMatrix$5 $outer;
                            private final int rowOffset$1;
                            private final int colOffset$1;

                            public final void apply(int i, int j, double v) {
                                int indexOffset = (j + this.colOffset$1) * this.$outer.m$1 + this.rowOffset$1 + i;
                                this.$outer.values$1[indexOffset] = v;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.rowOffset$1 = rowOffset$1;
                                this.colOffset$1 = colOffset$1;
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.m$1 = m$1;
                this.values$1 = values$1;
            }
        });
        return new DenseMatrix(m, n, values);
    }

    public BlockMatrix transpose() {
        RDD transposedBlocks = this.blocks().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Tuple2<Object, Object>, Matrix> apply(Tuple2<Tuple2<Object, Object>, Matrix> x0$6) {
                Tuple2<Tuple2<Object, Object>, Matrix> tuple2 = x0$6;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Matrix mat = (Matrix)tuple2._2();
                    if (tuple22 != null) {
                        int blockRowIndex = tuple22._1$mcI$sp();
                        int blockColIndex = tuple22._2$mcI$sp();
                        Tuple2 tuple23 = new Tuple2((Object)new Tuple2.mcII.sp(blockColIndex, blockRowIndex), (Object)mat.transpose());
                        return tuple23;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return new BlockMatrix((RDD<Tuple2<Tuple2<Object, Object>, Matrix>>)transposedBlocks, this.colsPerBlock(), this.rowsPerBlock(), this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nCols(), this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nRows());
    }

    @Override
    public breeze.linalg.DenseMatrix<Object> toBreeze() {
        Matrix localMat = this.toLocalMatrix();
        return new DenseMatrix.mcD.sp(localMat.numRows(), localMat.numCols(), localMat.toArray());
    }

    public BlockMatrix add(BlockMatrix other) {
        Predef$.MODULE$.require(this.numRows() == other.numRows(), (Function0)new Serializable(this, other){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrix $outer;
            private final BlockMatrix other$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Both matrices must have the same number of rows. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A.numRows: ", ", B.numRows: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.numRows()), BoxesRunTime.boxToLong((long)this.other$1.numRows())}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.other$1 = other$1;
            }
        });
        Predef$.MODULE$.require(this.numCols() == other.numCols(), (Function0)new Serializable(this, other){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrix $outer;
            private final BlockMatrix other$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Both matrices must have the same number of columns. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A.numCols: ", ", B.numCols: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.numCols()), BoxesRunTime.boxToLong((long)this.other$1.numCols())}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.other$1 = other$1;
            }
        });
        if (this.rowsPerBlock() == other.rowsPerBlock() && this.colsPerBlock() == other.colsPerBlock()) {
            RDD addedBlocks = RDD$.MODULE$.rddToPairRDDFunctions(this.blocks(), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Matrix.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).cogroup(other.blocks(), (Partitioner)this.createPartitioner()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Tuple2<Object, Object>, Matrix> apply(Tuple2<Tuple2<Object, Object>, Tuple2<Iterable<Matrix>, Iterable<Matrix>>> x0$7) {
                    Tuple2<Tuple2<Object, Object>, Tuple2<Iterable<Matrix>, Iterable<Matrix>>> tuple2 = x0$7;
                    if (tuple2 != null) {
                        Tuple2 tuple22 = (Tuple2)tuple2._1();
                        Tuple2 tuple23 = (Tuple2)tuple2._2();
                        if (tuple22 != null) {
                            int blockRowIndex = tuple22._1$mcI$sp();
                            int blockColIndex = tuple22._2$mcI$sp();
                            if (tuple23 != null) {
                                Tuple2 tuple24;
                                Iterable a = (Iterable)tuple23._1();
                                Iterable b = (Iterable)tuple23._2();
                                if (a.size() > 1 || b.size() > 1) {
                                    throw new SparkException(new StringBuilder().append((Object)"There are multiple MatrixBlocks with indices: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ", ", "). Please remove them."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)blockRowIndex), BoxesRunTime.boxToInteger((int)blockColIndex)}))).toString());
                                }
                                if (a.isEmpty()) {
                                    tuple24 = new Tuple2((Object)new Tuple2.mcII.sp(blockRowIndex, blockColIndex), b.head());
                                } else if (b.isEmpty()) {
                                    tuple24 = new Tuple2((Object)new Tuple2.mcII.sp(blockRowIndex, blockColIndex), a.head());
                                } else {
                                    breeze.linalg.Matrix result = (breeze.linalg.Matrix)((Matrix)a.head()).toBreeze().$plus(((Matrix)b.head()).toBreeze(), (UFunc.UImpl2)Matrix$.MODULE$.op_M_DM_Double_OpAdd());
                                    tuple24 = new Tuple2((Object)new Tuple2.mcII.sp(blockRowIndex, blockColIndex), (Object)Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)result));
                                }
                                Tuple2 tuple25 = tuple24;
                                return tuple25;
                            }
                        }
                    }
                    throw new MatchError(tuple2);
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            return new BlockMatrix((RDD<Tuple2<Tuple2<Object, Object>, Matrix>>)addedBlocks, this.rowsPerBlock(), this.colsPerBlock(), this.numRows(), this.numCols());
        }
        throw new SparkException("Cannot add matrices with different block dimensions");
    }

    public BlockMatrix multiply(BlockMatrix other) {
        Predef$.MODULE$.require(this.numCols() == other.numRows(), (Function0)new Serializable(this, other){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrix $outer;
            private final BlockMatrix other$2;

            public final String apply() {
                return new StringBuilder().append((Object)"The number of columns of A and the number of rows ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"of B must be equal. A.numCols: ", ", B.numRows: ", ". If you "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.numCols()), BoxesRunTime.boxToLong((long)this.other$2.numRows())}))).append((Object)"think they should be equal, try setting the dimensions of A and B explicitly while ").append((Object)"initializing them.").toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.other$2 = other$2;
            }
        });
        if (this.colsPerBlock() == other.rowsPerBlock()) {
            GridPartitioner resultPartitioner = GridPartitioner$.MODULE$.apply(this.numRowBlocks(), other.numColBlocks(), scala.math.package$.MODULE$.max(this.blocks().partitions().length, other.blocks().partitions().length));
            RDD flatA = this.blocks().flatMap((Function1)new Serializable(this, other){
                public static final long serialVersionUID = 0L;
                private final BlockMatrix other$2;

                public final Iterator<Tuple2<Tuple3<Object, Object, Object>, Matrix>> apply(Tuple2<Tuple2<Object, Object>, Matrix> x0$8) {
                    Tuple2<Tuple2<Object, Object>, Matrix> tuple2 = x0$8;
                    if (tuple2 != null) {
                        Tuple2 tuple22 = (Tuple2)tuple2._1();
                        Matrix block = (Matrix)tuple2._2();
                        if (tuple22 != null) {
                            int blockRowIndex = tuple22._1$mcI$sp();
                            int blockColIndex = tuple22._2$mcI$sp();
                            Iterator iterator = package$.MODULE$.Iterator().tabulate(this.other$2.numColBlocks(), (Function1)new Serializable(this, blockRowIndex, blockColIndex, block){
                                public static final long serialVersionUID = 0L;
                                private final int blockRowIndex$1;
                                private final int blockColIndex$1;
                                private final Matrix block$1;

                                public final Tuple2<Tuple3<Object, Object, Object>, Matrix> apply(int j) {
                                    return new Tuple2((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)this.blockRowIndex$1), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToInteger((int)this.blockColIndex$1)), (Object)this.block$1);
                                }
                                {
                                    this.blockRowIndex$1 = blockRowIndex$1;
                                    this.blockColIndex$1 = blockColIndex$1;
                                    this.block$1 = block$1;
                                }
                            });
                            return iterator;
                        }
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.other$2 = other$2;
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            RDD flatB = other.blocks().flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BlockMatrix $outer;

                public final Iterator<Tuple2<Tuple3<Object, Object, Object>, Matrix>> apply(Tuple2<Tuple2<Object, Object>, Matrix> x0$9) {
                    Tuple2<Tuple2<Object, Object>, Matrix> tuple2 = x0$9;
                    if (tuple2 != null) {
                        Tuple2 tuple22 = (Tuple2)tuple2._1();
                        Matrix block = (Matrix)tuple2._2();
                        if (tuple22 != null) {
                            int blockRowIndex = tuple22._1$mcI$sp();
                            int blockColIndex = tuple22._2$mcI$sp();
                            Iterator iterator = package$.MODULE$.Iterator().tabulate(this.$outer.numRowBlocks(), (Function1)new Serializable(this, blockRowIndex, blockColIndex, block){
                                public static final long serialVersionUID = 0L;
                                private final int blockRowIndex$2;
                                private final int blockColIndex$2;
                                private final Matrix block$2;

                                public final Tuple2<Tuple3<Object, Object, Object>, Matrix> apply(int i) {
                                    return new Tuple2((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)this.blockColIndex$2), (Object)BoxesRunTime.boxToInteger((int)this.blockRowIndex$2)), (Object)this.block$2);
                                }
                                {
                                    this.blockRowIndex$2 = blockRowIndex$2;
                                    this.blockColIndex$2 = blockColIndex$2;
                                    this.block$2 = block$2;
                                }
                            });
                            return iterator;
                        }
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            RDD newBlocks = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(flatA, ClassTag$.MODULE$.apply(Tuple3.class), ClassTag$.MODULE$.apply(Matrix.class), Ordering$.MODULE$.Tuple3((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).cogroup(flatB, (Partitioner)resultPartitioner).flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Iterator<Tuple2<Tuple2<Object, Object>, breeze.linalg.Matrix<Object>>> apply(Tuple2<Tuple3<Object, Object, Object>, Tuple2<Iterable<Matrix>, Iterable<Matrix>>> x0$10) {
                    Iterator iterator;
                    Tuple2<Tuple3<Object, Object, Object>, Tuple2<Iterable<Matrix>, Iterable<Matrix>>> tuple2 = x0$10;
                    if (tuple2 == null) throw new MatchError(tuple2);
                    Tuple3 tuple3 = (Tuple3)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple3 == null) throw new MatchError(tuple2);
                    int blockRowIndex = BoxesRunTime.unboxToInt((Object)tuple3._1());
                    int blockColIndex = BoxesRunTime.unboxToInt((Object)tuple3._2());
                    if (tuple22 == null) throw new MatchError(tuple2);
                    Iterable a = (Iterable)tuple22._1();
                    Iterable b = (Iterable)tuple22._2();
                    if (a.size() > 1 || b.size() > 1) {
                        throw new SparkException(new StringBuilder().append((Object)"There are multiple MatrixBlocks with indices: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ", ", "). Please remove them."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)blockRowIndex), BoxesRunTime.boxToInteger((int)blockColIndex)}))).toString());
                    }
                    if (a.nonEmpty() && b.nonEmpty()) {
                        DenseMatrix denseMatrix;
                        Matrix matrix = (Matrix)b.head();
                        if (matrix instanceof DenseMatrix) {
                            DenseMatrix denseMatrix2 = (DenseMatrix)matrix;
                            denseMatrix = ((Matrix)a.head()).multiply(denseMatrix2);
                        } else {
                            if (!(matrix instanceof SparseMatrix)) throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unrecognized matrix type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{b.head().getClass()})));
                            SparseMatrix sparseMatrix = (SparseMatrix)matrix;
                            denseMatrix = ((Matrix)a.head()).multiply(sparseMatrix.toDense());
                        }
                        DenseMatrix C = denseMatrix;
                        iterator = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2.mcII.sp(blockRowIndex, blockColIndex), C.toBreeze())}));
                        return iterator;
                    } else {
                        iterator = package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
                    }
                    return iterator;
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(breeze.linalg.Matrix.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).reduceByKey((Partitioner)resultPartitioner, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final breeze.linalg.Matrix<Object> apply(breeze.linalg.Matrix<Object> a, breeze.linalg.Matrix<Object> b) {
                    return (breeze.linalg.Matrix)a.$plus(b, (UFunc.UImpl2)Matrix$.MODULE$.op_M_DM_Double_OpAdd());
                }
            }), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(breeze.linalg.Matrix.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).mapValues((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Matrix apply(breeze.linalg.Matrix<Object> breeze) {
                    return Matrices$.MODULE$.fromBreeze(breeze);
                }
            });
            return new BlockMatrix((RDD<Tuple2<Tuple2<Object, Object>, Matrix>>)newBlocks, this.rowsPerBlock(), other.colsPerBlock(), this.numRows(), other.numCols());
        }
        throw new SparkException(new StringBuilder().append((Object)"colsPerBlock of A doesn't match rowsPerBlock of B. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A.colsPerBlock: ", ", B.rowsPerBlock: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.colsPerBlock()), BoxesRunTime.boxToInteger((int)other.rowsPerBlock())}))).toString());
    }

    public BlockMatrix(RDD<Tuple2<Tuple2<Object, Object>, Matrix>> blocks, int rowsPerBlock, int colsPerBlock, long nRows, long nCols) {
        this.blocks = blocks;
        this.rowsPerBlock = rowsPerBlock;
        this.colsPerBlock = colsPerBlock;
        this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nRows = nRows;
        this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nCols = nCols;
        Logging.class.$init$((Logging)this);
        this.numRowBlocks = (int)scala.math.package$.MODULE$.ceil((double)this.numRows() * 1.0 / (double)rowsPerBlock);
        this.numColBlocks = (int)scala.math.package$.MODULE$.ceil((double)this.numCols() * 1.0 / (double)colsPerBlock);
    }

    public BlockMatrix(RDD<Tuple2<Tuple2<Object, Object>, Matrix>> blocks, int rowsPerBlock, int colsPerBlock) {
        this(blocks, rowsPerBlock, colsPerBlock, 0L, 0L);
    }
}

