/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.SparkContext;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaDoubleRDD;
import org.apache.spark.api.java.JavaDoubleRDD$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.IsotonicRegressionModel$;
import org.apache.spark.mllib.regression.IsotonicRegressionModel$SaveLoadV1_0$;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\tMg\u0001B\u0001\u0003\u00015\u0011q#S:pi>t\u0017n\u0019*fOJ,7o]5p]6{G-\u001a7\u000b\u0005\r!\u0011A\u0003:fOJ,7o]5p]*\u0011QAB\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f)q\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u001b\u001b\u00051\"BA\f\u0019\u0003\tIwNC\u0001\u001a\u0003\u0011Q\u0017M^1\n\u0005m1\"\u0001D*fe&\fG.\u001b>bE2,\u0007CA\u000f!\u001b\u0005q\"BA\u0010\u0005\u0003\u0011)H/\u001b7\n\u0005\u0005r\"\u0001C*bm\u0016\f'\r\\3\t\u0011\r\u0002!Q1A\u0005\u0002\u0011\n!BY8v]\u0012\f'/[3t+\u0005)\u0003cA\b'Q%\u0011q\u0005\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u001f%J!A\u000b\t\u0003\r\u0011{WO\u00197fQ\r\u0011CF\r\t\u0003[Aj\u0011A\f\u0006\u0003_\u0019\t!\"\u00198o_R\fG/[8o\u0013\t\tdFA\u0003TS:\u001cW-I\u00014\u0003\u0015\tdf\r\u00181\u0011!)\u0004A!A!\u0002\u0013)\u0013a\u00032pk:$\u0017M]5fg\u0002B3\u0001\u000e\u00173\u0011!A\u0004A!b\u0001\n\u0003!\u0013a\u00039sK\u0012L7\r^5p]ND3a\u000e\u00173\u0011!Y\u0004A!A!\u0002\u0013)\u0013\u0001\u00049sK\u0012L7\r^5p]N\u0004\u0003f\u0001\u001e-e!Aa\b\u0001BC\u0002\u0013\u0005q(\u0001\u0005jg>$xN\\5d+\u0005\u0001\u0005CA\bB\u0013\t\u0011\u0005CA\u0004C_>dW-\u00198)\u0007ub#\u0007\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003A\u0003%I7o\u001c;p]&\u001c\u0007\u0005K\u0002EYIBQ\u0001\u0013\u0001\u0005\u0002%\u000ba\u0001P5oSRtD\u0003\u0002&M\u001dB\u0003\"a\u0013\u0001\u000e\u0003\tAQaI$A\u0002\u0015B3\u0001\u0014\u00173\u0011\u0015At\t1\u0001&Q\rqEF\r\u0005\u0006}\u001d\u0003\r\u0001\u0011\u0015\u0004!2\u0012\u0004fA$-e!9A\u000b\u0001b\u0001\n\u0013)\u0016!\u00049sK\u0012L7\r^5p]>\u0013H-F\u0001W!\r9&\fK\u0007\u00021*\u0011\u0011\fE\u0001\u0005[\u0006$\b.\u0003\u0002\\1\nAqJ\u001d3fe&tw\r\u0003\u0004^\u0001\u0001\u0006IAV\u0001\u000faJ,G-[2uS>twJ\u001d3!\u0011\u0015A\u0005\u0001\"\u0001`)\u0011Q\u0005m\u001a5\t\u000b\rr\u0006\u0019A1\u0011\u0007\t,\u0007&D\u0001d\u0015\t!\u0007$\u0001\u0003mC:<\u0017B\u00014d\u0005!IE/\u001a:bE2,\u0007\"\u0002\u001d_\u0001\u0004\t\u0007\"\u0002 _\u0001\u0004I\u0007C\u00012k\u0013\t\u00115\rK\u0002_Y1\f\u0013!\\\u0001\u0006c9\"d\u0006\r\u0005\u0006_\u0002!I\u0001]\u0001\u000eCN\u001cXM\u001d;Pe\u0012,'/\u001a3\u0015\u0007E\f)\u0001\u0006\u0002skB\u0011qb]\u0005\u0003iB\u0011A!\u00168ji\")aO\u001ca\u0002o\u0006\u0019qN\u001d3\u0011\ta\f\t\u0001\u000b\b\u0003szt!A_?\u000e\u0003mT!\u0001 \u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0012BA@\u0011\u0003\u001d\u0001\u0018mY6bO\u0016L1aWA\u0002\u0015\ty\b\u0003\u0003\u0004\u0002\b9\u0004\r!J\u0001\u0003qNDq!a\u0003\u0001\t\u0003\ti!A\u0004qe\u0016$\u0017n\u0019;\u0015\t\u0005=\u00111\u0004\t\u0006\u0003#\t9\u0002K\u0007\u0003\u0003'Q1!!\u0006\u0007\u0003\r\u0011H\rZ\u0005\u0005\u00033\t\u0019BA\u0002S\t\u0012C\u0001\"!\b\u0002\n\u0001\u0007\u0011qB\u0001\ti\u0016\u001cH\u000fR1uC\"\"\u0011\u0011\u0002\u00173\u0011\u001d\tY\u0001\u0001C\u0001\u0003G!B!!\n\u00024A!\u0011qEA\u0018\u001b\t\tICC\u0002\u001a\u0003WQ1!!\f\u0007\u0003\r\t\u0007/[\u0005\u0005\u0003c\tICA\u0007KCZ\fGi\\;cY\u0016\u0014F\t\u0012\u0005\t\u0003;\t\t\u00031\u0001\u0002&!\"\u0011\u0011\u0005\u00173\u0011\u001d\tY\u0001\u0001C\u0001\u0003s!2\u0001KA\u001e\u0011\u001d\ti\"a\u000eA\u0002!BC!a\u000e-e!A\u0011\u0011\t\u0001\u0005\u0002\u0011\t\u0019%\u0001\bc_VtG-\u0019:z-\u0016\u001cGo\u001c:\u0016\u0005\u0005\u0015\u0003\u0003BA$\u0003\u001bj!!!\u0013\u000b\u0007\u0005-C!\u0001\u0004mS:\fGnZ\u0005\u0005\u0003\u001f\nIE\u0001\u0004WK\u000e$xN\u001d\u0005\t\u0003'\u0002A\u0011\u0001\u0003\u0002D\u0005\u0001\u0002O]3eS\u000e$\u0018n\u001c8WK\u000e$xN\u001d\u0005\b\u0003/\u0002A\u0011IA-\u0003\u0011\u0019\u0018M^3\u0015\u000bI\fY&a\u001a\t\u0011\u0005u\u0013Q\u000ba\u0001\u0003?\n!a]2\u0011\t\u0005\u0005\u00141M\u0007\u0002\r%\u0019\u0011Q\r\u0004\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\t\u0011\u0005%\u0014Q\u000ba\u0001\u0003W\nA\u0001]1uQB!\u0011QNA:\u001d\ry\u0011qN\u0005\u0004\u0003c\u0002\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002v\u0005]$AB*ue&twMC\u0002\u0002rAAC!!\u0016-Y\"9\u0011Q\u0010\u0001\u0005R\u0005}\u0014!\u00044pe6\fGOV3sg&|g.\u0006\u0002\u0002l!\u001a\u0001!a!\u0011\u00075\n))C\u0002\u0002\b:\u0012A\"\u0012=qKJLW.\u001a8uC2D3\u0001\u0001\u00173\u000f\u001d\tiI\u0001E\u0001\u0003\u001f\u000bq#S:pi>t\u0017n\u0019*fOJ,7o]5p]6{G-\u001a7\u0011\u0007-\u000b\tJ\u0002\u0004\u0002\u0005!\u0005\u00111S\n\b\u0003#s\u0011QSAN!\u0011i\u0012q\u0013&\n\u0007\u0005eeD\u0001\u0004M_\u0006$WM\u001d\t\u0004\u001f\u0005u\u0015BA\u000e\u0011\u0011\u001dA\u0015\u0011\u0013C\u0001\u0003C#\"!a$\b\u0011\u0005\u0015\u0016\u0011\u0013E\u0005\u0003O\u000bAbU1wK2{\u0017\r\u001a,2?B\u0002B!!+\u0002,6\u0011\u0011\u0011\u0013\u0004\t\u0003[\u000b\t\n#\u0003\u00020\na1+\u0019<f\u0019>\fGMV\u0019`aM\u0019\u00111\u0016\b\t\u000f!\u000bY\u000b\"\u0001\u00024R\u0011\u0011q\u0015\u0005\t\u0003o\u000bY\u000b\"\u0001\u0002\u0000\u0005\tB\u000f[5t\r>\u0014X.\u0019;WKJ\u001c\u0018n\u001c8\t\u0011\u0005m\u00161\u0016C\u0001\u0003\u007f\nQ\u0002\u001e5jg\u000ec\u0017m]:OC6,gaBA`\u0003W\u0003\u0015\u0011\u0019\u0002\u0005\t\u0006$\u0018mE\u0004\u0002>:\t\u0019-a'\u0011\u0007=\t)-C\u0002\u0002HB\u0011q\u0001\u0015:pIV\u001cG\u000fC\u0006\u0002L\u0006u&Q3A\u0005\u0002\u00055\u0017\u0001\u00032pk:$\u0017M]=\u0016\u0003!B!\"!5\u0002>\nE\t\u0015!\u0003)\u0003%\u0011w.\u001e8eCJL\b\u0005C\u0006\u0002V\u0006u&Q3A\u0005\u0002\u00055\u0017A\u00039sK\u0012L7\r^5p]\"Q\u0011\u0011\\A_\u0005#\u0005\u000b\u0011\u0002\u0015\u0002\u0017A\u0014X\rZ5di&|g\u000e\t\u0005\b\u0011\u0006uF\u0011AAo)\u0019\ty.a9\u0002fB!\u0011\u0011]A_\u001b\t\tY\u000bC\u0004\u0002L\u0006m\u0007\u0019\u0001\u0015\t\u000f\u0005U\u00171\u001ca\u0001Q!Q\u0011\u0011^A_\u0003\u0003%\t!a;\u0002\t\r|\u0007/\u001f\u000b\u0007\u0003?\fi/a<\t\u0013\u0005-\u0017q\u001dI\u0001\u0002\u0004A\u0003\"CAk\u0003O\u0004\n\u00111\u0001)\u0011)\t\u00190!0\u0012\u0002\u0013\u0005\u0011Q_\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t9PK\u0002)\u0003s\\#!a?\u0011\t\u0005u(QA\u0007\u0003\u0003\u007fTAA!\u0001\u0003\u0004\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0003_AIAAa\u0002\u0002\u0000\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\t-\u0011QXI\u0001\n\u0003\t)0\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\t\u0015\t=\u0011QXA\u0001\n\u0003\u0012\t\"A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005'\u00012A\u0019B\u000b\u0013\r\t)h\u0019\u0005\u000b\u00053\ti,!A\u0005\u0002\tm\u0011\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001B\u000f!\ry!qD\u0005\u0004\u0005C\u0001\"aA%oi\"Q!QEA_\u0003\u0003%\tAa\n\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!\u0011\u0006B\u0018!\ry!1F\u0005\u0004\u0005[\u0001\"aA!os\"Q!\u0011\u0007B\u0012\u0003\u0003\u0005\rA!\b\u0002\u0007a$\u0013\u0007\u0003\u0006\u00036\u0005u\u0016\u0011!C!\u0005o\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005s\u0001bAa\u000f\u0003B\t%RB\u0001B\u001f\u0015\r\u0011y\u0004E\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\"\u0005{\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0005\u000b\u0005\u000f\ni,!A\u0005\u0002\t%\u0013\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007\u0001\u0013Y\u0005\u0003\u0006\u00032\t\u0015\u0013\u0011!a\u0001\u0005SA!Ba\u0014\u0002>\u0006\u0005I\u0011\tB)\u0003!A\u0017m\u001d5D_\u0012,GC\u0001B\u000f\u0011)\u0011)&!0\u0002\u0002\u0013\u0005#qK\u0001\ti>\u001cFO]5oOR\u0011!1\u0003\u0005\u000b\u00057\ni,!A\u0005B\tu\u0013AB3rk\u0006d7\u000fF\u0002A\u0005?B!B!\r\u0003Z\u0005\u0005\t\u0019\u0001B\u0015\u000f)\u0011\u0019'a+\u0002\u0002#\u0005!QM\u0001\u0005\t\u0006$\u0018\r\u0005\u0003\u0002b\n\u001ddACA`\u0003W\u000b\t\u0011#\u0001\u0003jM1!q\rB6\u00037\u0003\u0002B!\u001c\u0003t!B\u0013q\\\u0007\u0003\u0005_R1A!\u001d\u0011\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u001e\u0003p\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\t\u000f!\u00139\u0007\"\u0001\u0003zQ\u0011!Q\r\u0005\u000b\u0005+\u00129'!A\u0005F\t]\u0003B\u0003B@\u0005O\n\t\u0011\"!\u0003\u0002\u0006)\u0011\r\u001d9msR1\u0011q\u001cBB\u0005\u000bCq!a3\u0003~\u0001\u0007\u0001\u0006C\u0004\u0002V\nu\u0004\u0019\u0001\u0015\t\u0015\t%%qMA\u0001\n\u0003\u0013Y)A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t5%\u0011\u0014\t\u0006\u001f\t=%1S\u0005\u0004\u0005#\u0003\"AB(qi&|g\u000eE\u0003\u0010\u0005+C\u0003&C\u0002\u0003\u0018B\u0011a\u0001V;qY\u0016\u0014\u0004B\u0003BN\u0005\u000f\u000b\t\u00111\u0001\u0002`\u0006\u0019\u0001\u0010\n\u0019\t\u0015\t}%qMA\u0001\n\u0013\u0011\t+A\u0006sK\u0006$'+Z:pYZ,GC\u0001BR!\r\u0011'QU\u0005\u0004\u0005O\u001b'AB(cU\u0016\u001cG\u000f\u0003\u0005\u0002X\u0005-F\u0011\u0001BV)-\u0011(Q\u0016BX\u0005c\u0013\u0019L!.\t\u0011\u0005u#\u0011\u0016a\u0001\u0003?B\u0001\"!\u001b\u0003*\u0002\u0007\u00111\u000e\u0005\u0007G\t%\u0006\u0019A\u0013\t\ra\u0012I\u000b1\u0001&\u0011\u0019q$\u0011\u0016a\u0001\u0001\"A!\u0011XAV\t\u0003\u0011Y,\u0001\u0003m_\u0006$GC\u0002B_\u0005\u007f\u0013\t\rE\u0003\u0010\u0005++S\u0005\u0003\u0005\u0002^\t]\u0006\u0019AA0\u0011!\tIGa.A\u0002\u0005-\u0004\u0002\u0003B]\u0003##\tE!2\u0015\u000b)\u00139M!3\t\u0011\u0005u#1\u0019a\u0001\u0003?B\u0001\"!\u001b\u0003D\u0002\u0007\u00111\u000e\u0015\u0005\u0005\u0007dC\u000e\u0003\u0006\u0003 \u0006E\u0015\u0011!C\u0005\u0005CCC!!%-Y\"\"\u00111\u0012\u0017m\u0001")
public class IsotonicRegressionModel
implements Serializable,
Saveable {
    private final double[] boundaries;
    private final double[] predictions;
    private final boolean isotonic;
    private final Ordering<Object> predictionOrd;

    public static IsotonicRegressionModel load(SparkContext sparkContext, String string) {
        return IsotonicRegressionModel$.MODULE$.load(sparkContext, string);
    }

    public double[] boundaries() {
        return this.boundaries;
    }

    public double[] predictions() {
        return this.predictions;
    }

    public boolean isotonic() {
        return this.isotonic;
    }

    private Ordering<Object> predictionOrd() {
        return this.predictionOrd;
    }

    private void assertOrdered(double[] xs, Ordering<Object> ord) {
        IntRef i = IntRef.create((int)1);
        int len = xs.length;
        while (i.elem < len) {
            Predef$.MODULE$.require(ord.compare((Object)BoxesRunTime.boxToDouble((double)xs[i.elem - 1]), (Object)BoxesRunTime.boxToDouble((double)xs[i.elem])) <= 0, (Function0)new scala.Serializable(this, xs, i){
                public static final long serialVersionUID = 0L;
                private final double[] xs$1;
                private final IntRef i$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Elements (", ", ", ") are not ordered."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.xs$1[this.i$1.elem - 1]), BoxesRunTime.boxToDouble((double)this.xs$1[this.i$1.elem])}));
                }
                {
                    this.xs$1 = xs$1;
                    this.i$1 = i$1;
                }
            });
            ++i.elem;
        }
    }

    public RDD<Object> predict(RDD<Object> testData) {
        return testData.map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsotonicRegressionModel $outer;

            public final double apply(double testData) {
                return this.apply$mcDD$sp(testData);
            }

            public double apply$mcDD$sp(double testData) {
                return this.$outer.predict(testData);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.Double());
    }

    public JavaDoubleRDD predict(JavaDoubleRDD testData) {
        return JavaDoubleRDD$.MODULE$.fromRDD(this.predict((RDD<Object>)testData.rdd().retag(ClassTag$.MODULE$.apply(Double.class))));
    }

    public double predict(double testData) {
        int foundIndex = Arrays.binarySearch(this.boundaries(), testData);
        int insertIndex = -foundIndex - 1;
        return insertIndex == 0 ? BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(this.predictions()).head()) : (insertIndex == this.boundaries().length ? BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(this.predictions()).last()) : (foundIndex < 0 ? this.linearInterpolation$1(this.boundaries()[insertIndex - 1], this.predictions()[insertIndex - 1], this.boundaries()[insertIndex], this.predictions()[insertIndex], testData) : this.predictions()[foundIndex]));
    }

    public Vector boundaryVector() {
        return Vectors$.MODULE$.dense(this.boundaries());
    }

    public Vector predictionVector() {
        return Vectors$.MODULE$.dense(this.predictions());
    }

    @Override
    public void save(SparkContext sc, String path) {
        IsotonicRegressionModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.boundaries(), this.predictions(), this.isotonic());
    }

    @Override
    public String formatVersion() {
        return "1.0";
    }

    private final double linearInterpolation$1(double x1, double y1, double x2, double y2, double x) {
        return y1 + (y2 - y1) * (x - x1) / (x2 - x1);
    }

    public IsotonicRegressionModel(double[] boundaries, double[] predictions, boolean isotonic) {
        this.boundaries = boundaries;
        this.predictions = predictions;
        this.isotonic = isotonic;
        this.predictionOrd = isotonic ? package$.MODULE$.Ordering().apply((Ordering)Ordering.Double$.MODULE$) : package$.MODULE$.Ordering().apply((Ordering)Ordering.Double$.MODULE$).reverse();
        Predef$.MODULE$.require(boundaries.length == predictions.length);
        this.assertOrdered(boundaries, (Ordering<Object>)Ordering.Double$.MODULE$);
        this.assertOrdered(predictions, this.predictionOrd());
    }

    public IsotonicRegressionModel(Iterable<Object> boundaries, Iterable<Object> predictions, Boolean isotonic) {
        this((double[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(boundaries).asScala()).toArray(ClassTag$.MODULE$.Double()), (double[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(predictions).asScala()).toArray(ClassTag$.MODULE$.Double()), Predef$.MODULE$.Boolean2boolean(isotonic));
    }
}

