/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.optimization.GradientDescent;
import org.apache.spark.mllib.optimization.LeastSquaresGradient;
import org.apache.spark.mllib.optimization.SquaredL2Updater;
import org.apache.spark.mllib.regression.GeneralizedLinearAlgorithm;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.RidgeRegressionModel;
import org.apache.spark.mllib.regression.RidgeRegressionWithSGD$;
import org.apache.spark.rdd.RDD;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=e\u0001B\u0001\u0003\u00015\u0011aCU5eO\u0016\u0014Vm\u001a:fgNLwN\\,ji\"\u001cv\t\u0012\u0006\u0003\u0007\u0011\t!B]3he\u0016\u001c8/[8o\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0016!\ry\u0001CE\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\u001b\u000f\u0016tWM]1mSj,G\rT5oK\u0006\u0014\u0018\t\\4pe&$\b.\u001c\t\u0003\u001fMI!\u0001\u0006\u0002\u0003)IKGmZ3SK\u001e\u0014Xm]:j_:lu\u000eZ3m!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!a\u0002A!a\u0001\n\u0013i\u0012\u0001C:uKB\u001c\u0016N_3\u0016\u0003y\u0001\"AF\u0010\n\u0005\u0001:\"A\u0002#pk\ndW\r\u0003\u0005#\u0001\t\u0005\r\u0011\"\u0003$\u00031\u0019H/\u001a9TSj,w\fJ3r)\t!s\u0005\u0005\u0002\u0017K%\u0011ae\u0006\u0002\u0005+:LG\u000fC\u0004)C\u0005\u0005\t\u0019\u0001\u0010\u0002\u0007a$\u0013\u0007\u0003\u0005+\u0001\t\u0005\t\u0015)\u0003\u001f\u0003%\u0019H/\u001a9TSj,\u0007\u0005\u0003\u0005-\u0001\t\u0005\r\u0011\"\u0003.\u00035qW/\\%uKJ\fG/[8ogV\ta\u0006\u0005\u0002\u0017_%\u0011\u0001g\u0006\u0002\u0004\u0013:$\b\u0002\u0003\u001a\u0001\u0005\u0003\u0007I\u0011B\u001a\u0002#9,X.\u0013;fe\u0006$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0002%i!9\u0001&MA\u0001\u0002\u0004q\u0003\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0015\u0002\u0018\u0002\u001d9,X.\u0013;fe\u0006$\u0018n\u001c8tA!A\u0001\b\u0001BA\u0002\u0013%Q$\u0001\u0005sK\u001e\u0004\u0016M]1n\u0011!Q\u0004A!a\u0001\n\u0013Y\u0014\u0001\u0004:fOB\u000b'/Y7`I\u0015\fHC\u0001\u0013=\u0011\u001dA\u0013(!AA\u0002yA\u0001B\u0010\u0001\u0003\u0002\u0003\u0006KAH\u0001\ne\u0016<\u0007+\u0019:b[\u0002B\u0001\u0002\u0011\u0001\u0003\u0002\u0004%I!H\u0001\u0012[&t\u0017NQ1uG\"4%/Y2uS>t\u0007\u0002\u0003\"\u0001\u0005\u0003\u0007I\u0011B\"\u0002+5Lg.\u001b\"bi\u000eDgI]1di&|gn\u0018\u0013fcR\u0011A\u0005\u0012\u0005\bQ\u0005\u000b\t\u00111\u0001\u001f\u0011!1\u0005A!A!B\u0013q\u0012AE7j]&\u0014\u0015\r^2i\rJ\f7\r^5p]\u0002BQ\u0001\u0013\u0001\u0005\n%\u000ba\u0001P5oSRtD#\u0002&L\u00196s\u0005CA\b\u0001\u0011\u0015ar\t1\u0001\u001f\u0011\u0015as\t1\u0001/\u0011\u0015At\t1\u0001\u001f\u0011\u0015\u0001u\t1\u0001\u001f\u0011\u001d\u0001\u0006A1A\u0005\nE\u000b\u0001b\u001a:bI&,g\u000e^\u000b\u0002%B\u00111KV\u0007\u0002)*\u0011Q\u000bB\u0001\r_B$\u0018.\\5{CRLwN\\\u0005\u0003/R\u0013A\u0003T3bgR\u001c\u0016/^1sKN<%/\u00193jK:$\bBB-\u0001A\u0003%!+A\u0005he\u0006$\u0017.\u001a8uA!91\f\u0001b\u0001\n\u0013a\u0016aB;qI\u0006$XM]\u000b\u0002;B\u00111KX\u0005\u0003?R\u0013\u0001cU9vCJ,G\r\u0014\u001aVa\u0012\fG/\u001a:\t\r\u0005\u0004\u0001\u0015!\u0003^\u0003!)\b\u000fZ1uKJ\u0004\u0003bB2\u0001\u0005\u0004%\t\u0005Z\u0001\n_B$\u0018.\\5{KJ,\u0012!\u001a\t\u0003'\u001aL!a\u001a+\u0003\u001f\u001d\u0013\u0018\rZ5f]R$Um]2f]RD3AY5p!\tQW.D\u0001l\u0015\tag!\u0001\u0006b]:|G/\u0019;j_:L!A\\6\u0003\u000bMKgnY3\"\u0003A\fQ\u0001\r\u00189]ABaA\u001d\u0001!\u0002\u0013)\u0017AC8qi&l\u0017N_3sA!\u001a\u0011/[8\t\u000b!\u0003A\u0011A;\u0015\u0003)C3\u0001^5p\u0011\u0015A\b\u0001\"\u0015z\u0003-\u0019'/Z1uK6{G-\u001a7\u0015\tIQ\u0018Q\u0001\u0005\u0006w^\u0004\r\u0001`\u0001\bo\u0016Lw\r\u001b;t!\ri\u0018\u0011A\u0007\u0002}*\u0011q\u0010B\u0001\u0007Y&t\u0017\r\\4\n\u0007\u0005\raP\u0001\u0004WK\u000e$xN\u001d\u0005\u0007\u0003\u000f9\b\u0019\u0001\u0010\u0002\u0013%tG/\u001a:dKB$\bf\u0001\u0001j_\u001e9\u0011Q\u0002\u0002\t\u0002\u0005=\u0011A\u0006*jI\u001e,'+Z4sKN\u001c\u0018n\u001c8XSRD7k\u0012#\u0011\u0007=\t\tB\u0002\u0004\u0002\u0005!\u0005\u00111C\n\u0006\u0003#\t)\"\u0006\t\u0004-\u0005]\u0011bAA\r/\t1\u0011I\\=SK\u001aDq\u0001SA\t\t\u0003\ti\u0002\u0006\u0002\u0002\u0010!A\u0011\u0011EA\t\t\u0003\t\u0019#A\u0003ue\u0006Lg\u000eF\u0007\u0013\u0003K\tY$!\u0010\u0002@\u0005\u0005\u00131\t\u0005\t\u0003O\ty\u00021\u0001\u0002*\u0005)\u0011N\u001c9viB1\u00111FA\u0019\u0003ki!!!\f\u000b\u0007\u0005=b!A\u0002sI\u0012LA!a\r\u0002.\t\u0019!\u000b\u0012#\u0011\u0007=\t9$C\u0002\u0002:\t\u0011A\u0002T1cK2,G\rU8j]RDa\u0001LA\u0010\u0001\u0004q\u0003B\u0002\u000f\u0002 \u0001\u0007a\u0004\u0003\u00049\u0003?\u0001\rA\b\u0005\u0007\u0001\u0006}\u0001\u0019\u0001\u0010\t\u000f\u0005\u0015\u0013q\u0004a\u0001y\u0006q\u0011N\\5uS\u0006dw+Z5hQR\u001c\b&BA\u0010S\u0006%\u0013EAA&\u0003\u0015\td\u0006\r\u00181\u0011!\t\t#!\u0005\u0005\u0002\u0005=Cc\u0003\n\u0002R\u0005M\u0013QKA,\u00033B\u0001\"a\n\u0002N\u0001\u0007\u0011\u0011\u0006\u0005\u0007Y\u00055\u0003\u0019\u0001\u0018\t\rq\ti\u00051\u0001\u001f\u0011\u0019A\u0014Q\na\u0001=!1\u0001)!\u0014A\u0002yAC!!\u0014j_\"A\u0011\u0011EA\t\t\u0003\ty\u0006F\u0005\u0013\u0003C\n\u0019'!\u001a\u0002h!A\u0011qEA/\u0001\u0004\tI\u0003\u0003\u0004-\u0003;\u0002\rA\f\u0005\u00079\u0005u\u0003\u0019\u0001\u0010\t\ra\ni\u00061\u0001\u001fQ\u0011\ti&[8\t\u0011\u0005\u0005\u0012\u0011\u0003C\u0001\u0003[\"RAEA8\u0003cB\u0001\"a\n\u0002l\u0001\u0007\u0011\u0011\u0006\u0005\u0007Y\u0005-\u0004\u0019\u0001\u0018)\t\u0005-\u0014n\u001c\u0005\u000b\u0003o\n\t\"!A\u0005\n\u0005e\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\u001f\u0011\t\u0005u\u0014qQ\u0007\u0003\u0003\u007fRA!!!\u0002\u0004\u0006!A.\u00198h\u0015\t\t))\u0001\u0003kCZ\f\u0017\u0002BAE\u0003\u007f\u0012aa\u00142kK\u000e$\b\u0006BA\tS>DC!a\u0003j_\u0002")
public class RidgeRegressionWithSGD
extends GeneralizedLinearAlgorithm<RidgeRegressionModel> {
    private double stepSize;
    private int numIterations;
    private double regParam;
    private double miniBatchFraction;
    private final LeastSquaresGradient gradient;
    private final SquaredL2Updater updater;
    private final GradientDescent optimizer;

    public static RidgeRegressionModel train(RDD<LabeledPoint> rDD, int n) {
        return RidgeRegressionWithSGD$.MODULE$.train(rDD, n);
    }

    public static RidgeRegressionModel train(RDD<LabeledPoint> rDD, int n, double d, double d2) {
        return RidgeRegressionWithSGD$.MODULE$.train(rDD, n, d, d2);
    }

    public static RidgeRegressionModel train(RDD<LabeledPoint> rDD, int n, double d, double d2, double d3) {
        return RidgeRegressionWithSGD$.MODULE$.train(rDD, n, d, d2, d3);
    }

    public static RidgeRegressionModel train(RDD<LabeledPoint> rDD, int n, double d, double d2, double d3, Vector vector) {
        return RidgeRegressionWithSGD$.MODULE$.train(rDD, n, d, d2, d3, vector);
    }

    private double stepSize() {
        return this.stepSize;
    }

    private void stepSize_$eq(double x$1) {
        this.stepSize = x$1;
    }

    private int numIterations() {
        return this.numIterations;
    }

    private void numIterations_$eq(int x$1) {
        this.numIterations = x$1;
    }

    private double regParam() {
        return this.regParam;
    }

    private void regParam_$eq(double x$1) {
        this.regParam = x$1;
    }

    private double miniBatchFraction() {
        return this.miniBatchFraction;
    }

    private void miniBatchFraction_$eq(double x$1) {
        this.miniBatchFraction = x$1;
    }

    private LeastSquaresGradient gradient() {
        return this.gradient;
    }

    private SquaredL2Updater updater() {
        return this.updater;
    }

    @Override
    public GradientDescent optimizer() {
        return this.optimizer;
    }

    @Override
    public RidgeRegressionModel createModel(Vector weights2, double intercept2) {
        return new RidgeRegressionModel(weights2, intercept2);
    }

    public RidgeRegressionWithSGD(double stepSize, int numIterations, double regParam, double miniBatchFraction) {
        this.stepSize = stepSize;
        this.numIterations = numIterations;
        this.regParam = regParam;
        this.miniBatchFraction = miniBatchFraction;
        this.gradient = new LeastSquaresGradient();
        this.updater = new SquaredL2Updater();
        this.optimizer = new GradientDescent(this.gradient(), this.updater()).setStepSize(this.stepSize()).setNumIterations(this.numIterations()).setRegParam(this.regParam()).setMiniBatchFraction(this.miniBatchFraction());
    }

    public RidgeRegressionWithSGD() {
        this(1.0, 100, 0.01, 1.0);
    }
}

