/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.mllib.clustering.KMeans$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.Vector;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=b!B\u0001\u0003\u0001\ta!AE\"mkN$XM]5oOR\u0013X-\u001a(pI\u0016T!a\u0001\u0003\u0002\u0015\rdWo\u001d;fe&twM\u0003\u0002\u0006\r\u0005)Q\u000e\u001c7jE*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bM\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\b\u0015\u0013\t)rB\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u0018\u0001\t\u0015\r\u0011\"\u0001\u001a\u0003\u0015Ig\u000eZ3y\u0007\u0001)\u0012A\u0007\t\u0003\u001dmI!\u0001H\b\u0003\u0007%sG\u000f\u0003\u0005\u001f\u0001\t\u0005\t\u0015!\u0003\u001b\u0003\u0019Ig\u000eZ3yA!A\u0001\u0005\u0001BC\u0002\u0013\u0005\u0011%\u0001\u0003tSj,W#\u0001\u0012\u0011\u00059\u0019\u0013B\u0001\u0013\u0010\u0005\u0011auN\\4\t\u0011\u0019\u0002!\u0011!Q\u0001\n\t\nQa]5{K\u0002B\u0011\u0002\u000b\u0001\u0003\u0006\u0004%\tAA\u0015\u0002\u001d\r,g\u000e^3s/&$\bNT8s[V\t!\u0006\u0005\u0002,Y5\t!!\u0003\u0002.\u0005\tqa+Z2u_J<\u0016\u000e\u001e5O_Jl\u0007\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\u0002\u001f\r,g\u000e^3s/&$\bNT8s[\u0002B\u0001\"\r\u0001\u0003\u0006\u0004%\tAM\u0001\u0005G>\u001cH/F\u00014!\tqA'\u0003\u00026\u001f\t1Ai\\;cY\u0016D\u0001b\u000e\u0001\u0003\u0002\u0003\u0006IaM\u0001\u0006G>\u001cH\u000f\t\u0005\ts\u0001\u0011)\u0019!C\u0001e\u00051\u0001.Z5hQRD\u0001b\u000f\u0001\u0003\u0002\u0003\u0006IaM\u0001\bQ\u0016Lw\r\u001b;!\u0011!i\u0004A!b\u0001\n\u0003q\u0014\u0001C2iS2$'/\u001a8\u0016\u0003}\u00022A\u0004!C\u0013\t\tuBA\u0003BeJ\f\u0017\u0010\u0005\u0002,\u0001!AA\t\u0001B\u0001B\u0003%q(A\u0005dQ&dGM]3oA!1a\t\u0001C\u0001\u0005\u001d\u000ba\u0001P5oSRtDc\u0002\"I\u0013*[E*\u0014\u0005\u0006/\u0015\u0003\rA\u0007\u0005\u0006A\u0015\u0003\rA\t\u0005\u0006Q\u0015\u0003\rA\u000b\u0005\u0006c\u0015\u0003\ra\r\u0005\u0006s\u0015\u0003\ra\r\u0005\u0006{\u0015\u0003\ra\u0010\u0005\b\u001f\u0002\u0011\r\u0011\"\u0001Q\u0003\u0019I7\u000fT3bMV\t\u0011\u000b\u0005\u0002\u000f%&\u00111k\u0004\u0002\b\u0005>|G.Z1o\u0011\u0019)\u0006\u0001)A\u0005#\u00069\u0011n\u001d'fC\u001a\u0004\u0003\"B,\u0001\t\u0003A\u0016AB2f]R,'/F\u0001Z!\tQV,D\u0001\\\u0015\taF!\u0001\u0004mS:\fGnZ\u0005\u0003=n\u0013aAV3di>\u0014\b\"\u00021\u0001\t\u0003\t\u0017a\u00029sK\u0012L7\r\u001e\u000b\u00035\tDQaY0A\u0002e\u000bQ\u0001]8j]RDQ!\u001a\u0001\u0005\u0002\u0019\f1\u0002\u001d:fI&\u001cG\u000fU1uQR\u0011qh\u001a\u0005\u0006G\u0012\u0004\r!\u0017\u0005\u0006K\u0002!I!\u001b\u000b\u0003UZ\u00042a[:C\u001d\ta\u0017O\u0004\u0002na6\taN\u0003\u0002p1\u00051AH]8pizJ\u0011\u0001E\u0005\u0003e>\tq\u0001]1dW\u0006<W-\u0003\u0002uk\n!A*[:u\u0015\t\u0011x\u0002C\u0003xQ\u0002\u0007!&A\u0007q_&tGoV5uQ:{'/\u001c\u0005\u0006s\u0002!\tA_\u0001\fG>l\u0007/\u001e;f\u0007>\u001cH\u000f\u0006\u00024w\")1\r\u001fa\u00013\")\u0001\r\u0001C\u0005{R\u0019a0a\u0001\u0011\t9y(dM\u0005\u0004\u0003\u0003y!A\u0002+va2,'\u0007C\u0003xy\u0002\u0007!\u0006\u0003\u0004a\u0001\u0011%\u0011q\u0001\u000b\u0006}\u0006%\u00111\u0002\u0005\u0007o\u0006\u0015\u0001\u0019\u0001\u0016\t\rE\n)\u00011\u00014Q\u0011\t)!a\u0004\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006\u0010\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00033\t\u0019BA\u0004uC&d'/Z2\t\r\u0005u\u0001\u0001\"\u0001?\u0003%aW-\u00194O_\u0012,7\u000fK\u0003\u0001\u0003C\tY\u0003\u0005\u0003\u0002$\u0005\u001dRBAA\u0013\u0015\r\t)BB\u0005\u0005\u0003S\t)CA\u0003TS:\u001cW-\t\u0002\u0002.\u0005)\u0011G\f\u001c/a\u0001")
public class ClusteringTreeNode
implements Serializable {
    private final int index;
    private final long size;
    private final VectorWithNorm centerWithNorm;
    private final double cost;
    private final double height;
    private final ClusteringTreeNode[] children;
    private final boolean isLeaf;

    public int index() {
        return this.index;
    }

    public long size() {
        return this.size;
    }

    public VectorWithNorm centerWithNorm() {
        return this.centerWithNorm;
    }

    public double cost() {
        return this.cost;
    }

    public double height() {
        return this.height;
    }

    public ClusteringTreeNode[] children() {
        return this.children;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public Vector center() {
        return this.centerWithNorm().vector();
    }

    public int predict(Vector point) {
        Tuple2<Object, Object> tuple2 = this.predict(new VectorWithNorm(point));
        if (tuple2 != null) {
            int index2;
            int n;
            int index3 = n = (index2 = tuple2._1$mcI$sp());
            return index3;
        }
        throw new MatchError(tuple2);
    }

    public ClusteringTreeNode[] predictPath(Vector point) {
        return (ClusteringTreeNode[])this.predictPath(new VectorWithNorm(point)).toArray(ClassTag$.MODULE$.apply(ClusteringTreeNode.class));
    }

    private List<ClusteringTreeNode> predictPath(VectorWithNorm pointWithNorm) {
        List list;
        if (this.isLeaf()) {
            ClusteringTreeNode clusteringTreeNode = this;
            list = Nil$.MODULE$.$colon$colon((Object)clusteringTreeNode);
        } else {
            ClusteringTreeNode selected;
            ClusteringTreeNode clusteringTreeNode = selected = (ClusteringTreeNode)Predef$.MODULE$.refArrayOps((Object[])this.children()).minBy((Function1)new Serializable(this, pointWithNorm){
                public static final long serialVersionUID = 0L;
                private final VectorWithNorm pointWithNorm$2;

                public final double apply(ClusteringTreeNode child) {
                    return KMeans$.MODULE$.fastSquaredDistance(child.centerWithNorm(), this.pointWithNorm$2);
                }
                {
                    this.pointWithNorm$2 = pointWithNorm$2;
                }
            }, (Ordering)Ordering.Double$.MODULE$);
            list = selected.predictPath(pointWithNorm).$colon$colon((Object)clusteringTreeNode);
        }
        return list;
    }

    public double computeCost(Vector point) {
        Tuple2<Object, Object> tuple2 = this.predict(new VectorWithNorm(point));
        if (tuple2 != null) {
            double cost;
            double d;
            double cost2 = d = (cost = tuple2._2$mcD$sp());
            return cost2;
        }
        throw new MatchError(tuple2);
    }

    private Tuple2<Object, Object> predict(VectorWithNorm pointWithNorm) {
        return this.predict(pointWithNorm, KMeans$.MODULE$.fastSquaredDistance(this.centerWithNorm(), pointWithNorm));
    }

    private Tuple2<Object, Object> predict(VectorWithNorm pointWithNorm, double cost) {
        Tuple2 tuple2;
        while (true) {
            double minCost;
            Tuple2 tuple22;
            if (this_.isLeaf()) {
                return new Tuple2.mcID.sp(this_.index(), cost);
            }
            tuple2 = (Tuple2)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this_.children()).map((Function1)new Serializable(this_, pointWithNorm){
                public static final long serialVersionUID = 0L;
                private final VectorWithNorm pointWithNorm$1;

                public final Tuple2<ClusteringTreeNode, Object> apply(ClusteringTreeNode child) {
                    return new Tuple2((Object)child, (Object)BoxesRunTime.boxToDouble((double)KMeans$.MODULE$.fastSquaredDistance(child.centerWithNorm(), this.pointWithNorm$1)));
                }
                {
                    this.pointWithNorm$1 = pointWithNorm$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).minBy((Function1)new Serializable(this_){
                public static final long serialVersionUID = 0L;

                public final double apply(Tuple2<ClusteringTreeNode, Object> x$7) {
                    return x$7._2$mcD$sp();
                }
            }, (Ordering)Ordering.Double$.MODULE$);
            if (tuple2 == null) break;
            ClusteringTreeNode selectedChild = (ClusteringTreeNode)tuple2._1();
            double minCost2 = tuple2._2$mcD$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)selectedChild, (Object)BoxesRunTime.boxToDouble((double)minCost2));
            ClusteringTreeNode selectedChild2 = (ClusteringTreeNode)tuple23._1();
            cost = minCost = tuple23._2$mcD$sp();
            ClusteringTreeNode this_ = selectedChild2;
        }
        throw new MatchError((Object)tuple2);
    }

    public ClusteringTreeNode[] leafNodes() {
        return this.isLeaf() ? (ClusteringTreeNode[])((Object[])new ClusteringTreeNode[]{this}) : (ClusteringTreeNode[])Predef$.MODULE$.refArrayOps((Object[])this.children()).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<ClusteringTreeNode> apply(ClusteringTreeNode x$9) {
                return Predef$.MODULE$.refArrayOps((Object[])x$9.leafNodes());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ClusteringTreeNode.class)));
    }

    public ClusteringTreeNode(int index2, long size, VectorWithNorm centerWithNorm, double cost, double height, ClusteringTreeNode[] children) {
        this.index = index2;
        this.size = size;
        this.centerWithNorm = centerWithNorm;
        this.cost = cost;
        this.height = height;
        this.children = children;
        this.isLeaf = Predef$.MODULE$.refArrayOps((Object[])children).isEmpty();
        Predef$.MODULE$.require(this.isLeaf() && index2 >= 0 || !this.isLeaf() && index2 < 0);
    }
}

