/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.util.Properties;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.Logging;
import org.apache.spark.Partition;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.DataFrame$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.PartitionSpec;
import org.apache.spark.sql.execution.datasources.ResolvedDataSource;
import org.apache.spark.sql.execution.datasources.ResolvedDataSource$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartition;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartitioningInfo;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation$;
import org.apache.spark.sql.execution.datasources.json.JSONRelation;
import org.apache.spark.sql.execution.datasources.json.JSONRelation$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRelation;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005mg\u0001B\u0001\u0003\u0001-\u0011q\u0002R1uC\u001a\u0013\u0018-\\3SK\u0006$WM\u001d\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7\u0001A\n\u0004\u00011\u0011\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014)5\tA!\u0003\u0002\u0016\t\t9Aj\\4hS:<\u0007\u0002C\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002\u0015M\fHnQ8oi\u0016DH\u000f\u0005\u0002\u001a55\t!!\u0003\u0002\u001c\u0005\tQ1+\u0015'D_:$X\r\u001f;\t\ru\u0001A\u0011\u0001\u0002\u001f\u0003\u0019a\u0014N\\5u}Q\u0011q\u0004\t\t\u00033\u0001AQa\u0006\u000fA\u0002aAQA\t\u0001\u0005\u0002\r\naAZ8s[\u0006$HCA\u0010%\u0011\u0015)\u0013\u00051\u0001'\u0003\u0019\u0019x.\u001e:dKB\u0011qE\u000b\b\u0003\u001b!J!!\u000b\b\u0002\rA\u0013X\rZ3g\u0013\tYCF\u0001\u0004TiJLgn\u001a\u0006\u0003S9AQA\f\u0001\u0005\u0002=\naa]2iK6\fGCA\u00101\u0011\u0015qS\u00061\u00012!\t\u0011T'D\u00014\u0015\t!$!A\u0003usB,7/\u0003\u00027g\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000ba\u0002A\u0011A\u001d\u0002\r=\u0004H/[8o)\ry\"\b\u0010\u0005\u0006w]\u0002\rAJ\u0001\u0004W\u0016L\b\"B\u001f8\u0001\u00041\u0013!\u0002<bYV,\u0007\"B \u0001\t\u0003\u0001\u0015aB8qi&|gn\u001d\u000b\u0003?\u0005CQa\u0010 A\u0002\t\u0003Ba\u0011$'M5\tAI\u0003\u0002F\u001d\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u001d#%aA'ba\")q\b\u0001C\u0001\u0013R\u0011qD\u0013\u0005\u0006\u007f!\u0003\ra\u0013\t\u0005\u0019F3c%D\u0001N\u0015\tqu*\u0001\u0003vi&d'\"\u0001)\u0002\t)\fg/Y\u0005\u0003\u000f6CQa\u0015\u0001\u0005\u0002Q\u000bA\u0001\\8bIR\u0011Q\u000b\u0017\t\u00033YK!a\u0016\u0002\u0003\u0013\u0011\u000bG/\u0019$sC6,\u0007\"B-S\u0001\u00041\u0013\u0001\u00029bi\"DQa\u0015\u0001\u0005\u0002m#\u0012!\u0016\u0005\u0006;\u0002!\tAX\u0001\u0005U\u0012\u00147\r\u0006\u0003V?\u0006\u001c\u0007\"\u00021]\u0001\u00041\u0013aA;sY\")!\r\u0018a\u0001M\u0005)A/\u00192mK\")A\r\u0018a\u0001K\u0006Q\u0001O]8qKJ$\u0018.Z:\u0011\u000513\u0017BA4N\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\u0006;\u0002!\t!\u001b\u000b\t+*\\GN\\:vu\")\u0001\r\u001ba\u0001M!)!\r\u001ba\u0001M!)Q\u000e\u001ba\u0001M\u0005Q1m\u001c7v[:t\u0015-\\3\t\u000b=D\u0007\u0019\u00019\u0002\u00151|w/\u001a:C_VtG\r\u0005\u0002\u000ec&\u0011!O\u0004\u0002\u0005\u0019>tw\rC\u0003uQ\u0002\u0007\u0001/\u0001\u0006vaB,'OQ8v]\u0012DQA\u001e5A\u0002]\fQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\bCA\u0007y\u0013\tIhBA\u0002J]RDQa\u001f5A\u0002\u0015\fAcY8o]\u0016\u001cG/[8o!J|\u0007/\u001a:uS\u0016\u001c\b\"B/\u0001\t\u0003iHcB+\u007f\u007f\u0006\u0005\u00111\u0002\u0005\u0006Ar\u0004\rA\n\u0005\u0006Er\u0004\rA\n\u0005\b\u0003\u0007a\b\u0019AA\u0003\u0003)\u0001(/\u001a3jG\u0006$Xm\u001d\t\u0005\u001b\u0005\u001da%C\u0002\u0002\n9\u0011Q!\u0011:sCfDQa\u001f?A\u0002\u0015Da!\u0018\u0001\u0005\n\u0005=A#C+\u0002\u0012\u0005M\u0011QCA\u0011\u0011\u0019\u0001\u0017Q\u0002a\u0001M!1!-!\u0004A\u0002\u0019B\u0001\"a\u0006\u0002\u000e\u0001\u0007\u0011\u0011D\u0001\u0006a\u0006\u0014Ho\u001d\t\u0006\u001b\u0005\u001d\u00111\u0004\t\u0004'\u0005u\u0011bAA\u0010\t\tI\u0001+\u0019:uSRLwN\u001c\u0005\u0007w\u00065\u0001\u0019A3\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(\u0005!!n]8o)\r)\u0016\u0011\u0006\u0005\u00073\u0006\r\u0002\u0019\u0001\u0014\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002.Q\u0019Q+a\f\t\u0011\u0005E\u00121\u0006a\u0001\u0003g\tqA[:p]J#E\tE\u0003\u00026\u0005ub%\u0004\u0002\u00028)\u0019\u0001+!\u000f\u000b\u0007\u0005mB!A\u0002ba&LA!a\u0010\u00028\t9!*\u0019<b%\u0012#\u0005bBA\u0013\u0001\u0011\u0005\u00111\t\u000b\u0004+\u0006\u0015\u0003\u0002CA\u0019\u0003\u0003\u0002\r!a\u0012\u0011\u000b\u0005%\u0013q\n\u0014\u000e\u0005\u0005-#bAA'\t\u0005\u0019!\u000f\u001a3\n\t\u0005E\u00131\n\u0002\u0004%\u0012#\u0005bBA+\u0001\u0011\u0005\u0011qK\u0001\ba\u0006\u0014\u0018/^3u)\r)\u0016\u0011\f\u0005\t\u00037\n\u0019\u00061\u0001\u0002^\u0005)\u0001/\u0019;igB!Q\"a\u0018'\u0013\r\t\tG\u0004\u0002\u000byI,\u0007/Z1uK\u0012t\u0004\u0006BA*\u0003K\u0002B!a\u001a\u0002n5\u0011\u0011\u0011\u000e\u0006\u0004\u0003Wr\u0011AC1o]>$\u0018\r^5p]&!\u0011qNA5\u0005\u001d1\u0018M]1sONDq!a\u001d\u0001\t\u0003\t)(A\u0002pe\u000e$2!VA<\u0011\u0019I\u0016\u0011\u000fa\u0001M!1!\r\u0001C\u0001\u0003w\"2!VA?\u0011\u001d\ty(!\u001fA\u0002\u0019\n\u0011\u0002^1cY\u0016t\u0015-\\3\t\u0011\u0015\u0002\u0001\u0019!C\u0005\u0003\u0007+\u0012A\n\u0005\n\u0003\u000f\u0003\u0001\u0019!C\u0005\u0003\u0013\u000b!b]8ve\u000e,w\fJ3r)\u0011\tY)!%\u0011\u00075\ti)C\u0002\u0002\u0010:\u0011A!\u00168ji\"I\u00111SAC\u0003\u0003\u0005\rAJ\u0001\u0004q\u0012\n\u0004bBAL\u0001\u0001\u0006KAJ\u0001\bg>,(oY3!\u0011%\tY\n\u0001a\u0001\n\u0013\ti*A\nvg\u0016\u00148\u000b]3dS\u001aLW\rZ*dQ\u0016l\u0017-\u0006\u0002\u0002 B!Q\"!)2\u0013\r\t\u0019K\u0004\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005\u001d\u0006\u00011A\u0005\n\u0005%\u0016aF;tKJ\u001c\u0006/Z2jM&,GmU2iK6\fw\fJ3r)\u0011\tY)a+\t\u0015\u0005M\u0015QUA\u0001\u0002\u0004\ty\n\u0003\u0005\u00020\u0002\u0001\u000b\u0015BAP\u0003Q)8/\u001a:Ta\u0016\u001c\u0017NZ5fIN\u001b\u0007.Z7bA!I\u00111\u0017\u0001A\u0002\u0013%\u0011QW\u0001\rKb$(/Y(qi&|gn]\u000b\u0003\u0003o\u0003b!!/\u0002@\u001a2SBAA^\u0015\r\ti\fR\u0001\b[V$\u0018M\u00197f\u0013\u0011\t\t-a/\u0003\u000f!\u000b7\u000f['ba\"I\u0011Q\u0019\u0001A\u0002\u0013%\u0011qY\u0001\u0011Kb$(/Y(qi&|gn]0%KF$B!a#\u0002J\"Q\u00111SAb\u0003\u0003\u0005\r!a.\t\u0011\u00055\u0007\u0001)Q\u0005\u0003o\u000bQ\"\u001a=ue\u0006|\u0005\u000f^5p]N\u0004\u0003f\u0001\u0001\u0002RB!\u00111[Al\u001b\t\t)NC\u0002\u0002l\u0011IA!!7\u0002V\naQ\t\u001f9fe&lWM\u001c;bY\u0002")
public class DataFrameReader
implements Logging {
    public final SQLContext org$apache$spark$sql$DataFrameReader$$sqlContext;
    private String source;
    private Option<StructType> userSpecifiedSchema;
    private HashMap<String, String> extraOptions;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public DataFrame parquet(String ... paths) {
        return this.parquet((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public DataFrameReader format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameReader schema(StructType schema2) {
        this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)schema2));
        return this;
    }

    public DataFrameReader option(String key, String value) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)key), (Object)value));
        return this;
    }

    public DataFrameReader options(Map<String, String> options2) {
        this.extraOptions().$plus$plus$eq(options2);
        return this;
    }

    public DataFrameReader options(java.util.Map<String, String> options2) {
        this.options((Map<String, String>)JavaConversions$.MODULE$.mapAsScalaMap(options2));
        return this;
    }

    public DataFrame load(String path) {
        return this.option("path", path).load();
    }

    public DataFrame load() {
        ResolvedDataSource resolved = ResolvedDataSource$.MODULE$.apply(this.org$apache$spark$sql$DataFrameReader$$sqlContext, this.userSpecifiedSchema(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), this.source(), (scala.collection.immutable.Map<String, String>)this.extraOptions().toMap(Predef$.MODULE$.conforms()));
        return DataFrame$.MODULE$.apply(this.org$apache$spark$sql$DataFrameReader$$sqlContext, (LogicalPlan)new LogicalRelation(resolved.relation()));
    }

    public DataFrame jdbc(String url, String table, Properties properties) {
        return this.jdbc(url, table, JDBCRelation$.MODULE$.columnPartition(null), properties);
    }

    public DataFrame jdbc(String url, String table, String columnName, long lowerBound, long upperBound, int numPartitions, Properties connectionProperties) {
        JDBCPartitioningInfo partitioning = new JDBCPartitioningInfo(columnName, lowerBound, upperBound, numPartitions);
        Partition[] parts = JDBCRelation$.MODULE$.columnPartition(partitioning);
        return this.jdbc(url, table, parts, connectionProperties);
    }

    public DataFrame jdbc(String url, String table, String[] predicates, Properties connectionProperties) {
        Partition[] parts = (Partition[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])predicates).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Partition apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String part = (String)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    JDBCPartition jDBCPartition = new JDBCPartition(part, i);
                    return jDBCPartition;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Partition.class)));
        return this.jdbc(url, table, parts, connectionProperties);
    }

    private DataFrame jdbc(String url, String table, Partition[] parts, Properties connectionProperties) {
        Properties props = new Properties();
        this.extraOptions().foreach((Function1)new Serializable(this, props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(Tuple2<String, String> x0$2) {
                Tuple2<String, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    Object object = this.props$1.put(key, value);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.props$1 = props$1;
            }
        });
        props.putAll((java.util.Map<?, ?>)connectionProperties);
        JDBCRelation relation = new JDBCRelation(url, table, parts, props, this.org$apache$spark$sql$DataFrameReader$$sqlContext);
        return this.org$apache$spark$sql$DataFrameReader$$sqlContext.baseRelationToDataFrame(relation);
    }

    public DataFrame json(String path) {
        return this.format("json").load(path);
    }

    public DataFrame json(JavaRDD<String> jsonRDD) {
        return this.json((RDD<String>)jsonRDD.rdd());
    }

    public DataFrame json(RDD<String> jsonRDD) {
        double samplingRatio = new StringOps(Predef$.MODULE$.augmentString((String)this.extraOptions().getOrElse((Object)"samplingRatio", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "1.0";
            }
        }))).toDouble();
        return this.org$apache$spark$sql$DataFrameReader$$sqlContext.baseRelationToDataFrame(new JSONRelation((Option<RDD<String>>)new Some(jsonRDD), samplingRatio, this.userSpecifiedSchema(), (Option<PartitionSpec>)None$.MODULE$, (Option<StructType>)None$.MODULE$, JSONRelation$.MODULE$.$lessinit$greater$default$6(), this.org$apache$spark$sql$DataFrameReader$$sqlContext));
    }

    public DataFrame parquet(Seq<String> paths) {
        DataFrame dataFrame;
        if (paths.isEmpty()) {
            dataFrame = this.org$apache$spark$sql$DataFrameReader$$sqlContext.emptyDataFrame();
        } else {
            Path[] globbedPaths = (Path[])((TraversableOnce)paths.flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DataFrameReader $outer;

                public final Seq<Path> apply(String path) {
                    Path hdfsPath = new Path(path);
                    FileSystem fs = hdfsPath.getFileSystem(this.$outer.org$apache$spark$sql$DataFrameReader$$sqlContext.sparkContext().hadoopConfiguration());
                    Path qualified = hdfsPath.makeQualified(fs.getUri(), fs.getWorkingDirectory());
                    return SparkHadoopUtil$.MODULE$.get().globPathIfNecessary(qualified);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Path.class));
            dataFrame = this.org$apache$spark$sql$DataFrameReader$$sqlContext.baseRelationToDataFrame(new ParquetRelation((String[])Predef$.MODULE$.refArrayOps((Object[])globbedPaths).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Path x$1) {
                    return x$1.toString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), this.userSpecifiedSchema(), (Option<PartitionSpec>)None$.MODULE$, (scala.collection.immutable.Map<String, String>)this.extraOptions().toMap(Predef$.MODULE$.conforms()), this.org$apache$spark$sql$DataFrameReader$$sqlContext));
        }
        return dataFrame;
    }

    public DataFrame orc(String path) {
        return this.format("orc").load(path);
    }

    public DataFrame table(String tableName) {
        return DataFrame$.MODULE$.apply(this.org$apache$spark$sql$DataFrameReader$$sqlContext, this.org$apache$spark$sql$DataFrameReader$$sqlContext.catalog().lookupRelation((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName})), this.org$apache$spark$sql$DataFrameReader$$sqlContext.catalog().lookupRelation$default$2()));
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private Option<StructType> userSpecifiedSchema() {
        return this.userSpecifiedSchema;
    }

    private void userSpecifiedSchema_$eq(Option<StructType> x$1) {
        this.userSpecifiedSchema = x$1;
    }

    private HashMap<String, String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(HashMap<String, String> x$1) {
        this.extraOptions = x$1;
    }

    public DataFrameReader(SQLContext sqlContext) {
        this.org$apache$spark$sql$DataFrameReader$$sqlContext = sqlContext;
        Logging.class.$init$((Logging)this);
        this.source = sqlContext.conf().defaultDataSourceName();
        this.userSpecifiedSchema = None$.MODULE$;
        this.extraOptions = new HashMap();
    }
}

