/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.sql.Connection;
import java.util.Properties;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.SqlParser$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.CreateTableUsingAsSelect;
import org.apache.spark.sql.execution.datasources.ResolvedDataSource$;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001B\u0001\u0003\u0005-\u0011q\u0002R1uC\u001a\u0013\u0018-\\3Xe&$XM\u001d\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7\u0001A\n\u0003\u00011\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\u0002C\n\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000b\u0002\u0005\u00114\u0007CA\u000b\u0017\u001b\u0005\u0011\u0011BA\f\u0003\u0005%!\u0015\r^1Ge\u0006lW\r\u0003\u0004\u001a\u0001\u0011\u0005!AG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005ma\u0002CA\u000b\u0001\u0011\u0015\u0019\u0002\u00041\u0001\u0015\u0011\u0015q\u0002\u0001\"\u0001 \u0003\u0011iw\u000eZ3\u0015\u0005m\u0001\u0003\"B\u0011\u001e\u0001\u0004\u0011\u0013\u0001C:bm\u0016lu\u000eZ3\u0011\u0005U\u0019\u0013B\u0001\u0013\u0003\u0005!\u0019\u0016M^3N_\u0012,\u0007\"\u0002\u0010\u0001\t\u00031CCA\u000e(\u0011\u0015\tS\u00051\u0001)!\tICF\u0004\u0002\u000eU%\u00111FD\u0001\u0007!J,G-\u001a4\n\u00055r#AB*ue&twM\u0003\u0002,\u001d!)\u0001\u0007\u0001C\u0001c\u00051am\u001c:nCR$\"a\u0007\u001a\t\u000bMz\u0003\u0019\u0001\u0015\u0002\rM|WO]2f\u0011\u0015)\u0004\u0001\"\u00017\u0003\u0019y\u0007\u000f^5p]R\u00191dN\u001d\t\u000ba\"\u0004\u0019\u0001\u0015\u0002\u0007-,\u0017\u0010C\u0003;i\u0001\u0007\u0001&A\u0003wC2,X\rC\u0003=\u0001\u0011\u0005Q(A\u0004paRLwN\\:\u0015\u0005mq\u0004\"\u0002\u001f<\u0001\u0004y\u0004\u0003\u0002!DQ!j\u0011!\u0011\u0006\u0003\u0005:\t!bY8mY\u0016\u001cG/[8o\u0013\t!\u0015IA\u0002NCBDQ\u0001\u0010\u0001\u0005\u0002\u0019#\"aG$\t\u000bq*\u0005\u0019\u0001%\u0011\t%s\u0005\u0006K\u0007\u0002\u0015*\u00111\nT\u0001\u0005kRLGNC\u0001N\u0003\u0011Q\u0017M^1\n\u0005\u0011S\u0005\"\u0002)\u0001\t\u0003\t\u0016a\u00039beRLG/[8o\u0005f$\"a\u0007*\t\u000bM{\u0005\u0019\u0001+\u0002\u0011\r|GNT1nKN\u00042!D+)\u0013\t1fB\u0001\u0006=e\u0016\u0004X-\u0019;fIzB#a\u0014-\u0011\u0005ecV\"\u0001.\u000b\u0005ms\u0011AC1o]>$\u0018\r^5p]&\u0011QL\u0017\u0002\bm\u0006\u0014\u0018M]4t\u0011\u0015y\u0006\u0001\"\u0001a\u0003\u0011\u0019\u0018M^3\u0015\u0005\u0005$\u0007CA\u0007c\u0013\t\u0019gB\u0001\u0003V]&$\b\"B3_\u0001\u0004A\u0013\u0001\u00029bi\"DQa\u0018\u0001\u0005\u0002\u001d$\u0012!\u0019\u0005\u0006S\u0002!\tA[\u0001\u000bS:\u001cXM\u001d;J]R|GCA1l\u0011\u0015a\u0007\u000e1\u0001)\u0003%!\u0018M\u00197f\u001d\u0006lW\rC\u0003j\u0001\u0011%a\u000e\u0006\u0002b_\")\u0001/\u001ca\u0001c\u0006QA/\u00192mK&#WM\u001c;\u0011\u0005I,X\"A:\u000b\u0005Q\u0014\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005Y\u001c(a\u0004+bE2,\u0017\nZ3oi&4\u0017.\u001a:\t\u000ba\u0004A\u0011A=\u0002\u0017M\fg/Z!t)\u0006\u0014G.\u001a\u000b\u0003CjDQ\u0001\\<A\u0002!BQ\u0001\u001f\u0001\u0005\nq$\"!Y?\t\u000bA\\\b\u0019A9\t\r}\u0004A\u0011AA\u0001\u0003\u0011QGMY2\u0015\u000f\u0005\f\u0019!a\u0002\u0002\f!1\u0011Q\u0001@A\u0002!\n1!\u001e:m\u0011\u0019\tIA a\u0001Q\u0005)A/\u00192mK\"9\u0011Q\u0002@A\u0002\u0005=\u0011\u0001F2p]:,7\r^5p]B\u0013x\u000e]3si&,7\u000fE\u0002J\u0003#I1!a\u0005K\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\u0003/\u0001A\u0011AA\r\u0003\u0011Q7o\u001c8\u0015\u0007\u0005\fY\u0002\u0003\u0004f\u0003+\u0001\r\u0001\u000b\u0005\b\u0003?\u0001A\u0011AA\u0011\u0003\u001d\u0001\u0018M]9vKR$2!YA\u0012\u0011\u0019)\u0017Q\u0004a\u0001Q!9\u0011q\u0005\u0001\u0005\u0002\u0005%\u0012aA8sGR\u0019\u0011-a\u000b\t\r\u0015\f)\u00031\u0001)\u0011!\u0019\u0004\u00011A\u0005\n\u0005=R#\u0001\u0015\t\u0013\u0005M\u0002\u00011A\u0005\n\u0005U\u0012AC:pkJ\u001cWm\u0018\u0013fcR\u0019\u0011-a\u000e\t\u0013\u0005e\u0012\u0011GA\u0001\u0002\u0004A\u0013a\u0001=%c!9\u0011Q\b\u0001!B\u0013A\u0013aB:pkJ\u001cW\r\t\u0005\t=\u0001\u0001\r\u0011\"\u0003\u0002BU\t!\u0005C\u0005\u0002F\u0001\u0001\r\u0011\"\u0003\u0002H\u0005AQn\u001c3f?\u0012*\u0017\u000fF\u0002b\u0003\u0013B\u0011\"!\u000f\u0002D\u0005\u0005\t\u0019\u0001\u0012\t\u000f\u00055\u0003\u0001)Q\u0005E\u0005)Qn\u001c3fA!I\u0011\u0011\u000b\u0001A\u0002\u0013%\u00111K\u0001\rKb$(/Y(qi&|gn]\u000b\u0003\u0003+\u0002b!a\u0016\u0002^!BSBAA-\u0015\r\tY&Q\u0001\b[V$\u0018M\u00197f\u0013\u0011\ty&!\u0017\u0003\u000f!\u000b7\u000f['ba\"I\u00111\r\u0001A\u0002\u0013%\u0011QM\u0001\u0011Kb$(/Y(qi&|gn]0%KF$2!YA4\u0011)\tI$!\u0019\u0002\u0002\u0003\u0007\u0011Q\u000b\u0005\t\u0003W\u0002\u0001\u0015)\u0003\u0002V\u0005iQ\r\u001f;sC>\u0003H/[8og\u0002B\u0011\"a\u001c\u0001\u0001\u0004%I!!\u001d\u0002'A\f'\u000f^5uS>t\u0017N\\4D_2,XN\\:\u0016\u0005\u0005M\u0004#B\u0007\u0002v\u0005e\u0014bAA<\u001d\t1q\n\u001d;j_:\u0004R!a\u001f\u0002\f\"rA!! \u0002\b:!\u0011qPAC\u001b\t\t\tIC\u0002\u0002\u0004*\ta\u0001\u0010:p_Rt\u0014\"A\b\n\u0007\u0005%e\"A\u0004qC\u000e\\\u0017mZ3\n\t\u00055\u0015q\u0012\u0002\u0004'\u0016\f(bAAE\u001d!I\u00111\u0013\u0001A\u0002\u0013%\u0011QS\u0001\u0018a\u0006\u0014H/\u001b;j_:LgnZ\"pYVlgn]0%KF$2!YAL\u0011)\tI$!%\u0002\u0002\u0003\u0007\u00111\u000f\u0005\t\u00037\u0003\u0001\u0015)\u0003\u0002t\u0005!\u0002/\u0019:uSRLwN\\5oO\u000e{G.^7og\u0002B3\u0001AAP!\u0011\t\t+!*\u000e\u0005\u0005\r&BA.\u0005\u0013\u0011\t9+a)\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197")
public final class DataFrameWriter {
    private final DataFrame df;
    private String source;
    private SaveMode mode;
    private HashMap<String, String> extraOptions;
    private Option<Seq<String>> partitioningColumns;

    public DataFrameWriter partitionBy(String ... colNames) {
        return this.partitionBy((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter mode(SaveMode saveMode) {
        this.mode_$eq(saveMode);
        return this;
    }

    public DataFrameWriter mode(String saveMode) {
        block9: {
            SaveMode saveMode2;
            block6: {
                boolean bl;
                String string;
                block8: {
                    block7: {
                        block5: {
                            String string2 = string = saveMode.toLowerCase();
                            if ("overwrite" != null ? !"overwrite".equals(string2) : string2 != null) break block5;
                            saveMode2 = SaveMode.Overwrite;
                            break block6;
                        }
                        String string3 = string;
                        if ("append" != null ? !"append".equals(string3) : string3 != null) break block7;
                        saveMode2 = SaveMode.Append;
                        break block6;
                    }
                    String string4 = string;
                    if ("ignore" != null ? !"ignore".equals(string4) : string4 != null) break block8;
                    saveMode2 = SaveMode.Ignore;
                    break block6;
                }
                String string5 = string;
                if (!("error" != null ? !"error".equals(string5) : string5 != null)) {
                    bl = true;
                } else {
                    String string6 = string;
                    bl = !("default" != null ? !"default".equals(string6) : string6 != null);
                }
                if (!bl) break block9;
                saveMode2 = SaveMode.ErrorIfExists;
            }
            this.mode_$eq(saveMode2);
            return this;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown save mode: ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{saveMode}))).append((Object)"Accepted modes are 'overwrite', 'append', 'ignore', 'error'.").toString());
    }

    public DataFrameWriter format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameWriter option(String key, String value) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)key), (Object)value));
        return this;
    }

    public DataFrameWriter options(Map<String, String> options2) {
        this.extraOptions().$plus$plus$eq(options2);
        return this;
    }

    public DataFrameWriter options(java.util.Map<String, String> options2) {
        this.options((Map<String, String>)JavaConversions$.MODULE$.mapAsScalaMap(options2));
        return this;
    }

    public DataFrameWriter partitionBy(Seq<String> colNames) {
        this.partitioningColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        return this;
    }

    public void save(String path) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"path"), (Object)path));
        this.save();
    }

    public void save() {
        ResolvedDataSource$.MODULE$.apply(this.df.sqlContext(), this.source(), (String[])this.partitioningColumns().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String[] apply(Seq<String> x$1) {
                return (String[])x$1.toArray(ClassTag$.MODULE$.apply(String.class));
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String[] apply() {
                return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
            }
        }), this.mode(), (scala.collection.immutable.Map<String, String>)this.extraOptions().toMap(Predef$.MODULE$.conforms()), this.df);
    }

    public void insertInto(String tableName) {
        this.insertInto(SqlParser$.MODULE$.parseTableIdentifier(tableName));
    }

    private void insertInto(TableIdentifier tableIdent) {
        Option partitions = this.partitioningColumns().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<String, Option<String>> apply(Seq<String> x$2) {
                return ((TraversableOnce)x$2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, Option<String>> apply(String col2) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)col2), (Object)None$.MODULE$);
                    }
                }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
            }
        });
        SaveMode saveMode = this.mode();
        SaveMode saveMode2 = SaveMode.Overwrite;
        boolean overwrite = !(saveMode != null ? !((Object)((Object)saveMode)).equals((Object)saveMode2) : saveMode2 != null);
        this.df.sqlContext().executePlan((LogicalPlan)new InsertIntoTable((LogicalPlan)new UnresolvedRelation(tableIdent.toSeq(), UnresolvedRelation$.MODULE$.apply$default$2()), (scala.collection.immutable.Map)partitions.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<String, Option<String>> apply() {
                return Predef$.MODULE$.Map().empty();
            }
        }), this.df.logicalPlan(), overwrite, false)).toRdd();
    }

    public void saveAsTable(String tableName) {
        this.saveAsTable(SqlParser$.MODULE$.parseTableIdentifier(tableName));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void saveAsTable(TableIdentifier tableIdent) {
        boolean tableExists2 = this.df.sqlContext().catalog().tableExists(tableIdent.toSeq());
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)tableExists2), (Object)this.mode());
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl) {
                SaveMode saveMode2 = SaveMode.Ignore;
                SaveMode saveMode3 = saveMode;
                if (!(saveMode2 != null ? !((Object)((Object)saveMode2)).equals((Object)saveMode3) : saveMode3 != null)) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl) {
                SaveMode saveMode4 = SaveMode.ErrorIfExists;
                SaveMode saveMode5 = saveMode;
                if (!(saveMode4 != null ? !((Object)((Object)saveMode4)).equals((Object)saveMode5) : saveMode5 != null)) {
                    throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableIdent})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3());
                }
            }
        }
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl) {
                SaveMode saveMode6 = SaveMode.Append;
                SaveMode saveMode7 = saveMode;
                if (!(saveMode6 != null ? !((Object)((Object)saveMode6)).equals((Object)saveMode7) : saveMode7 != null)) {
                    this.insertInto(tableIdent);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        CreateTableUsingAsSelect cmd = new CreateTableUsingAsSelect(tableIdent, this.source(), false, (String[])this.partitioningColumns().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String[] apply(Seq<String> x$3) {
                return (String[])x$3.toArray(ClassTag$.MODULE$.apply(String.class));
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String[] apply() {
                return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
            }
        }), this.mode(), (scala.collection.immutable.Map<String, String>)this.extraOptions().toMap(Predef$.MODULE$.conforms()), this.df.logicalPlan());
        this.df.sqlContext().executePlan((LogicalPlan)cmd).toRdd();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * WARNING - void declaration
     */
    public void jdbc(String url, String table, Properties connectionProperties) {
        Connection conn;
        Properties props;
        block7: {
            Object object;
            boolean tableExists2;
            block6: {
                props = new Properties();
                this.extraOptions().foreach((Function1)new Serializable(this, props){
                    public static final long serialVersionUID = 0L;
                    private final Properties props$1;

                    public final Object apply(Tuple2<String, String> x0$1) {
                        Tuple2<String, String> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String key = (String)tuple2._1();
                            String value = (String)tuple2._2();
                            Object object = this.props$1.put(key, value);
                            return object;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.props$1 = props$1;
                    }
                });
                props.putAll((java.util.Map<?, ?>)connectionProperties);
                conn = JdbcUtils$.MODULE$.createConnection(url, props);
                try {
                    tableExists2 = JdbcUtils$.MODULE$.tableExists(conn, table);
                    SaveMode saveMode = this.mode();
                    SaveMode saveMode2 = SaveMode.Ignore;
                    if ((saveMode != null ? !((Object)((Object)saveMode)).equals((Object)saveMode2) : saveMode2 != null) || !tableExists2) break block6;
                }
                catch (Throwable throwable) {
                    void var5_5;
                    var5_5.close();
                    throw throwable;
                }
                conn.close();
                return;
            }
            SaveMode saveMode = this.mode();
            SaveMode saveMode3 = SaveMode.ErrorIfExists;
            if (!(saveMode != null ? !((Object)((Object)saveMode)).equals((Object)saveMode3) : saveMode3 != null) && tableExists2) {
                throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table})));
            }
            SaveMode saveMode4 = this.mode();
            SaveMode saveMode5 = SaveMode.Overwrite;
            if (!(saveMode4 != null ? !((Object)((Object)saveMode4)).equals((Object)saveMode5) : saveMode5 != null) && tableExists2) {
                JdbcUtils$.MODULE$.dropTable(conn, table);
                tableExists2 = false;
            }
            if (tableExists2) {
                object = BoxedUnit.UNIT;
                break block7;
            }
            String schema2 = JdbcUtils$.MODULE$.schemaString(this.df, url);
            String sql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE ", " (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table, schema2}));
            object = BoxesRunTime.boxToInteger((int)conn.prepareStatement(sql).executeUpdate());
        }
        conn.close();
        JdbcUtils$.MODULE$.saveTable(this.df, url, table, props);
    }

    public void json(String path) {
        this.format("json").save(path);
    }

    public void parquet(String path) {
        this.format("parquet").save(path);
    }

    public void orc(String path) {
        this.format("orc").save(path);
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private SaveMode mode() {
        return this.mode;
    }

    private void mode_$eq(SaveMode x$1) {
        this.mode = x$1;
    }

    private HashMap<String, String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(HashMap<String, String> x$1) {
        this.extraOptions = x$1;
    }

    private Option<Seq<String>> partitioningColumns() {
        return this.partitioningColumns;
    }

    private void partitioningColumns_$eq(Option<Seq<String>> x$1) {
        this.partitioningColumns = x$1;
    }

    public DataFrameWriter(DataFrame df) {
        this.df = df;
        this.source = df.sqlContext().conf().defaultDataSourceName();
        this.mode = SaveMode.ErrorIfExists;
        this.extraOptions = new HashMap();
        this.partitioningColumns = None$.MODULE$;
    }
}

