/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.columnar;

import java.nio.ByteBuffer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.MutableRow;
import org.apache.spark.sql.columnar.NativeColumnType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;

public final class STRING$
extends NativeColumnType<StringType$> {
    public static final STRING$ MODULE$;

    static {
        new STRING$();
    }

    @Override
    public int actualSize(InternalRow row, int ordinal) {
        return row.getUTF8String(ordinal).numBytes() + 4;
    }

    @Override
    public void append(UTF8String v, ByteBuffer buffer) {
        byte[] stringBytes = v.getBytes();
        buffer.putInt(stringBytes.length).put(stringBytes, 0, stringBytes.length);
    }

    @Override
    public UTF8String extract(ByteBuffer buffer) {
        int length = buffer.getInt();
        byte[] stringBytes = new byte[length];
        buffer.get(stringBytes, 0, length);
        return UTF8String.fromBytes((byte[])stringBytes);
    }

    @Override
    public void setField(MutableRow row, int ordinal, UTF8String value) {
        row.update(ordinal, (Object)value.clone());
    }

    @Override
    public UTF8String getField(InternalRow row, int ordinal) {
        return row.getUTF8String(ordinal);
    }

    @Override
    public void copyField(InternalRow from, int fromOrdinal, MutableRow to, int toOrdinal) {
        this.setField(to, toOrdinal, this.getField(from, fromOrdinal));
    }

    @Override
    public UTF8String clone(UTF8String v) {
        return v.clone();
    }

    private STRING$() {
        super(StringType$.MODULE$, 7, 8);
        MODULE$ = this;
    }
}

