/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.jdbc;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.Properties;
import org.apache.spark.Logging;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRDD$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public final class JdbcUtils$
implements Logging {
    public static final JdbcUtils$ MODULE$;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new JdbcUtils$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public Connection createConnection(String url, Properties connectionProperties) {
        return (Connection)JDBCRDD$.MODULE$.getConnector(connectionProperties.getProperty("driver"), url, connectionProperties).apply();
    }

    public boolean tableExists(Connection conn, String table) {
        return Try$.MODULE$.apply((Function0)new Serializable(conn, table){
            public static final long serialVersionUID = 0L;
            private final Connection conn$1;
            private final String table$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.conn$1.prepareStatement(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT 1 FROM ", " LIMIT 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table$1}))).executeQuery().next();
            }
            {
                this.conn$1 = conn$1;
                this.table$1 = table$1;
            }
        }).isSuccess();
    }

    public void dropTable(Connection conn, String table) {
        conn.prepareStatement(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP TABLE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table}))).executeUpdate();
    }

    public PreparedStatement insertStatement(Connection conn, String table, StructType rddSchema) {
        StringBuilder sql = new StringBuilder(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", " VALUES ("})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table})));
        for (int fieldsLeft = rddSchema.fields().length; fieldsLeft > 0; --fieldsLeft) {
            sql.append("?");
            StringBuilder stringBuilder = fieldsLeft > 1 ? sql.append(", ") : sql.append(")");
        }
        return conn.prepareStatement(sql.toString());
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public Iterator<Object> savePartition(Function0<Connection> getConnection, String table, Iterator<Row> iterator, StructType rddSchema, int[] nullTypes) {
        block27: {
            boolean committed;
            Connection conn;
            block26: {
                conn = (Connection)getConnection.apply();
                committed = false;
                conn.setAutoCommit(false);
                PreparedStatement stmt = this.insertStatement(conn, table, rddSchema);
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    int numFields = rddSchema.fields().length;
                    for (int i = 0; i < numFields; ++i) {
                        BoxedUnit boxedUnit;
                        if (row.isNullAt(i)) {
                            stmt.setNull(i + 1, nullTypes[i]);
                            continue;
                        }
                        DataType dataType = rddSchema.fields()[i].dataType();
                        IntegerType$ integerType$ = IntegerType$.MODULE$;
                        DataType dataType2 = dataType;
                        if (!(integerType$ != null ? !integerType$.equals(dataType2) : dataType2 != null)) {
                            stmt.setInt(i + 1, row.getInt(i));
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        LongType$ longType$ = LongType$.MODULE$;
                        DataType dataType3 = dataType;
                        if (!(longType$ != null ? !longType$.equals(dataType3) : dataType3 != null)) {
                            stmt.setLong(i + 1, row.getLong(i));
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        DoubleType$ doubleType$ = DoubleType$.MODULE$;
                        DataType dataType4 = dataType;
                        if (!(doubleType$ != null ? !doubleType$.equals(dataType4) : dataType4 != null)) {
                            stmt.setDouble(i + 1, row.getDouble(i));
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        FloatType$ floatType$ = FloatType$.MODULE$;
                        DataType dataType5 = dataType;
                        if (!(floatType$ != null ? !floatType$.equals(dataType5) : dataType5 != null)) {
                            stmt.setFloat(i + 1, row.getFloat(i));
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        ShortType$ shortType$ = ShortType$.MODULE$;
                        DataType dataType6 = dataType;
                        if (!(shortType$ != null ? !shortType$.equals(dataType6) : dataType6 != null)) {
                            stmt.setInt(i + 1, row.getShort(i));
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        ByteType$ byteType$ = ByteType$.MODULE$;
                        DataType dataType7 = dataType;
                        if (!(byteType$ != null ? !byteType$.equals(dataType7) : dataType7 != null)) {
                            stmt.setInt(i + 1, row.getByte(i));
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        BooleanType$ booleanType$ = BooleanType$.MODULE$;
                        DataType dataType8 = dataType;
                        if (!(booleanType$ != null ? !booleanType$.equals(dataType8) : dataType8 != null)) {
                            stmt.setBoolean(i + 1, row.getBoolean(i));
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        StringType$ stringType$ = StringType$.MODULE$;
                        DataType dataType9 = dataType;
                        if (!(stringType$ != null ? !stringType$.equals(dataType9) : dataType9 != null)) {
                            stmt.setString(i + 1, row.getString(i));
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        BinaryType$ binaryType$ = BinaryType$.MODULE$;
                        DataType dataType10 = dataType;
                        if (!(binaryType$ != null ? !binaryType$.equals(dataType10) : dataType10 != null)) {
                            stmt.setBytes(i + 1, (byte[])row.getAs(i));
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        TimestampType$ timestampType$ = TimestampType$.MODULE$;
                        DataType dataType11 = dataType;
                        if (!(timestampType$ != null ? !timestampType$.equals(dataType11) : dataType11 != null)) {
                            stmt.setTimestamp(i + 1, (Timestamp)row.getAs(i));
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        DateType$ dateType$ = DateType$.MODULE$;
                        DataType dataType12 = dataType;
                        if (!(dateType$ != null ? !dateType$.equals(dataType12) : dataType12 != null)) {
                            stmt.setDate(i + 1, (Date)row.getAs(i));
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        if (dataType instanceof DecimalType) {
                            stmt.setBigDecimal(i + 1, row.getDecimal(i));
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't translate non-null value for field ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})));
                    }
                    stmt.executeUpdate();
                }
                stmt.close();
                conn.commit();
                committed = true;
                if (!committed) break block26;
                try {
                    conn.close();
                }
                catch (Exception exception) {
                    this.logWarning((Function0<String>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Transaction succeeded, but closing failed";
                        }
                    }, exception);
                }
            }
            conn.rollback();
            conn.close();
            break block27;
            {
                catch (Throwable throwable) {
                    try {
                        void var8_8;
                        var8_8.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        if (committed) {
                            try {
                                conn.close();
                            }
                            catch (Exception exception) {
                                this.logWarning((Function0<String>)new /* invalid duplicate definition of identical inner class */, exception);
                            }
                        } else {
                            conn.rollback();
                            conn.close();
                        }
                        throw throwable2;
                    }
                }
            }
        }
        return Predef$.MODULE$.byteArrayOps((byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte())).iterator();
    }

    public String schemaString(DataFrame df, String url) {
        StringBuilder sb = new StringBuilder();
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(url);
        Predef$.MODULE$.refArrayOps((Object[])df.schema().fields()).foreach((Function1)new Serializable(sb, dialect){
            public static final long serialVersionUID = 0L;
            private final StringBuilder sb$1;
            private final JdbcDialect dialect$1;

            public final StringBuilder apply(StructField field) {
                String name = field.name();
                String typ = (String)this.dialect$1.getJDBCType(field.dataType()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(JdbcType x$1) {
                        return x$1.databaseTypeDefinition();
                    }
                }).getOrElse((Function0)new Serializable(this, field){
                    public static final long serialVersionUID = 0L;
                    private final StructField field$1;

                    public final String apply() {
                        block14: {
                            String string;
                            block3: {
                                DataType dataType;
                                block13: {
                                    block12: {
                                        block11: {
                                            block10: {
                                                block9: {
                                                    block8: {
                                                        block7: {
                                                            block6: {
                                                                block5: {
                                                                    block4: {
                                                                        block2: {
                                                                            dataType = this.field$1.dataType();
                                                                            IntegerType$ integerType$ = IntegerType$.MODULE$;
                                                                            DataType dataType2 = dataType;
                                                                            if (integerType$ != null ? !integerType$.equals(dataType2) : dataType2 != null) break block2;
                                                                            string = "INTEGER";
                                                                            break block3;
                                                                        }
                                                                        LongType$ longType$ = LongType$.MODULE$;
                                                                        DataType dataType3 = dataType;
                                                                        if (longType$ != null ? !longType$.equals(dataType3) : dataType3 != null) break block4;
                                                                        string = "BIGINT";
                                                                        break block3;
                                                                    }
                                                                    DoubleType$ doubleType$ = DoubleType$.MODULE$;
                                                                    DataType dataType4 = dataType;
                                                                    if (doubleType$ != null ? !doubleType$.equals(dataType4) : dataType4 != null) break block5;
                                                                    string = "DOUBLE PRECISION";
                                                                    break block3;
                                                                }
                                                                FloatType$ floatType$ = FloatType$.MODULE$;
                                                                DataType dataType5 = dataType;
                                                                if (floatType$ != null ? !floatType$.equals(dataType5) : dataType5 != null) break block6;
                                                                string = "REAL";
                                                                break block3;
                                                            }
                                                            ShortType$ shortType$ = ShortType$.MODULE$;
                                                            DataType dataType6 = dataType;
                                                            if (shortType$ != null ? !shortType$.equals(dataType6) : dataType6 != null) break block7;
                                                            string = "INTEGER";
                                                            break block3;
                                                        }
                                                        ByteType$ byteType$ = ByteType$.MODULE$;
                                                        DataType dataType7 = dataType;
                                                        if (byteType$ != null ? !byteType$.equals(dataType7) : dataType7 != null) break block8;
                                                        string = "BYTE";
                                                        break block3;
                                                    }
                                                    BooleanType$ booleanType$ = BooleanType$.MODULE$;
                                                    DataType dataType8 = dataType;
                                                    if (booleanType$ != null ? !booleanType$.equals(dataType8) : dataType8 != null) break block9;
                                                    string = "BIT(1)";
                                                    break block3;
                                                }
                                                StringType$ stringType$ = StringType$.MODULE$;
                                                DataType dataType9 = dataType;
                                                if (stringType$ != null ? !stringType$.equals(dataType9) : dataType9 != null) break block10;
                                                string = "TEXT";
                                                break block3;
                                            }
                                            BinaryType$ binaryType$ = BinaryType$.MODULE$;
                                            DataType dataType10 = dataType;
                                            if (binaryType$ != null ? !binaryType$.equals(dataType10) : dataType10 != null) break block11;
                                            string = "BLOB";
                                            break block3;
                                        }
                                        TimestampType$ timestampType$ = TimestampType$.MODULE$;
                                        DataType dataType11 = dataType;
                                        if (timestampType$ != null ? !timestampType$.equals(dataType11) : dataType11 != null) break block12;
                                        string = "TIMESTAMP";
                                        break block3;
                                    }
                                    DateType$ dateType$ = DateType$.MODULE$;
                                    DataType dataType12 = dataType;
                                    if (dateType$ != null ? !dateType$.equals(dataType12) : dataType12 != null) break block13;
                                    string = "DATE";
                                    break block3;
                                }
                                if (!(dataType instanceof DecimalType)) break block14;
                                DecimalType decimalType = (DecimalType)dataType;
                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DECIMAL(", ",", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)decimalType.precision()), BoxesRunTime.boxToInteger((int)decimalType.scale())}));
                            }
                            return string;
                        }
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Don't know how to save ", " to JDBC"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.field$1})));
                    }
                    {
                        this.field$1 = field$1;
                    }
                });
                String nullable = field.nullable() ? "" : "NOT NULL";
                return this.sb$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", ", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, typ, nullable})));
            }
            {
                this.sb$1 = sb$1;
                this.dialect$1 = dialect$1;
            }
        });
        return sb.length() < 2 ? "" : sb.substring(2);
    }

    public void saveTable(DataFrame df, String url, String table, Properties properties) {
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(url);
        int[] nullTypes = (int[])Predef$.MODULE$.refArrayOps((Object[])df.schema().fields()).map((Function1)new Serializable(dialect){
            public static final long serialVersionUID = 0L;
            private final JdbcDialect dialect$2;

            public final int apply(StructField field) {
                return BoxesRunTime.unboxToInt((Object)this.dialect$2.getJDBCType(field.dataType()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(JdbcType x$2) {
                        return x$2.jdbcNullType();
                    }
                }).getOrElse((Function0)new Serializable(this, field){
                    public static final long serialVersionUID = 0L;
                    private final StructField field$2;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        block14: {
                            int n;
                            block3: {
                                DataType dataType;
                                block13: {
                                    block12: {
                                        block11: {
                                            block10: {
                                                block9: {
                                                    block8: {
                                                        block7: {
                                                            block6: {
                                                                block5: {
                                                                    block4: {
                                                                        block2: {
                                                                            dataType = this.field$2.dataType();
                                                                            IntegerType$ integerType$ = IntegerType$.MODULE$;
                                                                            DataType dataType2 = dataType;
                                                                            if (integerType$ != null ? !integerType$.equals(dataType2) : dataType2 != null) break block2;
                                                                            n = 4;
                                                                            break block3;
                                                                        }
                                                                        LongType$ longType$ = LongType$.MODULE$;
                                                                        DataType dataType3 = dataType;
                                                                        if (longType$ != null ? !longType$.equals(dataType3) : dataType3 != null) break block4;
                                                                        n = -5;
                                                                        break block3;
                                                                    }
                                                                    DoubleType$ doubleType$ = DoubleType$.MODULE$;
                                                                    DataType dataType4 = dataType;
                                                                    if (doubleType$ != null ? !doubleType$.equals(dataType4) : dataType4 != null) break block5;
                                                                    n = 8;
                                                                    break block3;
                                                                }
                                                                FloatType$ floatType$ = FloatType$.MODULE$;
                                                                DataType dataType5 = dataType;
                                                                if (floatType$ != null ? !floatType$.equals(dataType5) : dataType5 != null) break block6;
                                                                n = 7;
                                                                break block3;
                                                            }
                                                            ShortType$ shortType$ = ShortType$.MODULE$;
                                                            DataType dataType6 = dataType;
                                                            if (shortType$ != null ? !shortType$.equals(dataType6) : dataType6 != null) break block7;
                                                            n = 4;
                                                            break block3;
                                                        }
                                                        ByteType$ byteType$ = ByteType$.MODULE$;
                                                        DataType dataType7 = dataType;
                                                        if (byteType$ != null ? !byteType$.equals(dataType7) : dataType7 != null) break block8;
                                                        n = 4;
                                                        break block3;
                                                    }
                                                    BooleanType$ booleanType$ = BooleanType$.MODULE$;
                                                    DataType dataType8 = dataType;
                                                    if (booleanType$ != null ? !booleanType$.equals(dataType8) : dataType8 != null) break block9;
                                                    n = -7;
                                                    break block3;
                                                }
                                                StringType$ stringType$ = StringType$.MODULE$;
                                                DataType dataType9 = dataType;
                                                if (stringType$ != null ? !stringType$.equals(dataType9) : dataType9 != null) break block10;
                                                n = 2005;
                                                break block3;
                                            }
                                            BinaryType$ binaryType$ = BinaryType$.MODULE$;
                                            DataType dataType10 = dataType;
                                            if (binaryType$ != null ? !binaryType$.equals(dataType10) : dataType10 != null) break block11;
                                            n = 2004;
                                            break block3;
                                        }
                                        TimestampType$ timestampType$ = TimestampType$.MODULE$;
                                        DataType dataType11 = dataType;
                                        if (timestampType$ != null ? !timestampType$.equals(dataType11) : dataType11 != null) break block12;
                                        n = 93;
                                        break block3;
                                    }
                                    DateType$ dateType$ = DateType$.MODULE$;
                                    DataType dataType12 = dataType;
                                    if (dateType$ != null ? !dateType$.equals(dataType12) : dataType12 != null) break block13;
                                    n = 91;
                                    break block3;
                                }
                                if (!(dataType instanceof DecimalType)) break block14;
                                n = 3;
                            }
                            return n;
                        }
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't translate null value for field ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.field$2})));
                    }
                    {
                        this.field$2 = field$2;
                    }
                }));
            }
            {
                this.dialect$2 = dialect$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        StructType rddSchema = df.schema();
        String driver = DriverRegistry$.MODULE$.getDriverClassName(url);
        Function0<Connection> getConnection = JDBCRDD$.MODULE$.getConnector(driver, url, properties);
        df.foreachPartition((Function1<Iterator<Row>, BoxedUnit>)new Serializable(table, nullTypes, rddSchema, getConnection){
            public static final long serialVersionUID = 0L;
            private final String table$2;
            private final int[] nullTypes$1;
            private final StructType rddSchema$1;
            private final Function0 getConnection$1;

            public final void apply(Iterator<Row> iterator) {
                JdbcUtils$.MODULE$.savePartition((Function0<Connection>)this.getConnection$1, this.table$2, iterator, this.rddSchema$1, this.nullTypes$1);
            }
            {
                this.table$2 = table$2;
                this.nullTypes$1 = nullTypes$1;
                this.rddSchema$1 = rddSchema$1;
                this.getConnection$1 = getConnection$1;
            }
        });
    }

    public Properties saveTable$default$4() {
        return new Properties();
    }

    private JdbcUtils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

