/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.ValidTypeMap;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.spark.SparkEnv$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFilters$;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.spark-project.guava.io.BaseEncoding;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class ParquetFilters$ {
    public static final ParquetFilters$ MODULE$;
    private final String PARQUET_FILTER_DATA;
    private final PartialFunction<DataType, Function2<String, Object, FilterPredicate>> makeEq;
    private final PartialFunction<DataType, Function2<String, Object, FilterPredicate>> makeNotEq;
    private final PartialFunction<DataType, Function2<String, Object, FilterPredicate>> makeLt;
    private final PartialFunction<DataType, Function2<String, Object, FilterPredicate>> makeLtEq;
    private final PartialFunction<DataType, Function2<String, Object, FilterPredicate>> makeGt;
    private final PartialFunction<DataType, Function2<String, Object, FilterPredicate>> makeGtEq;
    private final PartialFunction<DataType, Function2<String, Set<Object>, FilterPredicate>> makeInSet;
    private BoxedUnit relaxParquetValidTypeMap;
    private volatile boolean bitmap$0;

    static {
        new ParquetFilters$();
    }

    private void relaxParquetValidTypeMap$lzycompute() {
        ParquetFilters$ parquetFilters$ = this;
        synchronized (parquetFilters$) {
            if (!this.bitmap$0) {
                Constructor<?> constructor = Class.forName(new StringBuilder().append((Object)ValidTypeMap.class.getCanonicalName()).append((Object)"$FullTypeDescriptor").toString()).getDeclaredConstructor(PrimitiveType.PrimitiveTypeName.class, OriginalType.class);
                constructor.setAccessible(true);
                Object enumTypeDescriptor = constructor.newInstance(PrimitiveType.PrimitiveTypeName.BINARY, OriginalType.ENUM);
                Method addMethod = (Method)Predef$.MODULE$.refArrayOps((Object[])ValidTypeMap.class.getDeclaredMethods()).find((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Method x$11) {
                        String string = x$11.getName();
                        String string2 = "add";
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                }).get();
                addMethod.setAccessible(true);
                addMethod.invoke(null, Binary.class, enumTypeDescriptor);
                this.bitmap$0 = true;
            }
            return;
        }
    }

    public String PARQUET_FILTER_DATA() {
        return this.PARQUET_FILTER_DATA;
    }

    private PartialFunction<DataType, Function2<String, Object, FilterPredicate>> makeEq() {
        return this.makeEq;
    }

    private PartialFunction<DataType, Function2<String, Object, FilterPredicate>> makeNotEq() {
        return this.makeNotEq;
    }

    private PartialFunction<DataType, Function2<String, Object, FilterPredicate>> makeLt() {
        return this.makeLt;
    }

    private PartialFunction<DataType, Function2<String, Object, FilterPredicate>> makeLtEq() {
        return this.makeLtEq;
    }

    private PartialFunction<DataType, Function2<String, Object, FilterPredicate>> makeGt() {
        return this.makeGt;
    }

    private PartialFunction<DataType, Function2<String, Object, FilterPredicate>> makeGtEq() {
        return this.makeGtEq;
    }

    private PartialFunction<DataType, Function2<String, Set<Object>, FilterPredicate>> makeInSet() {
        return this.makeInSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<FilterPredicate> createFilter(StructType schema2, Filter predicate) {
        Filter filter;
        Map dataTypeOf = ((TraversableOnce)schema2.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, DataType> apply(StructField f) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)f.name()), (Object)f.dataType());
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        this.relaxParquetValidTypeMap();
        boolean bl = false;
        Not not = null;
        Filter filter2 = predicate;
        if (filter2 instanceof IsNull) {
            IsNull isNull = (IsNull)filter2;
            String name = isNull.attribute();
            return ((Option)this.makeEq().lift().apply(dataTypeOf.apply((Object)name))).map((Function1)new Serializable(name){
                public static final long serialVersionUID = 0L;
                private final String name$1;

                public final FilterPredicate apply(Function2<String, Object, FilterPredicate> x$1) {
                    return (FilterPredicate)x$1.apply((Object)this.name$1, null);
                }
                {
                    this.name$1 = name$1;
                }
            });
        }
        if (filter2 instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)filter2;
            String name = isNotNull.attribute();
            return ((Option)this.makeNotEq().lift().apply(dataTypeOf.apply((Object)name))).map((Function1)new Serializable(name){
                public static final long serialVersionUID = 0L;
                private final String name$2;

                public final FilterPredicate apply(Function2<String, Object, FilterPredicate> x$2) {
                    return (FilterPredicate)x$2.apply((Object)this.name$2, null);
                }
                {
                    this.name$2 = name$2;
                }
            });
        }
        if (filter2 instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter2;
            String name = equalTo.attribute();
            Object value = equalTo.value();
            return ((Option)this.makeEq().lift().apply(dataTypeOf.apply((Object)name))).map((Function1)new Serializable(name, value){
                public static final long serialVersionUID = 0L;
                private final String name$3;
                private final Object value$1;

                public final FilterPredicate apply(Function2<String, Object, FilterPredicate> x$3) {
                    return (FilterPredicate)x$3.apply((Object)this.name$3, this.value$1);
                }
                {
                    this.name$3 = name$3;
                    this.value$1 = value$1;
                }
            });
        }
        if (filter2 instanceof Not) {
            bl = true;
            not = (Not)filter2;
            Filter filter3 = not.child();
            if (filter3 instanceof EqualTo) {
                EqualTo equalTo = (EqualTo)filter3;
                String name = equalTo.attribute();
                Object value = equalTo.value();
                return ((Option)this.makeNotEq().lift().apply(dataTypeOf.apply((Object)name))).map((Function1)new Serializable(name, value){
                    public static final long serialVersionUID = 0L;
                    private final String name$4;
                    private final Object value$2;

                    public final FilterPredicate apply(Function2<String, Object, FilterPredicate> x$4) {
                        return (FilterPredicate)x$4.apply((Object)this.name$4, this.value$2);
                    }
                    {
                        this.name$4 = name$4;
                        this.value$2 = value$2;
                    }
                });
            }
        }
        if (filter2 instanceof EqualNullSafe) {
            EqualNullSafe equalNullSafe = (EqualNullSafe)filter2;
            String name = equalNullSafe.attribute();
            Object value = equalNullSafe.value();
            return ((Option)this.makeEq().lift().apply(dataTypeOf.apply((Object)name))).map((Function1)new Serializable(name, value){
                public static final long serialVersionUID = 0L;
                private final String name$5;
                private final Object value$3;

                public final FilterPredicate apply(Function2<String, Object, FilterPredicate> x$5) {
                    return (FilterPredicate)x$5.apply((Object)this.name$5, this.value$3);
                }
                {
                    this.name$5 = name$5;
                    this.value$3 = value$3;
                }
            });
        }
        if (bl && (filter = not.child()) instanceof EqualNullSafe) {
            EqualNullSafe equalNullSafe = (EqualNullSafe)filter;
            String name = equalNullSafe.attribute();
            Object value = equalNullSafe.value();
            return ((Option)this.makeNotEq().lift().apply(dataTypeOf.apply((Object)name))).map((Function1)new Serializable(name, value){
                public static final long serialVersionUID = 0L;
                private final String name$6;
                private final Object value$4;

                public final FilterPredicate apply(Function2<String, Object, FilterPredicate> x$6) {
                    return (FilterPredicate)x$6.apply((Object)this.name$6, this.value$4);
                }
                {
                    this.name$6 = name$6;
                    this.value$4 = value$4;
                }
            });
        }
        if (filter2 instanceof LessThan) {
            LessThan lessThan = (LessThan)filter2;
            String name = lessThan.attribute();
            Object value = lessThan.value();
            return ((Option)this.makeLt().lift().apply(dataTypeOf.apply((Object)name))).map((Function1)new Serializable(name, value){
                public static final long serialVersionUID = 0L;
                private final String name$7;
                private final Object value$5;

                public final FilterPredicate apply(Function2<String, Object, FilterPredicate> x$7) {
                    return (FilterPredicate)x$7.apply((Object)this.name$7, this.value$5);
                }
                {
                    this.name$7 = name$7;
                    this.value$5 = value$5;
                }
            });
        }
        if (filter2 instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter2;
            String name = lessThanOrEqual.attribute();
            Object value = lessThanOrEqual.value();
            return ((Option)this.makeLtEq().lift().apply(dataTypeOf.apply((Object)name))).map((Function1)new Serializable(name, value){
                public static final long serialVersionUID = 0L;
                private final String name$8;
                private final Object value$6;

                public final FilterPredicate apply(Function2<String, Object, FilterPredicate> x$8) {
                    return (FilterPredicate)x$8.apply((Object)this.name$8, this.value$6);
                }
                {
                    this.name$8 = name$8;
                    this.value$6 = value$6;
                }
            });
        }
        if (filter2 instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter2;
            String name = greaterThan.attribute();
            Object value = greaterThan.value();
            return ((Option)this.makeGt().lift().apply(dataTypeOf.apply((Object)name))).map((Function1)new Serializable(name, value){
                public static final long serialVersionUID = 0L;
                private final String name$9;
                private final Object value$7;

                public final FilterPredicate apply(Function2<String, Object, FilterPredicate> x$9) {
                    return (FilterPredicate)x$9.apply((Object)this.name$9, this.value$7);
                }
                {
                    this.name$9 = name$9;
                    this.value$7 = value$7;
                }
            });
        }
        if (filter2 instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter2;
            String name = greaterThanOrEqual.attribute();
            Object value = greaterThanOrEqual.value();
            return ((Option)this.makeGtEq().lift().apply(dataTypeOf.apply((Object)name))).map((Function1)new Serializable(name, value){
                public static final long serialVersionUID = 0L;
                private final String name$10;
                private final Object value$8;

                public final FilterPredicate apply(Function2<String, Object, FilterPredicate> x$10) {
                    return (FilterPredicate)x$10.apply((Object)this.name$10, this.value$8);
                }
                {
                    this.name$10 = name$10;
                    this.value$8 = value$8;
                }
            });
        }
        if (filter2 instanceof And) {
            And and = (And)filter2;
            Filter lhs = and.left();
            Filter rhs = and.right();
            return ((TraversableOnce)Option$.MODULE$.option2Iterable(this.createFilter(schema2, lhs)).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.createFilter(schema2, rhs)), Iterable$.MODULE$.canBuildFrom())).reduceOption((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final FilterPredicate apply(FilterPredicate x$1, FilterPredicate x$2) {
                    return FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2);
                }
            });
        }
        if (filter2 instanceof Or) {
            Or or = (Or)filter2;
            Filter lhs = or.left();
            Filter rhs = or.right();
            return this.createFilter(schema2, lhs).flatMap((Function1)new Serializable(schema2, rhs){
                public static final long serialVersionUID = 0L;
                private final StructType schema$1;
                private final Filter rhs$1;

                public final Option<FilterPredicate> apply(FilterPredicate lhsFilter) {
                    return ParquetFilters$.MODULE$.createFilter(this.schema$1, this.rhs$1).map((Function1)new Serializable(this, lhsFilter){
                        public static final long serialVersionUID = 0L;
                        private final FilterPredicate lhsFilter$1;

                        public final FilterPredicate apply(FilterPredicate rhsFilter) {
                            return FilterApi.or((FilterPredicate)this.lhsFilter$1, (FilterPredicate)rhsFilter);
                        }
                        {
                            this.lhsFilter$1 = lhsFilter$1;
                        }
                    });
                }
                {
                    this.schema$1 = schema$1;
                    this.rhs$1 = rhs$1;
                }
            });
        }
        if (!bl) return None$.MODULE$;
        Filter pred = not.child();
        return this.createFilter(schema2, pred).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final FilterPredicate apply(FilterPredicate x$1) {
                return FilterApi.not((FilterPredicate)x$1);
            }
        });
    }

    private void relaxParquetValidTypeMap() {
        if (!this.bitmap$0) {
            this.relaxParquetValidTypeMap$lzycompute();
        }
    }

    public void serializeFilterExpressions(Seq<Expression> filters, Configuration conf) {
        if (filters.nonEmpty()) {
            byte[] serialized = SparkEnv$.MODULE$.get().closureSerializer().newInstance().serialize(filters, ClassTag$.MODULE$.apply(Seq.class)).array();
            String encoded = BaseEncoding.base64().encode(serialized);
            conf.set(this.PARQUET_FILTER_DATA(), encoded);
        }
    }

    public Seq<Expression> deserializeFilterExpressions(Configuration conf) {
        Seq seq;
        String data = conf.get(this.PARQUET_FILTER_DATA());
        if (data == null) {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        } else {
            byte[] decoded = BaseEncoding.base64().decode((CharSequence)data);
            seq = (Seq)SparkEnv$.MODULE$.get().closureSerializer().newInstance().deserialize(ByteBuffer.wrap(decoded), ClassTag$.MODULE$.Nothing());
        }
        return seq;
    }

    private ParquetFilters$() {
        MODULE$ = this;
        this.PARQUET_FILTER_DATA = "org.apache.spark.sql.parquet.row.filter";
        this.makeEq = new anonfun.1();
        this.makeNotEq = new anonfun.2();
        this.makeLt = new anonfun.3();
        this.makeLtEq = new anonfun.4();
        this.makeGt = new anonfun.5();
        this.makeGtEq = new anonfun.6();
        this.makeInSet = new anonfun.7();
    }
}

