/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.CompressionCodecs$;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.TextBasedFileFormat;
import org.apache.spark.sql.execution.datasources.csv.CSVDataSource;
import org.apache.spark.sql.execution.datasources.csv.CSVDataSource$;
import org.apache.spark.sql.execution.datasources.csv.CSVFileFormat$;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions$;
import org.apache.spark.sql.execution.datasources.csv.CSVUtils$;
import org.apache.spark.sql.execution.datasources.csv.CsvOutputWriter;
import org.apache.spark.sql.execution.datasources.csv.UnivocityParser;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\u0001\u0003\u0001E\u0011QbQ*W\r&dWMR8s[\u0006$(BA\u0002\u0005\u0003\r\u00197O\u001e\u0006\u0003\u000b\u0019\t1\u0002Z1uCN|WO]2fg*\u0011q\u0001C\u0001\nKb,7-\u001e;j_:T!!\u0003\u0006\u0002\u0007M\fHN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\n\u0017!\t\u0019B#D\u0001\u0005\u0013\t)BAA\nUKb$()Y:fI\u001aKG.\u001a$pe6\fG\u000f\u0005\u0002\u001855\t\u0001D\u0003\u0002\u001a\u0011\u000591o\\;sG\u0016\u001c\u0018BA\u000e\u0019\u0005I!\u0015\r^1T_V\u00148-\u001a*fO&\u001cH/\u001a:\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u0011\u0001\u001b\u0005\u0011\u0001\"\u0002\u0012\u0001\t\u0003\u001a\u0013!C:i_J$h*Y7f)\u0005!\u0003CA\u0013,\u001d\t1\u0013&D\u0001(\u0015\u0005A\u0013!B:dC2\f\u0017B\u0001\u0016(\u0003\u0019\u0001&/\u001a3fM&\u0011A&\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005):\u0003\"B\u0018\u0001\t\u0003\u0002\u0014aC5t'Bd\u0017\u000e^1cY\u0016$B!\r\u001b;\u007fA\u0011aEM\u0005\u0003g\u001d\u0012qAQ8pY\u0016\fg\u000eC\u00036]\u0001\u0007a'\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u00028q5\t\u0001\"\u0003\u0002:\u0011\ta1\u000b]1sWN+7o]5p]\")1H\fa\u0001y\u00059q\u000e\u001d;j_:\u001c\b\u0003B\u0013>I\u0011J!AP\u0017\u0003\u00075\u000b\u0007\u000fC\u0003A]\u0001\u0007\u0011)\u0001\u0003qCRD\u0007C\u0001\"H\u001b\u0005\u0019%B\u0001#F\u0003\t17O\u0003\u0002G\u0019\u00051\u0001.\u00193p_BL!\u0001S\"\u0003\tA\u000bG\u000f\u001b\u0005\u0006\u0015\u0002!\teS\u0001\fS:4WM]*dQ\u0016l\u0017\r\u0006\u0003M+Z;\u0006c\u0001\u0014N\u001f&\u0011aj\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005A\u001bV\"A)\u000b\u0005IC\u0011!\u0002;za\u0016\u001c\u0018B\u0001+R\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006k%\u0003\rA\u000e\u0005\u0006w%\u0003\r\u0001\u0010\u0005\u00061&\u0003\r!W\u0001\u0006M&dWm\u001d\t\u00045\n,gBA.a\u001d\tav,D\u0001^\u0015\tq\u0006#\u0001\u0004=e>|GOP\u0005\u0002Q%\u0011\u0011mJ\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019GMA\u0002TKFT!!Y\u0014\u0011\u0005\t3\u0017BA4D\u0005)1\u0015\u000e\\3Ti\u0006$Xo\u001d\u0005\u0006S\u0002!\tE[\u0001\raJ,\u0007/\u0019:f/JLG/\u001a\u000b\u0006W:|w\u000f\u001f\t\u0003'1L!!\u001c\u0003\u0003'=+H\u000f];u/JLG/\u001a:GC\u000e$xN]=\t\u000bUB\u0007\u0019\u0001\u001c\t\u000bAD\u0007\u0019A9\u0002\u0007)|'\r\u0005\u0002sk6\t1O\u0003\u0002u\u000b\u0006IQ.\u00199sK\u0012,8-Z\u0005\u0003mN\u00141AS8c\u0011\u0015Y\u0004\u000e1\u0001=\u0011\u0015I\b\u000e1\u0001P\u0003)!\u0017\r^1TG\",W.\u0019\u0005\u0006w\u0002!\t\u0005`\u0001\fEVLG\u000e\u001a*fC\u0012,'\u000fF\b~\u00033\tY\"!\b\u0002\"\u0005\u0015\u0012\u0011GA\u001a!\u00191c0!\u0001\u0002\b%\u0011qp\n\u0002\n\rVt7\r^5p]F\u00022aEA\u0002\u0013\r\t)\u0001\u0002\u0002\u0010!\u0006\u0014H/\u001b;j_:,GMR5mKB)!,!\u0003\u0002\u000e%\u0019\u00111\u00023\u0003\u0011%#XM]1u_J\u0004B!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0004\u0003'A\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\t\u0005]\u0011\u0011\u0003\u0002\f\u0013:$XM\u001d8bYJ{w\u000fC\u00036u\u0002\u0007a\u0007C\u0003zu\u0002\u0007q\n\u0003\u0004\u0002 i\u0004\raT\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001c6\r[3nC\"1\u00111\u0005>A\u0002=\u000baB]3rk&\u0014X\rZ*dQ\u0016l\u0017\rC\u0004\u0002(i\u0004\r!!\u000b\u0002\u000f\u0019LG\u000e^3sgB!!LYA\u0016!\r9\u0012QF\u0005\u0004\u0003_A\"A\u0002$jYR,'\u000fC\u0003<u\u0002\u0007A\bC\u0004\u00026i\u0004\r!a\u000e\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u0003\u0002:\u0005}RBAA\u001e\u0015\r\ti$R\u0001\u0005G>tg-\u0003\u0003\u0002B\u0005m\"!D\"p]\u001aLw-\u001e:bi&|g\u000e\u0003\u0004\u0002F\u0001!\teI\u0001\ti>\u001cFO]5oO\"9\u0011\u0011\n\u0001\u0005B\u0005-\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u00055\u0003c\u0001\u0014\u0002P%\u0019\u0011\u0011K\u0014\u0003\u0007%sG\u000fC\u0004\u0002V\u0001!\t%a\u0016\u0002\r\u0015\fX/\u00197t)\r\t\u0014\u0011\f\u0005\t\u00037\n\u0019\u00061\u0001\u0002^\u0005)q\u000e\u001e5feB\u0019a%a\u0018\n\u0007\u0005\u0005tEA\u0002B]f\u0004")
public class CSVFileFormat
extends TextBasedFileFormat
implements DataSourceRegister {
    @Override
    public String shortName() {
        return "csv";
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        CSVOptions parsedOptions = new CSVOptions(options, sparkSession.sessionState().conf().sessionLocalTimeZone(), CSVOptions$.MODULE$.$lessinit$greater$default$3());
        CSVDataSource csvDataSource = CSVDataSource$.MODULE$.apply(parsedOptions);
        return csvDataSource.isSplitable() && super.isSplitable(sparkSession, options, path);
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        CSVOptions parsedOptions = new CSVOptions(options, sparkSession.sessionState().conf().sessionLocalTimeZone(), CSVOptions$.MODULE$.$lessinit$greater$default$3());
        return CSVDataSource$.MODULE$.apply(parsedOptions).inferSchema(sparkSession, files, parsedOptions);
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        CSVUtils$.MODULE$.verifySchema(dataSchema);
        Configuration conf = job.getConfiguration();
        CSVOptions csvOptions = new CSVOptions(options, sparkSession.sessionState().conf().sessionLocalTimeZone(), CSVOptions$.MODULE$.$lessinit$greater$default$3());
        csvOptions.compressionCodec().foreach((Function1)new Serializable(this, conf){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;

            public final void apply(String codec) {
                CompressionCodecs$.MODULE$.setCodecConfiguration(this.conf$1, codec);
            }
            {
                this.conf$1 = conf$1;
            }
        });
        return new OutputWriterFactory(this, csvOptions){
            private final CSVOptions csvOptions$1;

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new CsvOutputWriter(path, dataSchema, context, this.csvOptions$1);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder().append((Object)".csv").append((Object)CodecStreams$.MODULE$.getCompressionExtension((JobContext)context)).toString();
            }
            {
                this.csvOptions$1 = csvOptions$1;
            }
        };
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        CSVUtils$.MODULE$.verifySchema(dataSchema);
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        CSVOptions parsedOptions = new CSVOptions(options, sparkSession.sessionState().conf().sessionLocalTimeZone(), sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        dataSchema.getFieldIndex(parsedOptions.columnNameOfCorruptRecord()).foreach((Function1)new Serializable(this, dataSchema){
            public static final long serialVersionUID = 0L;
            private final StructType dataSchema$1;

            public final void apply(int corruptFieldIndex) {
                this.apply$mcVI$sp(corruptFieldIndex);
            }

            public void apply$mcVI$sp(int corruptFieldIndex) {
                StructField f = this.dataSchema$1.apply(corruptFieldIndex);
                DataType dataType = f.dataType();
                StringType$ stringType$ = StringType$.MODULE$;
                if (!(dataType != null ? !dataType.equals(stringType$) : stringType$ != null) && f.nullable()) {
                    return;
                }
                throw new AnalysisException("The field for corrupt records must be string type and nullable", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            {
                this.dataSchema$1 = dataSchema$1;
            }
        });
        return new Serializable(this, dataSchema, requiredSchema, broadcastedHadoopConf, parsedOptions){
            public static final long serialVersionUID = 0L;
            private final StructType dataSchema$1;
            private final StructType requiredSchema$1;
            private final Broadcast broadcastedHadoopConf$1;
            public final CSVOptions parsedOptions$1;

            public final Iterator<InternalRow> apply(PartitionedFile file) {
                Configuration conf = ((SerializableConfiguration)this.broadcastedHadoopConf$1.value()).value();
                UnivocityParser parser = new UnivocityParser(StructType$.MODULE$.apply((Seq)this.dataSchema$1.filterNot((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$buildReader$2 $outer;

                    public final boolean apply(StructField x$1) {
                        String string = x$1.name();
                        String string2 = this.$outer.parsedOptions$1.columnNameOfCorruptRecord();
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                })), StructType$.MODULE$.apply((Seq)this.requiredSchema$1.filterNot((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$buildReader$2 $outer;

                    public final boolean apply(StructField x$2) {
                        String string = x$2.name();
                        String string2 = this.$outer.parsedOptions$1.columnNameOfCorruptRecord();
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                })), this.parsedOptions$1);
                return CSVDataSource$.MODULE$.apply(this.parsedOptions$1).readFile(conf, file, parser, this.requiredSchema$1);
            }
            {
                this.dataSchema$1 = dataSchema$1;
                this.requiredSchema$1 = requiredSchema$1;
                this.broadcastedHadoopConf$1 = broadcastedHadoopConf$1;
                this.parsedOptions$1 = parsedOptions$1;
            }
        };
    }

    public String toString() {
        return "CSV";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof CSVFileFormat;
    }
}

