/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class OracleDialect$
extends JdbcDialect
implements Product {
    public static final OracleDialect$ MODULE$;

    static {
        new OracleDialect$();
    }

    @Override
    public boolean canHandle(String url) {
        return url.startsWith("jdbc:oracle");
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        None$ none$;
        if (sqlType == 2) {
            long scale = md == null ? 0L : md.build().getLong("scale");
            int n = size;
            switch (n) {
                default: {
                    if (scale == -127L) {
                        none$ = Option$.MODULE$.apply((Object)new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), 10));
                        break;
                    }
                    none$ = None$.MODULE$;
                    break;
                }
                case 0: {
                    none$ = Option$.MODULE$.apply((Object)new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), 10));
                    break;
                }
            }
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        Object object;
        DataType dataType = dt;
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        DataType dataType2 = dataType;
        if (!(booleanType$ != null ? !booleanType$.equals(dataType2) : dataType2 != null)) {
            object = new Some((Object)new JdbcType("NUMBER(1)", 16));
        } else {
            IntegerType$ integerType$ = IntegerType$.MODULE$;
            DataType dataType3 = dataType;
            if (!(integerType$ != null ? !integerType$.equals(dataType3) : dataType3 != null)) {
                object = new Some((Object)new JdbcType("NUMBER(10)", 4));
            } else {
                LongType$ longType$ = LongType$.MODULE$;
                DataType dataType4 = dataType;
                if (!(longType$ != null ? !longType$.equals(dataType4) : dataType4 != null)) {
                    object = new Some((Object)new JdbcType("NUMBER(19)", -5));
                } else {
                    FloatType$ floatType$ = FloatType$.MODULE$;
                    DataType dataType5 = dataType;
                    if (!(floatType$ != null ? !floatType$.equals(dataType5) : dataType5 != null)) {
                        object = new Some((Object)new JdbcType("NUMBER(19, 4)", 6));
                    } else {
                        DoubleType$ doubleType$ = DoubleType$.MODULE$;
                        DataType dataType6 = dataType;
                        if (!(doubleType$ != null ? !doubleType$.equals(dataType6) : dataType6 != null)) {
                            object = new Some((Object)new JdbcType("NUMBER(19, 4)", 8));
                        } else {
                            ByteType$ byteType$ = ByteType$.MODULE$;
                            DataType dataType7 = dataType;
                            if (!(byteType$ != null ? !byteType$.equals(dataType7) : dataType7 != null)) {
                                object = new Some((Object)new JdbcType("NUMBER(3)", 5));
                            } else {
                                ShortType$ shortType$ = ShortType$.MODULE$;
                                DataType dataType8 = dataType;
                                if (!(shortType$ != null ? !shortType$.equals(dataType8) : dataType8 != null)) {
                                    object = new Some((Object)new JdbcType("NUMBER(5)", 5));
                                } else {
                                    StringType$ stringType$ = StringType$.MODULE$;
                                    DataType dataType9 = dataType;
                                    object = !(stringType$ != null ? !stringType$.equals(dataType9) : dataType9 != null) ? new Some((Object)new JdbcType("VARCHAR2(255)", 12)) : None$.MODULE$;
                                }
                            }
                        }
                    }
                }
            }
        }
        return object;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public String productPrefix() {
        return "OracleDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof OracleDialect$;
    }

    public int hashCode() {
        return 959235752;
    }

    public String toString() {
        return "OracleDialect";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private OracleDialect$() {
        MODULE$ = this;
        Product.class.$init$((Product)this);
    }
}

