/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortPrefix;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.execution.SortPrefixUtils$NoOpPrefixComparator$;
import org.apache.spark.sql.execution.UnsafeExternalRowSorter;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.util.collection.unsafe.sort.PrefixComparator;
import org.apache.spark.util.collection.unsafe.sort.PrefixComparators;

public final class SortPrefixUtils$ {
    public static final SortPrefixUtils$ MODULE$;

    static {
        new SortPrefixUtils$();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public PrefixComparator getPrefixComparator(SortOrder sortOrder) {
        boolean bl;
        void var5_12;
        boolean bl2 = false;
        DecimalType decimalType = null;
        DataType dataType = sortOrder.dataType();
        if (StringType$.MODULE$.equals(dataType)) {
            PrefixComparator prefixComparator = sortOrder.isAscending() ? PrefixComparators.STRING : PrefixComparators.STRING_DESC;
            return var5_12;
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            PrefixComparator prefixComparator = sortOrder.isAscending() ? PrefixComparators.BINARY : PrefixComparators.BINARY_DESC;
            return var5_12;
        }
        boolean bl3 = BooleanType$.MODULE$.equals(dataType) ? true : (ByteType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : (LongType$.MODULE$.equals(dataType) ? true : (DateType$.MODULE$.equals(dataType) ? true : TimestampType$.MODULE$.equals(dataType))))));
        if (bl3) {
            PrefixComparator prefixComparator = sortOrder.isAscending() ? PrefixComparators.LONG : PrefixComparators.LONG_DESC;
            return var5_12;
        }
        if (dataType instanceof DecimalType) {
            bl2 = true;
            decimalType = (DecimalType)dataType;
            if (decimalType.precision() - decimalType.scale() <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
                PrefixComparator prefixComparator = sortOrder.isAscending() ? PrefixComparators.LONG : PrefixComparators.LONG_DESC;
                return var5_12;
            }
        }
        if (bl = FloatType$.MODULE$.equals(dataType) ? true : DoubleType$.MODULE$.equals(dataType)) {
            PrefixComparator prefixComparator = sortOrder.isAscending() ? PrefixComparators.DOUBLE : PrefixComparators.DOUBLE_DESC;
            return var5_12;
        }
        if (!bl2) {
            SortPrefixUtils$NoOpPrefixComparator$ sortPrefixUtils$NoOpPrefixComparator$ = SortPrefixUtils$NoOpPrefixComparator$.MODULE$;
            return var5_12;
        }
        PrefixComparator prefixComparator = sortOrder.isAscending() ? PrefixComparators.DOUBLE : PrefixComparators.DOUBLE_DESC;
        return var5_12;
    }

    public PrefixComparator getPrefixComparator(StructType schema) {
        PrefixComparator prefixComparator;
        if (schema.nonEmpty()) {
            StructField field = (StructField)schema.head();
            prefixComparator = this.getPrefixComparator(new SortOrder((Expression)new BoundReference(0, field.dataType(), field.nullable()), (SortDirection)Ascending$.MODULE$));
        } else {
            prefixComparator = new PrefixComparator(){

                public int compare(long prefix1, long prefix2) {
                    return 0;
                }
            };
        }
        return prefixComparator;
    }

    public boolean canSortFullyWithPrefix(SortOrder sortOrder) {
        boolean bl;
        DataType dataType = sortOrder.dataType();
        if (LongType$.MODULE$.equals(dataType) && sortOrder.nullable()) {
            bl = false;
        } else {
            DecimalType decimalType;
            boolean bl2 = BooleanType$.MODULE$.equals(dataType) ? true : (ByteType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : (LongType$.MODULE$.equals(dataType) ? true : (DateType$.MODULE$.equals(dataType) ? true : (TimestampType$.MODULE$.equals(dataType) ? true : (FloatType$.MODULE$.equals(dataType) ? true : DoubleType$.MODULE$.equals(dataType))))))));
            bl = bl2 ? true : dataType instanceof DecimalType && (decimalType = (DecimalType)dataType).precision() <= Decimal$.MODULE$.MAX_LONG_DIGITS();
        }
        return bl;
    }

    public boolean canSortFullyWithPrefix(StructField field) {
        return this.canSortFullyWithPrefix(new SortOrder((Expression)new BoundReference(0, field.dataType(), field.nullable()), (SortDirection)Ascending$.MODULE$));
    }

    public UnsafeExternalRowSorter.PrefixComputer createPrefixGenerator(StructType schema) {
        UnsafeExternalRowSorter.PrefixComputer prefixComputer;
        if (schema.nonEmpty()) {
            BoundReference boundReference = new BoundReference(0, ((StructField)schema.head()).dataType(), true);
            UnsafeProjection prefixProjection = UnsafeProjection$.MODULE$.create((Expression)new SortPrefix(new SortOrder((Expression)boundReference, (SortDirection)Ascending$.MODULE$)));
            prefixComputer = new UnsafeExternalRowSorter.PrefixComputer(prefixProjection){
                private final UnsafeProjection prefixProjection$1;

                public long computePrefix(InternalRow row) {
                    return this.prefixProjection$1.apply(row).getLong(0);
                }
                {
                    this.prefixProjection$1 = prefixProjection$1;
                }
            };
        } else {
            prefixComputer = new UnsafeExternalRowSorter.PrefixComputer(){

                public long computePrefix(InternalRow row) {
                    return 0L;
                }
            };
        }
        return prefixComputer;
    }

    private SortPrefixUtils$() {
        MODULE$ = this;
    }
}

