/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.jdbc;

import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.apache.spark.sql.execution.datasources.jdbc.DriverWrapper;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class JdbcUtils$
implements Logging {
    public static final JdbcUtils$ MODULE$;
    private final String JDBC_BATCH_FETCH_SIZE;
    private final String JDBC_BATCH_INSERT_SIZE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new JdbcUtils$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public String JDBC_BATCH_FETCH_SIZE() {
        return this.JDBC_BATCH_FETCH_SIZE;
    }

    public String JDBC_BATCH_INSERT_SIZE() {
        return this.JDBC_BATCH_INSERT_SIZE;
    }

    public Function0<Connection> createConnectionFactory(String url, Properties properties) {
        Option userSpecifiedDriverClass = Option$.MODULE$.apply((Object)properties.getProperty("driver"));
        userSpecifiedDriverClass.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(String className) {
                DriverRegistry$.MODULE$.register(className);
            }
        });
        String driverClass = (String)userSpecifiedDriverClass.getOrElse((Function0)new Serializable(url){
            public static final long serialVersionUID = 0L;
            private final String url$1;

            public final String apply() {
                return DriverManager.getDriver(this.url$1).getClass().getCanonicalName();
            }
            {
                this.url$1 = url$1;
            }
        });
        return new Serializable(url, properties, userSpecifiedDriverClass, driverClass){
            public static final long serialVersionUID = 0L;
            private final String url$1;
            private final Properties properties$1;
            private final Option userSpecifiedDriverClass$1;
            public final String driverClass$1;

            public final Connection apply() {
                this.userSpecifiedDriverClass$1.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(String className) {
                        DriverRegistry$.MODULE$.register(className);
                    }
                });
                Driver driver = (Driver)((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(DriverManager.getDrivers()).asScala()).collectFirst((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.createConnectionFactory.2 $outer;

                    /*
                     * WARNING - void declaration
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends Driver, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        void var6_9;
                        A1 A1 = x1;
                        if (A1 instanceof DriverWrapper) {
                            DriverWrapper driverWrapper = (DriverWrapper)A1;
                            String string = driverWrapper.wrapped().getClass().getCanonicalName();
                            String string2 = this.$outer.driverClass$1;
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                DriverWrapper driverWrapper2 = driverWrapper;
                                return var6_9;
                            }
                        }
                        String string = A1.getClass().getCanonicalName();
                        String string3 = this.$outer.driverClass$1;
                        if (!(string != null ? !string.equals(string3) : string3 != null)) {
                            A1 A12 = A1;
                            return var6_9;
                        }
                        Object object = function1.apply(x1);
                        return var6_9;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean isDefinedAt(Driver x1) {
                        Driver driver = x1;
                        if (driver instanceof DriverWrapper) {
                            DriverWrapper driverWrapper = (DriverWrapper)driver;
                            String string = driverWrapper.wrapped().getClass().getCanonicalName();
                            String string2 = this.$outer.driverClass$1;
                            if (string == null) {
                                if (string2 == null) return true;
                            } else if (string.equals(string2)) {
                                return true;
                            }
                        }
                        String string = driver.getClass().getCanonicalName();
                        String string3 = this.$outer.driverClass$1;
                        if (string != null) {
                            if (!string.equals(string3)) return false;
                            return true;
                        }
                        if (string3 == null) return true;
                        return false;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.createConnectionFactory.2 $outer;

                    public final Nothing$ apply() {
                        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not find registered driver with class ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.driverClass$1})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return driver.connect(this.url$1, this.properties$1);
            }
            {
                this.url$1 = url$1;
                this.properties$1 = properties$1;
                this.userSpecifiedDriverClass$1 = userSpecifiedDriverClass$1;
                this.driverClass$1 = driverClass$1;
            }
        };
    }

    public boolean tableExists(Connection conn, String url, String table) {
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(url);
        return Try$.MODULE$.apply((Function0)new Serializable(conn, table, dialect){
            public static final long serialVersionUID = 0L;
            private final Connection conn$1;
            private final String table$1;
            private final JdbcDialect dialect$1;

            /*
             * WARNING - void declaration
             */
            public final ResultSet apply() {
                ResultSet resultSet;
                PreparedStatement statement = this.conn$1.prepareStatement(this.dialect$1.getTableExistsQuery(this.table$1));
                try {
                    resultSet = statement.executeQuery();
                }
                catch (Throwable throwable) {
                    void var1_1;
                    var1_1.close();
                    throw throwable;
                }
                statement.close();
                return resultSet;
            }
            {
                this.conn$1 = conn$1;
                this.table$1 = table$1;
                this.dialect$1 = dialect$1;
            }
        }).isSuccess();
    }

    /*
     * WARNING - void declaration
     */
    public void dropTable(Connection conn, String table) {
        Statement statement = conn.createStatement();
        try {
            statement.executeUpdate(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP TABLE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table})));
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        statement.close();
    }

    public PreparedStatement insertStatement(Connection conn, String table, StructType rddSchema, JdbcDialect dialect) {
        String columns2 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])rddSchema.fields()).map((Function1)new Serializable(dialect){
            public static final long serialVersionUID = 0L;
            private final JdbcDialect dialect$2;

            public final String apply(StructField x) {
                return this.dialect$2.quoteIdentifier(x.name());
            }
            {
                this.dialect$2 = dialect$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(",");
        String placeholders = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])rddSchema.fields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$1) {
                return "?";
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(",");
        String sql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", " (", ") VALUES (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table, columns2, placeholders}));
        return conn.prepareStatement(sql);
    }

    public Option<JdbcType> getCommonJDBCType(DataType dt) {
        Option option;
        DataType dataType = dt;
        if (IntegerType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("INTEGER", 4));
        } else if (LongType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("BIGINT", -5));
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("DOUBLE PRECISION", 8));
        } else if (FloatType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("REAL", 6));
        } else if (ShortType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("INTEGER", 5));
        } else if (ByteType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("BYTE", -6));
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("BIT(1)", -7));
        } else if (StringType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("TEXT", 2005));
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("BLOB", 2004));
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("TIMESTAMP", 93));
        } else if (DateType$.MODULE$.equals(dataType)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("DATE", 91));
        } else if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            option = Option$.MODULE$.apply((Object)new JdbcType(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DECIMAL(", ",", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)decimalType.precision()), BoxesRunTime.boxToInteger((int)decimalType.scale())})), 3));
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    public JdbcType org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$getJdbcType(DataType dt, JdbcDialect dialect) {
        return (JdbcType)dialect.getJDBCType(dt).orElse((Function0)new Serializable(dt){
            public static final long serialVersionUID = 0L;
            private final DataType dt$1;

            public final Option<JdbcType> apply() {
                return JdbcUtils$.MODULE$.getCommonJDBCType(this.dt$1);
            }
            {
                this.dt$1 = dt$1;
            }
        }).getOrElse((Function0)new Serializable(dt){
            public static final long serialVersionUID = 0L;
            private final DataType dt$1;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't get JDBC type for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dt$1.simpleString()})));
            }
            {
                this.dt$1 = dt$1;
            }
        });
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public Iterator<Object> savePartition(Function0<Connection> getConnection, String table, Iterator<Row> iterator2, StructType rddSchema, int[] nullTypes, int batchSize, JdbcDialect dialect) {
        block35: {
            boolean supportsTransactions;
            boolean committed;
            Connection conn;
            block34: {
                boolean bl;
                Predef$.MODULE$.require(batchSize >= 1, (Function0)new Serializable(batchSize){
                    public static final long serialVersionUID = 0L;
                    private final int batchSize$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid value `", "` for parameter "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Object)BoxesRunTime.boxToInteger((int)this.batchSize$1)).toString()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`", "`. The minimum value is 1."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JdbcUtils$.MODULE$.JDBC_BATCH_INSERT_SIZE()}))).toString();
                    }
                    {
                        this.batchSize$1 = batchSize$1;
                    }
                });
                conn = (Connection)getConnection.apply();
                committed = false;
                try {
                    bl = conn.getMetaData().supportsDataManipulationTransactionsOnly() || conn.getMetaData().supportsDataDefinitionAndDataManipulationTransactions();
                }
                catch (Throwable throwable) {
                    boolean bl2;
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    this.logWarning((Function0<String>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Exception while detecting transaction support";
                        }
                    }, e);
                    bl = bl2 = true;
                }
                supportsTransactions = bl;
                if (supportsTransactions) {
                    conn.setAutoCommit(false);
                }
                PreparedStatement stmt = this.insertStatement(conn, table, rddSchema, dialect);
                int rowCount = 0;
                while (iterator2.hasNext()) {
                    Row row = (Row)iterator2.next();
                    int numFields = rddSchema.fields().length;
                    for (int i = 0; i < numFields; ++i) {
                        BoxedUnit boxedUnit;
                        if (row.isNullAt(i)) {
                            stmt.setNull(i + 1, nullTypes[i]);
                            continue;
                        }
                        DataType dataType = rddSchema.fields()[i].dataType();
                        if (IntegerType$.MODULE$.equals(dataType)) {
                            stmt.setInt(i + 1, row.getInt(i));
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        if (LongType$.MODULE$.equals(dataType)) {
                            stmt.setLong(i + 1, row.getLong(i));
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        if (DoubleType$.MODULE$.equals(dataType)) {
                            stmt.setDouble(i + 1, row.getDouble(i));
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        if (FloatType$.MODULE$.equals(dataType)) {
                            stmt.setFloat(i + 1, row.getFloat(i));
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        if (ShortType$.MODULE$.equals(dataType)) {
                            stmt.setInt(i + 1, row.getShort(i));
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        if (ByteType$.MODULE$.equals(dataType)) {
                            stmt.setInt(i + 1, row.getByte(i));
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        if (BooleanType$.MODULE$.equals(dataType)) {
                            stmt.setBoolean(i + 1, row.getBoolean(i));
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        if (StringType$.MODULE$.equals(dataType)) {
                            stmt.setString(i + 1, row.getString(i));
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        if (BinaryType$.MODULE$.equals(dataType)) {
                            stmt.setBytes(i + 1, (byte[])row.getAs(i));
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        if (TimestampType$.MODULE$.equals(dataType)) {
                            stmt.setTimestamp(i + 1, (Timestamp)row.getAs(i));
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        if (DateType$.MODULE$.equals(dataType)) {
                            stmt.setDate(i + 1, (Date)row.getAs(i));
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        if (dataType instanceof DecimalType) {
                            stmt.setBigDecimal(i + 1, row.getDecimal(i));
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        if (dataType instanceof ArrayType) {
                            ArrayType arrayType = (ArrayType)dataType;
                            DataType et = arrayType.elementType();
                            String typeName = this.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$getJdbcType(et, dialect).databaseTypeDefinition().toLowerCase().split("\\(")[0];
                            Array array2 = conn.createArrayOf(typeName, (Object[])row.getSeq(i).toArray(ClassTag$.MODULE$.AnyRef()));
                            stmt.setArray(i + 1, array2);
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't translate non-null value for field ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})));
                    }
                    stmt.addBatch();
                    if (++rowCount % batchSize != 0) continue;
                    stmt.executeBatch();
                    rowCount = 0;
                }
                Object object = rowCount > 0 ? (Object)stmt.executeBatch() : BoxedUnit.UNIT;
                stmt.close();
                if (supportsTransactions) {
                    conn.commit();
                }
                if (!(committed = true)) break block34;
                try {
                    conn.close();
                }
                catch (Exception exception) {
                    this.logWarning((Function0<String>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Transaction succeeded, but closing failed";
                        }
                    }, exception);
                }
            }
            if (supportsTransactions) {
                conn.rollback();
            }
            conn.close();
            break block35;
            {
                catch (Throwable throwable) {
                    try {
                        void var16_16;
                        var16_16.close();
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        if (committed) {
                            try {
                                conn.close();
                            }
                            catch (Exception exception) {
                                this.logWarning((Function0<String>)new /* invalid duplicate definition of identical inner class */, exception);
                            }
                        } else {
                            if (supportsTransactions) {
                                conn.rollback();
                            }
                            conn.close();
                        }
                        throw throwable3;
                    }
                }
            }
        }
        return Predef$.MODULE$.byteArrayOps((byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte())).iterator();
    }

    public String schemaString(Dataset<Row> df, String url) {
        StringBuilder sb = new StringBuilder();
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(url);
        Predef$.MODULE$.refArrayOps((Object[])df.schema().fields()).foreach((Function1)new Serializable(sb, dialect){
            public static final long serialVersionUID = 0L;
            private final StringBuilder sb$1;
            private final JdbcDialect dialect$3;

            public final StringBuilder apply(StructField field) {
                String name = this.dialect$3.quoteIdentifier(field.name());
                String typ = JdbcUtils$.MODULE$.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$getJdbcType(field.dataType(), this.dialect$3).databaseTypeDefinition();
                String nullable = field.nullable() ? "" : "NOT NULL";
                return this.sb$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", ", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, typ, nullable})));
            }
            {
                this.sb$1 = sb$1;
                this.dialect$3 = dialect$3;
            }
        });
        return sb.length() < 2 ? "" : sb.substring(2);
    }

    public void saveTable(Dataset<Row> df, String url, String table, Properties properties) {
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(url);
        int[] nullTypes = (int[])Predef$.MODULE$.refArrayOps((Object[])df.schema().fields()).map((Function1)new Serializable(dialect){
            public static final long serialVersionUID = 0L;
            private final JdbcDialect dialect$4;

            public final int apply(StructField field) {
                return JdbcUtils$.MODULE$.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$getJdbcType(field.dataType(), this.dialect$4).jdbcNullType();
            }
            {
                this.dialect$4 = dialect$4;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        StructType rddSchema = df.schema();
        Function0<Connection> getConnection = this.createConnectionFactory(url, properties);
        int batchSize = new StringOps(Predef$.MODULE$.augmentString(properties.getProperty(this.JDBC_BATCH_INSERT_SIZE(), "1000"))).toInt();
        df.foreachPartition((Function1<Iterator<Row>, BoxedUnit>)new Serializable(table, dialect, nullTypes, rddSchema, getConnection, batchSize){
            public static final long serialVersionUID = 0L;
            private final String table$2;
            private final JdbcDialect dialect$4;
            private final int[] nullTypes$1;
            private final StructType rddSchema$1;
            private final Function0 getConnection$1;
            private final int batchSize$2;

            public final void apply(Iterator<Row> iterator2) {
                JdbcUtils$.MODULE$.savePartition((Function0<Connection>)this.getConnection$1, this.table$2, iterator2, this.rddSchema$1, this.nullTypes$1, this.batchSize$2, this.dialect$4);
            }
            {
                this.table$2 = table$2;
                this.dialect$4 = dialect$4;
                this.nullTypes$1 = nullTypes$1;
                this.rddSchema$1 = rddSchema$1;
                this.getConnection$1 = getConnection$1;
                this.batchSize$2 = batchSize$2;
            }
        });
    }

    private JdbcUtils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.JDBC_BATCH_FETCH_SIZE = "fetchsize";
        this.JDBC_BATCH_INSERT_SIZE = "batchsize";
    }
}

