/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal;

import java.util.Locale;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat$;
import org.apache.spark.sql.internal.HiveSerDe;
import org.apache.spark.sql.internal.SQLConf;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;

public final class HiveSerDe$
implements Serializable {
    public static final HiveSerDe$ MODULE$;
    private final Map<String, HiveSerDe> serdeMap;

    static {
        new HiveSerDe$();
    }

    public Map<String, HiveSerDe> serdeMap() {
        return this.serdeMap;
    }

    public Option<HiveSerDe> sourceToSerDe(String source) {
        String string = source.toLowerCase(Locale.ROOT);
        String string2 = string.startsWith("org.apache.spark.sql.parquet") ? "parquet" : (string.startsWith("org.apache.spark.sql.orc") ? "orc" : (string.startsWith("org.apache.spark.sql.hive.orc") ? "orc" : (string.equals("orcfile") ? "orc" : (string.equals("parquetfile") ? "parquet" : (string.equals("avrofile") ? "avro" : string)))));
        String key = string2;
        return this.serdeMap().get((Object)key);
    }

    public CatalogStorageFormat getDefaultStorage(SQLConf conf) {
        String defaultStorageType = conf.getConfString("hive.default.fileformat", "textfile");
        Option<HiveSerDe> defaultHiveSerde = this.sourceToSerDe(defaultStorageType);
        Option x$4 = defaultHiveSerde.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(HiveSerDe x$1) {
                return x$1.inputFormat();
            }
        }).orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Some<String> apply() {
                return new Some((Object)"org.apache.hadoop.mapred.TextInputFormat");
            }
        });
        Option x$5 = defaultHiveSerde.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(HiveSerDe x$2) {
                return x$2.outputFormat();
            }
        }).orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Some<String> apply() {
                return new Some((Object)"org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat");
            }
        });
        Option x$6 = defaultHiveSerde.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(HiveSerDe x$3) {
                return x$3.serde();
            }
        }).orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Some<String> apply() {
                return new Some((Object)"org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe");
            }
        });
        Option x$7 = CatalogStorageFormat$.MODULE$.empty().copy$default$1();
        boolean x$8 = CatalogStorageFormat$.MODULE$.empty().copy$default$5();
        Map x$9 = CatalogStorageFormat$.MODULE$.empty().copy$default$6();
        return CatalogStorageFormat$.MODULE$.empty().copy(x$7, x$4, x$5, x$6, x$8, x$9);
    }

    public HiveSerDe apply(Option<String> inputFormat, Option<String> outputFormat, Option<String> serde) {
        return new HiveSerDe(inputFormat, outputFormat, serde);
    }

    public Option<Tuple3<Option<String>, Option<String>, Option<String>>> unapply(HiveSerDe x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3(x$0.inputFormat(), x$0.outputFormat(), x$0.serde()));
    }

    public Option<String> $lessinit$greater$default$1() {
        return None$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$2() {
        return None$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$1() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$2() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$3() {
        return None$.MODULE$;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private HiveSerDe$() {
        MODULE$ = this;
        this.serdeMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sequencefile"), (Object)new HiveSerDe((Option<String>)Option$.MODULE$.apply((Object)"org.apache.hadoop.mapred.SequenceFileInputFormat"), (Option<String>)Option$.MODULE$.apply((Object)"org.apache.hadoop.mapred.SequenceFileOutputFormat"), (Option<String>)Option$.MODULE$.apply((Object)"org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe"))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rcfile"), (Object)new HiveSerDe((Option<String>)Option$.MODULE$.apply((Object)"org.apache.hadoop.hive.ql.io.RCFileInputFormat"), (Option<String>)Option$.MODULE$.apply((Object)"org.apache.hadoop.hive.ql.io.RCFileOutputFormat"), (Option<String>)Option$.MODULE$.apply((Object)"org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe"))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"orc"), (Object)new HiveSerDe((Option<String>)Option$.MODULE$.apply((Object)"org.apache.hadoop.hive.ql.io.orc.OrcInputFormat"), (Option<String>)Option$.MODULE$.apply((Object)"org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat"), (Option<String>)Option$.MODULE$.apply((Object)"org.apache.hadoop.hive.ql.io.orc.OrcSerde"))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parquet"), (Object)new HiveSerDe((Option<String>)Option$.MODULE$.apply((Object)"org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat"), (Option<String>)Option$.MODULE$.apply((Object)"org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat"), (Option<String>)Option$.MODULE$.apply((Object)"org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe"))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"textfile"), (Object)new HiveSerDe((Option<String>)Option$.MODULE$.apply((Object)"org.apache.hadoop.mapred.TextInputFormat"), (Option<String>)Option$.MODULE$.apply((Object)"org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat"), (Option<String>)Option$.MODULE$.apply((Object)"org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe"))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"avro"), (Object)new HiveSerDe((Option<String>)Option$.MODULE$.apply((Object)"org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat"), (Option<String>)Option$.MODULE$.apply((Object)"org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat"), (Option<String>)Option$.MODULE$.apply((Object)"org.apache.hadoop.hive.serde2.avro.AvroSerDe")))}));
    }
}

