/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.util.Locale;
import java.util.Properties;
import org.apache.spark.Partition;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.DataFrameReader$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.FailureSafeParser;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions$;
import org.apache.spark.sql.execution.datasources.csv.CSVUtils$;
import org.apache.spark.sql.execution.datasources.csv.TextInputCSVDataSource$;
import org.apache.spark.sql.execution.datasources.csv.UnivocityParser;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartition;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation;
import org.apache.spark.sql.execution.datasources.json.TextInputJsonDataSource$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.DataSourceV2;
import org.apache.spark.sql.sources.v2.ReadSupport;
import org.apache.spark.sql.sources.v2.ReadSupportWithSchema;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@InterfaceStability.Stable
@ScalaSignature(bytes="\u0006\u0001\tEe\u0001B\u0001\u0003\u0001-\u0011q\u0002R1uC\u001a\u0013\u0018-\\3SK\u0006$WM\u001d\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7\u0001A\n\u0004\u00011\u0011\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u0018)\t9Aj\\4hS:<\u0007\u0002C\r\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005maR\"\u0001\u0002\n\u0005u\u0011!\u0001D*qCJ\\7+Z:tS>t\u0007BB\u0010\u0001\t\u0003\u0011\u0001%\u0001\u0004=S:LGO\u0010\u000b\u0003C\t\u0002\"a\u0007\u0001\t\u000beq\u0002\u0019\u0001\u000e\t\u000b\u0011\u0002A\u0011A\u0013\u0002\r\u0019|'/\\1u)\t\tc\u0005C\u0003(G\u0001\u0007\u0001&\u0001\u0004t_V\u00148-\u001a\t\u0003S1r!!\u0004\u0016\n\u0005-r\u0011A\u0002)sK\u0012,g-\u0003\u0002.]\t11\u000b\u001e:j]\u001eT!a\u000b\b\t\u000bA\u0002A\u0011A\u0019\u0002\rM\u001c\u0007.Z7b)\t\t#\u0007C\u00031_\u0001\u00071\u0007\u0005\u00025o5\tQG\u0003\u00027\u0005\u0005)A/\u001f9fg&\u0011\u0001(\u000e\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\"\u0002\u0019\u0001\t\u0003QDCA\u0011<\u0011\u0015a\u0014\b1\u0001)\u00031\u00198\r[3nCN#(/\u001b8h\u0011\u0015q\u0004\u0001\"\u0001@\u0003\u0019y\u0007\u000f^5p]R\u0019\u0011\u0005\u0011\"\t\u000b\u0005k\u0004\u0019\u0001\u0015\u0002\u0007-,\u0017\u0010C\u0003D{\u0001\u0007\u0001&A\u0003wC2,X\rC\u0003?\u0001\u0011\u0005Q\tF\u0002\"\r\u001eCQ!\u0011#A\u0002!BQa\u0011#A\u0002!\u0003\"!D%\n\u0005)s!a\u0002\"p_2,\u0017M\u001c\u0005\u0006}\u0001!\t\u0001\u0014\u000b\u0004C5s\u0005\"B!L\u0001\u0004A\u0003\"B\"L\u0001\u0004y\u0005CA\u0007Q\u0013\t\tfB\u0001\u0003M_:<\u0007\"\u0002 \u0001\t\u0003\u0019FcA\u0011U+\")\u0011I\u0015a\u0001Q!)1I\u0015a\u0001-B\u0011QbV\u0005\u00031:\u0011a\u0001R8vE2,\u0007\"\u0002.\u0001\t\u0003Y\u0016aB8qi&|gn\u001d\u000b\u0003CqCQAW-A\u0002u\u0003BAX1)Q5\tqL\u0003\u0002a\u001d\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\t|&aA'ba\")!\f\u0001C\u0001IR\u0011\u0011%\u001a\u0005\u00065\u000e\u0004\rA\u001a\t\u0005O2D\u0003&D\u0001i\u0015\tI'.\u0001\u0003vi&d'\"A6\u0002\t)\fg/Y\u0005\u0003E\"DQA\u001c\u0001\u0005\u0002=\fA\u0001\\8bIR\t\u0001\u000f\u0005\u0002ri:\u00111D]\u0005\u0003g\n\tq\u0001]1dW\u0006<W-\u0003\u0002vm\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003g\nAQA\u001c\u0001\u0005\u0002a$\"\u0001]=\t\u000bi<\b\u0019\u0001\u0015\u0002\tA\fG\u000f\u001b\u0005\u0006]\u0002!\t\u0001 \u000b\u0003avDQA`>A\u0002}\fQ\u0001]1uQN\u0004B!DA\u0001Q%\u0019\u00111\u0001\b\u0003\u0015q\u0012X\r]3bi\u0016$g\bK\u0002|\u0003\u000f\u0001B!!\u0003\u0002\u00105\u0011\u00111\u0002\u0006\u0004\u0003\u001bq\u0011AC1o]>$\u0018\r^5p]&!\u0011\u0011CA\u0006\u0005\u001d1\u0018M]1sONDq!!\u0006\u0001\t\u0013\t9\"\u0001\u0007m_\u0006$g+M*pkJ\u001cW\rF\u0002q\u00033AaA`A\n\u0001\u0004y\bbBA\u000f\u0001\u0011\u0005\u0011qD\u0001\u0005U\u0012\u00147\rF\u0004q\u0003C\t)#!\u000b\t\u000f\u0005\r\u00121\u0004a\u0001Q\u0005\u0019QO\u001d7\t\u000f\u0005\u001d\u00121\u0004a\u0001Q\u0005)A/\u00192mK\"A\u00111FA\u000e\u0001\u0004\ti#\u0001\u0006qe>\u0004XM\u001d;jKN\u00042aZA\u0018\u0013\r\t\t\u0004\u001b\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbBA\u000f\u0001\u0011\u0005\u0011Q\u0007\u000b\u0010a\u0006]\u0012\u0011HA\u001e\u0003\u007f\t\u0019%a\u0012\u0002R!9\u00111EA\u001a\u0001\u0004A\u0003bBA\u0014\u0003g\u0001\r\u0001\u000b\u0005\b\u0003{\t\u0019\u00041\u0001)\u0003)\u0019w\u000e\\;n]:\u000bW.\u001a\u0005\b\u0003\u0003\n\u0019\u00041\u0001P\u0003)awn^3s\u0005>,h\u000e\u001a\u0005\b\u0003\u000b\n\u0019\u00041\u0001P\u0003))\b\u000f]3s\u0005>,h\u000e\u001a\u0005\t\u0003\u0013\n\u0019\u00041\u0001\u0002L\u0005ia.^7QCJ$\u0018\u000e^5p]N\u00042!DA'\u0013\r\tyE\u0004\u0002\u0004\u0013:$\b\u0002CA*\u0003g\u0001\r!!\f\u0002)\r|gN\\3di&|g\u000e\u0015:pa\u0016\u0014H/[3t\u0011\u001d\ti\u0002\u0001C\u0001\u0003/\"\u0012\u0002]A-\u00037\ni&a\u001a\t\u000f\u0005\r\u0012Q\u000ba\u0001Q!9\u0011qEA+\u0001\u0004A\u0003\u0002CA0\u0003+\u0002\r!!\u0019\u0002\u0015A\u0014X\rZ5dCR,7\u000f\u0005\u0003\u000e\u0003GB\u0013bAA3\u001d\t)\u0011I\u001d:bs\"A\u00111KA+\u0001\u0004\ti\u0003C\u0004\u0002l\u0001!\t!!\u001c\u0002\t)\u001cxN\u001c\u000b\u0004a\u0006=\u0004B\u0002>\u0002j\u0001\u0007\u0001\u0006C\u0004\u0002l\u0001!\t!a\u001d\u0015\u0007A\f)\b\u0003\u0004\u007f\u0003c\u0002\ra \u0015\u0005\u0003c\n9\u0001C\u0004\u0002l\u0001!\t!a\u001f\u0015\u0007A\fi\b\u0003\u0005\u0002\u0000\u0005e\u0004\u0019AAA\u0003\u001dQ7o\u001c8S\t\u0012\u0003R!a!\u0002\f\"j!!!\"\u000b\u0007-\f9IC\u0002\u0002\n\u0012\t1!\u00199j\u0013\u0011\ti)!\"\u0003\u000f)\u000bg/\u0019*E\t\"B\u0011\u0011PAI\u0003/\u000bY\nE\u0002\u000e\u0003'K1!!&\u000f\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0003\u00033\u000b!%V:fA)\u001cxN\u001c\u0015ECR\f7/\u001a;\\'R\u0014\u0018N\\4^S\u0001Jgn\u001d;fC\u0012t\u0013EAAO\u0003\u0015\u0011dF\r\u00181\u0011\u001d\tY\u0007\u0001C\u0001\u0003C#2\u0001]AR\u0011!\ty(a(A\u0002\u0005\u0015\u0006#BAT\u0003[CSBAAU\u0015\r\tY\u000bB\u0001\u0004e\u0012$\u0017\u0002BAX\u0003S\u00131A\u0015#EQ!\ty*!%\u0002\u0018\u0006m\u0005bBA6\u0001\u0011\u0005\u0011Q\u0017\u000b\u0004a\u0006]\u0006\u0002CA]\u0003g\u0003\r!a/\u0002\u0017)\u001cxN\u001c#bi\u0006\u001cX\r\u001e\t\u00057\u0005u\u0006&C\u0002\u0002@\n\u0011q\u0001R1uCN,G\u000fC\u0004\u0002D\u0002!\t!!2\u0002\u0007\r\u001ch\u000fF\u0002q\u0003\u000fDaA_Aa\u0001\u0004A\u0003bBAb\u0001\u0011\u0005\u00111\u001a\u000b\u0004a\u00065\u0007\u0002CAh\u0003\u0013\u0004\r!a/\u0002\u0015\r\u001ch\u000fR1uCN,G\u000fC\u0004\u0002D\u0002!\t!a5\u0015\u0007A\f)\u000e\u0003\u0004\u007f\u0003#\u0004\ra \u0015\u0005\u0003#\f9\u0001C\u0004\u0002\\\u0002!\t!!8\u0002\u000fA\f'/];fiR\u0019\u0001/a8\t\ri\fI\u000e1\u0001)\u0011\u001d\tY\u000e\u0001C\u0001\u0003G$2\u0001]As\u0011\u0019q\u0018\u0011\u001da\u0001\u007f\"\"\u0011\u0011]A\u0004\u0011\u001d\tY\u000f\u0001C\u0001\u0003[\f1a\u001c:d)\r\u0001\u0018q\u001e\u0005\u0007u\u0006%\b\u0019\u0001\u0015\t\u000f\u0005-\b\u0001\"\u0001\u0002tR\u0019\u0001/!>\t\ry\f\t\u00101\u0001\u0000Q\u0011\t\t0a\u0002\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002|R\u0019\u0001/!@\t\u000f\u0005}\u0018\u0011 a\u0001Q\u0005IA/\u00192mK:\u000bW.\u001a\u0005\b\u0005\u0007\u0001A\u0011\u0001B\u0003\u0003\u0011!X\r\u001f;\u0015\u0007A\u00149\u0001\u0003\u0004{\u0005\u0003\u0001\r\u0001\u000b\u0005\b\u0005\u0007\u0001A\u0011\u0001B\u0006)\r\u0001(Q\u0002\u0005\u0007}\n%\u0001\u0019A@)\t\t%\u0011q\u0001\u0005\b\u0005'\u0001A\u0011\u0001B\u000b\u0003!!X\r\u001f;GS2,G\u0003BA^\u0005/AaA\u001fB\t\u0001\u0004A\u0003b\u0002B\n\u0001\u0011\u0005!1\u0004\u000b\u0005\u0003w\u0013i\u0002\u0003\u0004\u007f\u00053\u0001\ra \u0015\u0005\u00053\t9\u0001C\u0004\u0003$\u0001!IA!\n\u0002/\u0005\u001c8/\u001a:u\u001d>\u001c\u0006/Z2jM&,GmU2iK6\fG\u0003\u0002B\u0014\u0005[\u00012!\u0004B\u0015\u0013\r\u0011YC\u0004\u0002\u0005+:LG\u000fC\u0004\u00030\t\u0005\u0002\u0019\u0001\u0015\u0002\u0013=\u0004XM]1uS>t\u0007b\u0002B\u001a\u0001\u0011%!QG\u0001 m\u0016\u0014\u0018NZ=D_2,XN\u001c(b[\u0016|emQ8seV\u0004HOU3d_J$GC\u0002B\u0014\u0005o\u0011I\u0004\u0003\u00041\u0005c\u0001\ra\r\u0005\b\u0005w\u0011\t\u00041\u0001)\u0003e\u0019w\u000e\\;n]:\u000bW.Z(g\u0007>\u0014(/\u001e9u%\u0016\u001cwN\u001d3\t\u0011\u001d\u0002\u0001\u0019!C\u0005\u0005\u007f)\u0012\u0001\u000b\u0005\n\u0005\u0007\u0002\u0001\u0019!C\u0005\u0005\u000b\n!b]8ve\u000e,w\fJ3r)\u0011\u00119Ca\u0012\t\u0013\t%#\u0011IA\u0001\u0002\u0004A\u0013a\u0001=%c!9!Q\n\u0001!B\u0013A\u0013aB:pkJ\u001cW\r\t\u0005\n\u0005#\u0002\u0001\u0019!C\u0005\u0005'\n1#^:feN\u0003XmY5gS\u0016$7k\u00195f[\u0006,\"A!\u0016\u0011\t5\u00119fM\u0005\u0004\u00053r!AB(qi&|g\u000eC\u0005\u0003^\u0001\u0001\r\u0011\"\u0003\u0003`\u00059Ro]3s'B,7-\u001b4jK\u0012\u001c6\r[3nC~#S-\u001d\u000b\u0005\u0005O\u0011\t\u0007\u0003\u0006\u0003J\tm\u0013\u0011!a\u0001\u0005+B\u0001B!\u001a\u0001A\u0003&!QK\u0001\u0015kN,'o\u00159fG&4\u0017.\u001a3TG\",W.\u0019\u0011\t\u0013\t%\u0004A1A\u0005\n\t-\u0014\u0001D3yiJ\fw\n\u001d;j_:\u001cXC\u0001B7!\u0019\u0011yG!\u001e)Q5\u0011!\u0011\u000f\u0006\u0004\u0005gz\u0016aB7vi\u0006\u0014G.Z\u0005\u0005\u0005o\u0012\tHA\u0004ICNDW*\u00199\t\u0011\tm\u0004\u0001)A\u0005\u0005[\nQ\"\u001a=ue\u0006|\u0005\u000f^5p]N\u0004\u0003f\u0001\u0001\u0003\u0000A!!\u0011\u0011BF\u001d\u0011\u0011\u0019Ia\"\u000e\u0005\t\u0015%bAA\u0007\t%!!\u0011\u0012BC\u0003IIe\u000e^3sM\u0006\u001cWm\u0015;bE&d\u0017\u000e^=\n\t\t5%q\u0012\u0002\u0007'R\f'\r\\3\u000b\t\t%%Q\u0011")
public class DataFrameReader
implements Logging {
    public final SparkSession org$apache$spark$sql$DataFrameReader$$sparkSession;
    private String source;
    private Option<StructType> userSpecifiedSchema;
    private final HashMap<String, String> extraOptions;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Dataset<Row> load(String ... paths) {
        return this.load((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> json(String ... paths) {
        return this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> csv(String ... paths) {
        return this.csv((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> parquet(String ... paths) {
        return this.parquet((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> orc(String ... paths) {
        return this.orc((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> text(String ... paths) {
        return this.text((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<String> textFile(String ... paths) {
        return this.textFile((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public DataFrameReader format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameReader schema(StructType schema2) {
        this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)schema2));
        return this;
    }

    public DataFrameReader schema(String schemaString2) {
        this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)StructType$.MODULE$.fromDDL(schemaString2)));
        return this;
    }

    public DataFrameReader option(String key, String value) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
        return this;
    }

    public DataFrameReader option(String key, boolean value) {
        return this.option(key, ((Object)BoxesRunTime.boxToBoolean((boolean)value)).toString());
    }

    public DataFrameReader option(String key, long value) {
        return this.option(key, ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public DataFrameReader option(String key, double value) {
        return this.option(key, ((Object)BoxesRunTime.boxToDouble((double)value)).toString());
    }

    public DataFrameReader options(Map<String, String> options) {
        this.extraOptions().$plus$plus$eq(options);
        return this;
    }

    public DataFrameReader options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public Dataset<Row> load() {
        return this.load((Seq<String>)((Seq)Seq$.MODULE$.empty()));
    }

    public Dataset<Row> load(String path) {
        return this.option("path", path).load((Seq<String>)((Seq)Seq$.MODULE$.empty()));
    }

    /*
     * Unable to fully structure code
     */
    public Dataset<Row> load(Seq<String> paths) {
        block10: {
            block6: {
                block8: {
                    block9: {
                        block7: {
                            v0 = this.source().toLowerCase(Locale.ROOT);
                            var2_2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
                            if (!(v0 != null ? v0.equals(var2_2) == false : var2_2 != null)) {
                                throw new AnalysisException("Hive data source can only be used with tables, you can not read files of Hive data source directly.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                            }
                            cls = DataSource$.MODULE$.lookupDataSource(this.source(), this.org$apache$spark$sql$DataFrameReader$$sparkSession.sessionState().conf());
                            if (!DataSourceV2.class.isAssignableFrom(cls)) break block6;
                            ds = cls.newInstance();
                            options = new DataSourceOptions((java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(this.extraOptions().$plus$plus(DataSourceV2Utils$.MODULE$.extractSessionConfigs((DataSourceV2)ds, this.org$apache$spark$sql$DataFrameReader$$sparkSession.sessionState().conf()))).asJava());
                            var7_6 = new Tuple2(ds, this.userSpecifiedSchema());
                            if (var7_6 == null) break block7;
                            ds = var7_6._1();
                            var9_8 = (Option)var7_6._2();
                            if (!(ds instanceof ReadSupportWithSchema)) break block7;
                            var10_9 = (ReadSupportWithSchema)ds;
                            if (!(var9_8 instanceof Some)) break block7;
                            var11_10 = (Some)var9_8;
                            schema = (StructType)var11_10.x();
                            var13_12 = var10_9.createReader(schema, options);
                            break block8;
                        }
                        if (var7_6 == null) break block9;
                        ds = var7_6._1();
                        var15_14 = (Option)var7_6._2();
                        if (!(ds instanceof ReadSupport)) break block9;
                        var16_15 = (ReadSupport)ds;
                        if (!None$.MODULE$.equals(var15_14)) break block9;
                        var13_12 = var16_15.createReader(options);
                        break block8;
                    }
                    if (var7_6 != null) {
                        ds = var7_6._1();
                        var18_17 = (Option)var7_6._2();
                        if (ds instanceof ReadSupportWithSchema) {
                            var19_18 = (ReadSupportWithSchema)ds;
                            if (None$.MODULE$.equals(var18_17)) {
                                throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A schema needs to be specified when using ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var19_18})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                            }
                        }
                    }
                    if (var7_6 == null) ** GOTO lbl52
                    ds = var7_6._1();
                    var21_20 = (Option)var7_6._2();
                    if (!(ds instanceof ReadSupport)) ** GOTO lbl52
                    var22_21 = (ReadSupport)ds;
                    if (!(var21_20 instanceof Some)) ** GOTO lbl52
                    var23_22 = (Some)var21_20;
                    schema = (StructType)var23_22.x();
                    reader = var22_21.createReader(options);
                    v1 = reader.readSchema();
                    var26_25 = schema;
                    if (!(v1 != null ? v1.equals(var26_25) == false : var26_25 != null)) {
                        var13_12 = reader;
                    } else {
                        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " does not allow user-specified schemas."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var22_21})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
lbl52:
                        // 3 sources

                        var13_12 = null;
                    }
                }
                reader = var13_12;
                v2 = reader == null ? this.loadV1Source(paths) : Dataset$.MODULE$.ofRows(this.org$apache$spark$sql$DataFrameReader$$sparkSession, (LogicalPlan)DataSourceV2Relation$.MODULE$.apply(reader));
                break block10;
            }
            v2 = this.loadV1Source(paths);
        }
        return v2;
    }

    private Dataset<Row> loadV1Source(Seq<String> paths) {
        SparkSession x$4 = this.org$apache$spark$sql$DataFrameReader$$sparkSession;
        Seq<String> x$5 = paths;
        Option<StructType> x$6 = this.userSpecifiedSchema();
        String x$7 = this.source();
        scala.collection.immutable.Map x$8 = this.extraOptions().toMap(Predef$.MODULE$.$conforms());
        Seq<String> x$9 = DataSource$.MODULE$.apply$default$5();
        Option<BucketSpec> x$10 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$11 = DataSource$.MODULE$.apply$default$8();
        DataSource qual$1 = new DataSource(x$4, x$7, x$5, x$6, x$9, x$10, (scala.collection.immutable.Map<String, String>)x$8, x$11);
        boolean x$12 = qual$1.resolveRelation$default$1();
        return this.org$apache$spark$sql$DataFrameReader$$sparkSession.baseRelationToDataFrame(qual$1.resolveRelation(x$12));
    }

    public Dataset<Row> jdbc(String url, String table, Properties properties) {
        this.assertNoSpecifiedSchema("jdbc");
        this.extraOptions().$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(properties).asScala());
        this.extraOptions().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_URL()), (Object)url), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_NAME()), (Object)table), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        return this.format("jdbc").load();
    }

    public Dataset<Row> jdbc(String url, String table, String columnName, long lowerBound, long upperBound, int numPartitions, Properties connectionProperties) {
        this.extraOptions().$plus$plus$eq((TraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_PARTITION_COLUMN()), (Object)columnName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_LOWER_BOUND()), (Object)((Object)BoxesRunTime.boxToLong((long)lowerBound)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_UPPER_BOUND()), (Object)((Object)BoxesRunTime.boxToLong((long)upperBound)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_NUM_PARTITIONS()), (Object)((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString())})));
        return this.jdbc(url, table, connectionProperties);
    }

    public Dataset<Row> jdbc(String url, String table, String[] predicates, Properties connectionProperties) {
        this.assertNoSpecifiedSchema("jdbc");
        scala.collection.immutable.Map params = this.extraOptions().toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(connectionProperties).asScala()).toMap(Predef$.MODULE$.$conforms()));
        JDBCOptions options = new JDBCOptions(url, table, (scala.collection.immutable.Map<String, String>)params);
        Partition[] parts = (Partition[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])predicates).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Partition apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String part = (String)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    JDBCPartition jDBCPartition = new JDBCPartition(part, i);
                    return jDBCPartition;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Partition.class)));
        JDBCRelation relation = new JDBCRelation(parts, options, this.org$apache$spark$sql$DataFrameReader$$sparkSession);
        return this.org$apache$spark$sql$DataFrameReader$$sparkSession.baseRelationToDataFrame(relation);
    }

    public Dataset<Row> json(String path) {
        return this.json((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> json(Seq<String> paths) {
        return this.format("json").load(paths);
    }

    public Dataset<Row> json(JavaRDD<String> jsonRDD) {
        return this.json((RDD<String>)jsonRDD.rdd());
    }

    public Dataset<Row> json(RDD<String> jsonRDD) {
        return this.json(this.org$apache$spark$sql$DataFrameReader$$sparkSession.createDataset(jsonRDD, Encoders$.MODULE$.STRING()));
    }

    public Dataset<Row> json(Dataset<String> jsonDataset) {
        JSONOptions parsedOptions = new JSONOptions(this.extraOptions().toMap(Predef$.MODULE$.$conforms()), this.org$apache$spark$sql$DataFrameReader$$sparkSession.sessionState().conf().sessionLocalTimeZone(), this.org$apache$spark$sql$DataFrameReader$$sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        StructType schema2 = (StructType)this.userSpecifiedSchema().getOrElse((Function0)new Serializable(this, jsonDataset, parsedOptions){
            public static final long serialVersionUID = 0L;
            private final Dataset jsonDataset$1;
            private final JSONOptions parsedOptions$1;

            public final StructType apply() {
                return TextInputJsonDataSource$.MODULE$.inferFromDataset(this.jsonDataset$1, this.parsedOptions$1);
            }
            {
                this.jsonDataset$1 = jsonDataset$1;
                this.parsedOptions$1 = parsedOptions$1;
            }
        });
        this.verifyColumnNameOfCorruptRecord(schema2, parsedOptions.columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)schema2.filterNot((Function1)new Serializable(this, parsedOptions){
            public static final long serialVersionUID = 0L;
            private final JSONOptions parsedOptions$1;

            public final boolean apply(StructField x$1) {
                String string = x$1.name();
                String string2 = this.parsedOptions$1.columnNameOfCorruptRecord();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.parsedOptions$1 = parsedOptions$1;
            }
        }));
        Serializable createParser = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonParser apply(JsonFactory jsonFactory, String record) {
                return CreateJacksonParser$.MODULE$.string(jsonFactory, record);
            }
        };
        RDD parsed = jsonDataset.rdd().mapPartitions((Function1)new Serializable(this, parsedOptions, schema2, actualSchema, (Function2)createParser){
            public static final long serialVersionUID = 0L;
            private final JSONOptions parsedOptions$1;
            private final StructType schema$1;
            private final StructType actualSchema$1;
            public final Function2 createParser$1;

            public final Iterator<InternalRow> apply(Iterator<String> iter) {
                JacksonParser rawParser = new JacksonParser(this.actualSchema$1, this.parsedOptions$1);
                FailureSafeParser<IN> parser = new FailureSafeParser<IN>(new Serializable(this, rawParser){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;
                    private final JacksonParser rawParser$1;

                    public final Seq<InternalRow> apply(String input) {
                        return this.rawParser$1.parse((Object)input, this.$outer.createParser$1, (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final UTF8String apply(String x$1) {
                                return UTF8String.fromString((String)x$1);
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.rawParser$1 = rawParser$1;
                    }
                }, this.parsedOptions$1.parseMode(), this.schema$1, this.parsedOptions$1.columnNameOfCorruptRecord());
                return iter.flatMap((Function1)new Serializable(this, parser){
                    public static final long serialVersionUID = 0L;
                    private final FailureSafeParser parser$1;

                    public final Iterator<InternalRow> apply(String input) {
                        return this.parser$1.parse(input);
                    }
                    {
                        this.parser$1 = parser$1;
                    }
                });
            }
            {
                this.parsedOptions$1 = parsedOptions$1;
                this.schema$1 = schema$1;
                this.actualSchema$1 = actualSchema$1;
                this.createParser$1 = createParser$1;
            }
        }, jsonDataset.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        return this.org$apache$spark$sql$DataFrameReader$$sparkSession.internalCreateDataFrame((RDD<InternalRow>)parsed, schema2, jsonDataset.isStreaming());
    }

    public Dataset<Row> csv(String path) {
        return this.csv((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> csv(Dataset<String> csvDataset) {
        CSVOptions parsedOptions = new CSVOptions((scala.collection.immutable.Map<String, String>)this.extraOptions().toMap(Predef$.MODULE$.$conforms()), this.org$apache$spark$sql$DataFrameReader$$sparkSession.sessionState().conf().sessionLocalTimeZone(), CSVOptions$.MODULE$.$lessinit$greater$default$3());
        Dataset<String> filteredLines = CSVUtils$.MODULE$.filterCommentAndEmpty(csvDataset, parsedOptions);
        Option maybeFirstLine = Predef$.MODULE$.refArrayOps((Object[])filteredLines.take(1)).headOption();
        StructType schema2 = (StructType)this.userSpecifiedSchema().getOrElse((Function0)new Serializable(this, csvDataset, parsedOptions, maybeFirstLine){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataFrameReader $outer;
            private final Dataset csvDataset$1;
            private final CSVOptions parsedOptions$2;
            private final Option maybeFirstLine$1;

            public final StructType apply() {
                return TextInputCSVDataSource$.MODULE$.inferFromDataset(this.$outer.org$apache$spark$sql$DataFrameReader$$sparkSession, this.csvDataset$1, (Option<String>)this.maybeFirstLine$1, this.parsedOptions$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.csvDataset$1 = csvDataset$1;
                this.parsedOptions$2 = parsedOptions$2;
                this.maybeFirstLine$1 = maybeFirstLine$1;
            }
        });
        this.verifyColumnNameOfCorruptRecord(schema2, parsedOptions.columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)schema2.filterNot((Function1)new Serializable(this, parsedOptions){
            public static final long serialVersionUID = 0L;
            private final CSVOptions parsedOptions$2;

            public final boolean apply(StructField x$2) {
                String string = x$2.name();
                String string2 = this.parsedOptions$2.columnNameOfCorruptRecord();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.parsedOptions$2 = parsedOptions$2;
            }
        }));
        RDD linesWithoutHeader = (RDD)maybeFirstLine.map((Function1)new Serializable(this, parsedOptions, filteredLines){
            public static final long serialVersionUID = 0L;
            public final CSVOptions parsedOptions$2;
            private final Dataset filteredLines$1;

            public final RDD<String> apply(String firstLine) {
                return this.filteredLines$1.rdd().mapPartitions((Function1)new Serializable(this, firstLine){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;
                    private final String firstLine$1;

                    public final Iterator<String> apply(Iterator<String> x$3) {
                        return CSVUtils$.MODULE$.filterHeaderLine(x$3, this.firstLine$1, this.$outer.parsedOptions$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.firstLine$1 = firstLine$1;
                    }
                }, this.filteredLines$1.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(String.class));
            }
            {
                this.parsedOptions$2 = parsedOptions$2;
                this.filteredLines$1 = filteredLines$1;
            }
        }).getOrElse((Function0)new Serializable(this, filteredLines){
            public static final long serialVersionUID = 0L;
            private final Dataset filteredLines$1;

            public final RDD<String> apply() {
                return this.filteredLines$1.rdd();
            }
            {
                this.filteredLines$1 = filteredLines$1;
            }
        });
        RDD parsed = linesWithoutHeader.mapPartitions((Function1)new Serializable(this, parsedOptions, schema2, actualSchema){
            public static final long serialVersionUID = 0L;
            private final CSVOptions parsedOptions$2;
            private final StructType schema$3;
            private final StructType actualSchema$2;

            public final Iterator<InternalRow> apply(Iterator<String> iter) {
                UnivocityParser rawParser = new UnivocityParser(this.actualSchema$2, this.parsedOptions$2);
                FailureSafeParser<IN> parser = new FailureSafeParser<IN>(new Serializable(this, rawParser){
                    public static final long serialVersionUID = 0L;
                    private final UnivocityParser rawParser$2;

                    public final Seq<InternalRow> apply(String input) {
                        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalRow[]{this.rawParser$2.parse(input)}));
                    }
                    {
                        this.rawParser$2 = rawParser$2;
                    }
                }, this.parsedOptions$2.parseMode(), this.schema$3, this.parsedOptions$2.columnNameOfCorruptRecord());
                return iter.flatMap((Function1)new Serializable(this, parser){
                    public static final long serialVersionUID = 0L;
                    private final FailureSafeParser parser$2;

                    public final Iterator<InternalRow> apply(String input) {
                        return this.parser$2.parse(input);
                    }
                    {
                        this.parser$2 = parser$2;
                    }
                });
            }
            {
                this.parsedOptions$2 = parsedOptions$2;
                this.schema$3 = schema$3;
                this.actualSchema$2 = actualSchema$2;
            }
        }, linesWithoutHeader.mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        return this.org$apache$spark$sql$DataFrameReader$$sparkSession.internalCreateDataFrame((RDD<InternalRow>)parsed, schema2, csvDataset.isStreaming());
    }

    public Dataset<Row> csv(Seq<String> paths) {
        return this.format("csv").load(paths);
    }

    public Dataset<Row> parquet(String path) {
        return this.parquet((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> parquet(Seq<String> paths) {
        return this.format("parquet").load(paths);
    }

    public Dataset<Row> orc(String path) {
        return this.orc((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> orc(Seq<String> paths) {
        return this.format("orc").load(paths);
    }

    public Dataset<Row> table(String tableName) {
        this.assertNoSpecifiedSchema("table");
        return this.org$apache$spark$sql$DataFrameReader$$sparkSession.table(tableName);
    }

    public Dataset<Row> text(String path) {
        return this.text((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> text(Seq<String> paths) {
        return this.format("text").load(paths);
    }

    public Dataset<String> textFile(String path) {
        return this.textFile((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<String> textFile(Seq<String> paths) {
        this.assertNoSpecifiedSchema("textFile");
        return this.text(paths).select("value", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).as(this.org$apache$spark$sql$DataFrameReader$$sparkSession.implicits().newStringEncoder());
    }

    private void assertNoSpecifiedSchema(String operation) {
        if (this.userSpecifiedSchema().nonEmpty()) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User specified schema not supported with `", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private void verifyColumnNameOfCorruptRecord(StructType schema2, String columnNameOfCorruptRecord) {
        schema2.getFieldIndex(columnNameOfCorruptRecord).foreach((Function1)new Serializable(this, schema2){
            public static final long serialVersionUID = 0L;
            private final StructType schema$2;

            public final void apply(int corruptFieldIndex) {
                this.apply$mcVI$sp(corruptFieldIndex);
            }

            public void apply$mcVI$sp(int corruptFieldIndex) {
                StructField f = this.schema$2.apply(corruptFieldIndex);
                DataType dataType = f.dataType();
                StringType$ stringType$ = StringType$.MODULE$;
                if (!(dataType != null ? !dataType.equals(stringType$) : stringType$ != null) && f.nullable()) {
                    return;
                }
                throw new AnalysisException("The field for corrupt records must be string type and nullable", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            {
                this.schema$2 = schema$2;
            }
        });
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private Option<StructType> userSpecifiedSchema() {
        return this.userSpecifiedSchema;
    }

    private void userSpecifiedSchema_$eq(Option<StructType> x$1) {
        this.userSpecifiedSchema = x$1;
    }

    private HashMap<String, String> extraOptions() {
        return this.extraOptions;
    }

    public DataFrameReader(SparkSession sparkSession) {
        this.org$apache$spark$sql$DataFrameReader$$sparkSession = sparkSession;
        Logging.class.$init$((Logging)this);
        this.source = sparkSession.sessionState().conf().defaultDataSourceName();
        this.userSpecifiedSchema = None$.MODULE$;
        this.extraOptions = new HashMap();
    }
}

