/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.continuous;

import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.datasources.v2.DataSourceRDDPartition;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousDataSourceRDD$;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousExecution$;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousTaskRetryException;
import org.apache.spark.sql.execution.streaming.continuous.DataReaderThread;
import org.apache.spark.sql.execution.streaming.continuous.EpochCoordinatorRef$;
import org.apache.spark.sql.execution.streaming.continuous.EpochPollRunnable;
import org.apache.spark.sql.execution.streaming.continuous.ReportPartitionOffset;
import org.apache.spark.sql.sources.v2.reader.DataReader;
import org.apache.spark.sql.sources.v2.reader.DataReaderFactory;
import org.apache.spark.sql.sources.v2.reader.streaming.PartitionOffset;
import org.apache.spark.util.ThreadUtils$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\u0001\u0003\u0001E\u0011qcQ8oi&tWo\\;t\t\u0006$\u0018mU8ve\u000e,'\u000b\u0012#\u000b\u0005\r!\u0011AC2p]RLg.^8vg*\u0011QAB\u0001\ngR\u0014X-Y7j]\u001eT!a\u0002\u0005\u0002\u0013\u0015DXmY;uS>t'BA\u0005\u000b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\r\u0019b\u0003G\u0007\u0002))\u0011QCC\u0001\u0004e\u0012$\u0017BA\f\u0015\u0005\r\u0011F\t\u0012\t\u00033yi\u0011A\u0007\u0006\u00037q\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011Q\u0004C\u0001\tG\u0006$\u0018\r\\=ti&\u0011qD\u0007\u0002\n+:\u001c\u0018MZ3S_^D\u0001\"\t\u0001\u0003\u0002\u0003\u0006IAI\u0001\u0003g\u000e\u0004\"a\t\u0013\u000e\u0003)I!!\n\u0006\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\t\u0011\u001d\u0002!\u0011!Q\u0001\n!\n!b]9m\u0007>tG/\u001a=u!\tI#&D\u0001\t\u0013\tY\u0003B\u0001\u0006T#2\u001buN\u001c;fqRD\u0001\"\f\u0001\u0003\u0006\u0004%IAL\u0001\u0010e\u0016\fG-\u001a:GC\u000e$xN]5fgV\tq\u0006E\u00021k]j\u0011!\r\u0006\u0003eM\nA!\u001e;jY*\tA'\u0001\u0003kCZ\f\u0017B\u0001\u001c2\u0005\u0011a\u0015n\u001d;\u0011\u0007az\u0004$D\u0001:\u0015\tQ4(\u0001\u0004sK\u0006$WM\u001d\u0006\u0003yu\n!A\u001e\u001a\u000b\u0005yB\u0011aB:pkJ\u001cWm]\u0005\u0003\u0001f\u0012\u0011\u0003R1uCJ+\u0017\rZ3s\r\u0006\u001cGo\u001c:z\u0011!\u0011\u0005A!A!\u0002\u0013y\u0013\u0001\u0005:fC\u0012,'OR1di>\u0014\u0018.Z:!Q\t\tE\t\u0005\u0002F\u00116\taIC\u0001H\u0003\u0015\u00198-\u00197b\u0013\tIeIA\u0005ue\u0006t7/[3oi\")1\n\u0001C\u0001\u0019\u00061A(\u001b8jiz\"B!T(Q#B\u0011a\nA\u0007\u0002\u0005!)\u0011E\u0013a\u0001E!)qE\u0013a\u0001Q!)QF\u0013a\u0001_!91\u000b\u0001b\u0001\n\u0013!\u0016!\u00043bi\u0006\fV/Z;f'&TX-F\u0001V!\t)e+\u0003\u0002X\r\n\u0019\u0011J\u001c;\t\re\u0003\u0001\u0015!\u0003V\u00039!\u0017\r^1Rk\u0016,XmU5{K\u0002Bqa\u0017\u0001C\u0002\u0013%A,A\nfa>\u001c\u0007\u000eU8mY&sG/\u001a:wC2l5/F\u0001^!\t)e,\u0003\u0002`\r\n!Aj\u001c8h\u0011\u0019\t\u0007\u0001)A\u0005;\u0006!R\r]8dQB{G\u000e\\%oi\u0016\u0014h/\u00197Ng\u0002BQa\u0019\u0001\u0005R\u0011\fQbZ3u!\u0006\u0014H/\u001b;j_:\u001cX#A3\u0011\u0007\u00153\u0007.\u0003\u0002h\r\n)\u0011I\u001d:bsB\u00111%[\u0005\u0003U*\u0011\u0011\u0002U1si&$\u0018n\u001c8\t\u000b1\u0004A\u0011I7\u0002\u000f\r|W\u000e];uKR\u0019aN\u001f?\u0011\u0007=<\bD\u0004\u0002qk:\u0011\u0011\u000f^\u0007\u0002e*\u00111\u000fE\u0001\u0007yI|w\u000e\u001e \n\u0003\u001dK!A\u001e$\u0002\u000fA\f7m[1hK&\u0011\u00010\u001f\u0002\t\u0013R,'/\u0019;pe*\u0011aO\u0012\u0005\u0006w.\u0004\r\u0001[\u0001\u0006gBd\u0017\u000e\u001e\u0005\u0006{.\u0004\rA`\u0001\bG>tG/\u001a=u!\t\u0019s0C\u0002\u0002\u0002)\u00111\u0002V1tW\u000e{g\u000e^3yi\"9\u0011Q\u0001\u0001\u0005B\u0005\u001d\u0011!F4fiB\u0013XMZ3se\u0016$Gj\\2bi&|gn\u001d\u000b\u0005\u0003\u0013\ti\u0002E\u0003p\u0003\u0017\ty!C\u0002\u0002\u000ee\u00141aU3r!\u0011\t\t\"a\u0006\u000f\u0007\u0015\u000b\u0019\"C\u0002\u0002\u0016\u0019\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\r\u00037\u0011aa\u0015;sS:<'bAA\u000b\r\"110a\u0001A\u0002!<q!!\t\u0003\u0011\u0003\t\u0019#A\fD_:$\u0018N\\;pkN$\u0015\r^1T_V\u00148-\u001a*E\tB\u0019a*!\n\u0007\r\u0005\u0011\u0001\u0012AA\u0014'\u0019\t)#!\u000b\u00020A\u0019Q)a\u000b\n\u0007\u00055bI\u0001\u0004B]f\u0014VM\u001a\t\u0004\u000b\u0006E\u0012bAA\u001a\r\na1+\u001a:jC2L'0\u00192mK\"91*!\n\u0005\u0002\u0005]BCAA\u0012\u0011%\tY$!\n\u0005\u0002\t\ti$A\u0007hKR\u0014\u0015m]3SK\u0006$WM\u001d\u000b\u0005\u0003\u007f\t\t\u0007\r\u0003\u0002B\u0005=\u0003CBA\"\u0003\u000f\nY%\u0004\u0002\u0002F)\u0011Q!O\u0005\u0005\u0003\u0013\n)E\u0001\u000bD_:$\u0018N\\;pkN$\u0015\r^1SK\u0006$WM\u001d\t\u0005\u0003\u001b\ny\u0005\u0004\u0001\u0005\u0019\u0005E\u0013\u0011HA\u0001\u0002\u0003\u0015\t!a\u0015\u0003\u0007}#\u0013'\u0005\u0003\u0002V\u0005m\u0003cA#\u0002X%\u0019\u0011\u0011\f$\u0003\u000f9{G\u000f[5oOB\u0019Q)!\u0018\n\u0007\u0005}cIA\u0002B]fDqAOA\u001d\u0001\u0004\t\u0019\u0007\u0005\u00039\u0003KB\u0012bAA4s\tQA)\u0019;b%\u0016\fG-\u001a:\t\u0015\u0005-\u0014QEA\u0001\n\u0013\ti'A\u0006sK\u0006$'+Z:pYZ,GCAA8!\u0011\t\t(a\u001e\u000e\u0005\u0005M$bAA;g\u0005!A.\u00198h\u0013\u0011\tI(a\u001d\u0003\r=\u0013'.Z2u\u0001")
public class ContinuousDataSourceRDD
extends RDD<UnsafeRow> {
    private final transient java.util.List<DataReaderFactory<UnsafeRow>> readerFactories;
    private final int dataQueueSize;
    private final long epochPollIntervalMs;

    private java.util.List<DataReaderFactory<UnsafeRow>> readerFactories() {
        return this.readerFactories;
    }

    private int dataQueueSize() {
        return this.dataQueueSize;
    }

    private long epochPollIntervalMs() {
        return this.epochPollIntervalMs;
    }

    public Partition[] getPartitions() {
        return (Partition[])((TraversableOnce)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.readerFactories()).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DataSourceRDDPartition<UnsafeRow> apply(Tuple2<DataReaderFactory<UnsafeRow>, Object> x0$1) {
                Tuple2<DataReaderFactory<UnsafeRow>, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    DataReaderFactory readerFactory = (DataReaderFactory)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    DataSourceRDDPartition<UnsafeRow> dataSourceRDDPartition = new DataSourceRDDPartition<UnsafeRow>(index, readerFactory, ClassTag$.MODULE$.apply(UnsafeRow.class));
                    return dataSourceRDDPartition;
                }
                throw new MatchError(tuple2);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Partition.class));
    }

    public Iterator<UnsafeRow> compute(Partition split, TaskContext context) {
        if (context.attemptNumber() != 0) {
            throw new ContinuousTaskRetryException();
        }
        DataReader<UnsafeRow> reader = ((DataSourceRDDPartition)split).readerFactory().createDataReader();
        String coordinatorId = context.getLocalProperty(ContinuousExecution$.MODULE$.EPOCH_COORDINATOR_ID_KEY());
        ArrayBlockingQueue<Tuple2<UnsafeRow, PartitionOffset>> queue = new ArrayBlockingQueue<Tuple2<UnsafeRow, PartitionOffset>>(this.dataQueueSize());
        AtomicBoolean epochPollFailed = new AtomicBoolean(false);
        ScheduledExecutorService epochPollExecutor = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"epoch-poll--", "--", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{coordinatorId, BoxesRunTime.boxToInteger((int)context.partitionId())})));
        EpochPollRunnable epochPollRunnable = new EpochPollRunnable(queue, context, epochPollFailed);
        epochPollExecutor.scheduleWithFixedDelay(epochPollRunnable, 0L, this.epochPollIntervalMs(), TimeUnit.MILLISECONDS);
        PartitionOffset startOffset = ContinuousDataSourceRDD$.MODULE$.getBaseReader(reader).getOffset();
        AtomicBoolean dataReaderFailed = new AtomicBoolean(false);
        DataReaderThread dataReaderThread = new DataReaderThread(reader, queue, context, dataReaderFailed);
        dataReaderThread.setDaemon(true);
        dataReaderThread.start();
        context.addTaskCompletionListener((Function1)new Serializable(this, epochPollExecutor, dataReaderThread){
            public static final long serialVersionUID = 0L;
            private final ScheduledExecutorService epochPollExecutor$1;
            private final DataReaderThread dataReaderThread$1;

            public final void apply(TaskContext x$1) {
                this.dataReaderThread$1.interrupt();
                this.epochPollExecutor$1.shutdown();
            }
            {
                this.epochPollExecutor$1 = epochPollExecutor$1;
                this.dataReaderThread$1 = dataReaderThread$1;
            }
        });
        RpcEndpointRef epochEndpoint = EpochCoordinatorRef$.MODULE$.get(coordinatorId, SparkEnv$.MODULE$.get());
        return new Iterator<UnsafeRow>(this, context, queue, epochPollFailed, epochPollRunnable, startOffset, dataReaderFailed, dataReaderThread, epochEndpoint){
            private final int POLL_TIMEOUT_MS;
            private Tuple2<UnsafeRow, PartitionOffset> currentEntry;
            private PartitionOffset currentOffset;
            private long currentEpoch;
            private final TaskContext context$1;
            private final ArrayBlockingQueue queue$1;
            private final AtomicBoolean epochPollFailed$1;
            private final EpochPollRunnable epochPollRunnable$1;
            private final AtomicBoolean dataReaderFailed$1;
            private final DataReaderThread dataReaderThread$1;
            private final RpcEndpointRef epochEndpoint$1;

            public Iterator<UnsafeRow> seq() {
                return Iterator.class.seq((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.class.isEmpty((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.class.isTraversableAgain((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.class.hasDefiniteSize((Iterator)this);
            }

            public Iterator<UnsafeRow> take(int n) {
                return Iterator.class.take((Iterator)this, (int)n);
            }

            public Iterator<UnsafeRow> drop(int n) {
                return Iterator.class.drop((Iterator)this, (int)n);
            }

            public Iterator<UnsafeRow> slice(int from, int until) {
                return Iterator.class.slice((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<UnsafeRow, B> f) {
                return Iterator.class.map((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.class.$plus$plus((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<UnsafeRow, GenTraversableOnce<B>> f) {
                return Iterator.class.flatMap((Iterator)this, f);
            }

            public Iterator<UnsafeRow> filter(Function1<UnsafeRow, Object> p) {
                return Iterator.class.filter((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<UnsafeRow, B, Object> p) {
                return Iterator.class.corresponds((Iterator)this, that, p);
            }

            public Iterator<UnsafeRow> withFilter(Function1<UnsafeRow, Object> p) {
                return Iterator.class.withFilter((Iterator)this, p);
            }

            public Iterator<UnsafeRow> filterNot(Function1<UnsafeRow, Object> p) {
                return Iterator.class.filterNot((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<UnsafeRow, B> pf) {
                return Iterator.class.collect((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, UnsafeRow, B> op) {
                return Iterator.class.scanLeft((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<UnsafeRow, B, B> op) {
                return Iterator.class.scanRight((Iterator)this, z, op);
            }

            public Iterator<UnsafeRow> takeWhile(Function1<UnsafeRow, Object> p) {
                return Iterator.class.takeWhile((Iterator)this, p);
            }

            public Tuple2<Iterator<UnsafeRow>, Iterator<UnsafeRow>> partition(Function1<UnsafeRow, Object> p) {
                return Iterator.class.partition((Iterator)this, p);
            }

            public Tuple2<Iterator<UnsafeRow>, Iterator<UnsafeRow>> span(Function1<UnsafeRow, Object> p) {
                return Iterator.class.span((Iterator)this, p);
            }

            public Iterator<UnsafeRow> dropWhile(Function1<UnsafeRow, Object> p) {
                return Iterator.class.dropWhile((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<UnsafeRow, B>> zip(Iterator<B> that) {
                return Iterator.class.zip((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.class.padTo((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<UnsafeRow, Object>> zipWithIndex() {
                return Iterator.class.zipWithIndex((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<UnsafeRow, U> f) {
                Iterator.class.foreach((Iterator)this, f);
            }

            public boolean forall(Function1<UnsafeRow, Object> p) {
                return Iterator.class.forall((Iterator)this, p);
            }

            public boolean exists(Function1<UnsafeRow, Object> p) {
                return Iterator.class.exists((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.class.contains((Iterator)this, (Object)elem);
            }

            public Option<UnsafeRow> find(Function1<UnsafeRow, Object> p) {
                return Iterator.class.find((Iterator)this, p);
            }

            public int indexWhere(Function1<UnsafeRow, Object> p) {
                return Iterator.class.indexWhere((Iterator)this, p);
            }

            public <B> int indexOf(B elem) {
                return Iterator.class.indexOf((Iterator)this, elem);
            }

            public BufferedIterator<UnsafeRow> buffered() {
                return Iterator.class.buffered((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.class.grouped((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.class.sliding((Iterator)this, (int)size, (int)step);
            }

            public int length() {
                return Iterator.class.length((Iterator)this);
            }

            public Tuple2<Iterator<UnsafeRow>, Iterator<UnsafeRow>> duplicate() {
                return Iterator.class.duplicate((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start2, int len) {
                Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start2, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.class.sameElements((Iterator)this, that);
            }

            public Traversable<UnsafeRow> toTraversable() {
                return Iterator.class.toTraversable((Iterator)this);
            }

            public Iterator<UnsafeRow> toIterator() {
                return Iterator.class.toIterator((Iterator)this);
            }

            public Stream<UnsafeRow> toStream() {
                return Iterator.class.toStream((Iterator)this);
            }

            public String toString() {
                return Iterator.class.toString((Iterator)this);
            }

            public <B> int sliding$default$2() {
                return Iterator.class.sliding$default$2((Iterator)this);
            }

            public List<UnsafeRow> reversed() {
                return TraversableOnce.class.reversed((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.class.size((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.class.nonEmpty((TraversableOnce)this);
            }

            public int count(Function1<UnsafeRow, Object> p) {
                return TraversableOnce.class.count((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<UnsafeRow, B> pf) {
                return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, UnsafeRow, B> op) {
                return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<UnsafeRow, B, B> op) {
                return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, UnsafeRow, B> op) {
                return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<UnsafeRow, B, B> op) {
                return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, UnsafeRow, B> op) {
                return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<UnsafeRow, B, B> op) {
                return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, UnsafeRow, B> op) {
                return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<UnsafeRow, B, B> op) {
                return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, UnsafeRow, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.class.product((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start2) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start2);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
            }

            public List<UnsafeRow> toList() {
                return TraversableOnce.class.toList((TraversableOnce)this);
            }

            public Iterable<UnsafeRow> toIterable() {
                return TraversableOnce.class.toIterable((TraversableOnce)this);
            }

            public Seq<UnsafeRow> toSeq() {
                return TraversableOnce.class.toSeq((TraversableOnce)this);
            }

            public IndexedSeq<UnsafeRow> toIndexedSeq() {
                return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.class.toBuffer((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.class.toSet((TraversableOnce)this);
            }

            public Vector<UnsafeRow> toVector() {
                return TraversableOnce.class.toVector((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, UnsafeRow, Col> cbf) {
                return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef.$less$colon$less<UnsafeRow, Tuple2<T, U>> ev) {
                return TraversableOnce.class.toMap((TraversableOnce)this, ev);
            }

            public String mkString(String start2, String sep, String end) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)start2, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.class.mkString((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start2, String sep, String end) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start2, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
            }

            private int POLL_TIMEOUT_MS() {
                return this.POLL_TIMEOUT_MS;
            }

            private Tuple2<UnsafeRow, PartitionOffset> currentEntry() {
                return this.currentEntry;
            }

            private void currentEntry_$eq(Tuple2<UnsafeRow, PartitionOffset> x$1) {
                this.currentEntry = x$1;
            }

            private PartitionOffset currentOffset() {
                return this.currentOffset;
            }

            private void currentOffset_$eq(PartitionOffset x$1) {
                this.currentOffset = x$1;
            }

            private long currentEpoch() {
                return this.currentEpoch;
            }

            private void currentEpoch_$eq(long x$1) {
                this.currentEpoch = x$1;
            }

            public boolean hasNext() {
                Tuple2<UnsafeRow, PartitionOffset> tuple2;
                block9: {
                    boolean bl;
                    block8: {
                        block7: {
                            while (this.currentEntry() == null) {
                                if (this.context$1.isInterrupted() || this.context$1.isCompleted()) {
                                    this.currentEntry_$eq((Tuple2<UnsafeRow, PartitionOffset>)new Tuple2(null, null));
                                }
                                if (this.dataReaderFailed$1.get()) {
                                    throw new SparkException("data read failed", this.dataReaderThread$1.failureReason());
                                }
                                if (this.epochPollFailed$1.get()) {
                                    throw new SparkException("epoch poll failed", this.epochPollRunnable$1.failureReason());
                                }
                                this.currentEntry_$eq((Tuple2<UnsafeRow, PartitionOffset>)((Tuple2)this.queue$1.poll(this.POLL_TIMEOUT_MS(), TimeUnit.MILLISECONDS)));
                            }
                            tuple2 = this.currentEntry();
                            if (tuple2 == null) break block7;
                            UnsafeRow unsafeRow = (UnsafeRow)tuple2._1();
                            PartitionOffset partitionOffset = (PartitionOffset)tuple2._2();
                            if (unsafeRow != null || partitionOffset != null) break block7;
                            this.epochEndpoint$1.send((Object)new ReportPartitionOffset(this.context$1.partitionId(), this.currentEpoch(), this.currentOffset()));
                            this.currentEpoch_$eq(this.currentEpoch() + 1L);
                            this.currentEntry_$eq(null);
                            bl = false;
                            break block8;
                        }
                        if (tuple2 == null) break block9;
                        PartitionOffset offset = (PartitionOffset)tuple2._2();
                        this.currentOffset_$eq(offset);
                        bl = true;
                    }
                    return bl;
                }
                throw new MatchError(tuple2);
            }

            /*
             * WARNING - void declaration
             */
            public UnsafeRow next() {
                void var1_1;
                if (this.currentEntry() == null) {
                    throw new NoSuchElementException("No current row was set");
                }
                UnsafeRow r2 = (UnsafeRow)this.currentEntry()._1();
                this.currentEntry_$eq(null);
                return var1_1;
            }
            {
                this.context$1 = context$1;
                this.queue$1 = queue$1;
                this.epochPollFailed$1 = epochPollFailed$1;
                this.epochPollRunnable$1 = epochPollRunnable$1;
                this.dataReaderFailed$1 = dataReaderFailed$1;
                this.dataReaderThread$1 = dataReaderThread$1;
                this.epochEndpoint$1 = epochEndpoint$1;
                TraversableOnce.class.$init$((TraversableOnce)this);
                Iterator.class.$init$((Iterator)this);
                this.POLL_TIMEOUT_MS = 1000;
                this.currentOffset = startOffset$1;
                this.currentEpoch = new StringOps(Predef$.MODULE$.augmentString(context$1.getLocalProperty(ContinuousExecution$.MODULE$.START_EPOCH_KEY()))).toLong();
            }
        };
    }

    public Seq<String> getPreferredLocations(Partition split) {
        return Predef$.MODULE$.wrapRefArray((Object[])((DataSourceRDDPartition)split).readerFactory().preferredLocations());
    }

    public ContinuousDataSourceRDD(SparkContext sc, SQLContext sqlContext, java.util.List<DataReaderFactory<UnsafeRow>> readerFactories2) {
        this.readerFactories = readerFactories2;
        super(sc, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(UnsafeRow.class));
        this.dataQueueSize = sqlContext.conf().continuousStreamingExecutorQueueSize();
        this.epochPollIntervalMs = sqlContext.conf().continuousStreamingExecutorPollIntervalMs();
    }
}

