/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.runtime.BoxesRunTime;

public final class DB2Dialect$
extends JdbcDialect {
    public static final DB2Dialect$ MODULE$;

    static {
        new DB2Dialect$();
    }

    @Override
    public boolean canHandle(String url) {
        return url.startsWith("jdbc:db2");
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        None$ none$;
        int n = sqlType;
        switch (n) {
            default: {
                none$ = None$.MODULE$;
                break;
            }
            case 1111: {
                String string = typeName;
                Object object = "DECFLOAT".equals(string) ? Option$.MODULE$.apply((Object)new DecimalType(38, 18)) : ("XML".equals(string) ? Option$.MODULE$.apply((Object)StringType$.MODULE$) : (string.startsWith("TIMESTAMP") ? Option$.MODULE$.apply((Object)TimestampType$.MODULE$) : None$.MODULE$));
                none$ = object;
                break;
            }
            case 7: {
                none$ = Option$.MODULE$.apply((Object)FloatType$.MODULE$);
            }
        }
        return none$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        Object object;
        DataType dataType = dt;
        if (StringType$.MODULE$.equals(dataType)) {
            object = Option$.MODULE$.apply((Object)new JdbcType("CLOB", 2005));
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            object = Option$.MODULE$.apply((Object)new JdbcType("CHAR(1)", 1));
        } else {
            boolean bl = ShortType$.MODULE$.equals(dataType) ? true : ByteType$.MODULE$.equals(dataType);
            object = bl ? new Some((Object)new JdbcType("SMALLINT", 5)) : None$.MODULE$;
        }
        return object;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DB2Dialect$() {
        MODULE$ = this;
    }
}

