/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sources.v2;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.spark.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class DataSourceOptions {
    private final Map<String, String> keyLowerCasedMap;

    private String toLowerCase(String key) {
        return key.toLowerCase(Locale.ROOT);
    }

    public static DataSourceOptions empty() {
        return new DataSourceOptions(new HashMap<String, String>());
    }

    public DataSourceOptions(Map<String, String> originalMap) {
        this.keyLowerCasedMap = new HashMap<String, String>(originalMap.size());
        for (Map.Entry<String, String> entry2 : originalMap.entrySet()) {
            this.keyLowerCasedMap.put(this.toLowerCase(entry2.getKey()), entry2.getValue());
        }
    }

    public Map<String, String> asMap() {
        return new HashMap<String, String>(this.keyLowerCasedMap);
    }

    public Optional<String> get(String key) {
        return Optional.ofNullable(this.keyLowerCasedMap.get(this.toLowerCase(key)));
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String lcaseKey = this.toLowerCase(key);
        return this.keyLowerCasedMap.containsKey(lcaseKey) ? Boolean.parseBoolean(this.keyLowerCasedMap.get(lcaseKey)) : defaultValue;
    }

    public int getInt(String key, int defaultValue) {
        String lcaseKey = this.toLowerCase(key);
        return this.keyLowerCasedMap.containsKey(lcaseKey) ? Integer.parseInt(this.keyLowerCasedMap.get(lcaseKey)) : defaultValue;
    }

    public long getLong(String key, long defaultValue) {
        String lcaseKey = this.toLowerCase(key);
        return this.keyLowerCasedMap.containsKey(lcaseKey) ? Long.parseLong(this.keyLowerCasedMap.get(lcaseKey)) : defaultValue;
    }

    public double getDouble(String key, double defaultValue) {
        String lcaseKey = this.toLowerCase(key);
        return this.keyLowerCasedMap.containsKey(lcaseKey) ? Double.parseDouble(this.keyLowerCasedMap.get(lcaseKey)) : defaultValue;
    }
}

