/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.TaskContext$;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.internal.BaseSessionStateBuilder;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.internal.SessionStateBuilder;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.util.control.NonFatal$;

@InterfaceStability.Stable
public final class SparkSession$
implements Logging,
scala.Serializable {
    public static SparkSession$ MODULE$;
    private final InheritableThreadLocal<SparkSession> org$apache$spark$sql$SparkSession$$activeThreadSession;
    private final AtomicReference<SparkSession> org$apache$spark$sql$SparkSession$$defaultSession;
    private final String HIVE_SESSION_STATE_BUILDER_CLASS_NAME;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SparkSession$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkSession.Builder builder() {
        return new SparkSession.Builder();
    }

    public void setActiveSession(SparkSession session) {
        this.org$apache$spark$sql$SparkSession$$activeThreadSession().set(session);
    }

    public void clearActiveSession() {
        this.org$apache$spark$sql$SparkSession$$activeThreadSession().remove();
    }

    public void setDefaultSession(SparkSession session) {
        this.org$apache$spark$sql$SparkSession$$defaultSession().set(session);
    }

    public void clearDefaultSession() {
        this.org$apache$spark$sql$SparkSession$$defaultSession().set(null);
    }

    public Option<SparkSession> getActiveSession() {
        return TaskContext$.MODULE$.get() != null ? None$.MODULE$ : Option$.MODULE$.apply(this.org$apache$spark$sql$SparkSession$$activeThreadSession().get());
    }

    public Option<SparkSession> getDefaultSession() {
        return TaskContext$.MODULE$.get() != null ? None$.MODULE$ : Option$.MODULE$.apply((Object)this.org$apache$spark$sql$SparkSession$$defaultSession().get());
    }

    public SparkSession active() {
        return (SparkSession)this.getActiveSession().getOrElse((Function0 & Serializable & scala.Serializable)() -> (SparkSession)MODULE$.getDefaultSession().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("No active or default Spark session found");
        }));
    }

    public InheritableThreadLocal<SparkSession> org$apache$spark$sql$SparkSession$$activeThreadSession() {
        return this.org$apache$spark$sql$SparkSession$$activeThreadSession;
    }

    public AtomicReference<SparkSession> org$apache$spark$sql$SparkSession$$defaultSession() {
        return this.org$apache$spark$sql$SparkSession$$defaultSession;
    }

    private String HIVE_SESSION_STATE_BUILDER_CLASS_NAME() {
        return this.HIVE_SESSION_STATE_BUILDER_CLASS_NAME;
    }

    public String org$apache$spark$sql$SparkSession$$sessionStateClassName(SparkConf conf) {
        String string;
        String string2 = (String)conf.get(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION());
        if ("hive".equals(string2)) {
            string = this.HIVE_SESSION_STATE_BUILDER_CLASS_NAME();
        } else if ("in-memory".equals(string2)) {
            string = SessionStateBuilder.class.getCanonicalName();
        } else {
            throw new MatchError((Object)string2);
        }
        return string;
    }

    public void org$apache$spark$sql$SparkSession$$assertOnDriver() {
        if (Utils$.MODULE$.isTesting() && TaskContext$.MODULE$.get() != null) {
            throw new IllegalStateException("SparkSession should only be created and accessed on the driver.");
        }
    }

    public SessionState org$apache$spark$sql$SparkSession$$instantiateSessionState(String className, SparkSession sparkSession) {
        SessionState sessionState;
        try {
            Class clazz = Utils$.MODULE$.classForName(className);
            Constructor ctor = (Constructor)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])clazz.getConstructors())).head();
            sessionState = ((BaseSessionStateBuilder)ctor.newInstance(sparkSession, None$.MODULE$)).build();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new IllegalArgumentException(new StringBuilder(29).append("Error while instantiating '").append(className).append("':").toString(), e);
            }
            throw throwable;
        }
        return sessionState;
    }

    public boolean hiveClassesArePresent() {
        boolean bl;
        try {
            Utils$.MODULE$.classForName(this.HIVE_SESSION_STATE_BUILDER_CLASS_NAME());
            Utils$.MODULE$.classForName("org.apache.hadoop.hive.conf.HiveConf");
            bl = true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl2 = throwable2 instanceof ClassNotFoundException ? true : throwable2 instanceof NoClassDefFoundError;
            if (!bl2) {
                throw throwable;
            }
            boolean bl3 = false;
            bl = bl3;
        }
        return bl;
    }

    public void cleanupAnyExistingSession() {
        block0: {
            Option session = this.getActiveSession().orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getDefaultSession());
            if (!session.isDefined()) break block0;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(269).append("An existing Spark session exists as the active or default session.\n           |This probably means another suite leaked it. Attempting to stop it before continuing.\n           |This existing Spark session was created at:\n           |\n           |").append(((SparkSession)session.get()).org$apache$spark$sql$SparkSession$$creationSite().longForm()).append("\n           |\n         ").toString())).stripMargin());
            ((SparkSession)session.get()).stop();
            this.clearActiveSession();
            this.clearDefaultSession();
        }
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SparkSession$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.org$apache$spark$sql$SparkSession$$activeThreadSession = new InheritableThreadLocal();
        this.org$apache$spark$sql$SparkSession$$defaultSession = new AtomicReference();
        this.HIVE_SESSION_STATE_BUILDER_CLASS_NAME = "org.apache.spark.sql.hive.HiveSessionStateBuilder";
    }
}

