/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.util;

import java.io.Serializable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.spark.SparkConf;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.QueryExecutionException;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.util.QueryExecutionListener;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@Experimental
@InterfaceStability.Evolving
@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\b\u0011\u0001mAQ\u0001\u000b\u0001\u0005\n%Ba\u0001\u000b\u0001\u0005\u0002Ia\u0003\"B\u001a\u0001\t\u0003!\u0004\"\u0002#\u0001\t\u0003)\u0005\"\u0002%\u0001\t\u0003I\u0005BB&\u0001\t\u0003\u0011B\nC\u0003Q\u0001\u0011\u0005\u0013\u0006\u0003\u0004S\u0001\u0011\u0005!c\u0015\u0005\u0007]\u0002!\tAE8\t\ru\u0004\u0001\u0015!\u0003\u007f\u0011!\ti\u0001\u0001Q\u0001\n\u0005=\u0001bBA\u0013\u0001\u0011%\u0011q\u0005\u0005\b\u0003g\u0001A\u0011BA\u001b\u0011\u001d\t9\u0006\u0001C\u0005\u00033\u0012\u0001$\u0012=fGV$\u0018n\u001c8MSN$XM\\3s\u001b\u0006t\u0017mZ3s\u0015\t\t\"#\u0001\u0003vi&d'BA\n\u0015\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003+Y\tQa\u001d9be.T!a\u0006\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0012aA8sO\u000e\u00011c\u0001\u0001\u001dEA\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t1\u0011I\\=SK\u001a\u0004\"a\t\u0014\u000e\u0003\u0011R!!\n\u000b\u0002\u0011%tG/\u001a:oC2L!a\n\u0013\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012A\u000b\t\u0003W\u0001i\u0011\u0001\u0005\u000b\u0003U5BQA\f\u0002A\u0002=\nAaY8oMB\u0011\u0001'M\u0007\u0002)%\u0011!\u0007\u0006\u0002\n'B\f'o[\"p]\u001a\f\u0001B]3hSN$XM\u001d\u000b\u0003ka\u0002\"!\b\u001c\n\u0005]r\"\u0001B+oSRDQ!O\u0002A\u0002i\n\u0001\u0002\\5ti\u0016tWM\u001d\t\u0003WmJ!\u0001\u0010\t\u0003-E+XM]=Fq\u0016\u001cW\u000f^5p]2K7\u000f^3oKJD#a\u0001 \u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005#\u0012AC1o]>$\u0018\r^5p]&\u00111\t\u0011\u0002\r\t\u00164X\r\\8qKJ\f\u0005/[\u0001\u000bk:\u0014XmZ5ti\u0016\u0014HCA\u001bG\u0011\u0015ID\u00011\u0001;Q\t!a(A\u0003dY\u0016\f'\u000fF\u00016Q\t)a(A\u0007mSN$H*[:uK:,'o\u001d\u000b\u0002\u001bB\u0019QD\u0014\u001e\n\u0005=s\"!B!se\u0006L\u0018!B2m_:,\u0007FA\u0004?\u0003%ygnU;dG\u0016\u001c8\u000f\u0006\u00036)\u0006L\u0007\"B+\t\u0001\u00041\u0016\u0001\u00034v]\u000et\u0015-\\3\u0011\u0005]sfB\u0001-]!\tIf$D\u0001[\u0015\tY&$\u0001\u0004=e>|GOP\u0005\u0003;z\ta\u0001\u0015:fI\u00164\u0017BA0a\u0005\u0019\u0019FO]5oO*\u0011QL\b\u0005\u0006E\"\u0001\raY\u0001\u0003c\u0016\u0004\"\u0001Z4\u000e\u0003\u0015T!A\u001a\n\u0002\u0013\u0015DXmY;uS>t\u0017B\u00015f\u00059\tV/\u001a:z\u000bb,7-\u001e;j_:DQA\u001b\u0005A\u0002-\f\u0001\u0002Z;sCRLwN\u001c\t\u0003;1L!!\u001c\u0010\u0003\t1{gnZ\u0001\n_:4\u0015-\u001b7ve\u0016$B!\u000e9re\")Q+\u0003a\u0001-\")!-\u0003a\u0001G\")1/\u0003a\u0001i\u0006\tA\u000f\u0005\u0002vu:\u0011a\u000f\u001f\b\u00033^L\u0011aH\u0005\u0003sz\tq\u0001]1dW\u0006<W-\u0003\u0002|y\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0003sz\t\u0011\u0002\\5ti\u0016tWM]:\u0011\t}\fIAO\u0007\u0003\u0003\u0003QA!a\u0001\u0002\u0006\u00059Q.\u001e;bE2,'bAA\u0004=\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005-\u0011\u0011\u0001\u0002\u000b\u0019&\u001cHOQ;gM\u0016\u0014\u0018\u0001\u00027pG.\u0004B!!\u0005\u0002\"5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"A\u0003m_\u000e\\7O\u0003\u0003\u0002\u001a\u0005m\u0011AC2p]\u000e,(O]3oi*\u0019\u0011#!\b\u000b\u0005\u0005}\u0011\u0001\u00026bm\u0006LA!a\t\u0002\u0014\t1\"+Z3oiJ\fg\u000e\u001e*fC\u0012<&/\u001b;f\u0019>\u001c7.A\txSRDWI\u001d:pe\"\u000bg\u000e\u001a7j]\u001e$2!NA\u0015\u0011\u001d\tY\u0003\u0004a\u0001\u0003[\t\u0011A\u001a\t\u0006;\u0005=\"(N\u0005\u0004\u0003cq\"!\u0003$v]\u000e$\u0018n\u001c82\u0003!\u0011X-\u00193M_\u000e\\W\u0003BA\u001c\u0003{!B!!\u000f\u0002PA!\u00111HA\u001f\u0019\u0001!q!a\u0010\u000e\u0005\u0004\t\tEA\u0001B#\u0011\t\u0019%!\u0013\u0011\u0007u\t)%C\u0002\u0002Hy\u0011qAT8uQ&tw\rE\u0002\u001e\u0003\u0017J1!!\u0014\u001f\u0005\r\te.\u001f\u0005\t\u0003WiA\u00111\u0001\u0002RA)Q$a\u0015\u0002:%\u0019\u0011Q\u000b\u0010\u0003\u0011q\u0012\u0017P\\1nKz\n\u0011b\u001e:ji\u0016dunY6\u0016\t\u0005m\u0013q\f\u000b\u0005\u0003;\n\t\u0007\u0005\u0003\u0002<\u0005}CaBA \u001d\t\u0007\u0011\u0011\t\u0005\t\u0003WqA\u00111\u0001\u0002dA)Q$a\u0015\u0002^!\u001a\u0001!a\u001a\u0011\t\u0005%\u0014q\u000e\b\u0004\u007f\u0005-\u0014bAA7\u0001\u0006\u0011\u0012J\u001c;fe\u001a\f7-Z*uC\nLG.\u001b;z\u0013\u0011\t\t(a\u001d\u0003\u0011\u00153x\u000e\u001c<j]\u001eT1!!\u001cAQ\r\u0001\u0011q\u000f\t\u0004\u007f\u0005e\u0014bAA>\u0001\naQ\t\u001f9fe&lWM\u001c;bY\u0002")
public class ExecutionListenerManager
implements Logging {
    private final ListBuffer<QueryExecutionListener> listeners;
    private final ReentrantReadWriteLock lock;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @DeveloperApi
    public void register(QueryExecutionListener listener) {
        this.writeLock((Function0 & Serializable & scala.Serializable)() -> $this.listeners.$plus$eq((Object)listener));
    }

    @DeveloperApi
    public void unregister(QueryExecutionListener listener) {
        this.writeLock((Function0 & Serializable & scala.Serializable)() -> $this.listeners.$minus$eq((Object)listener));
    }

    @DeveloperApi
    public void clear() {
        this.writeLock((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.listeners.clear());
    }

    public QueryExecutionListener[] listListeners() {
        return (QueryExecutionListener[])this.listeners.toArray(ClassTag$.MODULE$.apply(QueryExecutionListener.class));
    }

    @DeveloperApi
    public ExecutionListenerManager clone() {
        return (ExecutionListenerManager)this.writeLock((Function0 & Serializable & scala.Serializable)() -> {
            void var1_1;
            ExecutionListenerManager newListenerManager = new ExecutionListenerManager();
            $this.listeners.foreach((Function1 & Serializable & scala.Serializable)listener -> {
                newListenerManager.register(listener);
                return BoxedUnit.UNIT;
            });
            return var1_1;
        });
    }

    public void onSuccess(String funcName, QueryExecution qe, long duration) {
        this.readLock((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withErrorHandling((Function1<QueryExecutionListener, BoxedUnit>)(Function1 & Serializable & scala.Serializable)listener -> {
            listener.onSuccess(funcName, qe, duration);
            return BoxedUnit.UNIT;
        }));
    }

    public void onFailure(String funcName, QueryExecution qe, Throwable t) {
        Exception exception;
        Throwable throwable = t;
        if (throwable instanceof Exception) {
            Exception exception2;
            exception = exception2 = (Exception)throwable;
        } else if (throwable != null) {
            Throwable throwable2 = throwable;
            String message = new StringBuilder(35).append("Hit an error when executing a query").append((Object)(throwable2.getMessage() == null ? "" : new StringBuilder(2).append(": ").append(throwable2.getMessage()).toString())).toString();
            exception = new QueryExecutionException(message, throwable2);
        } else {
            throw new MatchError((Object)throwable);
        }
        Exception exception3 = exception;
        this.readLock((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withErrorHandling((Function1<QueryExecutionListener, BoxedUnit>)(Function1 & Serializable & scala.Serializable)listener -> {
            listener.onFailure(funcName, qe, exception3);
            return BoxedUnit.UNIT;
        }));
    }

    private void withErrorHandling(Function1<QueryExecutionListener, BoxedUnit> f) {
        this.listeners.foreach((Function1 & Serializable & scala.Serializable)listener -> {
            ExecutionListenerManager.$anonfun$withErrorHandling$1(this, f, listener);
            return BoxedUnit.UNIT;
        });
    }

    private <A> A readLock(Function0<A> f) {
        Object object;
        ReentrantReadWriteLock.ReadLock rl = this.lock.readLock();
        rl.lock();
        try {
            object = f.apply();
        }
        finally {
            rl.unlock();
        }
        return (A)object;
    }

    private <A> A writeLock(Function0<A> f) {
        Object object;
        ReentrantReadWriteLock.WriteLock wl = this.lock.writeLock();
        wl.lock();
        try {
            object = f.apply();
        }
        finally {
            wl.unlock();
        }
        return (A)object;
    }

    public static final /* synthetic */ void $anonfun$new$1(ExecutionListenerManager $this, SparkConf conf$1, Seq classNames) {
        Utils$.MODULE$.loadExtensions(QueryExecutionListener.class, classNames, conf$1).foreach((Function1 & Serializable & scala.Serializable)listener -> {
            $this.register(listener);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$withErrorHandling$1(ExecutionListenerManager $this, Function1 f$1, QueryExecutionListener listener) {
        try {
            f$1.apply((Object)listener);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error executing query execution listener", e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private ExecutionListenerManager() {
        Logging.$init$((Logging)this);
        this.listeners = (ListBuffer)ListBuffer$.MODULE$.empty();
        this.lock = new ReentrantReadWriteLock();
    }

    public ExecutionListenerManager(SparkConf conf) {
        this();
        ((Option)conf.get((ConfigEntry)StaticSQLConf$.MODULE$.QUERY_EXECUTION_LISTENERS())).foreach((Function1 & Serializable & scala.Serializable)classNames -> {
            ExecutionListenerManager.$anonfun$new$1(this, conf, classNames);
            return BoxedUnit.UNIT;
        });
    }
}

