/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster;

import java.io.Serializable;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.yarn.Client;
import org.apache.spark.deploy.yarn.ClientArguments;
import org.apache.spark.deploy.yarn.YarnAppReport;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.SchedulerBackendUtils$;
import org.apache.spark.scheduler.cluster.YarnSchedulerBackend;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001I4Q!\u0006\f\u00015\u0001B\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\ta\u0001\u0011\t\u0011)A\u0005c!)Q\u0007\u0001C\u0001m!9!\b\u0001a\u0001\n\u0013Y\u0004b\u0002#\u0001\u0001\u0004%I!\u0012\u0005\u0007\u001d\u0002\u0001\u000b\u0015\u0002\u001f\t\u000f=\u0003\u0001\u0019!C\u0005!\"9!\u000e\u0001a\u0001\n\u0013Y\u0007BB7\u0001A\u0003&\u0011\u000bC\u0003o\u0001\u0011\u0005\u0003\u000eC\u0003p\u0001\u0011%\u0001N\u0002\u0003T\u0001\u0011!\u0006\"B\u001b\r\t\u0003i\u0006b\u00020\r\u0001\u0004%Ia\u0018\u0005\bG2\u0001\r\u0011\"\u0003e\u0011\u00191G\u0002)Q\u0005A\")q\r\u0004C!Q\")\u0011\u000e\u0004C\u0001Q\")\u0001\u000f\u0001C\u0005;\")\u0011\u000f\u0001C!Q\nQ\u0012,\u0019:o\u00072LWM\u001c;TG\",G-\u001e7fe\n\u000b7m[3oI*\u0011q\u0003G\u0001\bG2,8\u000f^3s\u0015\tI\"$A\u0005tG\",G-\u001e7fe*\u00111\u0004H\u0001\u0006gB\f'o\u001b\u0006\u0003;y\ta!\u00199bG\",'\"A\u0010\u0002\u0007=\u0014xmE\u0002\u0001C\u0015\u0002\"AI\u0012\u000e\u0003YI!\u0001\n\f\u0003)e\u000b'O\\*dQ\u0016$W\u000f\\3s\u0005\u0006\u001c7.\u001a8e!\t1\u0013&D\u0001(\u0015\tA#$\u0001\u0005j]R,'O\\1m\u0013\tQsEA\u0004M_\u001e<\u0017N\\4\u0004\u0001A\u0011QFL\u0007\u00021%\u0011q\u0006\u0007\u0002\u0012)\u0006\u001c8nU2iK\u0012,H.\u001a:J[Bd\u0017AA:d!\t\u00114'D\u0001\u001b\u0013\t!$D\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0004oaJ\u0004C\u0001\u0012\u0001\u0011\u0015I2\u00011\u0001-\u0011\u0015\u00014\u00011\u00012\u0003\u0019\u0019G.[3oiV\tA\b\u0005\u0002>\u00056\taH\u0003\u0002@\u0001\u0006!\u00110\u0019:o\u0015\t\t%$\u0001\u0004eKBdw._\u0005\u0003\u0007z\u0012aa\u00117jK:$\u0018AC2mS\u0016tGo\u0018\u0013fcR\u0011a\t\u0014\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0002\u0013\u0006)1oY1mC&\u00111\n\u0013\u0002\u0005+:LG\u000fC\u0004N\u000b\u0005\u0005\t\u0019\u0001\u001f\u0002\u0007a$\u0013'A\u0004dY&,g\u000e\u001e\u0011\u0002\u001b5|g.\u001b;peRC'/Z1e+\u0005\t\u0006C\u0001*\r\u001b\u0005\u0001!!D'p]&$xN\u001d+ie\u0016\fGm\u0005\u0002\r+B\u0011akW\u0007\u0002/*\u0011\u0001,W\u0001\u0005Y\u0006twMC\u0001[\u0003\u0011Q\u0017M^1\n\u0005q;&A\u0002+ie\u0016\fG\rF\u0001R\u00039\tG\u000e\\8x\u0013:$XM\u001d:vaR,\u0012\u0001\u0019\t\u0003\u000f\u0006L!A\u0019%\u0003\u000f\t{w\u000e\\3b]\u0006\u0011\u0012\r\u001c7po&sG/\u001a:skB$x\fJ3r)\t1U\rC\u0004N\u001f\u0005\u0005\t\u0019\u00011\u0002\u001f\u0005dGn\\<J]R,'O];qi\u0002\n1A];o)\u00051\u0015aC:u_BluN\\5u_J\f\u0011#\\8oSR|'\u000f\u00165sK\u0006$w\fJ3r)\t1E\u000eC\u0004N\u0011\u0005\u0005\t\u0019A)\u0002\u001d5|g.\u001b;peRC'/Z1eA\u0005)1\u000f^1si\u0006\u0011r/Y5u\r>\u0014\u0018\t\u001d9mS\u000e\fG/[8o\u0003]\t7/\u001f8d\u001b>t\u0017\u000e^8s\u0003B\u0004H.[2bi&|g.\u0001\u0003ti>\u0004\b")
public class YarnClientSchedulerBackend
extends YarnSchedulerBackend {
    public final SparkContext org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$sc;
    private Client org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client;
    private MonitorThread monitorThread;

    public Client org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client() {
        return this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client;
    }

    private void org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client_$eq(Client x$1) {
        this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client = x$1;
    }

    private MonitorThread monitorThread() {
        return this.monitorThread;
    }

    private void monitorThread_$eq(MonitorThread x$1) {
        this.monitorThread = x$1;
    }

    @Override
    public void start() {
        String driverHost = this.conf().get("spark.driver.host");
        String driverPort = this.conf().get("spark.driver.port");
        String hostport = new StringBuilder(1).append(driverHost).append(":").append(driverPort).toString();
        this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$sc.ui().foreach((Function1 & Serializable & scala.Serializable)ui -> this.conf().set("spark.driver.appUIAddress", ui.webUrl()));
        ArrayBuffer argsArrayBuf = new ArrayBuffer();
        argsArrayBuf.$plus$eq((Object)"--arg", (Object)hostport, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("ClientArguments called with: ").append(argsArrayBuf.mkString(" ")).toString());
        ClientArguments args = new ClientArguments((String[])argsArrayBuf.toArray(ClassTag$.MODULE$.apply(String.class)));
        this.totalExpectedExecutors_$eq(SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber(this.conf(), SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber$default$2()));
        this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client_$eq(new Client(args, this.conf()));
        this.bindToYarn(this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client().submitApplication(), (Option<ApplicationAttemptId>)None$.MODULE$);
        super.start();
        this.waitForApplication();
        this.monitorThread_$eq(this.asyncMonitorApplication());
        this.monitorThread().start();
    }

    private void waitForApplication() {
        block10: {
            YarnApplicationState state;
            block9: {
                String string;
                Option diags;
                block8: {
                    long monitorInterval = BoxesRunTime.unboxToLong((Object)this.conf().get(package$.MODULE$.CLIENT_LAUNCH_MONITOR_INTERVAL()));
                    Predef$.MODULE$.assert(this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client() != null && this.appId().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Application has not been submitted yet!");
                    Client qual$1 = this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client();
                    ApplicationId x$1 = (ApplicationId)this.appId().get();
                    boolean x$2 = true;
                    long x$3 = monitorInterval;
                    boolean x$4 = qual$1.monitorApplication$default$3();
                    YarnAppReport yarnAppReport = qual$1.monitorApplication(x$1, x$2, x$4, x$3);
                    if (yarnAppReport == null) {
                        throw new MatchError((Object)yarnAppReport);
                    }
                    YarnApplicationState state2 = yarnAppReport.appState();
                    Option<String> diags2 = yarnAppReport.diagnostics();
                    Tuple2 tuple2 = new Tuple2((Object)state2, diags2);
                    Tuple2 tuple22 = tuple2;
                    state = (YarnApplicationState)tuple22._1();
                    diags = (Option)tuple22._2();
                    YarnApplicationState yarnApplicationState = state;
                    YarnApplicationState yarnApplicationState2 = YarnApplicationState.FINISHED;
                    if (!(yarnApplicationState == null ? yarnApplicationState2 != null : !yarnApplicationState.equals(yarnApplicationState2))) break block8;
                    YarnApplicationState yarnApplicationState3 = state;
                    YarnApplicationState yarnApplicationState4 = YarnApplicationState.FAILED;
                    if (!(yarnApplicationState3 == null ? yarnApplicationState4 != null : !yarnApplicationState3.equals(yarnApplicationState4))) break block8;
                    YarnApplicationState yarnApplicationState5 = state;
                    YarnApplicationState yarnApplicationState6 = YarnApplicationState.KILLED;
                    if (yarnApplicationState5 != null ? !yarnApplicationState5.equals(yarnApplicationState6) : yarnApplicationState6 != null) break block9;
                }
                String genericMessage = "The YARN application has already ended! It might have been killed or the Application Master may have failed to start. Check the YARN application logs for more details.";
                Option option = diags;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String msg = (String)some.value();
                    this.logError((Function0 & Serializable & scala.Serializable)() -> genericMessage);
                    string = msg;
                } else if (None$.MODULE$.equals(option)) {
                    string = genericMessage;
                } else {
                    throw new MatchError((Object)option);
                }
                String exceptionMsg = string;
                throw new SparkException(exceptionMsg);
            }
            YarnApplicationState yarnApplicationState = state;
            YarnApplicationState yarnApplicationState7 = YarnApplicationState.RUNNING;
            if (yarnApplicationState != null ? !yarnApplicationState.equals(yarnApplicationState7) : yarnApplicationState7 != null) break block10;
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Application ").append(this.appId().get()).append(" has started running.").toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private MonitorThread asyncMonitorApplication() {
        void var1_1;
        Predef$.MODULE$.assert(this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client() != null && this.appId().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Application has not been submitted yet!");
        MonitorThread t = new MonitorThread();
        t.setName("YARN application state monitor");
        t.setDaemon(true);
        return var1_1;
    }

    @Override
    public void stop() {
        Predef$.MODULE$.assert(this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client() != null, (Function0 & Serializable & scala.Serializable)() -> "Attempted to stop this scheduler before starting it!");
        if (this.monitorThread() != null) {
            this.monitorThread().stopMonitor();
        }
        this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client().reportLauncherState(SparkAppHandle.State.FINISHED);
        super.stop();
        this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client().stop();
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> "Stopped");
    }

    public YarnClientSchedulerBackend(TaskSchedulerImpl scheduler, SparkContext sc) {
        this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$sc = sc;
        super(scheduler, sc);
        this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client = null;
        this.monitorThread = null;
    }

    public class MonitorThread
    extends Thread {
        private boolean allowInterrupt;

        private boolean allowInterrupt() {
            return this.allowInterrupt;
        }

        private void allowInterrupt_$eq(boolean x$1) {
            this.allowInterrupt = x$1;
        }

        @Override
        public void run() {
            try {
                Client qual$1 = this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$MonitorThread$$$outer().org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client();
                ApplicationId x$1 = (ApplicationId)this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$MonitorThread$$$outer().appId().get();
                boolean x$2 = false;
                boolean x$3 = qual$1.monitorApplication$default$2();
                long x$4 = qual$1.monitorApplication$default$4();
                YarnAppReport yarnAppReport = qual$1.monitorApplication(x$1, x$3, x$2, x$4);
                if (yarnAppReport == null) {
                    throw new MatchError((Object)yarnAppReport);
                }
                FinalApplicationStatus state = yarnAppReport.finalState();
                Option<String> diags = yarnAppReport.diagnostics();
                Tuple2 tuple2 = new Tuple2((Object)state, diags);
                Tuple2 tuple22 = tuple2;
                FinalApplicationStatus state2 = (FinalApplicationStatus)tuple22._1();
                Option diags2 = (Option)tuple22._2();
                this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$MonitorThread$$$outer().logError((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(103).append("YARN application has exited unexpectedly with state ").append(state2).append("! ").append("Check the YARN application logs for more details.").toString());
                diags2.foreach((Function1 & Serializable & scala.Serializable)err -> {
                    MonitorThread.$anonfun$run$2(this, err);
                    return BoxedUnit.UNIT;
                });
                this.allowInterrupt_$eq(false);
                this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$MonitorThread$$$outer().org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$sc.stop();
            }
            catch (InterruptedException e) {
                this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$MonitorThread$$$outer().logInfo((Function0 & Serializable & scala.Serializable)() -> "Interrupting monitor thread");
            }
        }

        public void stopMonitor() {
            block0: {
                if (!this.allowInterrupt()) break block0;
                this.interrupt();
            }
        }

        public /* synthetic */ YarnClientSchedulerBackend org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$MonitorThread$$$outer() {
            return YarnClientSchedulerBackend.this;
        }

        public static final /* synthetic */ void $anonfun$run$2(MonitorThread $this, String err) {
            $this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$MonitorThread$$$outer().logError((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Diagnostics message: ").append(err).toString());
        }

        public MonitorThread() {
            if (YarnClientSchedulerBackend.this == null) {
                throw null;
            }
            this.allowInterrupt = true;
        }
    }
}

