/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster;

import java.io.Serializable;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.yarn.ApplicationMaster$;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.SchedulerBackendUtils$;
import org.apache.spark.scheduler.cluster.YarnSchedulerBackend;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00013QAB\u0004\u0001\u0017EA\u0001B\u0003\u0001\u0003\u0002\u0003\u0006Ia\u0006\u0005\t7\u0001\u0011\t\u0011)A\u00059!)\u0001\u0005\u0001C\u0001C!)Q\u0005\u0001C!M!)Q\u0006\u0001C!]\tY\u0012,\u0019:o\u00072,8\u000f^3s'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012T!\u0001C\u0005\u0002\u000f\rdWo\u001d;fe*\u0011!bC\u0001\ng\u000eDW\rZ;mKJT!\u0001D\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00059y\u0011AB1qC\u000eDWMC\u0001\u0011\u0003\ry'oZ\n\u0003\u0001I\u0001\"a\u0005\u000b\u000e\u0003\u001dI!!F\u0004\u0003)e\u000b'O\\*dQ\u0016$W\u000f\\3s\u0005\u0006\u001c7.\u001a8e\u0007\u0001\u0001\"\u0001G\r\u000e\u0003%I!AG\u0005\u0003#Q\u000b7o[*dQ\u0016$W\u000f\\3s\u00136\u0004H.\u0001\u0002tGB\u0011QDH\u0007\u0002\u0017%\u0011qd\u0003\u0002\r'B\f'o[\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\t\u001aC\u0005\u0005\u0002\u0014\u0001!)!b\u0001a\u0001/!)1d\u0001a\u00019\u0005)1\u000f^1siR\tq\u0005\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013F\u0001\u0003V]&$\u0018\u0001E4fi\u0012\u0013\u0018N^3s\u0019><WK\u001d7t+\u0005y\u0003c\u0001\u00151e%\u0011\u0011'\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\tMRT(\u0010\b\u0003ia\u0002\"!N\u0015\u000e\u0003YR!a\u000e\f\u0002\rq\u0012xn\u001c;?\u0013\tI\u0014&\u0001\u0004Qe\u0016$WMZ\u0005\u0003wq\u00121!T1q\u0015\tI\u0014\u0006\u0005\u00024}%\u0011q\b\u0010\u0002\u0007'R\u0014\u0018N\\4")
public class YarnClusterSchedulerBackend
extends YarnSchedulerBackend {
    private final SparkContext sc;

    @Override
    public void start() {
        ApplicationAttemptId attemptId = ApplicationMaster$.MODULE$.getAttemptId();
        this.bindToYarn(attemptId.getApplicationId(), (Option<ApplicationAttemptId>)new Some((Object)attemptId));
        super.start();
        this.totalExpectedExecutors_$eq(SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber(this.sc.conf(), SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber$default$2()));
    }

    /*
     * WARNING - void declaration
     */
    public Option<Map<String, String>> getDriverLogUrls() {
        void var1_1;
        None$ driverLogs = None$.MODULE$;
        try {
            YarnConfiguration yarnConf = new YarnConfiguration(this.sc.hadoopConfiguration());
            ContainerId containerId = YarnSparkHadoopUtil$.MODULE$.getContainerId();
            String httpAddress = new StringBuilder(1).append(System.getenv(ApplicationConstants.Environment.NM_HOST.name())).append(":").append(System.getenv(ApplicationConstants.Environment.NM_HTTP_PORT.name())).toString();
            String yarnHttpPolicy = yarnConf.get("yarn.http.policy", YarnConfiguration.YARN_HTTP_POLICY_DEFAULT);
            String user = Utils$.MODULE$.getCurrentUserName();
            String string = yarnHttpPolicy;
            String string2 = "HTTPS_ONLY";
            String httpScheme = !(string != null ? !string.equals(string2) : string2 != null) ? "https://" : "http://";
            String baseUrl = new StringBuilder(21).append(httpScheme).append(httpAddress).append("/node/containerlogs/").append(containerId).append("/").append(user).toString();
            this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Base URL for logs: ").append(baseUrl).toString());
            driverLogs = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stdout"), (Object)new StringBuilder(19).append(baseUrl).append("/stdout?start=-4096").toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stderr"), (Object)new StringBuilder(19).append(baseUrl).append("/stderr?start=-4096").toString())})));
        }
        catch (Exception e) {
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> "Error while building AM log links, so AM logs link will not appear in application UI", e);
        }
        return var1_1;
    }

    public YarnClusterSchedulerBackend(TaskSchedulerImpl scheduler, SparkContext sc) {
        this.sc = sc;
        super(scheduler, sc);
    }
}

