/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.token.SignatureConfirmation;
import org.apache.ws.security.processor.Processor;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureConfirmationProcessor
implements Processor {
    private static Log log = LogFactory.getLog(SignatureConfirmationProcessor.class);

    @Override
    public List<WSSecurityEngineResult> handleToken(Element elem, RequestData data, WSDocInfo wsDocInfo) throws WSSecurityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Found SignatureConfirmation list element");
        }
        SignatureConfirmation sigConf = new SignatureConfirmation(elem);
        String id = sigConf.getID();
        if (data.getWssConfig().isWsiBSPCompliant() && (id == null || "".equals(id))) {
            throw new WSSecurityException(3, "requiredElementNoID", new Object[]{elem.getLocalName()});
        }
        WSSecurityEngineResult result = new WSSecurityEngineResult(128, sigConf);
        if (!"".equals(id)) {
            result.put("id", id);
        }
        wsDocInfo.addResult(result);
        wsDocInfo.addTokenElement(elem);
        return Collections.singletonList(result);
    }
}

