/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.Constant;

public final class ConstantInvokeDynamic
extends Constant {
    private final int bootstrapMethodAttrIndex;
    private final int nameAndTypeIndex;

    ConstantInvokeDynamic(DataInputStream dataInputStream) throws IOException {
        this(dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort());
    }

    public ConstantInvokeDynamic(int n, int n2) {
        super((byte)18);
        this.bootstrapMethodAttrIndex = n;
        this.nameAndTypeIndex = n2;
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.tag);
        dataOutputStream.writeShort(this.bootstrapMethodAttrIndex);
        dataOutputStream.writeShort(this.nameAndTypeIndex);
    }

    public final int getNameAndTypeIndex() {
        return this.nameAndTypeIndex;
    }

    public final int getBootstrapMethodAttrIndex() {
        return this.bootstrapMethodAttrIndex;
    }

    @Override
    public final String toString() {
        return super.toString() + "(bootstrapMethodAttrIndex=" + this.bootstrapMethodAttrIndex + ",nameAndTypeIndex=" + this.nameAndTypeIndex + ")";
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    @Override
    public void accept(ClassVisitor classVisitor) {
        classVisitor.visitConstantInvokeDynamic(this);
    }
}

