/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile.annotation;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.ConstantDouble;
import org.aspectj.apache.bcel.classfile.ConstantFloat;
import org.aspectj.apache.bcel.classfile.ConstantInteger;
import org.aspectj.apache.bcel.classfile.ConstantLong;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.classfile.annotation.ElementValue;

public class SimpleElementValue
extends ElementValue {
    private int idx;

    protected SimpleElementValue(int n, int n2, ConstantPool constantPool) {
        super(n, constantPool);
        this.idx = n2;
    }

    public SimpleElementValue(int n, ConstantPool constantPool, int n2) {
        super(n, constantPool);
        this.idx = constantPool.addInteger(n2);
    }

    public SimpleElementValue(int n, ConstantPool constantPool, long l) {
        super(n, constantPool);
        this.idx = constantPool.addLong(l);
    }

    public SimpleElementValue(int n, ConstantPool constantPool, double d) {
        super(n, constantPool);
        this.idx = constantPool.addDouble(d);
    }

    public SimpleElementValue(int n, ConstantPool constantPool, float f) {
        super(n, constantPool);
        this.idx = constantPool.addFloat(f);
    }

    public SimpleElementValue(int n, ConstantPool constantPool, short s) {
        super(n, constantPool);
        this.idx = constantPool.addInteger(s);
    }

    public SimpleElementValue(int n, ConstantPool constantPool, byte by) {
        super(n, constantPool);
        this.idx = constantPool.addInteger(by);
    }

    public SimpleElementValue(int n, ConstantPool constantPool, char c) {
        super(n, constantPool);
        this.idx = constantPool.addInteger(c);
    }

    public SimpleElementValue(int n, ConstantPool constantPool, boolean bl) {
        super(n, constantPool);
        this.idx = bl ? constantPool.addInteger(1) : constantPool.addInteger(0);
    }

    public SimpleElementValue(int n, ConstantPool constantPool, String string) {
        super(n, constantPool);
        this.idx = constantPool.addUtf8(string);
    }

    public byte getValueByte() {
        if (this.type != 66) {
            throw new RuntimeException("Dont call getValueByte() on a non BYTE ElementValue");
        }
        ConstantInteger constantInteger = (ConstantInteger)this.cpool.getConstant(this.idx, (byte)3);
        return (byte)constantInteger.getIntValue();
    }

    public char getValueChar() {
        if (this.type != 67) {
            throw new RuntimeException("Dont call getValueChar() on a non CHAR ElementValue");
        }
        ConstantInteger constantInteger = (ConstantInteger)this.cpool.getConstant(this.idx, (byte)3);
        return (char)constantInteger.getIntValue();
    }

    public long getValueLong() {
        if (this.type != 74) {
            throw new RuntimeException("Dont call getValueLong() on a non LONG ElementValue");
        }
        ConstantLong constantLong = (ConstantLong)this.cpool.getConstant(this.idx);
        return constantLong.getValue();
    }

    public float getValueFloat() {
        if (this.type != 70) {
            throw new RuntimeException("Dont call getValueFloat() on a non FLOAT ElementValue");
        }
        ConstantFloat constantFloat = (ConstantFloat)this.cpool.getConstant(this.idx);
        return constantFloat.getValue().floatValue();
    }

    public double getValueDouble() {
        if (this.type != 68) {
            throw new RuntimeException("Dont call getValueDouble() on a non DOUBLE ElementValue");
        }
        ConstantDouble constantDouble = (ConstantDouble)this.cpool.getConstant(this.idx);
        return constantDouble.getValue();
    }

    public boolean getValueBoolean() {
        if (this.type != 90) {
            throw new RuntimeException("Dont call getValueBoolean() on a non BOOLEAN ElementValue");
        }
        ConstantInteger constantInteger = (ConstantInteger)this.cpool.getConstant(this.idx);
        return constantInteger.getValue() != 0;
    }

    public short getValueShort() {
        if (this.type != 83) {
            throw new RuntimeException("Dont call getValueShort() on a non SHORT ElementValue");
        }
        ConstantInteger constantInteger = (ConstantInteger)this.cpool.getConstant(this.idx);
        return (short)constantInteger.getIntValue();
    }

    public SimpleElementValue(SimpleElementValue simpleElementValue, ConstantPool constantPool, boolean bl) {
        super(simpleElementValue.getElementValueType(), constantPool);
        if (!bl) {
            this.idx = simpleElementValue.getIndex();
        } else {
            switch (simpleElementValue.getElementValueType()) {
                case 115: {
                    this.idx = constantPool.addUtf8(simpleElementValue.getValueString());
                    break;
                }
                case 73: {
                    this.idx = constantPool.addInteger(simpleElementValue.getValueInt());
                    break;
                }
                case 66: {
                    this.idx = constantPool.addInteger(simpleElementValue.getValueByte());
                    break;
                }
                case 67: {
                    this.idx = constantPool.addInteger(simpleElementValue.getValueChar());
                    break;
                }
                case 74: {
                    this.idx = constantPool.addLong(simpleElementValue.getValueLong());
                    break;
                }
                case 70: {
                    this.idx = constantPool.addFloat(simpleElementValue.getValueFloat());
                    break;
                }
                case 68: {
                    this.idx = constantPool.addDouble(simpleElementValue.getValueDouble());
                    break;
                }
                case 90: {
                    if (simpleElementValue.getValueBoolean()) {
                        this.idx = constantPool.addInteger(1);
                        break;
                    }
                    this.idx = constantPool.addInteger(0);
                    break;
                }
                case 83: {
                    this.idx = constantPool.addInteger(simpleElementValue.getValueShort());
                    break;
                }
                default: {
                    throw new RuntimeException("SimpleElementValueGen class does not know how to copy this type " + this.type);
                }
            }
        }
    }

    public int getIndex() {
        return this.idx;
    }

    public String getValueString() {
        if (this.type != 115) {
            throw new RuntimeException("Dont call getValueString() on a non STRING ElementValue");
        }
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.cpool.getConstant(this.idx);
        return constantUtf8.getValue();
    }

    public int getValueInt() {
        if (this.type != 73) {
            throw new RuntimeException("Dont call getValueString() on a non STRING ElementValue");
        }
        ConstantInteger constantInteger = (ConstantInteger)this.cpool.getConstant(this.idx);
        return constantInteger.getValue();
    }

    @Override
    public String stringifyValue() {
        switch (this.type) {
            case 73: {
                ConstantInteger constantInteger = (ConstantInteger)this.cpool.getConstant(this.idx);
                return Integer.toString(constantInteger.getValue());
            }
            case 74: {
                ConstantLong constantLong = (ConstantLong)this.cpool.getConstant(this.idx);
                return Long.toString(constantLong.getValue());
            }
            case 68: {
                ConstantDouble constantDouble = (ConstantDouble)this.cpool.getConstant(this.idx);
                return constantDouble.getValue().toString();
            }
            case 70: {
                ConstantFloat constantFloat = (ConstantFloat)this.cpool.getConstant(this.idx);
                return Float.toString(constantFloat.getValue().floatValue());
            }
            case 83: {
                ConstantInteger constantInteger = (ConstantInteger)this.cpool.getConstant(this.idx);
                return Integer.toString(constantInteger.getValue());
            }
            case 66: {
                ConstantInteger constantInteger = (ConstantInteger)this.cpool.getConstant(this.idx);
                return Integer.toString(constantInteger.getValue());
            }
            case 67: {
                ConstantInteger constantInteger = (ConstantInteger)this.cpool.getConstant(this.idx);
                return new Character((char)constantInteger.getIntValue()).toString();
            }
            case 90: {
                ConstantInteger constantInteger = (ConstantInteger)this.cpool.getConstant(this.idx);
                if (constantInteger.getValue() == 0) {
                    return "false";
                }
                return "true";
            }
            case 115: {
                ConstantUtf8 constantUtf8 = (ConstantUtf8)this.cpool.getConstant(this.idx);
                return constantUtf8.getValue();
            }
        }
        throw new RuntimeException("SimpleElementValueGen class does not know how to stringify type " + this.type);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.type) {
            case 73: {
                ConstantInteger constantInteger = (ConstantInteger)this.cpool.getConstant(this.idx);
                stringBuilder.append("(int)").append(Integer.toString(constantInteger.getValue()));
                break;
            }
            case 74: {
                ConstantLong constantLong = (ConstantLong)this.cpool.getConstant(this.idx);
                stringBuilder.append("(long)").append(Long.toString(constantLong.getValue()));
                break;
            }
            case 68: {
                ConstantDouble constantDouble = (ConstantDouble)this.cpool.getConstant(this.idx);
                stringBuilder.append("(double)").append(constantDouble.getValue().toString());
                break;
            }
            case 70: {
                ConstantFloat constantFloat = (ConstantFloat)this.cpool.getConstant(this.idx);
                stringBuilder.append("(float)").append(Float.toString(constantFloat.getValue().floatValue()));
                break;
            }
            case 83: {
                ConstantInteger constantInteger = (ConstantInteger)this.cpool.getConstant(this.idx);
                stringBuilder.append("(short)").append(Integer.toString(constantInteger.getValue()));
                break;
            }
            case 66: {
                ConstantInteger constantInteger = (ConstantInteger)this.cpool.getConstant(this.idx);
                stringBuilder.append("(byte)").append(Integer.toString(constantInteger.getValue()));
                break;
            }
            case 67: {
                ConstantInteger constantInteger = (ConstantInteger)this.cpool.getConstant(this.idx);
                stringBuilder.append("(char)").append(new Character((char)constantInteger.getIntValue()).toString());
                break;
            }
            case 90: {
                ConstantInteger constantInteger = (ConstantInteger)this.cpool.getConstant(this.idx);
                stringBuilder.append("(boolean)");
                if (constantInteger.getValue() == 0) {
                    stringBuilder.append("false");
                    break;
                }
                stringBuilder.append("true");
                break;
            }
            case 115: {
                ConstantUtf8 constantUtf8 = (ConstantUtf8)this.cpool.getConstant(this.idx);
                stringBuilder.append("(string)").append(constantUtf8.getValue());
                break;
            }
            default: {
                throw new RuntimeException("SimpleElementValueGen class does not know how to stringify type " + this.type);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.type);
        switch (this.type) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                dataOutputStream.writeShort(this.idx);
                break;
            }
            default: {
                throw new RuntimeException("SimpleElementValueGen doesnt know how to write out type " + this.type);
            }
        }
    }
}

