/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.jta;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Provider;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

public class Transaction {
    private static final InheritableThreadLocal<Provider<UserTransaction>> userTransactionProviders = new InheritableThreadLocal();

    @Inject
    private static void injectTransactionProvider(Provider<UserTransaction> provider) {
        userTransactionProviders.set(provider);
    }

    public static void require(final Runnable runnable) {
        Transaction.require(new ReturningRunnable<Void, RuntimeException>(){

            @Override
            public Void run() {
                runnable.run();
                return null;
            }
        });
    }

    public static <E extends Throwable> void require(final ThrowingRunnable<E> runnable) throws E {
        Transaction.require(new ReturningRunnable<Void, E>(){

            @Override
            public Void run() throws Throwable {
                runnable.run();
                return null;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T, E extends Throwable> T require(ReturningRunnable<T, E> runnable) throws E {
        Preconditions.checkNotNull(userTransactionProviders.get(), (Object)"Transactions not supported. You need to add <transactional/> to your configuration file.");
        UserTransaction userTransaction = (UserTransaction)((Provider)userTransactionProviders.get()).get();
        boolean myTransaction = false;
        try {
            if (userTransaction.getStatus() == 6) {
                userTransaction.begin();
                myTransaction = true;
            }
            try {
                T t = runnable.run();
                return t;
            }
            catch (RuntimeException e) {
                userTransaction.setRollbackOnly();
                throw e;
            }
            finally {
                if (myTransaction) {
                    if (userTransaction.getStatus() == 1) {
                        userTransaction.rollback();
                    } else {
                        userTransaction.commit();
                    }
                }
            }
        }
        catch (HeuristicMixedException | HeuristicRollbackException | NotSupportedException | RollbackException | SystemException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface ReturningRunnable<T, E extends Throwable> {
        public T run() throws E;
    }

    public static interface ThrowingRunnable<E extends Throwable> {
        public void run() throws E;
    }

    public static interface Runnable {
        public void run();
    }
}

