/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.mojo.appassembler.AbstractAppAssemblerMojo;

@Mojo(name="create-repository", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class CreateRepositoryMojo
extends AbstractAppAssemblerMojo {
    @Parameter(defaultValue="${project.build.directory}/appassembler", required=true)
    private File assembleDirectory;
    @Parameter(defaultValue="false")
    private boolean installBooterArtifacts;
    @Parameter(defaultValue="repo")
    private String repositoryName;
    @Parameter(defaultValue="${project.artifacts}", readonly=true)
    private Set<Artifact> artifacts;
    @Parameter(defaultValue="${plugin.version}", readonly=true)
    private String pluginVersion;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private ArtifactMetadataSource metadataSource;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArtifactRepositoryLayout artifactRepositoryLayout = this.getArtifactRepositoryLayout();
        StringBuffer path = new StringBuffer("file://" + this.assembleDirectory.getAbsolutePath() + "/");
        path.append(this.repositoryName);
        ArtifactRepository artifactRepository = this.artifactRepositoryFactory.createDeploymentArtifactRepository("appassembler", path.toString(), artifactRepositoryLayout, true);
        this.installArtifact(this.projectArtifact, artifactRepository);
        for (Artifact artifact : this.artifacts) {
            this.installArtifact(artifact, artifactRepository, this.useTimestampInSnapshotFileName);
        }
        if (this.installBooterArtifacts) {
            this.installBooterArtifacts(artifactRepository);
        }
    }

    private void installBooterArtifacts(ArtifactRepository artifactRepository) throws MojoExecutionException {
        Artifact artifact = this.artifactFactory.createDependencyArtifact("org.codehaus.mojo.appassembler", "appassembler-booter", VersionRange.createFromVersion((String)this.pluginVersion), "jar", null, "runtime");
        try {
            Artifact p = this.artifactFactory.createBuildArtifact("org.codehaus.mojo.appassembler", "appassembler-maven-plugin", this.pluginVersion, "jar");
            ExcludesArtifactFilter filter = new ExcludesArtifactFilter(Collections.singletonList("junit:junit"));
            ArtifactResolutionResult result = this.artifactResolver.resolveTransitively(Collections.singleton(artifact), p, this.localRepository, Collections.EMPTY_LIST, this.metadataSource, (ArtifactFilter)filter);
            for (Artifact a : result.getArtifacts()) {
                this.installArtifact(a, artifactRepository, this.useTimestampInSnapshotFileName);
            }
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Failed to copy artifact.", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Failed to copy artifact.", (Exception)((Object)e));
        }
    }
}

