/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cobertura.tasks;

import net.sourceforge.cobertura.check.CheckCoverageMain;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.cobertura.configuration.ConfigCheck;
import org.codehaus.mojo.cobertura.configuration.Regex;
import org.codehaus.mojo.cobertura.tasks.AbstractTask;
import org.codehaus.plexus.util.StringUtils;

public class CheckTask
extends AbstractTask {
    private ConfigCheck config;
    private String dataFile;

    public CheckTask() {
        super(CheckCoverageMain.class.getName());
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.dataFile != null) {
            this.cmdLineArgs.addArg("--datafile", this.dataFile);
        }
        if (StringUtils.isNotEmpty((String)this.config.getBranchRate())) {
            this.cmdLineArgs.addArg("--branch", this.config.getBranchRate());
        }
        if (StringUtils.isNotEmpty((String)this.config.getLineRate())) {
            this.cmdLineArgs.addArg("--line", this.config.getLineRate());
        }
        if (StringUtils.isNotEmpty((String)this.config.getTotalBranchRate())) {
            this.cmdLineArgs.addArg("--totalbranch", this.config.getTotalBranchRate());
        }
        if (StringUtils.isNotEmpty((String)this.config.getTotalLineRate())) {
            this.cmdLineArgs.addArg("--totalline", this.config.getTotalLineRate());
        }
        if (StringUtils.isNotEmpty((String)this.config.getPackageBranchRate())) {
            this.cmdLineArgs.addArg("--packagebranch", this.config.getPackageBranchRate());
        }
        if (StringUtils.isNotEmpty((String)this.config.getPackageLineRate())) {
            this.cmdLineArgs.addArg("--packageline", this.config.getPackageLineRate());
        }
        if (StringUtils.isNotEmpty((String)this.config.getMaxmem())) {
            this.setMaxmem(this.config.getMaxmem());
        }
        for (Regex regex : this.config.getRegexes()) {
            this.cmdLineArgs.addArg("--regex", regex.toString());
        }
        int returnCode = this.executeJava();
        if (returnCode == 0) {
            this.getLog().info((CharSequence)"All checks passed.");
        } else {
            if (this.config.isHaltOnFailure()) {
                throw new MojoFailureException("Coverage check failed. See messages above.");
            }
            this.getLog().error((CharSequence)"Coverage check failed. See messages above.");
        }
    }

    public ConfigCheck getConfig() {
        return this.config;
    }

    public String getDataFile() {
        return this.dataFile;
    }

    public void setConfig(ConfigCheck config) {
        this.config = config;
    }

    public void setDataFile(String dataFile) {
        this.dataFile = dataFile;
    }
}

