/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives;

import java.io.File;
import java.io.IOException;
import org.codehaus.mojo.natives.Dependency;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.parser.Parser;

public class SourceDependencyAnalyzer {
    public static boolean isStaled(File source, File dest, Parser parser, File[] includePaths) throws NativeBuildException {
        if (!source.exists()) {
            throw new NativeBuildException(source.getPath() + " not found.");
        }
        if (!dest.exists() || dest.lastModified() < source.lastModified()) {
            return true;
        }
        Dependency dependency = new Dependency(null, source, parser, includePaths);
        try {
            dependency.analyze();
        }
        catch (IOException ioe) {
            throw new NativeBuildException("Error analysing " + source.getPath() + ". Reason: " + ioe.getMessage());
        }
        return dest.lastModified() < dependency.getCompositeLastModified();
    }
}

