/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.xml.AbstractXmlMojo;
import org.codehaus.mojo.xml.Resolver;
import org.codehaus.mojo.xml.transformer.NameValuePair;
import org.codehaus.mojo.xml.transformer.TransformationSet;
import org.codehaus.plexus.components.io.filemappers.FileMapper;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.xml.sax.InputSource;

@Mojo(defaultPhase=LifecyclePhase.GENERATE_RESOURCES, name="transform", threadSafe=true)
public class TransformMojo
extends AbstractXmlMojo {
    @Parameter
    private TransformationSet[] transformationSets;
    @Parameter(property="xml.forceCreation", defaultValue="false")
    private boolean forceCreation;
    @Parameter(property="xml.transformerFactory")
    private String transformerFactory;

    private void setFeature(TransformerFactory pTransformerFactory, String name, Boolean value) throws MojoExecutionException {
        Method m;
        try {
            m = pTransformerFactory.getClass().getMethod("setFeature", String.class, Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            m = null;
        }
        if (m == null) {
            pTransformerFactory.setAttribute(name, value);
        } else {
            try {
                m.invoke((Object)pTransformerFactory, name, value);
            }
            catch (IllegalAccessException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                throw new MojoExecutionException(t.getMessage(), t);
            }
        }
    }

    private Templates getTemplate(Resolver pResolver, Source stylesheet, TransformationSet transformationSet) throws MojoExecutionException, MojoFailureException {
        NameValuePair[] attributes;
        NameValuePair[] features;
        TransformerFactory tf = this.getTransformerFactory();
        if (pResolver != null) {
            tf.setURIResolver(pResolver);
        }
        if ((features = transformationSet.getFeatures()) != null) {
            for (int i = 0; i < features.length; ++i) {
                NameValuePair feature = features[i];
                String name = feature.getName();
                if (name == null || name.length() == 0) {
                    throw new MojoFailureException("A features name is missing or empty.");
                }
                String value = feature.getValue();
                if (value == null) {
                    throw new MojoFailureException("No value specified for feature " + name);
                }
                this.setFeature(tf, name, Boolean.valueOf(value));
            }
        }
        if ((attributes = transformationSet.getAttributes()) != null) {
            for (int i = 0; i < attributes.length; ++i) {
                NameValuePair attribute = attributes[i];
                String name = attribute.getName();
                if (name == null || name.length() == 0) {
                    throw new MojoFailureException("An attributes name is missing or empty.");
                }
                String value = attribute.getValue();
                if (value == null) {
                    throw new MojoFailureException("No value specified for attribute " + name);
                }
                tf.setAttribute(name, value);
            }
        }
        try {
            return tf.newTemplates(stylesheet);
        }
        catch (TransformerConfigurationException e) {
            throw new MojoExecutionException("Failed to parse stylesheet " + stylesheet + ": " + e.getMessage(), (Exception)e);
        }
    }

    private TransformerFactory getTransformerFactory() throws MojoFailureException, MojoExecutionException {
        if (this.transformerFactory == null) {
            return TransformerFactory.newInstance();
        }
        try {
            return TransformMojo.newTransformerFactory(this.transformerFactory, Thread.currentThread().getContextClassLoader());
        }
        catch (NoSuchMethodException exception) {
            throw new MojoFailureException("JDK6 required when using transformerFactory parameter");
        }
        catch (IllegalAccessException exception) {
            throw new MojoExecutionException("Cannot instantiate transformer factory", (Exception)exception);
        }
        catch (InvocationTargetException exception) {
            throw new MojoExecutionException("Cannot instantiate transformer factory", (Exception)exception);
        }
    }

    public static TransformerFactory newTransformerFactory(String factoryClassName, ClassLoader classLoader) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class[] methodTypes = new Class[]{String.class, ClassLoader.class};
        Method method = TransformerFactory.class.getDeclaredMethod("newInstance", methodTypes);
        Object[] methodArgs = new Object[]{factoryClassName, classLoader};
        return (TransformerFactory)method.invoke(null, methodArgs);
    }

    private File getFile(File pDir, String pFile) {
        if (new File(pFile).isAbsolute()) {
            throw new IllegalStateException("Output/Input file names must not be absolute.");
        }
        return new File(pDir, pFile);
    }

    private File getDir(File pDir) {
        if (pDir == null) {
            return this.getBasedir();
        }
        return this.asAbsoluteFile(pDir);
    }

    private void addToClasspath(File pOutputDir) {
        MavenProject project = this.getProject();
        for (Resource resource : project.getResources()) {
            if (!resource.getDirectory().equals(pOutputDir)) continue;
            return;
        }
        Resource resource = new Resource();
        resource.setDirectory(pOutputDir.getPath());
        resource.setFiltering(false);
        project.addResource(resource);
    }

    private File getOutputDir(File pOutputDir) {
        if (pOutputDir == null) {
            MavenProject project = this.getProject();
            String dir = project.getBuild().getDirectory();
            if (dir == null) {
                throw new IllegalStateException("The projects build directory is null.");
            }
            dir = dir + "/generated-resources/xml/xslt";
            return this.asAbsoluteFile(new File(dir));
        }
        return this.asAbsoluteFile(pOutputDir);
    }

    private static String getAllExMsgs(Throwable ex, boolean includeExName) {
        StringBuffer sb = new StringBuffer(includeExName ? ex.toString() : ex.getLocalizedMessage());
        while ((ex = ex.getCause()) != null) {
            sb.append("\nCaused by: " + ex.toString());
        }
        return sb.toString();
    }

    protected long findLastModified(List files, boolean oldest) {
        long timeStamp = oldest ? Long.MIN_VALUE : Long.MAX_VALUE;
        for (Object no : files) {
            long fileModifTime;
            if (no == null) continue;
            if (no instanceof File) {
                fileModifTime = ((File)no).lastModified();
            } else {
                String sdep = no.toString();
                try {
                    URL url = new URL(sdep);
                    URLConnection uCon = url.openConnection();
                    uCon.setUseCaches(false);
                    fileModifTime = uCon.getLastModified();
                }
                catch (MalformedURLException e) {
                    fileModifTime = new File(sdep).lastModified();
                }
                catch (IOException ex) {
                    fileModifTime = oldest ? Long.MIN_VALUE : Long.MAX_VALUE;
                    this.getLog().warn((CharSequence)("Skipping URL '" + no + "' from up-to-date check due to error while opening connection: " + TransformMojo.getAllExMsgs(ex, true)));
                }
            }
            this.getLog().debug((CharSequence)((oldest ? "Depends " : "Produces ") + no + ": " + new Date(fileModifTime)));
            if (!(fileModifTime > timeStamp ^ !oldest)) continue;
            timeStamp = fileModifTime;
        }
        if (timeStamp == Long.MIN_VALUE) {
            return Long.MAX_VALUE;
        }
        if (timeStamp == Long.MAX_VALUE) {
            return Long.MIN_VALUE;
        }
        return timeStamp;
    }

    protected boolean isUpdToDate(List dependsFiles, List producesFiles) {
        long inputTimeStamp = this.findLastModified(dependsFiles, true);
        long destTimeStamp = producesFiles == null ? Long.MIN_VALUE : this.findLastModified(producesFiles, false);
        this.getLog().debug((CharSequence)("Depends timeStamp: " + inputTimeStamp + ", produces timestamp: " + destTimeStamp));
        return inputTimeStamp < destTimeStamp;
    }

    private void transform(Transformer pTransformer, File input, File output, Resolver pResolver) throws MojoExecutionException {
        File dir = output.getParentFile();
        dir.mkdirs();
        this.getLog().info((CharSequence)("Transforming file: " + input.getPath()));
        FileOutputStream fos = null;
        try {
            boolean transformInPlace = output.equals(input);
            File tmpOutput = null;
            if (transformInPlace) {
                tmpOutput = File.createTempFile("xml-maven-plugin", "xml");
                tmpOutput.deleteOnExit();
                fos = new FileOutputStream(tmpOutput);
            } else {
                fos = new FileOutputStream(output);
            }
            String parentFile = input.getParent() == null ? null : input.getParentFile().toURI().toURL().toExternalForm();
            pTransformer.transform(pResolver.resolve(input.toURI().toURL().toExternalForm(), parentFile), new StreamResult(fos));
            fos.close();
            fos = null;
            if (transformInPlace) {
                FileUtils.copyFile((File)tmpOutput, (File)output);
                tmpOutput.delete();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create output file " + output.getPath() + ": " + e.getMessage(), (Exception)e);
        }
        catch (TransformerException e) {
            throw new MojoExecutionException("Failed to transform input file " + input.getPath() + ": " + e.getMessage(), (Exception)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    private File getOutputFile(File targetDir, String pName, FileMapper[] pFileMappers) {
        String name = pName;
        if (pFileMappers != null) {
            for (int i = 0; i < pFileMappers.length; ++i) {
                name = pFileMappers[i].getMappedFileName(name);
            }
        }
        return this.getFile(targetDir, name);
    }

    private void transform(Resolver pResolver, TransformationSet pTransformationSet) throws MojoExecutionException, MojoFailureException {
        Templates template;
        String[] fileNames = this.getFileNames(pTransformationSet.getDir(), pTransformationSet.getIncludes(), this.getExcludes(pTransformationSet.getExcludes(), pTransformationSet.isSkipDefaultExcludes()));
        if (fileNames == null || fileNames.length == 0) {
            this.getLog().warn((CharSequence)("No files found for transformation by stylesheet " + pTransformationSet.getStylesheet()));
            return;
        }
        String stylesheetName = pTransformationSet.getStylesheet();
        if (stylesheetName == null) {
            this.getLog().warn((CharSequence)"No stylesheet configured.");
            return;
        }
        URL stylesheetUrl = this.getResource(stylesheetName);
        InputStream stream = null;
        try {
            stream = stylesheetUrl.openStream();
            InputSource isource = new InputSource(stream);
            isource.setSystemId(stylesheetUrl.toExternalForm());
            template = this.getTemplate(pResolver, new SAXSource(isource), pTransformationSet);
            stream.close();
            stream = null;
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        finally {
            IOUtil.close((InputStream)stream);
        }
        int filesTransformed = 0;
        File inputDir = this.getDir(pTransformationSet.getDir());
        File outputDir = this.getOutputDir(pTransformationSet.getOutputDir());
        for (int i = 0; i < fileNames.length; ++i) {
            File input = this.getFile(inputDir, fileNames[i]);
            File output = this.getOutputFile(outputDir, fileNames[i], pTransformationSet.getFileMappers());
            boolean needsTransform = this.forceCreation;
            if (!needsTransform) {
                ArrayList<File> dependsFiles = new ArrayList<File>();
                ArrayList<File> producesFiles = new ArrayList<File>();
                dependsFiles.add(this.getProject().getFile());
                if ("file".equals(stylesheetUrl.getProtocol())) {
                    dependsFiles.add(new File(stylesheetUrl.getFile()));
                }
                ArrayList catalogFiles = new ArrayList();
                ArrayList catalogUrls = new ArrayList();
                this.setCatalogs(catalogFiles, catalogUrls);
                dependsFiles.addAll(catalogFiles);
                dependsFiles.add(input);
                File[] files = this.asFiles(this.getBasedir(), pTransformationSet.getOtherDepends());
                for (int j = 0; j < files.length; ++j) {
                    dependsFiles.add(files[j]);
                }
                producesFiles.add(output);
                boolean bl = needsTransform = !this.isUpdToDate(dependsFiles, producesFiles);
            }
            if (!needsTransform) {
                this.getLog().debug((CharSequence)("Skipping XSL transformation.  File " + fileNames[i] + " is up-to-date."));
                continue;
            }
            ++filesTransformed;
            try {
                Transformer t = this.newTransformer(template, pTransformationSet);
                t.setURIResolver(pResolver);
                NameValuePair[] parameters = pTransformationSet.getParameters();
                if (parameters != null) {
                    for (int j = 0; j < parameters.length; ++j) {
                        NameValuePair key = parameters[j];
                        t.setParameter(key.getName(), key.getValue());
                    }
                }
                this.transform(t, input, output, pResolver);
                continue;
            }
            catch (TransformerConfigurationException e) {
                throw new MojoExecutionException("Failed to create Transformer: " + e.getMessage(), (Exception)e);
            }
        }
        if (filesTransformed > 0) {
            this.getLog().info((CharSequence)("Transformed " + filesTransformed + " file(s)."));
        }
        if (pTransformationSet.isAddedToClasspath()) {
            this.addToClasspath(pTransformationSet.getOutputDir());
        }
    }

    private Transformer newTransformer(Templates template, TransformationSet pTransformationSet) throws TransformerConfigurationException, MojoExecutionException, MojoFailureException {
        Transformer t = template.newTransformer();
        NameValuePair[] properties = pTransformationSet.getOutputProperties();
        if (properties != null) {
            for (int i = 0; i < properties.length; ++i) {
                String name = properties[i].getName();
                if (name == null || "".equals(name)) {
                    throw new MojoFailureException("Missing or empty output property name");
                }
                String value = properties[i].getValue();
                if (value == null) {
                    throw new MojoFailureException("Missing value for output property " + name);
                }
                try {
                    t.setOutputProperty(name, value);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new MojoExecutionException("Unsupported property name or value: " + name + " => " + value + e.getMessage(), (Exception)e);
                }
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkipping()) {
            this.getLog().debug((CharSequence)"Skipping execution, as demanded by user.");
            return;
        }
        if (this.transformationSets == null || this.transformationSets.length == 0) {
            throw new MojoFailureException("No TransformationSets configured.");
        }
        Object oldProxySettings = this.activateProxy();
        try {
            Resolver resolver = this.getResolver();
            for (int i = 0; i < this.transformationSets.length; ++i) {
                TransformationSet transformationSet = this.transformationSets[i];
                resolver.setValidating(transformationSet.isValidating());
                this.transform(resolver, transformationSet);
            }
        }
        finally {
            this.passivateProxy(oldProxySettings);
        }
    }
}

