/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.auth;

import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.util.SecurityUtils;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PasswordFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FilePublicKeyProvider
extends AbstractKeyPairProvider {
    private static final Logger LOG = LoggerFactory.getLogger(FilePublicKeyProvider.class);
    private String[] files;
    private PasswordFinder passwordFinder;

    FilePublicKeyProvider(String[] files) {
        this.files = files;
    }

    FilePublicKeyProvider(String[] files, PasswordFinder passwordFinder) {
        this.files = files;
        this.passwordFinder = passwordFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<KeyPair> loadKeys() {
        if (!SecurityUtils.isBouncyCastleRegistered()) {
            throw new IllegalStateException("BouncyCastle must be registered as a JCE provider");
        }
        ArrayList<KeyPair> keys = new ArrayList<KeyPair>();
        for (String file : this.files) {
            try {
                PEMReader r = new PEMReader((Reader)new InputStreamReader(new FileInputStream(file)), this.passwordFinder);
                try {
                    Object o = r.readObject();
                    if (o instanceof KeyPair) {
                        keys.add(new KeyPair(((KeyPair)o).getPublic(), null));
                        continue;
                    }
                    if (!(o instanceof PublicKey)) continue;
                    keys.add(new KeyPair((PublicKey)o, null));
                }
                finally {
                    r.close();
                }
            }
            catch (Exception e) {
                LOG.info("Unable to read key {}: {}", (Object)file, (Object)e);
            }
        }
        return keys;
    }
}

