/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.convert.BaseV20Converter;
import org.directwebremoting.dwrp.ArrayJsonOutboundVariable;
import org.directwebremoting.dwrp.ArrayNonJsonOutboundVariable;
import org.directwebremoting.dwrp.CollectionOutboundVariable;
import org.directwebremoting.dwrp.ErrorOutboundVariable;
import org.directwebremoting.dwrp.ParseUtil;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayConverter
extends BaseV20Converter
implements Converter {
    private static final Log log = LogFactory.getLog(ArrayConverter.class);
    private ConverterManager converterManager = null;

    @Override
    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable data, InboundContext inctx) throws MarshallException {
        if (!paramType.isArray()) {
            throw new MarshallException(paramType);
        }
        String value = data.getValue();
        if (value.startsWith("[")) {
            value = value.substring(1);
        }
        if (value.endsWith("]")) {
            value = value.substring(0, value.length() - 1);
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        int size = st.countTokens();
        Class<?> componentType = paramType.getComponentType();
        Object array = Array.newInstance(componentType, size);
        inctx.addConverted(data, paramType, array);
        InboundContext incx = data.getLookup();
        for (int i = 0; i < size; ++i) {
            String token = st.nextToken();
            String[] split = ParseUtil.splitInbound(token);
            String splitType = split[0];
            String splitValue = split[1];
            InboundVariable nested = new InboundVariable(incx, null, splitType, splitValue);
            nested.dereference();
            Object output = this.converterManager.convertInbound(componentType, nested, inctx, inctx.getCurrentTypeHintContext());
            Array.set(array, i, output);
        }
        return array;
    }

    @Override
    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) throws MarshallException {
        if (!data.getClass().isArray()) {
            throw new MarshallException(data.getClass());
        }
        CollectionOutboundVariable ov = outctx.isJsonMode() ? new ArrayJsonOutboundVariable() : new ArrayNonJsonOutboundVariable(outctx);
        outctx.put(data, ov);
        int size = Array.getLength(data);
        ArrayList<OutboundVariable> ovs = new ArrayList<OutboundVariable>();
        for (int i = 0; i < size; ++i) {
            OutboundVariable nested;
            try {
                nested = this.converterManager.convertOutbound(Array.get(data, i), outctx);
            }
            catch (Exception ex) {
                String errorMessage = "Conversion error for " + data.getClass().getName() + ".";
                log.warn((Object)errorMessage, (Throwable)ex);
                nested = new ErrorOutboundVariable(errorMessage);
            }
            ovs.add(nested);
        }
        ov.setChildren(ovs);
        return ov;
    }
}

