/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.directwebremoting.convert.BaseV20Converter;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.NonNestedOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigNumberConverter
extends BaseV20Converter
implements Converter {
    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable data, InboundContext inctx) throws MarshallException {
        String value = data.getValue();
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            if (paramType == BigDecimal.class) {
                return new BigDecimal(value.trim());
            }
            if (paramType == BigInteger.class) {
                return new BigInteger(value.trim());
            }
            throw new MarshallException(paramType);
        }
        catch (NumberFormatException ex) {
            throw new MarshallException(paramType, Messages.getString("BigNumberConverter.FormatError", value));
        }
    }

    @Override
    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) {
        if (data == null) {
            return new NonNestedOutboundVariable("null");
        }
        return new NonNestedOutboundVariable(data.toString());
    }
}

