/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.directwebremoting.convert.BaseV20Converter;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.NonNestedOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.util.LocalUtil;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOM4JConverter
extends BaseV20Converter
implements Converter {
    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable data, InboundContext inctx) throws MarshallException {
        String value = LocalUtil.decode(data.getValue());
        try {
            SAXReader xmlReader = new SAXReader();
            Document doc = xmlReader.read((Reader)new StringReader(value));
            if (paramType == Document.class) {
                return doc;
            }
            if (paramType == Element.class) {
                return doc.getRootElement();
            }
            throw new MarshallException(paramType);
        }
        catch (MarshallException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MarshallException(paramType, (Throwable)ex);
        }
    }

    @Override
    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) throws MarshallException {
        try {
            if (!(data instanceof Node)) {
                throw new MarshallException(data.getClass());
            }
            Node node = (Node)data;
            OutputFormat outformat = OutputFormat.createCompactFormat();
            outformat.setEncoding("UTF-8");
            StringWriter xml = new StringWriter();
            XMLWriter writer = new XMLWriter((Writer)xml, outformat);
            writer.write(node);
            writer.flush();
            xml.flush();
            String script = EnginePrivate.xmlStringToJavascriptDom(xml.toString());
            NonNestedOutboundVariable ov = new NonNestedOutboundVariable(script);
            outctx.put(data, ov);
            return ov;
        }
        catch (MarshallException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MarshallException(data.getClass(), (Throwable)ex);
        }
    }
}

