/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.directwebremoting.convert.BeanConverter;
import org.directwebremoting.convert.StringEnumAbstractBaseConverter;
import org.directwebremoting.dwrp.ParseUtil;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.Property;
import org.directwebremoting.extend.TypeHintContext;
import org.directwebremoting.impl.PropertyDescriptorProperty;
import org.directwebremoting.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlBeanConverter
extends BeanConverter {
    private static StringEnumAbstractBaseConverter enumConverter = new StringEnumAbstractBaseConverter();
    private static Log logger = LogFactory.getLog(XmlBeanConverter.class);

    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable iv, InboundContext inctx) throws MarshallException {
        String value = iv.getValue();
        logger.debug((Object)("handling variable (" + value + ") for class (" + paramType.getName() + ")"));
        if (value.trim().equals("null")) {
            return null;
        }
        if (!value.startsWith("{")) {
            throw new MarshallException(paramType, Messages.getString("BeanConverter.FormatError", "{"));
        }
        if (!value.endsWith("}")) {
            throw new MarshallException(paramType, Messages.getString("BeanConverter.FormatError", "{"));
        }
        value = value.substring(1, value.length() - 1);
        try {
            if (this.instanceType != null) {
                Class.forName(this.instanceType.getName());
            } else {
                Class.forName(paramType.getName());
            }
            Class<?>[] innerClasses = paramType.getClasses();
            Class<?> factory = null;
            for (Class<?> aClass : innerClasses) {
                if (!aClass.getName().endsWith("Factory")) continue;
                factory = aClass;
            }
            if (factory == null) {
                logger.error((Object)("XmlObject.Factory method not found for Class [" + paramType.toString() + "]"));
                throw new MarshallException(paramType, "XmlObject.Factory method not found");
            }
            Class[] emptyArglist = new Class[]{};
            Method newInstance = factory.getMethod("newInstance", emptyArglist);
            Object bean = newInstance.invoke(null, (Object[])emptyArglist);
            if (this.instanceType != null) {
                inctx.addConverted(iv, this.instanceType, bean);
            } else {
                inctx.addConverted(iv, paramType, bean);
            }
            Map<String, Property> properties = this.getPropertyMapFromClass(paramType, false, true);
            Map<String, String> tokens = XmlBeanConverter.extractInboundTokens(paramType, value);
            for (Map.Entry<String, String> entry : tokens.entrySet()) {
                String key = entry.getKey();
                String val = entry.getValue();
                logger.debug((Object)("token entry (" + key + ") with value (" + val + ")"));
                Property property = properties.get(key);
                if (property == null) {
                    logger.warn((Object)("Missing java bean property to match javascript property: " + key + ". For causes see debug level logs:"));
                    logger.debug((Object)"- The javascript may be refer to a property that does not exist");
                    logger.debug((Object)("- You may be missing the correct setter: set" + Character.toTitleCase(key.charAt(0)) + key.substring(1) + "()"));
                    logger.debug((Object)"- The property may be excluded using include or exclude rules.");
                    StringBuffer all = new StringBuffer();
                    Iterator<String> pit = properties.keySet().iterator();
                    while (pit.hasNext()) {
                        all.append(pit.next());
                        if (!pit.hasNext()) continue;
                        all.append(',');
                    }
                    logger.debug((Object)("Fields exist for (" + all + ")."));
                    continue;
                }
                Class<?> propType = property.getPropertyType();
                String[] split = ParseUtil.splitInbound(val);
                String splitValue = split[1];
                String splitType = split[0];
                InboundVariable nested = new InboundVariable(iv.getLookup(), null, splitType, splitValue);
                nested.dereference();
                TypeHintContext incc = this.createTypeHintContext(inctx, property);
                Object output = this.converterManager.convertInbound(propType, nested, inctx, incc);
                property.setValue(bean, output);
            }
            return bean;
        }
        catch (MarshallException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MarshallException(paramType, (Throwable)ex);
        }
    }

    @Override
    public Map<String, Property> getPropertyMapFromClass(Class<?> paramType, boolean readRequired, boolean writeRequired) throws MarshallException {
        try {
            if (!XmlObject.class.isAssignableFrom(paramType)) {
                throw new MarshallException(paramType, "class (" + paramType.getName() + ") not assignable from XmlObject");
            }
            Class<Object> beanInterface = paramType.isInterface() ? paramType : paramType.getInterfaces()[0];
            Class superInterface = (Class)beanInterface.getGenericInterfaces()[0];
            HashMap<String, Property> properties = new HashMap<String, Property>();
            while (XmlObject.class.isAssignableFrom(superInterface)) {
                BeanInfo info = Introspector.getBeanInfo(beanInterface);
                PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
                for (int i = 0; i < descriptors.length; ++i) {
                    PropertyDescriptor descriptor = descriptors[i];
                    String name = descriptor.getName();
                    String type = descriptor.getPropertyType().getName();
                    if (type.matches(".*\\$Enum")) {
                        this.getConverterManager().addConverter(type, enumConverter);
                    }
                    if ("class".equals(name) || !this.isAllowedByIncludeExcludeRules(name) || readRequired && descriptor.getReadMethod() == null || writeRequired && descriptor.getWriteMethod() == null) continue;
                    properties.put(name, new PropertyDescriptorProperty(descriptor));
                }
                beanInterface = (Class<Object>)beanInterface.getGenericInterfaces()[0];
                superInterface = (Class)beanInterface.getGenericInterfaces()[0];
            }
            return properties;
        }
        catch (IntrospectionException ex) {
            throw new MarshallException(paramType, (Throwable)ex);
        }
    }
}

