/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import java.lang.reflect.Method;
import java.util.Map;
import org.directwebremoting.ScriptSession;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.TypeHintContext;
import org.directwebremoting.io.RawData;
import org.directwebremoting.proxy.Callback;
import org.directwebremoting.util.IdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallbackHelper {
    private static IdGenerator idGenerator = new IdGenerator();
    public static final String KEY_CALLBACK = "org.directwebremoting.callback";
    public static final String KEY_TYPE = "org.directwebremoting.type";

    public static <T> String saveCallback(Callback<T> callback, Class<T> type) {
        String key = CallbackHelper.createUniqueId();
        for (ScriptSession session : callback.getScriptSessions()) {
            Map callbackMap = (Map)session.getAttribute(KEY_CALLBACK);
            callbackMap.put(key, callback);
            session.setAttribute(KEY_CALLBACK, callbackMap);
            Map typeMap = (Map)session.getAttribute(KEY_TYPE);
            typeMap.put(key, type);
            session.setAttribute(KEY_TYPE, typeMap);
        }
        return key;
    }

    public static <T> void executeCallback(String key, RawData data) throws MarshallException {
        WebContext webContext = WebContextFactory.get();
        ScriptSession session = webContext.getScriptSession();
        ConverterManager converterManager = webContext.getContainer().getBean(ConverterManager.class);
        Map typeMap = (Map)session.getAttribute(KEY_TYPE);
        Class type = (Class)typeMap.remove(key);
        session.removeAttribute(KEY_TYPE);
        session.setAttribute(KEY_TYPE, typeMap);
        try {
            Method method = Callback.class.getMethod("dataReturned", type);
            InboundContext inctx = data.getInboundContext();
            TypeHintContext incc = new TypeHintContext(converterManager, method, 0);
            InboundVariable iv = data.getInboundVariable();
            Object callbackData = converterManager.convertInbound(type, iv, inctx, incc);
            Map callbackMap = (Map)session.getAttribute(KEY_TYPE);
            Callback callback = (Callback)callbackMap.remove(key);
            session.removeAttribute(KEY_TYPE);
            session.setAttribute(KEY_CALLBACK, callbackMap);
            callback.dataReturned(callbackData);
        }
        catch (Exception ex) {
            throw new MarshallException(type, (Throwable)ex);
        }
    }

    public static String createUniqueId() {
        return idGenerator.generateId(16);
    }
}

