/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import java.util.ArrayList;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;

public class ScriptBufferUtil {
    private ScriptBufferUtil() {
    }

    public static String createOutput(ScriptBuffer buffer, ConverterManager converterManager) throws MarshallException {
        return ScriptBufferUtil.createOutput(buffer, converterManager, false);
    }

    public static String createOutput(ScriptBuffer buffer, ConverterManager converterManager, boolean jsonOutput) throws MarshallException {
        OutboundContext context = new OutboundContext(jsonOutput);
        ArrayList<OutboundVariable> scriptParts = new ArrayList<OutboundVariable>();
        for (Object object : buffer.getParts()) {
            OutboundVariable ov = converterManager.convertOutbound(object, context);
            scriptParts.add(ov);
        }
        StringBuffer output = new StringBuffer();
        context.prepareForOutput();
        for (OutboundVariable ov : scriptParts) {
            output.append(ov.getDeclareCode());
        }
        for (OutboundVariable ov : scriptParts) {
            output.append(ov.getBuildCode());
        }
        for (OutboundVariable ov : scriptParts) {
            String assignCode = ov.getAssignCode();
            if (assignCode == null) {
                throw new NullPointerException();
            }
            output.append(assignCode);
        }
        return output.toString();
    }
}

