/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCreatorManager
implements CreatorManager {
    private static final Log log = LogFactory.getLog(DefaultCreatorManager.class);
    protected Map<String, Class<? extends Creator>> creatorTypes = new HashMap<String, Class<? extends Creator>>();
    protected Map<String, Creator> creators = new HashMap<String, Creator>();
    protected boolean debug = false;
    protected boolean initApplicationScopeCreatorsAtStartup = false;
    protected static List<String> ignore = Arrays.asList("creator", "class");

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public void addCreatorType(String typeName, String className) {
        if (!LocalUtil.isJavaIdentifier(typeName)) {
            log.error((Object)("Illegal identifier: '" + typeName + "'"));
            return;
        }
        Class<Creator> clazz = LocalUtil.classForName(typeName, className, Creator.class);
        if (clazz != null) {
            log.debug((Object)("- adding creator type: " + typeName + " = " + clazz));
            this.creatorTypes.put(typeName, clazz);
        }
    }

    @Override
    public void addCreator(String scriptName, String creatorName, Map<String, String> params) throws InstantiationException, IllegalAccessException, IllegalArgumentException {
        Class<? extends Creator> clazz = this.creatorTypes.get(creatorName);
        if (clazz == null) {
            log.error((Object)("Missing creator: " + creatorName + " (while initializing creator for: " + scriptName + ".js)"));
            return;
        }
        Creator creator = clazz.newInstance();
        LocalUtil.setParams(creator, params, ignore);
        creator.setProperties(params);
        this.addCreator(creator.getJavascript(), creator);
    }

    @Override
    public void addCreator(String scriptName, Creator creator) throws IllegalArgumentException {
        Creator other = this.creators.get(scriptName);
        if (other != null) {
            throw new IllegalArgumentException(Messages.getString("DefaultCreatorManager.DuplicateName", scriptName, other.getType().getName(), creator));
        }
        try {
            Class<?> test = creator.getType();
            if (test == null) {
                log.error((Object)("Creator: '" + creator + "' for " + scriptName + ".js is returning null for type queries."));
            } else {
                log.debug((Object)("- adding creator: " + creator.getClass().getSimpleName() + " for " + scriptName));
                this.creators.put(scriptName, creator);
            }
        }
        catch (NoClassDefFoundError ex) {
            log.error((Object)("Missing class for creator '" + creator + "'. Cause: " + ex.getMessage()));
        }
        catch (Exception ex) {
            log.error((Object)("Error loading class for creator '" + creator + "'."), (Throwable)ex);
        }
        if (this.initApplicationScopeCreatorsAtStartup && creator.getScope().equals("application")) {
            try {
                WebContext webcx = WebContextFactory.get();
                Object object = creator.getInstance();
                webcx.getServletContext().setAttribute(creator.getJavascript(), object);
                log.debug((Object)("Created new " + creator.getJavascript() + ", stored in application."));
            }
            catch (InstantiationException ex) {
                log.warn((Object)("Failed to create " + creator.getJavascript()), (Throwable)ex);
                log.debug((Object)"Maybe it will succeed when the application is in flight. If so you should probably set initApplicationScopeCreatorsAtStartup=false in web.xml");
            }
        }
    }

    @Override
    public Collection<String> getCreatorNames() throws SecurityException {
        if (!this.debug) {
            throw new SecurityException();
        }
        return Collections.unmodifiableSet(this.creators.keySet());
    }

    @Override
    public Creator getCreator(String scriptName) throws SecurityException {
        Creator creator = this.creators.get(scriptName);
        if (creator == null) {
            StringBuffer buffer = new StringBuffer("Names of known classes are: ");
            for (String key : this.creators.keySet()) {
                buffer.append(key);
                buffer.append(' ');
            }
            log.warn((Object)buffer.toString());
            throw new SecurityException(Messages.getString("DefaultCreatorManager.MissingName", scriptName));
        }
        return creator;
    }

    @Override
    public void setCreators(Map<String, Creator> creators) {
        this.creators = creators;
    }

    public boolean isInitApplicationScopeCreatorsAtStartup() {
        return this.initApplicationScopeCreatorsAtStartup;
    }

    public void setInitApplicationScopeCreatorsAtStartup(boolean initApplicationScopeCreatorsAtStartup) {
        this.initApplicationScopeCreatorsAtStartup = initApplicationScopeCreatorsAtStartup;
    }
}

