/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Hub;
import org.directwebremoting.HubFactory;
import org.directwebremoting.ServerContext;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.impl.ContainerUtil;
import org.directwebremoting.impl.DefaultHub;

public class DefaultHubBuilder
implements HubFactory.HubBuilder {
    private static final String ATTRIBUTE_SERVER_CONTEXT = "org.directwebremoting.impl.Hub";
    private static final Log log = LogFactory.getLog(DefaultHubBuilder.class);

    public void set(ServletContext context) {
        try {
            DefaultHub hub = new DefaultHub();
            context.setAttribute(ATTRIBUTE_SERVER_CONTEXT, (Object)hub);
        }
        catch (Exception ex) {
            log.fatal((Object)"Failed to create an ExecutionContext", (Throwable)ex);
        }
    }

    public Hub get() {
        ServerContext serverContext = WebContextFactory.get();
        if (serverContext == null && (serverContext = ContainerUtil.getSingletonServerContext()) == null) {
            log.fatal((Object)"Error initializing Hub because singleton ServerContext == null.");
            log.fatal((Object)"This probably means that either DWR has not been properly initialized (in which case you should delay the current action until it has)");
            log.fatal((Object)"or that there is more than 1 DWR servlet is configured in this classloader, in which case you should provide a ServletContext to the Hub yourself.");
            throw new IllegalStateException("No singleton ServerContext see logs for possible causes and solutions.");
        }
        ServletContext servletContext = serverContext.getServletContext();
        Hub reply = (Hub)servletContext.getAttribute(ATTRIBUTE_SERVER_CONTEXT);
        if (reply == null) {
            log.warn((Object)"HubFactory.get() returns null when DWR has not been initialized in the given ServletContext");
        }
        return reply;
    }

    public Hub get(ServletContext servletContext) {
        if (servletContext == null) {
            throw new NullPointerException("servletContext");
        }
        Hub reply = (Hub)servletContext.getAttribute(ATTRIBUTE_SERVER_CONTEXT);
        if (reply == null) {
            log.warn((Object)"HubFactory.get(ServletContext) returns null when DWR has not been initialized in the given ServletContext");
        }
        return reply;
    }
}

