/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.io.IOException;
import java.io.StringWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Container;
import org.directwebremoting.ScriptSession;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.RealWebContext;
import org.directwebremoting.extend.ScriptSessionManager;
import org.directwebremoting.impl.DefaultServerContext;
import org.directwebremoting.util.IdGenerator;
import org.directwebremoting.util.SwallowingHttpServletResponse;

public class DefaultWebContext
extends DefaultServerContext
implements RealWebContext {
    private boolean avoidConnectionLimitWithWindowName = true;
    private static IdGenerator generator = new IdGenerator();
    private String scriptSessionId = null;
    private String page = null;
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private static final Log log = LogFactory.getLog(DefaultWebContext.class);

    public DefaultWebContext(HttpServletRequest request, HttpServletResponse response, ServletConfig config, ServletContext context, Container container) {
        super(config, context, container);
        this.request = request;
        this.response = response;
        Object value = container.getBean("avoidConnectionLimitWithWindowName");
        if (value != null) {
            this.avoidConnectionLimitWithWindowName = Boolean.parseBoolean(value.toString());
        }
    }

    public void checkPageInformation(String sentPage, String sentScriptId, String windowName) {
        RealScriptSession scriptSession;
        ScriptSessionManager scriptSessionManager = this.getScriptSessionManager();
        String httpSessionId = null;
        HttpSession httpSession = this.request.getSession(false);
        if (httpSession != null) {
            httpSessionId = httpSession.getId();
        }
        if ((scriptSession = scriptSessionManager.getScriptSession(sentScriptId, sentPage, httpSessionId)) == null) {
            scriptSession = scriptSessionManager.createScriptSession(sentPage, httpSessionId);
            String newSessionId = scriptSession.getId();
            EnginePrivate.remoteHandleNewScriptSession(scriptSession, newSessionId);
            log.debug((Object)("ScriptSession re-sync: " + sentScriptId + " has become " + newSessionId));
            this.scriptSessionId = newSessionId;
            this.page = sentPage;
        } else {
            scriptSession.updateLastAccessedTime();
            String storedPage = scriptSession.getPage();
            if (!storedPage.equals(sentPage)) {
                log.error((Object)("Invalid Page: Passed page=" + sentPage + ", but page in script session=" + storedPage));
                throw new SecurityException("Invalid Page");
            }
            this.scriptSessionId = sentScriptId;
            this.page = sentPage;
        }
        if (this.avoidConnectionLimitWithWindowName) {
            if (windowName == null || windowName.equals("")) {
                windowName = "DWR-" + generator.generateId(16);
                EnginePrivate.remoteHandleNewWindowName(scriptSession, windowName);
            }
            scriptSession.setWindowName(windowName);
        }
    }

    public String getCurrentPage() {
        return this.page;
    }

    public ScriptSession getScriptSession() {
        ScriptSessionManager manager = this.getScriptSessionManager();
        RealScriptSession scriptSession = manager.getScriptSession(this.scriptSessionId, null, null);
        if (scriptSession == null) {
            throw new SecurityException("Expected script session to exist");
        }
        return scriptSession;
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public HttpSession getSession(boolean create) {
        return this.request.getSession(create);
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.request;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.response;
    }

    public String forwardToString(String url) throws ServletException, IOException {
        StringWriter sout = new StringWriter();
        StringBuffer buffer = sout.getBuffer();
        HttpServletResponse realResponse = this.getHttpServletResponse();
        SwallowingHttpServletResponse fakeResponse = new SwallowingHttpServletResponse(realResponse, sout, realResponse.getCharacterEncoding());
        HttpServletRequest realRequest = this.getHttpServletRequest();
        realRequest.setAttribute("org.directwebremoting", (Object)Boolean.TRUE);
        this.getServletContext().getRequestDispatcher(url).forward((ServletRequest)realRequest, (ServletResponse)fakeResponse);
        return buffer.toString();
    }
}

