/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.AjaxFilter;
import org.directwebremoting.Container;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.AccessControl;
import org.directwebremoting.extend.AjaxFilterManager;
import org.directwebremoting.extend.Configurator;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.extend.TypeHintContext;
import org.directwebremoting.impl.DTDEntityResolver;
import org.directwebremoting.impl.SignatureParser;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.LogErrorHandler;
import org.directwebremoting.util.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwrXmlConfigurator
implements Configurator {
    private Document document;
    private static List<String> ignore = Arrays.asList("class");
    public static final Log log = LogFactory.getLog(DwrXmlConfigurator.class);
    private AjaxFilterManager ajaxFilterManager = null;
    private ConverterManager converterManager = null;
    private CreatorManager creatorManager = null;
    private AccessControl accessControl = null;
    private String classResourceName;
    private String servletResourceName;
    private static final String ELEMENT_INIT = "init";
    private static final String ELEMENT_ALLOW = "allow";
    private static final String ELEMENT_CREATE = "create";
    private static final String ELEMENT_CONVERT = "convert";
    private static final String ELEMENT_PARAM = "param";
    private static final String ELEMENT_INCLUDE = "include";
    private static final String ELEMENT_EXCLUDE = "exclude";
    private static final String ELEMENT_PARAMETER = "parameter";
    private static final String ELEMENT_AUTH = "auth";
    private static final String ELEMENT_SIGNATURES = "signatures";
    private static final String ELEMENT_FILTER = "filter";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_CONVERTER = "converter";
    private static final String ATTRIBUTE_MATCH = "match";
    private static final String ATTRIBUTE_JAVASCRIPT = "javascript";
    private static final String ATTRIBUTE_CREATOR = "creator";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String ATTRIBUTE_METHOD = "method";
    private static final String ATTRIBUTE_ROLE = "role";
    private static final String ATTRIBUTE_NUMBER = "number";
    private static final String ATTRIBUTE_TYPE = "type";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServletResourceName(String servletResourceName) throws IOException, ParserConfigurationException, SAXException {
        this.servletResourceName = servletResourceName;
        ServletContext servletContext = WebContextFactory.get().getServletContext();
        if (servletContext == null) {
            throw new IOException(Messages.getString("DwrXmlConfigurator.MissingServletContext"));
        }
        InputStream in = null;
        try {
            in = servletContext.getResourceAsStream(servletResourceName);
            if (in == null) {
                throw new IOException(Messages.getString("DwrXmlConfigurator.MissingConfigFile", servletResourceName));
            }
            log.debug((Object)("Configuring from servlet resource: " + servletResourceName));
            this.setInputStream(in);
        }
        finally {
            LocalUtil.close(in);
        }
    }

    public void setClassResourceName(String classResourceName) throws IOException, ParserConfigurationException, SAXException {
        this.classResourceName = classResourceName;
        InputStream in = this.getClass().getResourceAsStream(classResourceName);
        if (in == null) {
            throw new IOException(Messages.getString("DwrXmlConfigurator.MissingConfigFile", classResourceName));
        }
        log.debug((Object)("Configuring from class resource: " + classResourceName));
        this.setInputStream(in);
    }

    public void setInputStream(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setEntityResolver(new DTDEntityResolver());
        db.setErrorHandler(new LogErrorHandler());
        this.document = db.parse(in);
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    @Override
    public void configure(Container container) {
        this.accessControl = container.getBean(AccessControl.class);
        this.ajaxFilterManager = container.getBean(AjaxFilterManager.class);
        this.converterManager = container.getBean(ConverterManager.class);
        this.creatorManager = container.getBean(CreatorManager.class);
        Element root = this.document.getDocumentElement();
        NodeList rootChildren = root.getChildNodes();
        for (int i = 0; i < rootChildren.getLength(); ++i) {
            Node node = rootChildren.item(i);
            if (node.getNodeType() != 1) continue;
            Element child = (Element)node;
            if (child.getNodeName().equals(ELEMENT_INIT)) {
                this.loadInits(child);
                continue;
            }
            if (child.getNodeName().equals(ELEMENT_ALLOW)) {
                this.loadAllows(child);
                continue;
            }
            if (!child.getNodeName().equals(ELEMENT_SIGNATURES)) continue;
            this.loadSignature(child);
        }
    }

    private void loadInits(Element child) {
        NodeList inits = child.getChildNodes();
        for (int j = 0; j < inits.getLength(); ++j) {
            String className;
            String id;
            if (inits.item(j).getNodeType() != 1) continue;
            Element initer = (Element)inits.item(j);
            if (initer.getNodeName().equals(ATTRIBUTE_CREATOR)) {
                id = initer.getAttribute(ATTRIBUTE_ID);
                className = initer.getAttribute(ATTRIBUTE_CLASS);
                this.creatorManager.addCreatorType(id, className);
                continue;
            }
            if (!initer.getNodeName().equals(ATTRIBUTE_CONVERTER)) continue;
            id = initer.getAttribute(ATTRIBUTE_ID);
            className = initer.getAttribute(ATTRIBUTE_CLASS);
            this.converterManager.addConverterType(id, className);
        }
    }

    private void loadAllows(Element child) {
        NodeList allows = child.getChildNodes();
        for (int j = 0; j < allows.getLength(); ++j) {
            if (allows.item(j).getNodeType() != 1) continue;
            Element allower = (Element)allows.item(j);
            if (allower.getNodeName().equals(ELEMENT_CREATE)) {
                this.loadCreate(allower);
                continue;
            }
            if (allower.getNodeName().equals(ELEMENT_CONVERT)) {
                this.loadConvert(allower);
                continue;
            }
            if (!allower.getNodeName().equals(ELEMENT_FILTER)) continue;
            this.loadFilter(allower);
        }
    }

    private void loadConvert(Element allower) {
        String match = allower.getAttribute(ATTRIBUTE_MATCH);
        String type = allower.getAttribute(ATTRIBUTE_CONVERTER);
        try {
            Map<String, String> params = DwrXmlConfigurator.createSettingMap(allower);
            this.converterManager.addConverter(match, type, params);
        }
        catch (NoClassDefFoundError ex) {
            log.info((Object)("Convertor '" + type + "' not loaded due to NoClassDefFoundError. (match='" + match + "'). Cause: " + ex.getMessage()));
        }
        catch (Exception ex) {
            log.error((Object)("Failed to add convertor: match=" + match + ", type=" + type), (Throwable)ex);
        }
    }

    private void loadCreate(Element allower) {
        String type = allower.getAttribute(ATTRIBUTE_CREATOR);
        String javascript = allower.getAttribute(ATTRIBUTE_JAVASCRIPT);
        try {
            Map<String, String> params = DwrXmlConfigurator.createSettingMap(allower);
            this.creatorManager.addCreator(javascript, type, params);
            this.processPermissions(javascript, allower);
            this.processAuth(javascript, allower);
            this.processParameters(javascript, allower);
            this.processAjaxFilters(javascript, allower);
        }
        catch (NoClassDefFoundError ex) {
            log.info((Object)("Creator '" + type + "' not loaded due to NoClassDefFoundError. (javascript='" + javascript + "'). Cause: " + ex.getMessage()));
        }
        catch (Exception ex) {
            log.error((Object)("Failed to add creator: type=" + type + ", javascript=" + javascript), (Throwable)ex);
        }
    }

    private void loadFilter(Element allower) {
        String type = allower.getAttribute(ATTRIBUTE_CLASS);
        try {
            Class<?> impl = LocalUtil.classForName(type);
            AjaxFilter object = (AjaxFilter)impl.newInstance();
            LocalUtil.setParams(object, DwrXmlConfigurator.createSettingMap(allower), ignore);
            this.ajaxFilterManager.addAjaxFilter(object);
        }
        catch (ClassCastException ex) {
            log.error((Object)(type + " does not implement " + AjaxFilter.class.getName()), (Throwable)ex);
        }
        catch (NoClassDefFoundError ex) {
            log.info((Object)("Missing class for filter (class='" + type + "'). Cause: " + ex.getMessage()));
        }
        catch (Exception ex) {
            log.error((Object)("Failed to add filter: class=" + type), (Throwable)ex);
        }
    }

    private static Map<String, String> createSettingMap(Element parent) {
        HashMap<String, String> params = new HashMap<String, String>();
        NamedNodeMap attrs = parent.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node node = attrs.item(i);
            String name = node.getNodeName();
            String value = node.getNodeValue();
            params.put(name, value);
        }
        NodeList locNodes = parent.getElementsByTagName(ELEMENT_PARAM);
        for (int i = 0; i < locNodes.getLength(); ++i) {
            String name;
            Element element = (Element)locNodes.item(i);
            if (element.getParentNode() != parent || (name = element.getAttribute(ATTRIBUTE_NAME)) == null) continue;
            String value = element.getAttribute(ATTRIBUTE_VALUE);
            if (value == null || value.length() == 0) {
                StringBuffer buffer = new StringBuffer();
                NodeList textNodes = element.getChildNodes();
                for (int j = 0; j < textNodes.getLength(); ++j) {
                    buffer.append(textNodes.item(j).getNodeValue());
                }
                value = buffer.toString();
            }
            params.put(name, value);
        }
        return params;
    }

    private void processPermissions(String javascript, Element parent) {
        NodeList incNodes = parent.getElementsByTagName(ELEMENT_INCLUDE);
        for (int i = 0; i < incNodes.getLength(); ++i) {
            Element include = (Element)incNodes.item(i);
            String method = include.getAttribute(ATTRIBUTE_METHOD);
            this.accessControl.addIncludeRule(javascript, method);
        }
        NodeList excNodes = parent.getElementsByTagName(ELEMENT_EXCLUDE);
        for (int i = 0; i < excNodes.getLength(); ++i) {
            Element include = (Element)excNodes.item(i);
            String method = include.getAttribute(ATTRIBUTE_METHOD);
            this.accessControl.addExcludeRule(javascript, method);
        }
    }

    private void processAuth(String javascript, Element parent) {
        NodeList nodes = parent.getElementsByTagName(ELEMENT_AUTH);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element include = (Element)nodes.item(i);
            String method = include.getAttribute(ATTRIBUTE_METHOD);
            String role = include.getAttribute(ATTRIBUTE_ROLE);
            this.accessControl.addRoleRestriction(javascript, method, role);
        }
    }

    private void processAjaxFilters(String javascript, Element parent) {
        NodeList nodes = parent.getElementsByTagName(ELEMENT_FILTER);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element include = (Element)nodes.item(i);
            String type = include.getAttribute(ATTRIBUTE_CLASS);
            AjaxFilter filter = LocalUtil.classNewInstance(javascript, type, AjaxFilter.class);
            if (filter == null) continue;
            LocalUtil.setParams(filter, DwrXmlConfigurator.createSettingMap(include), ignore);
            this.ajaxFilterManager.addAjaxFilter(filter, javascript);
        }
    }

    private void loadSignature(Element element) {
        StringBuffer sigtext = new StringBuffer();
        element.normalize();
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            short type = node.getNodeType();
            if (type != 3 && type != 4) {
                log.warn((Object)("Ignoring illegal node type: " + type));
                continue;
            }
            sigtext.append(node.getNodeValue());
        }
        SignatureParser sigp = new SignatureParser(this.converterManager, this.creatorManager);
        sigp.parse(sigtext.toString());
    }

    private void processParameters(String javascript, Element parent) throws ClassNotFoundException {
        NodeList nodes = parent.getElementsByTagName(ELEMENT_PARAMETER);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element include = (Element)nodes.item(i);
            String methodName = include.getAttribute(ATTRIBUTE_METHOD);
            Creator creator = this.creatorManager.getCreator(javascript);
            Class<?> dest = creator.getType();
            Method method = null;
            for (Method test : dest.getMethods()) {
                if (!test.getName().equals(methodName)) continue;
                if (method == null) {
                    method = test;
                    continue;
                }
                log.warn((Object)"Setting extra type info to overloaded methods may fail with <parameter .../>");
            }
            if (method == null) {
                log.error((Object)("Unable to find method called: " + methodName + " on type: " + dest.getName() + " from creator: " + javascript));
                continue;
            }
            String number = include.getAttribute(ATTRIBUTE_NUMBER);
            int paramNo = Integer.parseInt(number);
            String types = include.getAttribute(ATTRIBUTE_TYPE);
            StringTokenizer st = new StringTokenizer(types, ",");
            int j = 0;
            while (st.hasMoreTokens()) {
                String type = st.nextToken();
                Class<?> clazz = LocalUtil.classForName(type.trim());
                TypeHintContext thc = new TypeHintContext(this.converterManager, method, paramNo).createChildContext(j);
                ++j;
                this.converterManager.setExtraTypeInfo(thc, clazz);
            }
        }
    }

    public String toString() {
        if (this.servletResourceName != null) {
            return "DwrXmlConfigurator[ServletResource:" + this.servletResourceName + "]";
        }
        return "DwrXmlConfigurator[ClassResource:" + this.classResourceName + "]";
    }
}

