/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.directwebremoting.extend.DownloadManager;
import org.directwebremoting.extend.FileGenerator;
import org.directwebremoting.extend.Handler;

public class DownloadHandler
implements Handler {
    private DownloadManager downloadManager;
    protected String downloadHandlerUrl;

    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        FileGenerator generator;
        String id = request.getPathInfo();
        if (!id.startsWith(this.downloadHandlerUrl)) {
            response.sendError(404);
        }
        if ((generator = this.downloadManager.getFile(id = id.substring(this.downloadHandlerUrl.length()))) == null) {
            response.sendError(404);
        } else {
            response.setHeader("Content-disposition", "attachment; filename=" + generator.getFilename());
            response.setContentType(generator.getMimeType());
            ServletOutputStream out = response.getOutputStream();
            generator.generateFile((OutputStream)out);
        }
    }

    public void setDownloadManager(DownloadManager downloadManager) {
        this.downloadManager = downloadManager;
    }

    public void setDownloadHandlerUrl(String downloadHandlerUrl) {
        this.downloadHandlerUrl = downloadHandlerUrl;
    }
}

