/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FakeHttpSession
implements HttpSession {
    private String id = null;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private long creationTime;
    private int maxInactiveInterval = 1800000;
    private static final Log log = LogFactory.getLog(FakeHttpSession.class);

    public FakeHttpSession() {
        this.creationTime = System.currentTimeMillis();
    }

    public FakeHttpSession(String id) {
        this.id = id;
        this.creationTime = System.currentTimeMillis();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        if (this.id == null) {
            log.warn((Object)"Inventing data in FakeHttpSession.getId() to remain plausible.");
            this.id = "fake";
        }
        return this.id;
    }

    public long getLastAccessedTime() {
        return this.creationTime;
    }

    public ServletContext getServletContext() {
        return null;
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    @Deprecated
    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Deprecated
    public Object getValue(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    @Deprecated
    public String[] getValueNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.keySet().size()]);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    @Deprecated
    public void putValue(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    @Deprecated
    public void removeValue(String name) {
        this.attributes.remove(name);
    }

    public void invalidate() {
    }

    public boolean isNew() {
        return true;
    }
}

