/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.security.Principal;
import javax.security.auth.Subject;
import org.eclipse.jetty.security.Authentication;
import org.eclipse.jetty.security.DefaultAuthentication;
import org.eclipse.jetty.server.UserIdentity;

public class DefaultUserIdentity
implements UserIdentity {
    public final Authentication SUCCESSFUL_BASIC = new DefaultAuthentication(Authentication.Status.SUCCESS, "BASIC", this);
    public final Authentication SUCCESSFUL_DIGEST = new DefaultAuthentication(Authentication.Status.SUCCESS, "BASIC", this);
    private final Subject _subject;
    private final Principal _userPrincipal;
    private final String[] _roles;

    public DefaultUserIdentity(Subject subject, Principal userPrincipal, String[] roles) {
        this._subject = subject;
        this._userPrincipal = userPrincipal;
        this._roles = roles;
    }

    public String[] getRoles() {
        return this._roles;
    }

    public Subject getSubject() {
        return this._subject;
    }

    public Principal getUserPrincipal() {
        return this._userPrincipal;
    }

    public boolean isUserInRole(String role) {
        for (String r : this._roles) {
            if (!r.equals(role)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return DefaultUserIdentity.class.getSimpleName() + "('" + this._userPrincipal + "')";
    }
}

