/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jetty.http.security.Credential;
import org.eclipse.jetty.security.MappedLoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;

public class HashLoginService
extends MappedLoginService {
    private String _config;
    private Resource _configResource;
    private Scanner _scanner;
    private int _refreshInterval = 0;

    public HashLoginService() {
    }

    public HashLoginService(String name) {
        this.setName(name);
    }

    public HashLoginService(String name, String config) {
        this.setName(name);
        this.setConfig(config);
    }

    public String getConfig() {
        return this._config;
    }

    public void getConfig(String config) {
        this._config = config;
    }

    public Resource getConfigResource() {
        return this._configResource;
    }

    public void setConfig(String config) {
        this._config = config;
    }

    public void setRefreshInterval(int msec) {
        this._refreshInterval = msec;
    }

    public int getRefreshInterval() {
        return this._refreshInterval;
    }

    protected UserIdentity loadUser(String username) {
        return null;
    }

    public void loadUsers() throws IOException {
        if (this._config == null) {
            return;
        }
        this._configResource = Resource.newResource((String)this._config);
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Load " + this + " from " + this._config));
        }
        Properties properties = new Properties();
        properties.load(this._configResource.getInputStream());
        HashSet<String> known = new HashSet<String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String username = ((String)entry.getKey()).trim();
            String credentials = ((String)entry.getValue()).trim();
            String roles = null;
            int c = credentials.indexOf(44);
            if (c > 0) {
                roles = credentials.substring(c + 1).trim();
                credentials = credentials.substring(0, c).trim();
            }
            if (username == null || username.length() <= 0 || credentials == null || credentials.length() <= 0) continue;
            String[] roleArray = UserIdentity.NO_ROLES;
            if (roles != null && roles.length() > 0) {
                roleArray = roles.split(",");
            }
            known.add(username);
            this.putUser(username, Credential.getCredential((String)credentials), roleArray);
        }
        Iterator users = this._users.keySet().iterator();
        while (users.hasNext()) {
            String user = (String)users.next();
            if (known.contains(user)) continue;
            users.remove();
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.getRefreshInterval() > 0) {
            this._scanner = new Scanner();
            this._scanner.setScanInterval(this.getRefreshInterval());
            ArrayList<File> dirList = new ArrayList<File>(1);
            dirList.add(this._configResource.getFile());
            this._scanner.setScanDirs(dirList);
            this._scanner.setFilenameFilter(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    File f = new File(dir, name);
                    try {
                        if (f.compareTo(HashLoginService.this._configResource.getFile()) == 0) {
                            return true;
                        }
                    }
                    catch (IOException e) {
                        return false;
                    }
                    return false;
                }
            });
            this._scanner.addListener((Scanner.Listener)new Scanner.BulkListener(){

                public void filesChanged(List filenames) throws Exception {
                    if (filenames == null) {
                        return;
                    }
                    if (filenames.isEmpty()) {
                        return;
                    }
                    if (filenames.size() == 1 && filenames.get(0).equals(HashLoginService.this._config)) {
                        HashLoginService.this.loadUsers();
                    }
                }

                public String toString() {
                    return "HashLoginService$Scanner";
                }
            });
            this._scanner.setReportExistingFilesOnStartup(false);
            this._scanner.setRecursive(false);
            this._scanner.start();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this._scanner != null) {
            this._scanner.stop();
        }
        this._scanner = null;
    }
}

